package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.Activity;
import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.SearchView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.TravelAdapter;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripTable;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TravelsByStatusActivity extends AppCompatActivity implements OnItemClickListener{

    String status;
    JSONArray jsonArray,adapterArray;
    RecyclerView recyclerView;
    boolean forResult;
    TravelAdapter travelAdapter;
    TextView errorText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_travels_by_status);
        status=getIntent().getStringExtra("status");
        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle(getIntent().getStringExtra("title"));
        forResult=getIntent().getBooleanExtra("result",false);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTravels();
    }

    private void getTravels(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("status",status);
        params.put("list", HcmDatabase.getInstance(this).getTravelsList(status).toString());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());


        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_TRAVELS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTravels(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTravels(JSONObject jsonObject) throws JSONException{
        HcmDatabase hcmDatabase=HcmDatabase.getInstance(this);
        hcmDatabase.insertTravels(jsonObject.getJSONArray("travels"));
        jsonArray=hcmDatabase.getTravels(status);

        setAdapter();
    }



    @Override
    public void itemClicked(int position) {
        if(forResult) {
            Intent intent = new Intent();
            try {
                JSONObject jsonObject =((TravelAdapter) recyclerView.getAdapter()).getJsonArray()
                        .getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(TripTable.TRIPID));
                intent.putExtra("to", jsonObject.getString(TripTable.PLACE));
                intent.putExtra("type", jsonObject.getString(TripTable.TRAVELTYPE));

            } catch (JSONException e) {
                e.printStackTrace();
            }
            setResult(Activity.RESULT_OK, intent);
            finish();
        }else{
            Intent intent=new Intent(getApplicationContext(),TravelInfoActivity.class);
            try {
                intent.putExtra("id",travelAdapter.getJsonArray().getJSONObject(position).getString(TripTable.TRIPID));
            } catch (JSONException e) {
                e.printStackTrace();
            }
            startActivity(intent);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.hcm_travel, menu);
        MenuItem search=menu.findItem(R.id.action_search);

        SearchManager searchManager = (SearchManager) getSystemService(Context.SEARCH_SERVICE);
        SearchView searchView = (SearchView) search.getActionView();
        searchView.performClick();
        // menuItem.expandActionView();
        searchView.setIconified(true);

        searchManager.setOnDismissListener(new SearchManager.OnDismissListener() {
            @Override
            public void onDismiss() {
                setAdapter();
            }
        });
        searchManager.setOnCancelListener(new SearchManager.OnCancelListener() {
            @Override
            public void onCancel() {
                setAdapter();
            }
        });
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String s) {
                return false;
            }

            @Override
            public boolean onQueryTextChange(String s) {
               if(s.isEmpty()){
                   setAdapter();
               }else {
                   try {
                       setFilteredAdapter(s);
                   } catch (JSONException e) {
                       e.printStackTrace();
                   }
               }
                return false;
            }
        });
        return true;
    }

    private void setFilteredAdapter(String string) throws JSONException {
        adapterArray=new JSONArray();
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.toString().contains(string)) {
                adapterArray.put(jsonObject);
            }
        }
        travelAdapter=new TravelAdapter(this,adapterArray);
        recyclerView.setAdapter(travelAdapter);
        if(adapterArray.length()==0){
            errorText.setText("No Matched Found");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }

    private void setAdapter(){
        travelAdapter=new TravelAdapter(this,jsonArray);
        recyclerView.setAdapter(travelAdapter);
        if(jsonArray.length()==0){
            errorText.setText("No Travels Found");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


}
