package com.b2lmobitech.fieldcloudplus.hcm.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by HP on 30-01-2017.
 */

public class attendanceadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> date, time, place, status, Insync, Outsync;

    public attendanceadapter(Context context, ArrayList<String> date, ArrayList<String> time, ArrayList<String> place, ArrayList<String> status,ArrayList<String> Insync,ArrayList<String> Outsync) {

        super(context, R.layout.custom_attendance, date);
        this.mycontext = context;
        this.date = date;
        this.time = time;
        this.place = place;
        this.status = status;
        this.Insync = Insync;
        this.Outsync = Outsync;

    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_attendance, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.datevalue = (TextView) convertView.findViewById(R.id.datevalue);
            myholder.timevalue = (TextView) convertView.findViewById(R.id.timevalue);
            myholder.placevalue = (TextView) convertView.findViewById(R.id.placevalue);
            myholder.statusvalue = (TextView) convertView.findViewById(R.id.statusvalue);
            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }
        DateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        DateFormat targetFormat = new SimpleDateFormat("dd MMM yyyy");
        try {
            Date date2 = originalFormat.parse(date.get(position));
            String formattedDate = targetFormat.format(date2);
            myholder.datevalue.setText(formattedDate);
        } catch (ParseException e) {
            e.printStackTrace();
            myholder.datevalue.setText(date.get(position));
        }
//        String formattedDate = targetFormat.format(date2);
////        Format formatter = new SimpleDateFormat("dd MMM yyyy");
//        myholder.datevalue.setText(formattedDate);
//        myholder.datevalue.setText(date.get(position));
        myholder.timevalue.setText(time.get(position));
        myholder.placevalue.setText(place.get(position));
        if(status.get(position).equalsIgnoreCase("IN"))
        {
            myholder.statusvalue.setText("CHECKED IN");
        }
        else {
            myholder.statusvalue.setText(status.get(position));
        }
        final LinearLayout content_sync = (LinearLayout) convertView.findViewById(R.id.attendancelistlayout);
        if(Insync.get(position).equalsIgnoreCase("No")&&Outsync.get(position).equalsIgnoreCase("No"))
        {
            content_sync.setBackgroundColor(Color.parseColor("#ffccd5"));
        }
        else if(status.get(position).equalsIgnoreCase("Present")&&Insync.get(position).equalsIgnoreCase("Yes")&&Outsync.get(position).equalsIgnoreCase("No"))
        {
            content_sync.setBackgroundColor(Color.parseColor("#ffccd5"));
        }
        else
        {
            content_sync.setBackgroundColor(Color.TRANSPARENT);
        }

        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView datevalue, timevalue, placevalue, statusvalue;


    }
}
