package com.b2lmobitech.fieldcloudplus.hcm.adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import java.util.ArrayList;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 30-01-2017.
 */

public class leaveadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> status,leavedays,permissioninminutes,leavefrom,leaveto,permissionfrom,permissionto,leavetype,applieddateandtime,leavereason,rejectedreason,deleteicon,syncfordelete;
    private int hour,minutes,updatecheck=0;
    private String hourtext="",minutetext="",registeredcompany,registeredemailid,url_getleaverecord="",selectedleavetype="",selecteddate="";
    private sqldatabase mDbHelper;
    private  String status_delete="",leavedays_delete="",permissioninminutes_delete="",leavefrom_delete="",leaveto_delete="",permissionfrom_delete="",permissionto_delete="",leavetype_delete="",applieddateandtime_delete="",leavereason_delete="",rejectedreason_delete="",deleteicon_delete="",syncfordelete_delete="";
    private leaveListener leaveListener;

    public leaveadapter(Context context,ArrayList<String> status,ArrayList<String> leavedays,ArrayList<String> permissioninminutes,ArrayList<String> leavefrom,ArrayList<String> leaveto,ArrayList<String> permissionfrom,ArrayList<String> permissionto,ArrayList<String> leavetype,ArrayList<String> applieddateandtime,ArrayList<String> leavereason,ArrayList<String> rejectedreason,ArrayList<String> deleteicon,ArrayList<String> syncfordelete) {

        super(context, R.layout.custom_leaveactivity, applieddateandtime);
        this.mycontext = context;
        leaveListener= (leaveadapter.leaveListener) context;
        this.status=status;
        this.leavedays =leavedays;
        this.permissioninminutes = permissioninminutes;
        this.leavefrom = leavefrom;
        this.leaveto = leaveto;
        this.permissionfrom = permissionfrom;
        this.permissionto = permissionto;
        this.leavetype = leavetype;
        this.applieddateandtime =applieddateandtime;
        this.leavereason = leavereason;
        this.rejectedreason = rejectedreason;
        this.deleteicon = deleteicon;
        this.syncfordelete = syncfordelete;
        mDbHelper = new sqldatabase(mycontext);
        globalvariables.Logoutsharedpreference = mycontext.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_leaveactivity, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.
            myholder.status = (ImageView) convertView.findViewById(R.id.status);
            myholder.days = (TextView) convertView.findViewById(R.id.days);
            myholder.from = (TextView) convertView.findViewById(R.id.from);
            myholder.to = (TextView) convertView.findViewById(R.id.to);
            myholder.type = (TextView) convertView.findViewById(R.id.type);
            myholder.dateandtime = (TextView) convertView.findViewById(R.id.dateandtime);
            myholder.reason = (TextView) convertView.findViewById(R.id.reason);
            myholder.next = (ImageView) convertView.findViewById(R.id.next);
            myholder.delete = (ImageView) convertView.findViewById(R.id.delete);
            convertView.setTag(myholder);
            //convertView.setBackgroundColor(position % 2 == 0 ? Color.WHITE : Color.parseColor("#FEFCFF"));

        } else {
            myholder = (holder) convertView.getTag();

        }
        myholder.type.setText(leavetype.get(position));
        myholder.reason.setText(leavereason.get(position));

if(leavetype.get(position).equalsIgnoreCase("Permission"))
{
    hour = Integer.valueOf(permissioninminutes.get(position))/60;
    if(hour<9)
    {
        if(hour==1)
        {
            hourtext = "0" + hour+" hour";
        }
        else {
            hourtext = "0" + hour+" hours";
        }
    }
    else
    {
        hourtext = ""+hour+" hours";
    }
    minutes = Integer.valueOf(permissioninminutes.get(position))%60;
    if(minutes<9)
    {
        if(minutes==1)
        {
            minutetext = "0" + minutes+" minute";
        }
        else {
            minutetext = "0" + minutes+" minutes";
        }
    }
    else
    {
        minutetext = ""+minutes+" minutes";
    }

    myholder.days.setText(hourtext+" : "+minutetext);
    myholder.from.setText(permissionfrom.get(position));
    myholder.to.setText(" - "+permissionto.get(position));
    myholder.dateandtime.setText(applieddateandtime.get(position));
}
        else
{
    if(leavedays.get(position).equalsIgnoreCase("1"))
    {
        myholder.days.setText(leavedays.get(position) + " day");
        myholder.to.setText("");
    }
    else {
        myholder.days.setText(leavedays.get(position) + " days");
        myholder.to.setText(" - "+leaveto.get(position));
    }
    myholder.from.setText(leavefrom.get(position));
    myholder.dateandtime.setText(applieddateandtime.get(position));
}
        if(status.get(position).equalsIgnoreCase("pending"))
        {
            myholder.status.setImageResource(R.drawable.ic_action_pending);
            myholder.next.setVisibility(View.INVISIBLE);
            myholder.delete.setVisibility(View.VISIBLE);
        }
        else if(status.get(position).equalsIgnoreCase("accepted"))
        {
            myholder.status.setImageResource(R.mipmap.ic_accepted);
            myholder.delete.setVisibility(View.GONE);
            myholder.next.setVisibility(View.INVISIBLE);

        }
        else if(status.get(position).equalsIgnoreCase("rejected"))
        {
            myholder.status.setImageResource(R.mipmap.ic_rejected);
            myholder.delete.setVisibility(View.GONE);
            myholder.next.setVisibility(View.VISIBLE);
        }

        final RelativeLayout content_leaveactivity = (RelativeLayout) convertView.findViewById(R.id.content_leaveactivity);
        final ImageView deletebutton = (ImageView) convertView.findViewById(R.id.delete);
        final TextView typeofleave = (TextView) convertView.findViewById(R.id.type);
        final TextView applieddateandtimevalue = (TextView) convertView.findViewById(R.id.dateandtime);
        if(status.get(position).equalsIgnoreCase("rejected")) {
            content_leaveactivity.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    alert(rejectedreason.get(position));
                }
            });
        }
        else
        {
            content_leaveactivity.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                   //dont show anything
                }
            });
        }
        if(syncfordelete.get(position).equalsIgnoreCase("No"))
        {
            content_leaveactivity.setBackgroundColor(Color.parseColor("#DBD7D6"));
        }
        else
        {
            content_leaveactivity.setBackgroundColor(Color.TRANSPARENT);
        }
        if(deleteicon.get(position).equalsIgnoreCase("No")){
            myholder.delete.setVisibility(View.INVISIBLE);
        }else{
            deletebutton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);
                    alertdialog.setTitle("Delete");
                    alertdialog.setIcon(R.mipmap.ic_delete);
                    alertdialog.setMessage("Are you sure you want to delete this?");
                    alertdialog.setPositiveButton("Yes",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {

                                    leaveListener.deleteLeave(leavetype.get(position),applieddateandtime.get(position));
                                   /* status.remove(status.get(position));
                                    leavedays.remove(leavedays.get(position));
                                    permissioninminutes.remove(permissioninminutes.get(position));
                                    leavefrom.remove(leavefrom.get(position));
                                    leaveto.remove(leaveto.get(position));
                                    permissionfrom.remove(permissionfrom.get(position));
                                    permissionto.remove(permissionto.get(position));
                                    leavetype.remove(leavetype.get(position));
                                    applieddateandtime.remove(applieddateandtime.get(position));
                                    leavereason.remove(leavereason.get(position));
                                    rejectedreason.remove(rejectedreason.get(position));
                                    deleteicon.remove(deleteicon.get(position));
                                    syncfordelete.remove(syncfordelete.get(position));
                                    //applieddateandtime.remove(applieddateandtimevalue.getText().toString());
                                    notifyDataSetChanged();
                                    Toast.makeText(mycontext,"Deleted",Toast.LENGTH_LONG).show();
                                    mDbHelper.delete_leavetable(registeredcompany, registeredemailid, typeofleave.getText().toString(), applieddateandtimevalue.getText().toString());
                                    mDbHelper.close();*/
                                }
                            });
                    alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // TODO Auto-generated method stub

                        }
                    }).create();
                    alertdialog.show();


                }
            });
        }
        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {
        ImageView status,next,delete;
        TextView days,from,to,type,dateandtime,reason;
    }

    private void alert(String message) {
        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

        alertdialog.setTitle("Rejected Reason");
        alertdialog.setIcon(R.mipmap.ic_rejected);
        alertdialog.setMessage(message);
        alertdialog.create();
        alertdialog.show();
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    public interface leaveListener{
        void deleteLeave(String type,String datetime);
    }
}
