package com.b2lmobitech.fieldcloudplus.hcm.adapter;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by HP on 30-01-2017.
 */

public class timesheetadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> timesheetdate,team,from,to,activity,sync;
    private SimpleDateFormat onlydate,fulldate;
    private Date date;

    public timesheetadapter(Context context, ArrayList<String> timesheetdate, ArrayList<String> team, ArrayList<String> from, ArrayList<String> to, ArrayList<String> activity, ArrayList<String> sync) {

        super(context, R.layout.custom_timesheet, team);
        this.mycontext = context;
        this.timesheetdate=timesheetdate;
        this.team =team;
        this.from = from;
        this.to = to;
        this.activity = activity;
        this.sync = sync;
        fulldate = new SimpleDateFormat("dd MMM yyyy,EEE");
        onlydate = new SimpleDateFormat("yyyy-MM-dd");

    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_timesheet, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.
            myholder.timesheetdate = (TextView) convertView.findViewById(R.id.timesheetdate);
            myholder.team = (TextView) convertView.findViewById(R.id.team);
            myholder.from = (TextView) convertView.findViewById(R.id.from);
            myholder.to = (TextView) convertView.findViewById(R.id.to);
            myholder.activity = (TextView) convertView.findViewById(R.id.activity);
            myholder.fulllayout = (LinearLayout) convertView.findViewById(R.id.fulllayout);
            myholder.totaltime = (TextView) convertView.findViewById(R.id.totaltime);

            convertView.setTag(myholder);
            //convertView.setBackgroundColor(position % 2 == 0 ? Color.WHITE : Color.parseColor("#FEFCFF"));

        } else {
            myholder = (holder) convertView.getTag();

        }
        try {
            date = onlydate.parse(timesheetdate.get(position));
        } catch (ParseException E) {

        }
        myholder.timesheetdate.setText(fulldate.format(date));

        if(team.get(position).equalsIgnoreCase("no data available") || team.get(position).equalsIgnoreCase("null")){
            myholder.team.setText("");
        }else{
            myholder.team.setText(team.get(position));
        }

        myholder.from.setText(changetimeformat(from.get(position)));
        myholder.to.setText(changetimeformat(to.get(position)));
        myholder.totaltime.setText(differenceintime(changetimeformat(from.get(position)),changetimeformat(to.get(position))));
        myholder.activity.setText(activity.get(position));



        if(sync.get(position).equalsIgnoreCase("no"))
        {
            myholder.fulllayout.setBackgroundColor(Color.parseColor("#ffccd5"));
        }
        else
        {
            myholder.fulllayout.setBackgroundColor(Color.TRANSPARENT);
        }


        final RelativeLayout headinglayout = (RelativeLayout) convertView.findViewById(R.id.headinglayout);
        if(position!=0)
        {
            if(timesheetdate.get(position).equalsIgnoreCase(timesheetdate.get(position-1)))
            {
                headinglayout.setVisibility(convertView.GONE);
            }
            else
            {
                headinglayout.setVisibility(convertView.VISIBLE);
            }
        }
        else
        {
            headinglayout.setVisibility(convertView.VISIBLE);
        }

        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {
        TextView timesheetdate,team,from,to,activity,totaltime;
        LinearLayout fulllayout;
    }

    private String changetimeformat(String input)
    {
        String output= "";
        Date date = null;
        TimeZone utc;
        SimpleDateFormat inputFormat,outputFormat;
         utc = TimeZone.getTimeZone("etc/UTC");
         inputFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
         inputFormat.setTimeZone(utc);
         outputFormat = new SimpleDateFormat("hh:mm aa", Locale.US);
         outputFormat.setTimeZone(utc);
         try {
             date = inputFormat.parse(input);
             output = outputFormat.format(date);
         }catch(Exception E)
         {

         }
        return output;
    }
    private String differenceintime(String starttime,String endtime)
    { String difference = "";
        try
        {

            SimpleDateFormat format = new SimpleDateFormat("hh:mm aa");
            Date date1 = format.parse(starttime);
            Date date2 = format.parse(endtime);
            long mills = date2.getTime() - date1.getTime();
//            Log.v("Data1", ""+date1.getTime());
//            Log.v("Data2", ""+date2.getTime());
            int hours = (int) (mills/(1000 * 60 * 60));
            int mins = (int) (mills/(1000*60)) % 60;

            difference = hours + "h " + mins+"m"; // updated value every1 second

        }
        catch (Exception e)
        {
            e.printStackTrace();
//            Toast.makeText(getContext(),e.toString(),Toast.LENGTH_LONG).show();
        }
        return difference;
    }
}
