package com.b2lmobitech.fieldcloudplus.hcm

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import androidx.lifecycle.ViewModelProvider
import android.content.Context
import android.content.Intent
import android.content.IntentSender
import android.content.pm.PackageManager
import android.gesture.GestureOverlayView
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.location.*
import android.location.Location
import com.google.android.gms.location.LocationListener;
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.os.Looper
import android.provider.MediaStore
import android.provider.Settings
import com.google.android.material.snackbar.Snackbar
import androidx.core.app.ActivityCompat
import androidx.core.content.FileProvider
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import android.util.Base64
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.ScrollView
import android.widget.Toast
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.attendanceimage
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.utils.DistanceCalculator
import com.b2lmobitech.fieldcloudplus.utils.toByteArray
import com.b2lmobitech.fieldcloudplus.utils.toast
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.GoogleApiClient
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import com.google.android.gms.location.LocationRequest
import java.io.*
import java.text.SimpleDateFormat
import java.util.*

class attendanceimage : AppCompatActivity(), ConnectionCallbacks, OnConnectionFailedListener {

    private var companyname=""
    private var emailid=""
    private var date=""
    private var checkintime=""
    private var checkouttime=""
    private var checkinlocation=""
    private var checkoutlocation=""
    private var status=""
    private var totaltime=""
    private var Insync=""
    private var Outsync=""
    private var display=""
    private var facilityId=""
    private var picturefilename = "no data available"
    private var signaturefilename = "no data available"
    private var imageinstring = ""
    private var signatureinstring = ""
    private var mDbHelper: sqldatabase? = null
    private var mycontext: Context? = null
    private var gestureView: GestureOverlayView? = null
    private var scrollmain: ScrollView? = null
    private var snackbar: Snackbar? = null
    private var cameraButton: ImageView? = null
    private var snapshot: ImageView? = null

    private var imagefilepath: File? = null
    private var signfilepath: File? = null

    private val locationListener: LocationListener? = null
    private var location: Location? = null
    private val running = false
    private var currentlocation = "0.0,0.0"
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0
    private var addresses: List<Address>? = null
    var locationManager: LocationManager? = null
    var imgbmp: Bitmap? = null
    var sigbmp: Bitmap? = null


    private lateinit var mGoogleApiClient: GoogleApiClient
    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    var mLocationRequest: LocationRequest? = null
    private val UPDATE_INTERVAL = 10 * 1000 /* 10 secs */.toLong()
    private val FASTEST_INTERVAL: Long = 1000 /* 2 sec */



    //Geo Fence Details
    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0
    private var currentShift = ""

    private lateinit var dbViewModel: DBViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_attendanceimage)
        val toolbar = findViewById<View>(R.id.toolbar) as Toolbar
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        mycontext = this
        var actionBar = getSupportActionBar()
        if (actionBar != null) {

            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);

        }
        snackbar = Snackbar.make(findViewById(android.R.id.content), "All fields are mandatory.", Snackbar.LENGTH_INDEFINITE)
        mDbHelper = sqldatabase(mycontext)

        intent?.extras?.let {
            companyname = it.getString("companyname")!!
            emailid = it.getString("emailid")!!
            date = it.getString("date")!!
            checkintime = it.getString("checkintime")!!
            checkouttime = it.getString("checkouttime")!!
            checkinlocation = it.getString("checkinlocation")!!
            checkoutlocation = it.getString("checkoutlocation")!!
            status = it.getString("status")!!
            totaltime =it.getString("totaltime")!!
            Insync = it.getString("Insync")!!
            Outsync = it.getString("Outsync")!!
            display = it.getString("display")!!
            facilityId = it.getString("facility")!!
            geoFenceEnabled = intent.getBooleanExtra("geo", false)
            geoLat = intent.getDoubleExtra("lat", 0.0)
            geoLon = intent.getDoubleExtra("lon", 0.0)
            geoDistance = intent.getIntExtra("distance", 0)
            currentShift = intent.getStringExtra("shiftId")?:""
        }

        scrollmain = findViewById<View>(R.id.scrollmain) as ScrollView
        val clearbutton = findViewById<View>(R.id.clear) as Button
        cameraButton = findViewById<View>(R.id.cameraButton) as ImageView
        snapshot = findViewById<View>(R.id.snapshot) as ImageView
        gestureView = findViewById<View>(R.id.signaturePad) as GestureOverlayView

        gestureView?.setOnTouchListener { v, event ->
            scrollmain!!.requestDisallowInterceptTouchEvent(true) //very important
            false
        }

        clearbutton.setOnClickListener {
            gestureView!!.cancelClearAnimation()
            gestureView!!.clear(true)
        }

        cameraButton!!.setOnClickListener {
            if (isDeviceSupportCamera()) {
                captureImage()
            } else {
                snackbar = Snackbar.make(findViewById(android.R.id.content), "Sorry! Your device doesn't support camera", Snackbar.LENGTH_INDEFINITE)
                toast()
            }
        }

        mGoogleApiClient = GoogleApiClient.Builder(this)
                .addConnectionCallbacks(this)
                .addOnConnectionFailedListener(this)
                .addApi(LocationServices.API).build()
        mGoogleApiClient.connect()

        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)

    }

    override fun onResume() {
        super.onResume()
        locationManager = this.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        val isGPSEnabled = locationManager!!.isProviderEnabled(LocationManager.GPS_PROVIDER)
        val isNetworkEnabled = locationManager!!.isProviderEnabled(LocationManager.NETWORK_PROVIDER)
        var message = ""
        var positivebutton = ""
        var title = ""
        if (!isGPSEnabled || !isNetworkEnabled) { //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            val alertdialog = AlertDialog.Builder(this)
            alertdialog.setIcon(R.drawable.ic_action_location)
            alertdialog.setCancelable(false)
            if (!isGPSEnabled && !isNetworkEnabled) {
                message = "No location provider is enabled for location access!!"
                positivebutton = "Turn On"
                title = "Enable Lcoation"
            } else {
                message = "Change Lcoation accuracy to high"
                positivebutton = "Change"
                title = "Accuracy is Low"
            }
            alertdialog.setTitle(title)
            alertdialog.setMessage(message)
            alertdialog.setPositiveButton(positivebutton
            ) { dialog, whichButton -> startActivity(Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS)) }
            alertdialog.setNegativeButton("Cancel") { dialog, which ->
                // TODO Auto-generated method stub
                finish()
            }.create()
            alertdialog.show()
        }
        //findlocation();
    }

    override fun onDestroy() {
        mDbHelper!!.close()
        super.onDestroy()
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean { // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.attendanceimage, menu)
        return super.onCreateOptionsMenu(menu)
        // return true;
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        val id = item.itemId
        if (id == R.id.attendance_ok) {
            if (gestureView!!.gesture != null && !picturefilename.equals("no data available", ignoreCase = true)) {
                connectLocation()
            } else {
                snackbar = Snackbar.make(findViewById(android.R.id.content), "All fields are mandatory", Snackbar.LENGTH_INDEFINITE)
                toast()
            }
            return true
        }
        return super.onOptionsItemSelected(item)
    }

    private fun sendAttendance() {

        try {
            gestureView!!.isDrawingCacheEnabled = true
            sigbmp = Bitmap.createBitmap(gestureView!!.drawingCache)
            val baos = ByteArrayOutputStream()
            sigbmp?.compress(Bitmap.CompressFormat.PNG, 100, baos) //JPEG
            storeImage(sigbmp!!)
            val b = baos.toByteArray()
            signatureinstring = Base64.encodeToString(b, Base64.DEFAULT)
            baos.close()
        } catch (e: IOException) {
            //e.printStackTrace();
        }
        val df1 = SimpleDateFormat("yyyy-MM-dd")
        val c1 = Calendar.getInstance()
        val enddate = df1.format(c1.time)
        val c = Calendar.getInstance() // this takes current date
        c.add(Calendar.DATE, -45)
        val startdate = df1.format(c.time)

        dbViewModel.deleteAttendanceHistory(startdate)

        val attendenceEntity = AttendenceEntity(companyname = companyname,
                emailid = emailid,date = date,checkouttime = checkouttime,checkintime = checkintime,
                checkinlocation = currentlocation,checkoutlocation = checkoutlocation,status = status,totaltime = totaltime,
                INSYNC = Insync,OUTSYNC = Outsync,imagepath = picturefilename,
                attendanceimage = imagefilepath?.absolutePath!!,signaturepath = signaturefilename,
                signature = signfilepath?.absolutePath!!
                ,facility_id = facilityId,shift_id = currentShift)

        dbViewModel.saveAttendance(attendenceEntity){
            val returnIntent = Intent()
            returnIntent.putExtra("result", "You have successfully 'Checked In' at $checkintime from $currentlocation")
            setResult(Activity.RESULT_OK, returnIntent)
            finish()
        }
    }

    private fun toast() {
        snackbar!!.setAction("CLOSE") { snackbar!!.dismiss() }.setActionTextColor(resources.getColor(android.R.color.holo_blue_dark)).show()
    }// no camera on this device

    // this device has a camera
    private fun isDeviceSupportCamera(): Boolean {
        if (mycontext!!.packageManager.hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY)) { // this device has a camera
           return true
        } else { // no camera on this device
            return false
        }
    }


    private fun storeImage(image:Bitmap) {
        val pictureFile = getSignFile();
        if (pictureFile == null) {
            return
        }
        try {
            val fos = FileOutputStream(pictureFile);
            image.compress(Bitmap.CompressFormat.PNG, 90, fos);
            fos.close();
        } catch (e:FileNotFoundException) {
            Log.d("file", "File not found: " + e.message);
        } catch (e:IOException) {
            Log.d("file", "Error accessing file: " + e.message);
        }
    }

    private fun captureImage() {

        fun getoutputMediaFileUri(): File {

            val mediaFile: File = Utility.getCapturedImageFile(this)

            /* val mediaStorageDir = Environment.getDataDirectory()
     //        val mediaStorageDir = File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/" + "AttendanceImages")
             if (!mediaStorageDir.exists()) {
                 mediaStorageDir.mkdirs()
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            var mediaFile: File = Utility.getCapturedImageFile(this)

            /* var mediaFile: File? = null
             val mediaStorageDir = Environment.getDataDirectory()
             if (!mediaStorageDir.exists()) {
                 if (!mediaStorageDir.mkdirs()) {
                     return null
                 }
             }
             val dateFormatter2 = SimpleDateFormat("yyyyMMdd_HHmmss")
             mediaFile = File(mediaStorageDir.path + File.separator
                     + "IMG_" + dateFormatter2.format(Date()) + ".jpg")*/
            picturefilename = mediaFile.name
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            //   Uri fileUri = getOutputMediaFileUri();
            val fileUri = FileProvider.getUriForFile(this@attendanceimage,
                    BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE)
        } catch (e: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
// Log.e("erroe",e.toString());
            e.printStackTrace()
            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
                e1.printStackTrace()
            }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == Activity.RESULT_OK) {
                try {
                    val filename = imagefilepath
                    decodemyFile(filename)
                } catch (e: Exception) { // TODO Auto-generated catch block
                    Toast.makeText(applicationContext,
                            "please try again", Toast.LENGTH_SHORT)
                            .show()
                }
            } else if (resultCode == Activity.RESULT_CANCELED) {
                picturefilename = "no data available"
                // user cancelled Image capture
                Toast.makeText(applicationContext,
                        "You cancelled image capture", Toast.LENGTH_SHORT)
                        .show()
            } else if( requestCode == 4) {
                when (resultCode) {
                    Activity.RESULT_OK -> findlocation()
                    Activity.RESULT_CANCELED -> {
                        val snackBar = Snackbar.make(window.decorView, "Please enable location", Snackbar.LENGTH_INDEFINITE)
                        snackBar.show()
                        RequestProgress.getInstance(this).hideProgressBar()
                    }
                }
            }else {
                picturefilename = "no data available"
                // failed to capture image
                Toast.makeText(applicationContext,
                        "Sorry! Failed to capture image", Toast.LENGTH_SHORT)
                        .show()
            }
        }
    }



    private fun getSignFile():File{
        val mediaFile: File = Utility.getSignFile(this)
        signaturefilename = mediaFile.name
        signfilepath = mediaFile
        return mediaFile
    }


    private fun decodemyFile(f: File?) {
        try { // Decode image size
            val o = BitmapFactory.Options()
            o.inJustDecodeBounds = true
            BitmapFactory.decodeStream(FileInputStream(f), null, o)
            o.inSampleSize = 4
            o.inJustDecodeBounds = false
            //---
            imgbmp = BitmapFactory.decodeStream(FileInputStream(f), null, o) //o2
            val stream = ByteArrayOutputStream()
            //bmp.creates
            imgbmp?.compress(Bitmap.CompressFormat.JPEG, 80, stream)
            val byteArray = stream.toByteArray()
            try { //convert file into array of bytes
                val fileOuputStream = FileOutputStream(f) //outputfile
                fileOuputStream.write(byteArray)
                fileOuputStream.flush()
                fileOuputStream.close()
                val filename = imagefilepath
                if (Uri.fromFile(filename).path != null) { // globalvariables.BitMapToString(bmp), subcategorylistadapter.Picturefilename
                    imageinstring = globalvariables.BitMapToString(imgbmp)
                    snapshot!!.setImageBitmap(imgbmp)
                }
            } catch (e: Exception) {
                e.printStackTrace()
                Log.e("result erroe", e.toString())
            }
        } catch (e: FileNotFoundException) {
        }
        // return null;
    }

    override fun onConnected(bundle: Bundle?) {}
    override fun onConnectionSuspended(i: Int) {}
    override fun onConnectionFailed(connectionResult: ConnectionResult) {}


    fun connectLocation() {
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 10000
        locationRequest.fastestInterval = 10000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())

        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                findlocation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(this, 4)
                    } catch (e: IntentSender.SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    fun findlocation() {
        findViewById<View>(R.id.progressBar).visibility = View.VISIBLE
        val geocoder = Geocoder(mycontext!!, Locale.getDefault())

        locationManager = mycontext!!.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }
        mLocationRequest = LocationRequest.create()
        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY,null).addOnCompleteListener {
            it.result?.let { location->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + "" + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude
                try {
                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1) // Here 1 represent max location result to returned, by documents it recommended 1 to 5
                    val address = addresses?.get(0)
                    currentlocation = if (address != null) {
                        address.getAddressLine(0)
                    } else {
                        "$currentlocationlaltitue,$currentlocationlongitude"
                    }
                } catch (e: Exception) { // TODO Auto-generated catch block
//										e.printStackTrace();
                    currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                } finally {
                    calculateDistance(currentlocationlaltitue,currentlocationlongitude)
                }
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }
    }

    private fun calculateDistance(lat: Double, lon: Double) {
        val distance = DistanceCalculator.distance(geoLat, geoLon, lat, lon)
        if (( !geoFenceEnabled || distance <= geoDistance ) || BuildConfig.DEBUG) {
            sendAttendance()
        } else {
            alertNotInFacility()
        }
    }

    private fun alertNotInFacility() {
        val alertdialog = AlertDialog.Builder(this)
        alertdialog.setMessage("It seems you are out of the geofence")
        alertdialog.setPositiveButton("Close"
        ) { dialog, whichButton -> finish() }.create()
        alertdialog.setCancelable(false)
        alertdialog.show()
    }

    fun getLocation(provider: String?) {
        val geocoder = Geocoder(mycontext!!, Locale.getDefault())
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }
       /* locationManager?.requestLocationUpdates(provider, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, LocationListener {

        })
        locationManager!!.requestLocationUpdates(provider, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES.toFloat(), locationListener)
        if (locationManager != null) { //   Log.e("Network locationmanager","coming");
            location = locationManager!!.getLastKnownLocation(provider)
            if (location != null) {
                currentlocationlaltitue = location!!.latitude
                currentlocationlongitude = location!!.longitude
                try {
                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1) // Here 1 represent max location result to returned, by documents it recommended 1 to 5
                    val address = addresses?.firstOrNull()
                    currentlocation = if (address != null) {
                        address.getAddressLine(0)
                    } else {
                        "$currentlocationlaltitue,$currentlocationlongitude"
                    }
                    //addressFragments.add(address.getAdminArea());
// currentlocation = currentlocation.substring(1,currentlocation.length()-1);
                } catch (e: Exception) { // TODO Auto-generated catch block
//											e.printStackTrace();
//fetchCityName(mycontext, location);currentlocation = currentlocationlaltitue+","+currentlocationlongitude;
                    currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                }
            }
        } else {
            getLocation(LocationManager.PASSIVE_PROVIDER)
        }*/
    }

    companion object {
        private const val CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100
        private const val MIN_DISTANCE_CHANGE_FOR_UPDATES: Long = 10 // 10 meters
        private const val MIN_TIME_BW_UPDATES = 1000 * 60 * 1.toLong()
        fun calculateInSampleSize(options: BitmapFactory.Options, reqWidth: Int, reqHeight: Int): Int { //Raw height and width of image
            val height = options.outHeight
            val width = options.outWidth
            var inSampleSize = 1
            if (height > reqHeight || width > reqWidth) {
                val halfHeight = height / 2
                val halfWidth = width / 2
                // Calculate the largest inSampleSize value that is a power of 2 and keeps both
// height and width larger than the requested height and width.
                while (halfHeight / inSampleSize >= reqHeight
                        && halfWidth / inSampleSize >= reqWidth) {
                    inSampleSize *= 2
                }
            }
            return inSampleSize
        }
    }
}