package com.b2lmobitech.fieldcloudplus.hcm;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class leaveapply extends AppCompatActivity {

    private sqldatabase mDbHelper;
    private Context mycontext;
    private String registeredcompany,registeredemailid,selectedleavetype="";
    private  Spinner leavetype;
    private Snackbar snackBar;
    private  EditText leavereason;
    private String month_from="",day_from="",hour_from="",minute_from="",month_to="",day_to="",hour_to="",minute_to="";
    private  EditText leaverangefrom,leaverangeto;
    private TextView leavereasontext,fromtext,totext;
    private long permissioninminutes=0,permissionindays=0;
    private ImageView fromimage,toimage;
    private ProgressBar progressBar;
    private String url_insertleave = "";
    private int status =0;
    private  String update_leavefrom="",update_leaveto="",update_leavedays="",update_permissiondate="",update_permissionfrom="",update_permissionto="",update_permissioninminutes="",update_applieddateandtime="",update_reasonforleaveorpermission="";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_leaveapply);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        leavetype = (Spinner) findViewById(R.id.leavetype);
        leaverangefrom = (EditText) findViewById(R.id.leaverangefrom);
        leaverangeto = (EditText) findViewById(R.id.leaverangeto);
        leavereason = (EditText) findViewById(R.id.leavereason);
        leavereasontext = (TextView) findViewById(R.id.leavereasontext);
        Button apply = (Button) findViewById(R.id.apply);
        fromimage = (ImageView) findViewById(R.id.leaverangeimage);
        toimage = (ImageView) findViewById(R.id.leaverangeimage2);
        fromtext = (TextView) findViewById(R.id.leaverangefromtext);
        totext = (TextView) findViewById(R.id.leaverangetotext);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        progressBar = (ProgressBar) findViewById(R.id.leaveapplyprogressBar);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        ArrayList<String> selectleavetype = new ArrayList<String>();
        selectleavetype.add("Select Leave type");
        selectleavetype.add("Permission");
        selectleavetype.add("Sick Leave");
        selectleavetype.add("Casual Leave");
        selectleavetype.add("Earned Leave");
        ArrayAdapter<String> leavetypeAdapter = new ArrayAdapter<String>(this,
                R.layout.simple_spinner_item, selectleavetype);
        leavetypeAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        leavetype.setAdapter(leavetypeAdapter);
        leaverangefrom.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(selectedleavetype.equalsIgnoreCase("Select Leave type"))
                {
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please select leave type.", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }
                else
                {
                    if(leavereason.getText().toString().equalsIgnoreCase(""))
                    {
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please give reason.", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                    else
                    {
                        if(selectedleavetype.equalsIgnoreCase("Permission"))
                    {
                        leaverangeto.setText("");
                        final Calendar mcurrentTime = Calendar.getInstance();
                        int hour = mcurrentTime.get(Calendar.HOUR_OF_DAY);
                        int minute = mcurrentTime.get(Calendar.MINUTE);
                        TimePickerDialog mTimePicker = new TimePickerDialog(mycontext, new TimePickerDialog.OnTimeSetListener() {
                            @Override
                            public void onTimeSet(TimePicker timePicker, int selectedHour, int selectedMinute) {
                                Calendar myCalendartime = Calendar.getInstance();
                                myCalendartime.set(Calendar.HOUR_OF_DAY, selectedHour);//24 hr formate
//                                Toast.makeText(mycontext,"selectedHour="+selectedHour,Toast.LENGTH_LONG).show();
                                myCalendartime.set(Calendar.MINUTE, selectedMinute);

                                long diff = (myCalendartime.getTime().getTime()-mcurrentTime.getTime().getTime());
                                int Mins = (int) (diff/(1000*60));
                                if (Mins > 0) {
                                    snackBar.dismiss();
                                    if(selectedHour<10)
                                    {
                                        hour_from = "0" + selectedHour;
                                    }
                                    else
                                    {
                                        hour_from = "" + selectedHour;
                                    }
                                    if(selectedMinute<10)
                                    {
                                        minute_from = "0" + selectedMinute;
                                    }
                                    else
                                    {
                                        minute_from = "" + selectedMinute;
                                    }
                                    leaverangefrom.setText(hour_from + ":" + minute_from);
                                } else {
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate time", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                    leaverangefrom.setText("");
                                }
                            }
                        }, hour, minute, true);
                        mTimePicker.setTitle("24 Hour Time format");
                        mTimePicker.show();
                    }
                    else {
                        leaverangeto.setText("");
                        final Calendar c = Calendar.getInstance();
                        int mYear = c.get(Calendar.YEAR); // current year
                        int mMonth = c.get(Calendar.MONTH); // current month
                        int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                        // date picker dialog
                        DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                                new DatePickerDialog.OnDateSetListener() {

                                    @Override
                                    public void onDateSet(DatePicker view, int year,
                                                          int monthOfYear, int dayOfMonth) {
                                        // set day of month , month and year value in the edit text
                                        monthOfYear = monthOfYear + 1;
                                        if (monthOfYear < 10) {
                                            month_from = "0" + monthOfYear;
                                        } else {
                                            month_from = "" + monthOfYear;
                                        }
                                        if (dayOfMonth < 10) {

                                            day_from = "0" + dayOfMonth;
                                        } else {
                                            day_from = "" + dayOfMonth;
                                        }
                                        Calendar myCalendar = Calendar.getInstance();
                                        myCalendar.set(Calendar.YEAR, year);
                                        myCalendar.set(Calendar.MONTH, monthOfYear - 1);
                                        myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                                        long diff = (myCalendar.getTimeInMillis() - c.getTimeInMillis()) / (1000 * 60 * 60 * 24);
//                                Toast.makeText(mycontext,"c.getTime()="+c.getTime(),Toast.LENGTH_LONG).show();
//                                Toast.makeText(mycontext,"diff*24="+(myCalendar.getTimeInMillis() - c.getTimeInMillis()) / (1000 * 60 * 60) ,Toast.LENGTH_LONG).show();
//                               Toast.makeText(mycontext,"diff="+diff,Toast.LENGTH_LONG).show();
                                        if ((myCalendar.getTimeInMillis() - c.getTimeInMillis()) / (1000 * 60 * 60) >= 0) {//bcoz -23/24=0 for long,logic will not work for yesterday so dont change this.
                                            Cursor attendancedatewise_cursor = mDbHelper.get_attendancetable_checkin(registeredcompany, registeredemailid, year + "-" + month_from + "-" + day_from);
                                            if (attendancedatewise_cursor.moveToFirst()) {
                                                snackBar.dismiss();
                                                snackBar = Snackbar.make(findViewById(android.R.id.content), "You already took attendance today,so please select from tomorrow", Snackbar.LENGTH_INDEFINITE);
                                                toast();
                                                leaverangefrom.setText("");
                                            } else {
                                                snackBar.dismiss();
                                                leaverangefrom.setText(year + "-" + month_from + "-" + day_from);
                                            }
                                            attendancedatewise_cursor.close();
                                        } else {
                                            snackBar.dismiss();
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate date,You can select only from today", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                            leaverangefrom.setText("");
                                        }
                                    }
                                }, mYear, mMonth, mDay);
                        datePickerDialog.show();
                    }
                    }
                }

            }
        });
        leaverangeto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(selectedleavetype.equalsIgnoreCase("Select Leave type"))
                {
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please select leave type.", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }
                else if(selectedleavetype.equalsIgnoreCase("Permission"))
                {
                    if(leaverangefrom.getText().toString().equalsIgnoreCase(""))
                    {
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please give from", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                    else {
                        Calendar mcurrentTime = Calendar.getInstance();
                        int hour = mcurrentTime.get(Calendar.HOUR_OF_DAY);
                        int minute = mcurrentTime.get(Calendar.MINUTE);
                        TimePickerDialog mTimePicker = new TimePickerDialog(mycontext, new TimePickerDialog.OnTimeSetListener() {
                            @Override
                            public void onTimeSet(TimePicker timePicker, int selectedHour, int selectedMinute) {
                                String[] fromtime = leaverangefrom.getText().toString().split(":");
                                int fromhour = Integer.valueOf(fromtime[0]);
                                int fromminute = Integer.valueOf(fromtime[1]);
                                Calendar myCalendartime_from = Calendar.getInstance();
                                myCalendartime_from.set(Calendar.HOUR_OF_DAY, fromhour);
                                myCalendartime_from.set(Calendar.MINUTE, fromminute);
                                Calendar myCalendartime_to = Calendar.getInstance();
                                myCalendartime_to.set(Calendar.HOUR_OF_DAY, selectedHour);
                                myCalendartime_to.set(Calendar.MINUTE, selectedMinute);
                                long diff = (myCalendartime_to.getTime().getTime()- myCalendartime_from.getTime().getTime());
                                int Mins = (int) (diff/(1000*60));
                                permissioninminutes = Mins;
                                if (Mins > 0) {
                                    snackBar.dismiss();
                                    if (selectedHour < 10) {
                                        hour_to = "0" + selectedHour;
                                    } else {
                                        hour_to = "" + selectedHour;
                                    }
                                    if (selectedMinute < 10) {
                                        minute_to = "0" + selectedMinute;
                                    } else {
                                        minute_to = "" + selectedMinute;
                                    }
                                    leaverangeto.setText(hour_to + ":" + minute_to);
                                } else {
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate time", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                    leaverangeto.setText("");
                                }
                            }
                        }, hour, minute, true);
                        mTimePicker.setTitle("24 Hour Time format");
                        mTimePicker.show();
                    }
                }
                else {
                    if(leaverangefrom.getText().toString().equalsIgnoreCase(""))
                    {
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please give from", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                    else {
                        final Calendar c = Calendar.getInstance();
                        int mYear = c.get(Calendar.YEAR); // current year
                        int mMonth = c.get(Calendar.MONTH); // current month
                        int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                        // date picker dialog
                        DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                                new DatePickerDialog.OnDateSetListener() {

                                    @Override
                                    public void onDateSet(DatePicker view, int year,
                                                          int monthOfYear, int dayOfMonth) {
                                        // set day of month , month and year value in the edit text
                                        monthOfYear = monthOfYear + 1;
                                        if (monthOfYear < 10) {
                                            month_to = "0" + monthOfYear;
                                        } else {
                                            month_to = "" + monthOfYear;
                                        }
                                        if (dayOfMonth < 10) {

                                            day_to = "0" + dayOfMonth;
                                        } else {
                                            day_to = "" + dayOfMonth;
                                        }
                                        leaverangeto.setText(year + "-" + month_to + "-" + day_to);
                                        String[] fromdays = leaverangefrom.getText().toString().split("-");
                                        int fromyear = Integer.valueOf(fromdays[0]);
                                        int frommonth = Integer.valueOf(fromdays[1]);
                                        int fromday = Integer.valueOf(fromdays[2]);
                                        Calendar myCalendar_from = Calendar.getInstance();
                                        myCalendar_from.set(Calendar.YEAR, fromyear);
                                        myCalendar_from.set(Calendar.MONTH, frommonth - 1);
                                        myCalendar_from.set(Calendar.DAY_OF_MONTH, fromday);
                                        Calendar myCalendar_to = Calendar.getInstance();
                                        myCalendar_to.set(Calendar.YEAR, year);
                                        myCalendar_to.set(Calendar.MONTH, monthOfYear - 1);
                                        myCalendar_to.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                                        long diff = (myCalendar_to.getTime().getTime() - myCalendar_from.getTime().getTime()) / (1000 * 60 * 60 * 24);
                                        permissionindays = diff;
                                        // Toast.makeText(mycontext, "myCalendar_from.getTime()=" + myCalendar_from.getTime(), Toast.LENGTH_LONG).show();
                                        //Toast.makeText(mycontext, "myCalendar_to.getTime()=" + myCalendar_to.getTime(), Toast.LENGTH_LONG).show();
                                        //Toast.makeText(mycontext, "diff=" + diff, Toast.LENGTH_LONG).show();
                                        if (diff > 0) {

                                            snackBar.dismiss();
                                            leaverangeto.setText(year + "-" + month_to + "-" + day_to);
                                        } else {
                                            snackBar.dismiss();
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate date.", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                            leaverangeto.setText("");
                                        }
                                    }
                                }, mYear, mMonth, mDay);
                        datePickerDialog.show();
                    }
                }
            }
        });
        leavetype.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                snackBar.dismiss();
                selectedleavetype = leavetype.getSelectedItem().toString();
                if(selectedleavetype.equalsIgnoreCase("Permission"))
                {
                    leavereasontext.setText("Permission Reason");
                    fromimage.setImageResource(R.drawable.ic_action_clock);
                    toimage.setImageResource(R.drawable.ic_action_clock);
                    fromtext.setText("From Time");
                    totext.setText("To Time");
                }
                else {
                    leavereasontext.setText("Leave Reason");
                    fromimage.setImageResource(R.drawable.ic_action_calenderblack);
                    toimage.setImageResource(R.drawable.ic_action_calenderblack);
                    fromtext.setText("From Date");
                    totext.setText("To Date");
                }
                leaverangefrom.setText("");
                leaverangeto.setText("");
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        apply.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
                if(selectedleavetype.equalsIgnoreCase("Select Leave type"))
                {
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please Select Leave type", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }
                else
                {
                    if (leavereason.getText().toString().equalsIgnoreCase("")) {
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please give reason", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                    else
                    {
                        if(leaverangefrom.getText().toString().equalsIgnoreCase(""))
                        {
                            snackBar = Snackbar.make(findViewById(android.R.id.content), "All fields are manditory", Snackbar.LENGTH_INDEFINITE);
                            toast();
                        }
                        else
                        {
                            if(leaverangeto.getText().toString().equalsIgnoreCase(""))
                            {
                                if(selectedleavetype.equalsIgnoreCase("Permission")) {
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "All fields are manditory", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                }
                                else
                                {
                                    try {
                                        Cursor onedayvalidation1 = mDbHelper.get_leavetable_validationforoneday1(registeredcompany, registeredemailid, leaverangefrom.getText().toString());
                                        if (onedayvalidation1.getCount() == 0) {
                                            Cursor onedayvalidation2 = mDbHelper.get_leavetable_validationforoneday2(registeredcompany, registeredemailid, leaverangefrom.getText().toString());
                                            if (onedayvalidation2.getCount() == 0) {
                                                alert("Do you want 1 day of Leave?", "Leave");
                                            } else {
                                                snackBar = Snackbar.make(findViewById(android.R.id.content), "You already applied leave for this day.", Snackbar.LENGTH_INDEFINITE);
                                                toast();
                                            }
                                            onedayvalidation2.close();
                                        } else {
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "You already applied leave for this day.", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                        }
                                        onedayvalidation1.close();

                                    }catch(Exception e)
                                    {
                                      //Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
                                    }

                                }
                            }
                            else
                            {
                                if(selectedleavetype.equalsIgnoreCase("Permission")) {
                                    try {
                                        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                                        Cursor permissionvalidation1 = mDbHelper.get_leavetable_validationforpermission1(registeredcompany, registeredemailid, sdf2.format(new Date()), leaverangefrom.getText().toString(), leaverangeto.getText().toString());
                                        if (permissionvalidation1.getCount() != 0) {
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the applied permission and try again.", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                        } else {
                                            Cursor permissionvalidation2 = mDbHelper.get_leavetable_validationforpermission2(registeredcompany, registeredemailid, sdf2.format(new Date()), leaverangefrom.getText().toString(), leaverangeto.getText().toString());
                                            if (permissionvalidation2.getCount() != 0) {
                                                snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the applied permission and try again.", Snackbar.LENGTH_INDEFINITE);
                                                toast();
                                            } else {
                                                Cursor permissionvalidation3 = mDbHelper.get_leavetable_validationforpermission3(registeredcompany, registeredemailid, sdf2.format(new Date()));
                                                if (permissionvalidation3.getCount() != 0) {
                                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Already applied leave today.", Snackbar.LENGTH_INDEFINITE);
                                                    toast();
                                                } else {
                                                    alert("Do you want " + String.valueOf(permissioninminutes) + " minutes of permission?", "Permission");
                                                }
                                                permissionvalidation3.close();
                                            }
                                            permissionvalidation2.close();
                                        }
                                        permissionvalidation1.close();
                                    }catch(Exception e)
                                    {
                                      //  Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
                                    }

                                }
                                else
                                {
                                    try {
                                        Cursor validation1 = mDbHelper.get_leavetable_validationfordatesrange1(registeredcompany, registeredemailid, leaverangefrom.getText().toString(), leaverangeto.getText().toString());
                                        if (validation1.getCount() != 0) {
                                            snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the applied leaves and try again.", Snackbar.LENGTH_INDEFINITE);
                                            toast();
                                        } else {
                                            Cursor validation2 =  mDbHelper.get_leavetable_validationfordatesrange2(registeredcompany, registeredemailid, leaverangefrom.getText().toString(), leaverangeto.getText().toString());
                                            if (validation2.getCount() != 0) {
                                                snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the applied leaves and try again.", Snackbar.LENGTH_INDEFINITE);
                                                toast();
                                            }
                                            else
                                            {
                                                Cursor validation3 =  mDbHelper.get_leavetable_validationfordatesrange3(registeredcompany, registeredemailid, leaverangefrom.getText().toString(), leaverangeto.getText().toString());
                                                if (validation3.getCount() != 0) {
                                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the applied leaves and try again.", Snackbar.LENGTH_INDEFINITE);
                                                    toast();
                                                }
                                                else {
                                                    if (permissionindays == 0) {
                                                        alert("Do you want " + String.valueOf(permissionindays + 1) + " day of Leave?", "Leave");
                                                    } else {
                                                        alert("Do you want " + String.valueOf(permissionindays + 1) + " days of Leave?", "Leave");
                                                    }
                                                }
                                                validation3.close();
                                            }

                                            validation2.close();
                                        }
                                        validation1.close();
                                    }catch(Exception e)
                                    {
                                       // Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
                                    }
                                }
                            }
                        }

                    }
                }

            }
        });
    }

    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }

    private void toast() {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

    private void alert(String message,String title) {
        AlertDialog.Builder alertdialog = new AlertDialog.Builder(this);

        alertdialog.setTitle(title);
        alertdialog.setIcon(R.drawable.ic_action_submit);
        alertdialog.setMessage(message);
        alertdialog.setPositiveButton("Yes",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton)
                    {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");

                        if(selectedleavetype.equalsIgnoreCase("Permission")) {
                            update_leavefrom= "000-00-00";
                            update_leaveto="0000-00-00";
                            update_leavedays= "0";
                            update_permissiondate=sdf2.format(new Date());
                            update_permissionfrom=leaverangefrom.getText().toString()+":00";
                            update_permissionto=leaverangeto.getText().toString()+":00";
                            update_permissioninminutes=String.valueOf(permissioninminutes);
                            update_applieddateandtime=sdf.format(new Date());
                            update_reasonforleaveorpermission=leavereason.getText().toString();
                           // mDbHelper.insert_leavetable(registeredcompany, registeredemailid, selectedleavetype,"000-00-00","0000-00-00","0", sdf2.format(new Date()),leaverangefrom.getText().toString()+":00",leaverangeto.getText().toString()+":00",String.valueOf(permissioninminutes), sdf.format(new Date()), leavereason.getText().toString(), "No");
                            mDbHelper.insert_leavetable(registeredcompany, registeredemailid, selectedleavetype, update_leavefrom, update_leaveto, update_leavedays, update_permissiondate, update_permissionfrom, update_permissionto, update_permissioninminutes, update_applieddateandtime, update_reasonforleaveorpermission, "No");
                        }
                        else
                        {
                            if(leaverangeto.getText().toString().equalsIgnoreCase(""))
                            {
                                update_leavefrom= leaverangefrom.getText().toString();
                               // update_leaveto="0000-00-00";
                                update_leaveto=leaverangefrom.getText().toString();
                                update_leavedays= "1";
                                update_permissiondate="0000-00-00";
                                update_permissionfrom="00:00:00";
                                update_permissionto="00:00:00";
                                update_permissioninminutes="0";
                                update_applieddateandtime=sdf.format(new Date());
                                update_reasonforleaveorpermission=leavereason.getText().toString();
                               // mDbHelper.insert_leavetable(registeredcompany, registeredemailid, selectedleavetype, leaverangefrom.getText().toString(), "0000-00-00", "1", "0000-00-00", "00:00:00", "00:00:00", "0", sdf.format(new Date()), leavereason.getText().toString(), "No");
                            }
                            else {
                                update_leavefrom= leaverangefrom.getText().toString();
                                update_leaveto=leaverangeto.getText().toString();
                                update_leavedays= String.valueOf(permissionindays + 1);
                                update_permissiondate="0000-00-00";
                                update_permissionfrom="00:00:00";
                                update_permissionto="00:00:00";
                                update_permissioninminutes="0";
                                update_applieddateandtime=sdf.format(new Date());
                                update_reasonforleaveorpermission=leavereason.getText().toString();
                               // mDbHelper.insert_leavetable(registeredcompany, registeredemailid, selectedleavetype, leaverangefrom.getText().toString(), leaverangeto.getText().toString(), String.valueOf(permissionindays + 1), "0000-00-00", "00:00:00", "00:00:00", "0", sdf.format(new Date()), leavereason.getText().toString(), "No");
                            }
                            mDbHelper.insert_leavetable(registeredcompany, registeredemailid, selectedleavetype, update_leavefrom, update_leaveto, update_leavedays, update_permissiondate, update_permissionfrom, update_permissionto, update_permissioninminutes, update_applieddateandtime, update_reasonforleaveorpermission, "No");
                        }
                        finish();
                        Toast.makeText(mycontext,"Successfully applied.",Toast.LENGTH_LONG).show();
                    }
                });
        alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                // TODO Auto-generated method stub

            }
        }).create();
        alertdialog.show();
    }

}
