package com.b2lmobitech.fieldcloudplus.hcm.new_sql

import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import android.content.Context
import com.b2lmobitech.fieldcloudplus.hcm.Attendance
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.ShiftDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.TimeSheetDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity
import com.b2lmobitech.fieldcloudplus.utils.snack
import com.cruzbytes.alfarz.sql.doa.AttendanceDOA


@Database(entities = [AttendenceEntity::class, FacilityEntity::class, TimesheetEntity::class,ShiftEntity::class], version = 2)
@TypeConverters(Converters::class)
 abstract class LocalDatabase: RoomDatabase() {

    abstract fun attendenceDOA(): AttendanceDOA
    abstract fun facilityDOA(): FacilityDOA
    abstract fun timeSheetDOA(): TimeSheetDOA
    abstract fun shiftDOA(): ShiftDOA

    companion object {

        @Volatile var INSTANCE: LocalDatabase? = null

        fun getAppDataBase(context: Context): LocalDatabase? {

            Room.databaseBuilder(context.applicationContext,
                    LocalDatabase::class.java, "facility_new")
                    .build()

            if (INSTANCE == null){
                synchronized(LocalDatabase::class){
                    INSTANCE = Room.databaseBuilder(context.applicationContext, LocalDatabase::class.java, "facility_new").build()
                }
            }
            return INSTANCE
        }

        fun destroyDataBase(){
            INSTANCE = null
        }
    }
}