package com.cruzbytes.alfarz.sql.doa

import androidx.lifecycle.LiveData
import androidx.paging.DataSource
import androidx.room.*
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity

@Dao //data access objects
interface AttendanceDOA{

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun save(key: AttendenceEntity): Long?

    @Update
    fun merge(key: AttendenceEntity)

    @Delete
    fun delete(key: AttendenceEntity)

    @Query("DELETE  FROM AttendenceEntity")
    fun deleteAll()

    @Query("SELECT * FROM AttendenceEntity ORDER BY id DESC")
    fun fetchAll(): LiveData<List<AttendenceEntity>>

    @Query("SELECT * FROM AttendenceEntity ORDER BY id DESC LIMIT 6")
    fun fetchLatest(): LiveData<List<AttendenceEntity>>

    @Query("DELETE  FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<:date")
    fun deleteHistory(date:String)

    @Query("SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)=:date AND shift_id=:shiftId")
    fun getAttendance(date:String,shiftId:String): LiveData<List<AttendenceEntity>>

    @Query("SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)=:date")
    fun getAttendance(date:String): LiveData<List<AttendenceEntity>>

    @Query("SELECT * FROM AttendenceEntity WHERE INSYNC='No' AND OUTSYNC='No' LIMIT 1")
    fun getCheckInNotSynced(): LiveData<List<AttendenceEntity>>

    @Query("SELECT * FROM AttendenceEntity WHERE AttendenceEntity.OUTSYNC='No' AND status='Present' LIMIT 1")
    fun getCheckOutNotSynced(): LiveData<List<AttendenceEntity>>

    @Query("UPDATE AttendenceEntity SET INSYNC = 'YES' WHERE status='IN' AND id IN (:ids)")
    fun updateCheckInSynced(ids:List<Int>)

    @Query("UPDATE AttendenceEntity SET OUTSYNC = 'YES' WHERE status='Present' AND id IN (:ids)")
    fun updateCheckOutSynced(ids:List<Int>)

    @Query("UPDATE AttendenceEntity SET status=:status,totaltime=:toaltime,facility_id_out=:facility_id_out,checkouttime=:checkouttime,checkoutlocation=:checkoutlocation,OUTSYNC='No',status='Present' WHERE id=:id")
    fun updateCheckOut(checkouttime:String,checkoutlocation:String,status:String,toaltime:String,id:Int,facility_id_out:String)

    @Query("SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<=:enddate AND DATE(AttendenceEntity.date)>=:startdate ")
    fun getcurrentmonthpresent(startdate: String,enddate :String): LiveData<List<AttendenceEntity>>

    @Query("SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date)<=:enddate AND DATE(AttendenceEntity.date)>=:startdate ")
    fun getcurrentmonth_present(startdate: String,enddate :String): List<AttendenceEntity>
    @Query("SELECT * FROM AttendenceEntity WHERE DATE(AttendenceEntity.date) =:selecteddate ")
    fun getselecteddatedetails_attendance(selecteddate: String): LiveData<List<AttendenceEntity>>
}