package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa

import androidx.lifecycle.LiveData
import androidx.room.*
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity


@Dao
interface FacilityDOA{

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun save(key: FacilityEntity): Long?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun saveAll(keys:List<FacilityEntity>)

    @Update
    fun merge(key: FacilityEntity)

    @Delete
    fun delete(key: FacilityEntity)

    @Query("DELETE  FROM FacilityEntity")
    fun deleteAll()

    @Query("SELECT * FROM FacilityEntity")
    fun fetchAll(): LiveData<List<FacilityEntity>>

}