package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa

import androidx.lifecycle.LiveData
import androidx.room.*
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity


@Dao
interface ShiftDOA{

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun save(key: ShiftEntity): Long?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun saveAll(keys:List<ShiftEntity>)

    @Update
    fun merge(key: ShiftEntity)

    @Delete
    fun delete(key: ShiftEntity)

    @Query("DELETE  FROM ShiftEntity")
    fun deleteAll()

    @Query("SELECT * FROM ShiftEntity")
    fun fetchAll(): LiveData<List<ShiftEntity>>

}