package com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa

import androidx.lifecycle.LiveData
import androidx.paging.DataSource
import androidx.room.*
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity

@Dao
interface TimeSheetDOA {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun save(key: TimesheetEntity): Long?

    @Update
    fun merge(key: TimesheetEntity)

    @Delete
    fun delete(key: TimesheetEntity)

    @Query("DELETE  FROM TimesheetEntity")
    fun deleteAll()

    @Query("SELECT * FROM TimesheetEntity  ORDER BY id DESC")
    fun fetchAll(): DataSource.Factory<Int, TimesheetEntity>

    @Query("SELECT * FROM TimesheetEntity WHERE DATE(timesheetdate) >= DATE(:startDate) AND DATE(timesheetdate) <= DATE(:endDate) ORDER BY id DESC")
    fun fetchAll(startDate: String, endDate: String): DataSource.Factory<Int, TimesheetEntity>


    @Query("SELECT * FROM TimesheetEntity WHERE sync='No' ORDER BY id DESC")
    fun fetchNotSynced(): LiveData<List<TimesheetEntity>>

    @Query("DELETE  FROM TimesheetEntity WHERE DATE(TimesheetEntity.starttime)<:date")
    fun deleteHistory(date: String)


    @Query("SELECT * FROM TimesheetEntity WHERE timesheetdate=:date AND ( TIME(:currentStart) BETWEEN  DATETIME(starttime) AND DATETIME(endtime) OR DATETIME(:currentEnd) BETWEEN DATETIME(starttime) AND DATETIME(endtime)  OR ( DATETIME(starttime) > DATETIME(:currentStart)  AND DATETIME(endtime) < DATETIME(:currentEnd) ))")
    fun validateTimesheet(currentStart: String, currentEnd: String,date: String): LiveData<List<TimesheetEntity>>

    @Query("UPDATE TimesheetEntity SET sync = 'Yes' WHERE id IN (:ids)")
    fun updateSynced(ids: List<Int>)

}
