package com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.paging.LivePagedListBuilder
import androidx.paging.PagedList
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.Base64
import androidx.lifecycle.MutableLiveData
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.LocalDatabase
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.ShiftDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.AttendenceEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity
import com.cruzbytes.alfarz.sql.doa.AttendanceDOA
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.ByteArrayOutputStream
import java.io.File
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors


class DBViewModel(application: Application): AndroidViewModel(application) {

    private lateinit var facilityDOA: FacilityDOA
    private lateinit var attendanceDOA: AttendanceDOA
    private lateinit var shiftDOA: ShiftDOA
    private var executorService: ExecutorService

    init {
        LocalDatabase.getAppDataBase(application)?.let {
            facilityDOA = it.facilityDOA()
            attendanceDOA = it.attendenceDOA()
            shiftDOA = it.shiftDOA()
        }
        executorService = Executors.newSingleThreadExecutor();
    }

    fun inserAttendanceHistory(jsonArray: JSONArray) {

        executorService.execute { attendanceDOA.deleteAll() }

        for (i in 0 until jsonArray.length()) {
            try {
                val jsonObject = jsonArray.getJSONObject(i)

                val attendenceEntity = AttendenceEntity(companyname = jsonObject.getString("companyname"),
                        emailid = jsonObject.getString("emailid"),
                        date = jsonObject.getString("date"),
                        checkintime = jsonObject.getString("checkintime"),
                        checkouttime = jsonObject.getString("checkouttime"),
                        status = jsonObject.getString("status"),
                        checkinlocation = jsonObject.getString("checkinlocation"),
                        checkoutlocation = jsonObject.getString("checkoutlocation"),
                        totaltime = jsonObject.getString("totaltime"),
                        INSYNC = "Yes",
                        OUTSYNC = if (jsonObject.getString("checkouttime").equals("00:00:00", ignoreCase = true)) {
                            "Yes"
                        } else {
                            "Yes"
                        }, facility_id = jsonObject.getString("facility_id"),
                        facility_id_out = jsonObject.getString("facility_id_out"))

                executorService.execute { attendanceDOA.save(attendenceEntity) }

            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    fun addAllFacilities(jsonArray: JSONArray,callBack: CompletedCallBack? = null) {

        val list: ArrayList<FacilityEntity> = ArrayList<FacilityEntity>();
        for (i in 0 until jsonArray.length()) {
            val jsonObject = jsonArray.getJSONObject(i)
            val facilityEntity = FacilityEntity(
                    companyname = jsonObject.getString("companyname"),
                    atmid = jsonObject.getString("atmid"),
                    state = jsonObject.getString("state"),
                    location = jsonObject.getString("location"),
                    atmaddress = jsonObject.getString("atmaddress"),
                    sitename = jsonObject.getString("sitename"),
                    country = jsonObject.getString("country"),
                    latitude = jsonObject.getString("latitude"),
                    longitude = jsonObject.getString("longitude"),
                    geofencing = jsonObject.getString("geofencing"),
                    geo_distance = jsonObject.getString("geo_distance"))
            list.add(facilityEntity)
        }
        executorService.execute {
            facilityDOA.deleteAll()
            facilityDOA.saveAll(list)
            callBack?.onTaskCompleted()
            getAllFacilities()
        }
    }

    val shifts = MutableLiveData<List<ShiftEntity>>()

    fun getSifts(): LiveData<List<ShiftEntity>> {
       return shiftDOA.fetchAll()
    }

    fun getAllFacilities(): LiveData<List<FacilityEntity>> {
        return facilityDOA.fetchAll()
    }

    fun addAllShits(jsonArray: JSONArray) {

        val list = ArrayList<ShiftEntity>()
        for (i in 0 until jsonArray.length()) {
            val jsonObject = jsonArray.getJSONObject(i)
            val shiftEntity = ShiftEntity(
                    shiftId = jsonObject.getString("shift_id"),
                    companyname =  jsonObject.getString("companyname"),
                    timeFrom = jsonObject.getString("timefrom"),
                    timeto = jsonObject.getString("timeto"),
            )
            list.add(shiftEntity)
        }
        executorService.execute {
            shiftDOA.deleteAll()
            shiftDOA.saveAll(list)
        }
    }

    fun getAllAttendance(date:String=""): LiveData<List<AttendenceEntity>> {
        if(date.isEmpty()){
            return attendanceDOA.fetchAll()
        }else{
            return getAttendance(date)
        }
    }



    fun deleteAttendanceHistory(date: String) {
        executorService.execute {
            attendanceDOA.deleteHistory(date)
        }
    }

    fun saveAttendance(attendenceEntity: AttendenceEntity,onCompleted:()->Unit){
        executorService.execute {
            attendanceDOA.save(attendenceEntity)
            onCompleted.invoke()
        }
    }

    fun getAttendance(date: String,sfhitId:String): LiveData<List<AttendenceEntity>> {
       // return attendanceDOA.getAttendance(date,sfhitId)
        return attendanceDOA.getAttendance(date)
    }

    fun getAttendance(date: String): LiveData<List<AttendenceEntity>> {
        return attendanceDOA.getAttendance(date)
    }

    fun getCheckInNotSynced(): LiveData<List<AttendenceEntity>> {
        return  attendanceDOA.getCheckInNotSynced();
    }

    fun getCheckOutNotSynced(): LiveData<List<AttendenceEntity>> {
        return attendanceDOA.getCheckOutNotSynced();
    }

    fun attendenceToJSON(list: List<AttendenceEntity>, isCheckIn: Boolean = true): JSONArray {
        val jsonArray = JSONArray()
        list.forEach {
            val json = JSONObject()
            json.put("companyname", it.companyname)
            json.put("emailid", it.emailid)
            json.put("date", it.date)
            json.put("checkintime", it.checkintime)
            json.put("checkouttime", it.checkouttime)
            json.put("checkinlocation", it.checkinlocation)
            json.put("checkoutlocation", it.checkoutlocation)
            json.put("status", it.status)
            json.put("totaltime", it.totaltime)
            json.put("_id", it.id)
            json.put("facility_id_out", it.facility_id_out)
            if (isCheckIn) {
                json.put("checkinimagepath", it.imagepath)
                json.put("checkinsignaturepath", it.signaturepath)
                fileToImage(it.attendanceimage)?.let {
                    json.put("checkinimage",it)
                }
                fileToImage(it.signature)?.let {
                    json.put("checkinsignature",it)
                }
                json.put("facility_id", it.facility_id)
                json.put("shift_id", it.shift_id)
            }

            jsonArray.put(json)
        }
        return jsonArray
    }

    fun fileToImage(path:String): String? {
        val file = File(path)
        if (file.exists() && file.length() > 0) {
            val bm = BitmapFactory.decodeFile(path)
            val bOut = ByteArrayOutputStream()
            bm.compress(Bitmap.CompressFormat.JPEG, 100, bOut)
            return  Base64.encodeToString(bOut.toByteArray(), Base64.DEFAULT)
        }else{
            return null
        }
    }

    fun updateAttendanceSynced(jsonArray: JSONArray,completedCallBack: CompletedCallBack? = null) {
        val ids = ArrayList<Int>();
        for (i in 0 until jsonArray.length()) {
            ids.add(jsonArray.getInt(i))
        }
        executorService.execute {
            attendanceDOA.updateCheckInSynced(ids)
            attendanceDOA.updateCheckOutSynced(ids)
            completedCallBack?.onTaskCompleted()
            getAllAttendance()
        }
    }

    fun updateCheckout(checkouttime:String,checkoutlocation:String,status:String,toaltime:String,id:Int,facility_id_out:String,completedCallBack: CompletedCallBack? = null){
        executorService.execute {
            attendanceDOA.updateCheckOut(checkouttime = checkouttime, checkoutlocation = checkoutlocation, status = status,
                    toaltime = toaltime, id = id,facility_id_out = facility_id_out)
            completedCallBack?.onTaskCompleted()
        }

    }


        /*fun getOptionKey(keyName:String): Flowable<History> {
          // return database?.historyDOA().
       }

      fun getOptionKeys(): Array<OptionKey>? {
           return database?.optionKeyDOA()?.fetchAll()
       }

       fun getOptionLookupByName(name: String):Flowable<History>{
           return database?.optionLookupDOA()?.getSingleOptionLookup(name)!!
       }

       fun getOrderTypeById(id: Int): Flowable<OrderTypeEntity>? {
           return database?.orderTypeDOA()?.getOrderTypeById(id)
       }

       fun getByOptionKeyName(name: String): Flowable<Array<History>>? {
           return database?.optionLookupDOA()?.getByOptionKeyName(name)
       }

       fun getOrderTypes(): Flowable<Array<OrderTypeEntity>>? {
           return database?.orderTypeDOA()?.fetchAll()
       }

       fun getOrderTypeByGroup(group: String): Flowable<Array<OrderTypeEntity>>? {
           return database?.orderTypeDOA()?.getOrderTypeByGroup(group)
       }*/
        fun getcurrentmonthpresent(startdate: String,enddate :String): LiveData<List<AttendenceEntity>> {
            return attendanceDOA.getcurrentmonthpresent(startdate,enddate)
        }
    fun getcurrentmonth_present(startdate: String,enddate :String): List<AttendenceEntity> {
        return attendanceDOA.getcurrentmonth_present(startdate,enddate)
    }
    fun getselecteddatedetails_attendance(selecteddate: String): LiveData<List<AttendenceEntity>> {
        return attendanceDOA.getselecteddatedetails_attendance(selecteddate)
    }
    interface CompletedCallBack{
        fun onTaskCompleted()
    }
}
