package com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.paging.LivePagedListBuilder
import androidx.paging.PagedList
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.Base64
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.LocalDatabase
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.ShiftDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.TimeSheetDOA
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.ShiftEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.timesheettable
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.ByteArrayOutputStream
import java.io.File
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors


class TimeSheetVM(application: Application): AndroidViewModel(application) {

    private lateinit var facilityDOA: FacilityDOA
    private lateinit var timeSheetDOA: TimeSheetDOA


    private var executorService: ExecutorService

    init {
        LocalDatabase.getAppDataBase(application)?.let {
            facilityDOA = it.facilityDOA()
            timeSheetDOA = it.timeSheetDOA()
        }
        executorService = Executors.newSingleThreadExecutor();
    }

    fun inserTimesheetHistory(jsonArray: JSONArray) {
        executorService.execute { timeSheetDOA.deleteAll() }
        for (i in 0 until jsonArray.length()) {
            try {
                val jsonObject = jsonArray.getJSONObject(i)
                val timesheetEntity = TimesheetEntity(companyname = jsonObject.getString("companyname"),
                        employeemailid = jsonObject.getString("employeemailid"),
                        attendancegroup = jsonObject.getString("attendancegroup"),
                        attendancesubgroup = jsonObject.getString("attendancesubgroup"),
                        attendenceteam = jsonObject.getString("attendenceteam"),
                        activity = jsonObject.getString("activity"),
                        latitude = jsonObject.getString("latitude"),
                        longitude = jsonObject.getString("longitude"),
                        timesheetdate = jsonObject.getString("timesheetdate"),
                        starttime = jsonObject.getString("starttime"),
                        endtime = jsonObject.getString("endtime"),
                        dateandtime = jsonObject.getString("dateandtime"),
                        sync = "Yes",
                        facility_id = jsonObject.getString("facility_id"))
                executorService.execute {
                    timeSheetDOA.save(timesheetEntity)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }



    fun addAllFacilities(jsonArray: JSONArray) {

        val list: ArrayList<FacilityEntity> = ArrayList<FacilityEntity>();
        for (i in 0 until jsonArray.length()) {
            val jsonObject = jsonArray.getJSONObject(i)
            val facilityEntity = FacilityEntity(
                    companyname = jsonObject.getString("companyname"),
                    atmid = jsonObject.getString("atmid"),
                    state = jsonObject.getString("state"),
                    location = jsonObject.getString("location"),
                    atmaddress = jsonObject.getString("atmaddress"),
                    sitename = jsonObject.getString("sitename"),
                    country = jsonObject.getString("country"),
                    latitude = jsonObject.getString("latitude"),
                    longitude = jsonObject.getString("longitude"),
                    geofencing = jsonObject.getString("geofencing"),
                    geo_distance = jsonObject.getString("geo_distance"))
            list.add(facilityEntity)
        }
        executorService.execute {
            facilityDOA.deleteAll()
            facilityDOA.saveAll(list)
            getAllFacilities()
        }
    }

    fun getAllFacilities(): LiveData<List<FacilityEntity>> {
        return facilityDOA.fetchAll()
    }

    fun getNotSynced(): LiveData<List<TimesheetEntity>> {
        return timeSheetDOA.fetchNotSynced()
    }

    fun getAllTS(startDate: String="",endDate: String=""): LiveData<PagedList<TimesheetEntity>> {
        val list: LiveData<PagedList<TimesheetEntity>>
        if(startDate.isEmpty()){
            list = LivePagedListBuilder<Int, TimesheetEntity>(
                    timeSheetDOA.fetchAll(),500).build()
        }else{
            list = LivePagedListBuilder<Int, TimesheetEntity>(
                    timeSheetDOA.fetchAll(startDate = startDate,endDate = endDate),500).build()
        }
        return list
    }

    fun saveTimesheet(timesheetEntity: TimesheetEntity,completedCallBack: CompletedCallBack? = null){
        executorService.execute {
            timeSheetDOA.save(timesheetEntity)
            completedCallBack?.onTaskCompleted()
        }
    }

    fun validateTimesheet(startTime:String,endTime:String,date:String): LiveData<List<TimesheetEntity>> {
        return timeSheetDOA.validateTimesheet(startTime,endTime,date)
    }



    fun toJSON(list: List<TimesheetEntity>, isCheckIn: Boolean = true): JSONArray {
        val jsonArray = JSONArray()
        list.forEach {
            val json = JSONObject()
            json.put("companyname", it.companyname)
            json.put("activity", it.activity)
            json.put("attendancegroup", it.attendancegroup)
            json.put("attendenceteam", it.attendenceteam)
            json.put("dateandtime", it.dateandtime)
            json.put("employeemailid", it.employeemailid)
            json.put("endtime", it.endtime)
            json.put("facility_id", it.facility_id)
            json.put("latitude", it.latitude)
            json.put("_id", it.id)
            json.put("longitude", it.longitude)
            json.put("starttime", it.starttime)
            json.put("timesheetdate", it.timesheetdate)

            jsonArray.put(json)
        }
        return jsonArray
    }

    fun updateAttendanceSynced(jsonArray: JSONArray,completedCallBack: DBViewModel.CompletedCallBack? = null) {
        val ids = ArrayList<Int>();
        for (i in 0 until jsonArray.length()) {
            ids.add(jsonArray.getInt(i))
        }
        executorService.execute {
            timeSheetDOA.updateSynced(ids)
            completedCallBack?.onTaskCompleted()
        }
    }

    fun fileToImage(path:String): String? {
        val file = File(path)
        if (file.exists() && file.length() > 0) {
            val bm = BitmapFactory.decodeFile(path)
            val bOut = ByteArrayOutputStream()
            bm.compress(Bitmap.CompressFormat.JPEG, 100, bOut)
            return  Base64.encodeToString(bOut.toByteArray(), Base64.DEFAULT)
        }else{
            return null
        }
    }


    interface CompletedCallBack{
        fun onTaskCompleted()
    }
}
