package com.b2lmobitech.fieldcloudplus.hcm.new_wroks


import android.os.Bundle
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityAttendanceBinding
import com.b2lmobitech.fieldcloudplus.databinding.FragmentChooseFacilityBinding
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
//import kotlinx.android.synthetic.main.activity_task_submitworkreport.*
//import kotlinx.android.synthetic.main.fragment_choose_facility.*
import org.json.JSONArray
import org.json.JSONObject
import java.util.ArrayList


/**
 * A simple [Fragment] subclass.
 */
class ChooseFacilityFragment() : androidx.fragment.app.DialogFragment() {

    private var facilityEntities:List<FacilityEntity> = ArrayList<FacilityEntity>()
    private var facilitySelectedListener:FacilitySelectedListener? = null
    private val stateList = HashSet<String>()
    private var cityList = LinkedHashMap<String,HashSet<String>> ()
    private lateinit var binding: FragmentChooseFacilityBinding
    fun setfacilityEntities(list:List<FacilityEntity>){
        facilityEntities = list
        facilityEntities.forEach {
            stateList.add(it.state)
        }

        stateList.forEach { state ->
            val city = HashSet<String>()
            facilityEntities.forEach {
                if(it.state.equals(state,ignoreCase = true)){
                    city.add(it.location)
                }
            }
            cityList.put(state,city)
        }
    }

    fun setFacilitySelectedListener(facilitySelectedListener:FacilitySelectedListener){
        this.facilitySelectedListener =facilitySelectedListener
    }

    private fun setSpinners(){
        fun setCitySpinner(selectedState:String){
            val cityAdapter = ArrayAdapter<String>(requireContext(), R.layout.simple_spinner_item,cityList.get(selectedState)!!.toList())
            cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            binding.materialSpinner2.adapter = cityAdapter
        }

        fun filterFacilities(selectedCity:String){
            val filteredList = ArrayList<FacilityEntity>()
            facilityEntities.forEach {
                if(it.location.equals(selectedCity,true)){
                    filteredList.add(it)
                }

            }
            setAdapter(filteredList)
        }

        val stateAdapter = ArrayAdapter<String>(requireContext(), R.layout.simple_spinner_item, stateList.toMutableList())
        stateAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.stateSpinner.adapter = stateAdapter

        binding.stateSpinner.onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
            override fun onNothingSelected(parent: AdapterView<*>?) {
                //setCitySpinner(stateSpinner.selectedItem.toString())
                binding.stateSpinner.selectedItem?.let {
                    setCitySpinner(it.toString())
                }
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.stateSpinner.selectedItem?.let {
                    setCitySpinner(it.toString())
                }
            }
        }

        binding.materialSpinner2.onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
            override fun onNothingSelected(parent: AdapterView<*>?) {
                //setCitySpinner(stateSpinner.selectedItem.toString())
                binding.materialSpinner2.selectedItem?.let {
                    filterFacilities(it.toString())
                }
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.materialSpinner2.selectedItem?.let {
                    filterFacilities(it.toString())
                }
            }
        }





    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        // Inflate the layout for this fragment
        binding = FragmentChooseFacilityBinding.inflate(inflater, container, false)
//        return inflater.inflate(R.layout.fragment_choose_facility, container, false)
        return binding.root
    }

    override fun onStart() {
        super.onStart()
        dialog?.window?.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.facilityRecycler.setManager(requireContext())
        binding.facilityRecycler.addDivider(requireContext())
        setSpinners()
    }

    private fun setAdapter(facilityEntities : ArrayList<FacilityEntity>){
        val listener = object : OnItemClickListener{
            override fun itemClicked(position: Int) {
                facilityEntities[position].let {
                    facilitySelectedListener?.onFacilitySelected(it)
                }
            }
        }
        val adapter = FacilityAdapter(facilityEntities,listener)
        binding.facilityRecycler.adapter = adapter
    }

    interface FacilitySelectedListener{
        fun onFacilitySelected(facilityEntity: FacilityEntity)
    }

}
