package com.b2lmobitech.fieldcloudplus.hcm.new_wroks;

import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;

import java.util.List;

/**
 * Created by home on 10/31/2017.
 */

public class FacilityAdapter extends  RecyclerView.Adapter<FacilityAdapter.viewHolder>{

    private List<FacilityEntity> list;
    private OnItemClickListener itemClickListener;

    public FacilityAdapter(List<FacilityEntity> list, OnItemClickListener onItemClickListener) {
        this.list = list;
        itemClickListener= onItemClickListener;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        FacilityEntity facilityEntity = list.get(holder.getAdapterPosition());
        holder.siteName.setText(facilityEntity.getSitename());
        holder.siteAddress.setText(facilityEntity.getAtmaddress());
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_facility, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView siteName,siteAddress;
        public viewHolder(final View itemView) {
            super(itemView);
            siteName=itemView.findViewById(R.id.siteName);
            siteAddress=itemView.findViewById(R.id.siteAddress);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }

}
