package com.b2lmobitech.fieldcloudplus.hcm.new_wroks

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityFacilityVisiDetailsBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectReportBinding
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.string
import com.b2lmobitech.fieldcloudplus.utils.visible
//import kotlinx.android.synthetic.main.activity_facility_visi_details.*
//import kotlinx.android.synthetic.main.activity_facility_visits.*
//import kotlinx.android.synthetic.main.list_facility_visit_timesheet.view.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*
import kotlin.collections.HashMap

class FacilityVisiDetailsActivity : AppCompatActivity() {

    private val calendar = Calendar.getInstance()
    private var atmId=""
    private var date=""
    private var facility = ""
    private lateinit var binding: ActivityFacilityVisiDetailsBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_facility_visi_details)
        binding = ActivityFacilityVisiDetailsBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        intent?.extras?.let {
            atmId = it.getString("atm")!!
            date = it.getString("date")!!
            facility = it.getString("facility")!!
        }

        supportActionBar?.let {
            it.setTitle("Facility Details")
            it.setSubtitle(date)
            it.setDisplayHomeAsUpEnabled(true)
        }

        getReport()

    }

    private fun getReport() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["date"] = date
        params["companyname"] = preference.getCompanyName()
        params["atm"]=atmId

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITY_VISIT_DETAILS, params) { response ->
            try {
                binding.scrollView.visible()
                setDetails(JSONObject(response))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }

    }

    private fun setDetails(jsonObject: JSONObject){
        binding.txtFacility.text = facility

        val attendanceDetails = jsonObject.getJSONArray("a")
        if(attendanceDetails.length() != 0){
            val attendence = attendanceDetails.getJSONObject(0)
            if(!attendence.getString("checkinperson").equals("null")){
                binding.txtMstName1.text = attendence.getString("checkinperson")
                binding.txtMstEmail1.text = attendence.getString("checkin_id")
                binding.txtCheckinTime.text = attendence.getString("checkintime")
            }else{
                binding.cardCheckIn.hidden()
            }

            if(!attendence.getString("checkoutperson").equals("null")) {
                binding.txtMstName2.text = attendence.getString("checkoutperson")
                binding.txtMstEmail2.text = attendence.getString("checkout_id")
                binding.txtCheckoutTime.text = attendence.getString("checkouttime")
            }else{
                binding.cardCheckOut.hidden()
            }

        }
        val timesheet = jsonObject.getJSONArray("t")

        for(i in 0 until timesheet.length()){
            val view = layoutInflater.inflate(R.layout.list_facility_visit_timesheet,null)
            var txt_mst_name3: TextView = view.findViewById(R.id.txt_mst_name3)
            var txt_mst_email3: TextView = view.findViewById(R.id.txt_mst_email3)
            var txt_ts_start: TextView = view.findViewById(R.id.txt_ts_start)
            var txt_ts_end: TextView = view.findViewById(R.id.txt_ts_end)
            var txt_ts_activity: TextView = view.findViewById(R.id.txt_ts_activity)
            timesheet.getJSONObject(i)?.let {
                if(it.getString("employeename").equals("null")){
                    return
                }
                txt_mst_name3.text = it.getString("employeename")
                txt_mst_email3.text = it.getString("employeemailid")
                txt_ts_start.text = it.getString("starttime")
                txt_ts_end.text = it.getString("endtime")
                txt_ts_activity.text = it.getString("activity")
                binding.linearLayout.addView(view)
            }
        }


    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val id = item.itemId
        if(android.R.id.home == id){
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

}
