package com.b2lmobitech.fieldcloudplus.hcm.new_wroks

import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.visible
//import kotlinx.android.synthetic.main.list_facility_visit.view.*
import org.json.JSONArray

/**
 * Created by home on 10/31/2017.
 */
class FacilityVisitAdapter(var list: JSONArray, var itemClickListener: OnItemClickListener? = null) :
        androidx.recyclerview.widget.RecyclerView.Adapter<FacilityVisitAdapter.viewHolder>() {

    override fun getItemCount(): Int {
        return list.length()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.list_facility_visit, parent, false)
        return viewHolder(itemView)
    }

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        holder.itemView.run {
            val jsonObject = list.getJSONObject(holder.layoutPosition)
            holder.facility_id.text = jsonObject.getString("sitename")
            holder.facility_address.text = jsonObject.getString("location") +" - "+jsonObject.getString("state")
            if(jsonObject.getString("status").equals("Abscent",ignoreCase = true)){
                holder.status.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.absent))
                holder.txt_mft_name.hidden()
            }else{
                holder.status.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.complete))
                holder.txt_mft_name.text = jsonObject.getString("employeename")
                holder.txt_mft_name.visible()
            }
        }
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView){
        init {
            itemView.setOnClickListener {
                itemClickListener?.itemClicked(layoutPosition)
            }
        }
        val facility_id: TextView = itemView.findViewById(R.id.facility_id)
        val facility_address: TextView = itemView.findViewById(R.id.facility_address)
        val status: ImageView = itemView.findViewById(R.id.status)
        val txt_mft_name: TextView = itemView.findViewById(R.id.txt_mft_name)
    }
}