package com.b2lmobitech.fieldcloudplus.hcm.new_wroks

import android.app.DatePickerDialog
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.google.android.material.bottomsheet.BottomSheetDialog
import android.view.Menu
import android.view.MenuItem
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityFacilityVisiDetailsBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityFacilityVisitsBinding
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.*
//import kotlinx.android.synthetic.main.activity_facility_visits.*
//import kotlinx.android.synthetic.main.sheet_facility_visit.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*
import kotlin.collections.HashMap

class FacilityVisitsActivity : AppCompatActivity() {

    private lateinit var adapter: FacilityVisitAdapter
    private val calendar = Calendar.getInstance()
    private lateinit var binding: ActivityFacilityVisitsBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_facility_visits)
        binding = ActivityFacilityVisitsBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Facility Visits")
            setSubtitle(Date().string("yyyy-MM-dd"))
        }

        setAdapter()
        getReport()
    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_facility_visit,menu)
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val id = item.itemId

        if (id == R.id.action_calendar) {
            val c = Calendar.getInstance()
            val mYear = c[Calendar.YEAR] // current year
            val mMonth = c[Calendar.MONTH] // current month
            val mDay = c[Calendar.DAY_OF_MONTH] // current day

            // date picker dialog
            val datePickerDialog = DatePickerDialog(this, DatePickerDialog.OnDateSetListener { view, year, monthOfYear, dayOfMonth ->
                        // set day of month , month and year value in the edit text
                calendar[Calendar.YEAR] = year
                calendar[Calendar.MONTH] = monthOfYear
                calendar[Calendar.DAY_OF_MONTH] = dayOfMonth
                supportActionBar?.setSubtitle(Date(calendar.timeInMillis).string("yyyy-MM-dd"))
                getReport()
            }, mYear, mMonth, mDay)
            datePickerDialog.datePicker.maxDate = Calendar.getInstance().timeInMillis
            datePickerDialog.show()
            return true
        }else if(android.R.id.home == id){
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun getReport() {
        val preference = Preference.getInstance(this)
        binding.cardView.hidden()
        val params: MutableMap<String, String> = HashMap()
        params["date"] = Date(calendar.timeInMillis).string("yyyy-MM-dd")
        params["companyname"] = preference.getCompanyName()
        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITY_VISITS, params) { response ->
            try {
                updateAdapter(JSONArray(response))
                binding.cardView.visible()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setAdapter(){
        binding.recyclerview.setManager(this)
        binding.recyclerview.addDivider(this)
        adapter = FacilityVisitAdapter(JSONArray(), OnItemClickListener {
            if(adapter.list.getJSONObject(it).getString("status").equals("Abscent",ignoreCase = true)){
                return@OnItemClickListener
            }
            val bundle = Bundle()
            bundle.putString("atm",adapter.list.getJSONObject(it).getString("atmid"))
            bundle.putString("date",Date(calendar.timeInMillis).string("yyyy-MM-dd"))
            bundle.putString("facility",adapter.list.getJSONObject(it).getString("sitename"))
            val intent  = Intent(applicationContext,FacilityVisiDetailsActivity::class.java)
            intent.putExtras(bundle)
            startActivity(intent)

            //showSheet(adapter.list.getJSONObject(it))
        })
        binding.recyclerview.adapter = adapter
    }

    private fun updateAdapter(jsonArray: JSONArray= JSONArray()){
        adapter.list = jsonArray
        adapter.notifyDataSetChanged()
    }

    fun showSheet(jsonObject: JSONObject){
        if(jsonObject.getString("status").equals("Abscent",ignoreCase = true)){
            return
        }
        val sheet = BottomSheetDialog(this)
        sheet.setContentView(R.layout.sheet_facility_visit)
        val txt_facility: TextView? = sheet.findViewById(R.id.txt_facility)
        val txt_mst_mail: TextView? = sheet.findViewById(R.id.txt_mst_mail)
        val txt_mst_name: TextView? = sheet.findViewById(R.id.txt_mst_name)
        val txt_datetime: TextView? = sheet.findViewById(R.id.txt_datetime)
        val txt_status_type: TextView? = sheet.findViewById(R.id.txt_status_type)
        sheet.run {
            txt_facility!!.text = jsonObject.getString("sitename")
            txt_mst_mail!!.text = jsonObject.getString("emailid")
            txt_mst_name!!.text = jsonObject.getString("employeename")
            txt_datetime!!.text =  jsonObject.getString("status")?.let {
                if( it.equals("check_in",true) || it.equals("check_out"))
                    jsonObject.getString("status_time")
                else { jsonObject.getString("status_time").toDate("yyyy-MM-dd HH:mm:ss").string(DateConstant.REDABLE_DATE)+ " "+
                        jsonObject.getString("starttime") +"\n"+jsonObject.getString("status_time").toDate("yyyy-MM-dd HH:mm:ss").string(DateConstant.REDABLE_DATE)+" "+jsonObject.getString("endtime") }
            }
            txt_status_type!!.text = jsonObject.getString("status")?.let {
                if(it.equals("check_in",true)) "Check In " else if(it.equals("check_out")) "Check Out" else "Time Sheet"
            }
        }
        sheet.show()
    }

}
