package com.b2lmobitech.fieldcloudplus.hcm.others;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;

import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;

import android.util.Log;


import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
//import com.firebase.jobdispatcher.JobParameters;
//import com.firebase.jobdispatcher.JobService;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.common.util.concurrent.ListenableFuture;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocationUpdate extends ListenableWorker {

    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    LocationManager locationManager;
    private String currentlocation = "0.0,0.0";
    private Double currentlocationlaltitue = 0.0, currentlocationlongitude = 0.0;
    String registeredcompany,registeredemailid;
//    Context mycontext;
    public LocationUpdate(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
//        mycontext = appContext;
    }

    @Override
    public ListenableFuture<Result> startWork() {
        // Do your work here.
        Data input = getInputData();
//        Bundle bundle=job.getExtras();
        if(input!=null){
            registeredcompany=input.getString("registeredcompany");
            registeredemailid=input.getString("registeredemailid");
            findlocation();
        }
        // Return a ListenableFuture<>
        return null;
    }

    @Override
    public void onStopped() {
        // Cleanup because you are being stopped.
    }
//    @Override
//    public boolean onStartJob(JobParameters job) {
//        Bundle bundle=job.getExtras();
//        if(bundle!=null){
//         registeredcompany=bundle.getString("registeredcompany");
//         registeredemailid=bundle.getString("registeredemailid");
//         findlocation();
//        }
//        return false;
//    }
//
//    @Override
//    public boolean onStopJob(JobParameters job) {
//        return false;
//    }

    public void findlocation() {

        try {
            final Geocoder geocoder = new Geocoder(getApplicationContext(), Locale.getDefault());
            locationManager = (LocationManager) getApplicationContext().getSystemService(Context.LOCATION_SERVICE);
            mFusedLocationClient = LocationServices.getFusedLocationProviderClient(getApplicationContext());
            if (ActivityCompat.checkSelfPermission(getApplicationContext(), android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(getApplicationContext(), Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return;
            }
            mLocationRequest = new LocationRequest();
            mLocationRequest.setPriority(LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY);
            /* 10 secs */
            long UPDATE_INTERVAL = 10 * 1000;
            mLocationRequest.setInterval(UPDATE_INTERVAL);
            /* 2 sec */
            long FASTEST_INTERVAL = 1000;
            mLocationRequest.setFastestInterval(FASTEST_INTERVAL);
            mLocationRequest.setMaxWaitTime(2000);
            mLocationRequest.setNumUpdates(1);
            mLocationRequest.setExpirationDuration(5000);


            LocationCallback locationCallback=new LocationCallback(){

                @Override
                public void onLocationResult(LocationResult locationResult) {

                    Log.e("Location","in result");
                    if(locationResult.getLocations().size()==0){
                        Log.e("Location","No lcoations found");
                        return;
                    }
                    android.location.Location location =locationResult.getLastLocation();

                    //Place current location marker
                    Log.e("Location", location.getLatitude() + "" + location.getLongitude());
                    currentlocationlaltitue = location.getLatitude();
                    currentlocationlongitude = location.getLongitude();

                    try {
                        List<Address> addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1);
                        Address address = addresses.get(0);

                        if (address != null) {
                            currentlocation = address.getAddressLine(0);
                        } else {
                            currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                        }
                    } catch (Exception e) {
                        currentlocation = currentlocationlaltitue + "," + currentlocationlongitude;
                    }

                    HcmDatabase.getInstance(getApplicationContext())//LocationUpdate.this
                            .insertLocation(registeredcompany,registeredemailid,currentlocation,"",
                                    currentlocationlaltitue.toString(),currentlocationlongitude.toString());
                    syncData();

                };

            };

            Log.e("called","yes");
            mFusedLocationClient.requestLocationUpdates(mLocationRequest, locationCallback, Looper.myLooper());
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    private void syncData(){
        final HcmDatabase hcmDatabase=HcmDatabase.getInstance(getApplicationContext());
        StringRequest postRequest = new StringRequest(Request.Method.POST, HCMURL.INSERT_LOCATION,
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject jsonObject=new JSONObject(response);
                            hcmDatabase.updateLocationSynced(jsonObject.getJSONArray("list"));
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("JSON",hcmDatabase.getLocationNotSynced().toString());
                return params;
            }
        };

            Volley.newRequestQueue(getApplicationContext()).add(postRequest);
    }

}
