package com.b2lmobitech.fieldcloudplus.hcm.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;

import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripExpenseTable;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.attendancetable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.leavetable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.locationtable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.timesheettable;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class HcmDatabase {

    private static HcmDatabase mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static sqldatabase sqliteHelper;

    private HcmDatabase(Context context){
        // Specify the application context
        mContext = context;
        // Get the request queue
        sqliteHelper=new sqldatabase(context);
    }

    public static synchronized HcmDatabase getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(mInstance == null){
            mInstance = new HcmDatabase(context);
        }
        // Return MySingleton new Instance
        return mInstance;
    }

    public JSONArray getTravelsList(String status){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TripTable.TABLENAME +" WHERE "+TripTable.STATUS+"='"+status+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        JSONObject jsonObject=new JSONObject();
                        jsonObject.put("id",cursor.getString(cursor.getColumnIndexOrThrow(TripTable.TRIPID)));
                        jsonObject.put("dt",cursor.getString(cursor.getColumnIndexOrThrow(TripTable.UPDATEDDATETIME)));
                        jsonArray.put(jsonObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTravels(String status){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TripTable.TABLENAME +" WHERE "+TripTable.STATUS+"='"+status+"'";
        switch (status.toLowerCase()){
            case "request":
                query=query+" ORDER BY "+TripTable.DATETIME +" DESC";
                break;
            case "approved":
                query=query+" ORDER BY "+TripTable.START +" ASC";
                break;
            case "cancel":
                query=query+" ORDER BY "+TripTable.END +" DESC";
                break;
        }
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getExpenses(){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TripExpenseTable.TABLENAME +" WHERE "+TripExpenseTable.DELETED+"='no'";
        query=query+" ORDER BY "+TripExpenseTable.DATETIME +" DESC";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONObject getTravelInfo(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TripTable.TABLENAME +" WHERE "+TripTable.TRIPID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if(cursor!=null) {
            cursor.moveToFirst();
            return cursorToJson(cursor);
        }else{
            return null;
        }
    }

    public JSONObject getExpenseInfo(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TripExpenseTable.TABLENAME +" WHERE "+TripExpenseTable.EXPENSEID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if(cursor!=null) {
            cursor.moveToFirst();
            return cursorToJson(cursor);
        }else{
            return null;
        }
    }

    public void insertTravels(JSONArray jsonArray) throws JSONException {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict(TripTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertExpenses(JSONArray jsonArray) throws JSONException {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict(TripExpenseTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insetAttendanceTable(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            try {
                JSONObject jsonObject=jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();

                cv.put(attendancetable.COMPANYNAME, jsonObject.getString("companyname"));
                cv.put(attendancetable.EMAILID, jsonObject.getString("emailid"));
                cv.put(attendancetable.DATE, jsonObject.getString("date"));
                cv.put(attendancetable.CHECKINTIME, jsonObject.getString("checkintime"));
                cv.put(attendancetable.CHECKOUTTIME, jsonObject.getString("checkouttime"));
                cv.put(attendancetable.CHECKINLOCATION, jsonObject.getString("checkinlocation"));
                cv.put(attendancetable.CHECKOUTLOCATION, jsonObject.getString("checkoutlocation"));
                cv.put(attendancetable.STATUS, jsonObject.getString("status"));
                cv.put(attendancetable.TOTALTIME, jsonObject.getString("totaltime"));
                cv.put(attendancetable.INSYNC, "Yes");
                if( jsonObject.getString("checkouttime").equalsIgnoreCase("00:00:00")) {
                    cv.put(attendancetable.OUTSYNC, "No");
                }else{
                    cv.put(attendancetable.OUTSYNC, "Yes");
                }
                sdb.insertWithOnConflict(attendancetable.TABLE_NAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void insertTimesheet(JSONArray jsonArray){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++) {
            try {
                JSONObject jsonObject=jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();
                cv.put(timesheettable.COMPANYNAME, jsonObject.getString("companyname"));
                cv.put(timesheettable.EMPLOYEEEMAILID, jsonObject.getString("employeemailid"));
                cv.put(timesheettable.ATTENDACEGROUP, jsonObject.getString("attendancegroup"));
                cv.put(timesheettable.ATTENDANCESUBGROUP, jsonObject.getString("attendancesubgroup"));
                cv.put(timesheettable.ATTENDANCETEAM, jsonObject.getString("attendenceteam"));
                cv.put(timesheettable.ACTIVITY, jsonObject.getString("activity"));
                cv.put(timesheettable.LATITUDE, jsonObject.getString("latitude"));
                cv.put(timesheettable.LONGITUDE, jsonObject.getString("longitude"));
                cv.put(timesheettable.LOCATION, jsonObject.getString("location"));
                cv.put(timesheettable.TIMESHEETDATE, jsonObject.getString("timesheetdate"));
                cv.put(timesheettable.STARTTIME, jsonObject.getString("starttime"));
                cv.put(timesheettable.ENDTIME, jsonObject.getString("endtime"));
                cv.put(timesheettable.DATEANDTIME, jsonObject.getString("dateandtime"));
                cv.put(timesheettable.SYNC, "yes");
                sdb.insertWithOnConflict(timesheettable.TABLE_NAME, null, cv,SQLiteDatabase.CONFLICT_REPLACE);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public void insertLeaves(JSONArray jsonArray){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++) {
            try {
                JSONObject jsonObject=jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();
                cv.put(leavetable.COMPANYNAME, jsonObject.getString("companyname"));
                cv.put(leavetable.EMPLOYEEEMAILID, jsonObject.getString("employeemailid"));
                cv.put(leavetable.LEAVETYPE, jsonObject.getString("leavetype"));
                cv.put(leavetable.LEAVEFROM, jsonObject.getString("leavefrom"));
                cv.put(leavetable.LEAVETO, jsonObject.getString("leaveto"));
                cv.put(leavetable.LEAVEDAYS, jsonObject.getString("leavedays"));
                cv.put(leavetable.PERMISSIONDATE, jsonObject.getString("permissiondate"));
                cv.put(leavetable.PERMISSIONFROM, jsonObject.getString("permissionfrom"));
                cv.put(leavetable.PERMISSIONTO, jsonObject.getString("permissionto"));
                cv.put(leavetable.PERMISSIONINMINUTES, jsonObject.getString("permissioninminutes"));
                cv.put(leavetable.APPLIEDDATEANDTIME, jsonObject.getString("appliedateandtime"));
                cv.put(leavetable.REASONFORLEAVEORPERMISSION, jsonObject.getString("reasonforleaveorpermission"));
                cv.put(leavetable.STATUS, jsonObject.getString("status"));
                cv.put(leavetable.ACCEPTEDORREJECTEDDATEANDTIME, jsonObject.getString("acceptedorrejecteddateandtime"));
                cv.put(leavetable.REJECTEDREASON, jsonObject.getString("rejectedreason"));
                cv.put(leavetable.PRIORITY, jsonObject.getString("priority"));
                cv.put(leavetable.SYNC, "Yes");
                cv.put(leavetable.SYNCWITHSERVER, "No");
                sdb.insertWithOnConflict(leavetable.TABLE_NAME, null, cv,SQLiteDatabase.CONFLICT_REPLACE);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public JSONArray getLocationNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(locationtable.TABLE_NAME,null,locationtable.SYNC+ " = ? ",new String[]{"No"},null,null,locationtable._ID+" DESC ");
        return cursorToArray(c);
    }

    public JSONArray getTimesheetNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.SYNC+ " = ? ",new String[]{"no"},null,null,timesheettable._ID+" ASC ");
        return cursorToArray(c);
    }

    public JSONArray getLeavesNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.SYNC+ " = ? ",new String[]{"No"},null,null,leavetable._ID+" ASC ");
        return cursorToArray(c);
    }

    public JSONArray getAttendanceNotSynced() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.INSYNC+ " = ? AND "+attendancetable.OUTSYNC+ " = ? ",new String[]{"No","No"},null,null,attendancetable._ID+" DESC ");
        JSONArray jsonArray=new JSONArray();
        if(c.moveToFirst()){
            do{
                JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here
                JSONList.put("companyname",c.getString(c.getColumnIndexOrThrow(attendancetable.COMPANYNAME)));
                JSONList.put("emailid",c.getString(c.getColumnIndexOrThrow(attendancetable.EMAILID)));
                JSONList.put("date",c.getString(c.getColumnIndexOrThrow(attendancetable.DATE)));
                JSONList.put("checkintime",c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKINTIME)));
                JSONList.put("checkouttime",c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKOUTTIME)));
                JSONList.put("checkinlocation",c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKINLOCATION)));
                JSONList.put("checkoutlocation",c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKOUTLOCATION)));
                JSONList.put("status",c.getString(c.getColumnIndexOrThrow(attendancetable.STATUS)));
                JSONList.put("totaltime",c.getString(c.getColumnIndexOrThrow(attendancetable.TOTALTIME)));
                JSONList.put(attendancetable._ID,c.getString(c.getColumnIndexOrThrow(attendancetable._ID)));
                byte[] cam=c.getBlob(c.getColumnIndexOrThrow(attendancetable.ATTENDANCEIMAGE));
                String temp =null;
                if(cam!=null) {
                    temp = Base64.encodeToString(cam, Base64.DEFAULT);

                }
                JSONList.put("checkinimage",temp);
                JSONList.put("checkinimagepath",c.getString(c.getColumnIndexOrThrow(attendancetable.IMAGEPATH)));
                byte[] cam1=c.getBlob(c.getColumnIndexOrThrow(attendancetable.SIGNATURE));
                String temp1 =null;
                if(cam1!=null) {
                    temp1= Base64.encodeToString(cam1, Base64.DEFAULT);

                }

                JSONList.put("checkinsignature",temp1);
                JSONList.put("checkinsignaturepath",c.getString(c.getColumnIndexOrThrow(attendancetable.SIGNATUREPATH)));
                jsonArray.put(JSONList);
            }while(c.moveToNext());

        }

        return jsonArray;

    }

    public JSONArray getAttendanceCheckOutNotSynced() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.INSYNC+ " = ? OR "+attendancetable.OUTSYNC+ " = ? ",new String[]{"No","No"},null,null,attendancetable._ID+" DESC ");
        JSONArray jsonArray=new JSONArray();
        if(c.moveToFirst()){
            do{
                JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here
                JSONList.put("companyname", c.getString(c.getColumnIndexOrThrow(attendancetable.COMPANYNAME)));
                JSONList.put("emailid", c.getString(c.getColumnIndexOrThrow(attendancetable.EMAILID)));
                JSONList.put("date", c.getString(c.getColumnIndexOrThrow(attendancetable.DATE)));
                JSONList.put("checkintime", c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKINTIME)));
                JSONList.put("checkouttime", c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKOUTTIME)));
                JSONList.put("checkinlocation", c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKINLOCATION)));
                JSONList.put("checkoutlocation", c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKOUTLOCATION)));
                JSONList.put("status", c.getString(c.getColumnIndexOrThrow(attendancetable.STATUS)));
                JSONList.put("totaltime", c.getString(c.getColumnIndexOrThrow(attendancetable.TOTALTIME)));
                JSONList.put(attendancetable._ID,c.getString(c.getColumnIndexOrThrow(attendancetable._ID)));
                jsonArray.put(JSONList);
            }while(c.moveToNext());
        }
        return jsonArray;

    }

    public void updateLocationSynced(JSONArray jsonArray) {

        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            ContentValues cv = new ContentValues();
            cv.put(locationtable.SYNC, "Yes");
            try {
                sdb.update(locationtable.TABLE_NAME, cv ,locationtable._ID+" = ? ", new String[]{jsonArray.getString(i)});
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateTimesheetSynced(JSONArray jsonArray) {

        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            ContentValues cv = new ContentValues();
            cv.put(timesheettable.SYNC, "Yes");
            try {
                sdb.update(timesheettable.TABLE_NAME, cv ,timesheettable._ID+" = ? ", new String[]{jsonArray.getString(i)});
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAttendanceSynced(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.INSYNC, "Yes");
            try {
                sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.STATUS+ " = ?  AND "+attendancetable._ID+" = ? "
                        , new String[]{"IN",jsonArray.getString(i)});
            } catch (JSONException e) {
                e.printStackTrace();
            }
            cv.put(attendancetable.OUTSYNC, "Yes");
            try {
                sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.STATUS+ " = ?  AND "+attendancetable._ID+" = ? "
                        , new String[]{"Present",jsonArray.getString(i)});
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

    }
    public void updateLeavesSynced(JSONArray jsonArray){
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            ContentValues cv = new ContentValues();
            cv.put(leavetable.SYNC, "Yes");
            try {
                sdb.update(leavetable.TABLE_NAME, cv ,leavetable._ID+" = ? ", new String[]{jsonArray.getString(i)});
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLeaveDeleted(String leavetype,String applieddatenadtime) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete("leavetable",leavetable.LEAVETYPE+ " = ? AND "+leavetable.APPLIEDDATEANDTIME+ " = ? ", new String[]{leavetype,applieddatenadtime});
    }

    private static JSONObject cursorToJson(Cursor c) throws JSONException {

        JSONObject retVal = new JSONObject();
        for(int i=0; i<c.getColumnCount(); i++) {
            String cName = c.getColumnName(i);

            switch (c.getType(i)) {
                case Cursor.FIELD_TYPE_INTEGER:
                    retVal.put(cName, c.getInt(i));
                    break;
                case Cursor.FIELD_TYPE_FLOAT:
                    retVal.put(cName, c.getFloat(i));
                    break;
                case Cursor.FIELD_TYPE_STRING:
                    retVal.put(cName, c.getString(i));
                    break;
                case Cursor.FIELD_TYPE_BLOB:
                    retVal.put(cName, Utility.getString(c.getBlob(i)));
                    break;
            }
        }
        return retVal;
    }

    private static JSONArray cursorToArray(Cursor c) {

        JSONArray jsonArray=new JSONArray();

        if (c != null) {
            if(c.getCount() > 0)
            {
                c.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(c));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (c.moveToNext());
            }
            c.close();
        }
        return jsonArray;
    }

    public void insertLocation(String Companyname,String emailid,String location,String checkinname,
                               String latitude,String longitude) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        try {
            SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(locationtable.COMPANYNAME, Companyname);
            cv.put(locationtable.EMAILID, emailid);
            cv.put(locationtable.LOCATION, location);
            cv.put(locationtable.CHECKINNAME, checkinname);
            cv.put(locationtable.LATITUDE, latitude);
            cv.put(locationtable.LONGITUDE, longitude);
            cv.put(locationtable.DATE, DateUtils.getCurrentDate());
            cv.put(locationtable.TIME, DateUtils.getCurrentTime());
            cv.put(locationtable.SYNC, "No");

            sdb.insert(locationtable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public String getCheckinTime() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.DATE+ " = ? ",new String[]{DateUtils.getCurrentDate()},null,null,attendancetable._ID+" DESC ");
        String time = null;
        JSONArray jsonArray=new JSONArray();
        if(c.moveToFirst()){
            do{
                time=c.getString(c.getColumnIndexOrThrow(attendancetable.CHECKINTIME));
            }while(c.moveToNext());
        }

        return time;

    }

    public boolean isCheckedIn() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.DATE+ " = ? ",new String[]{DateUtils.getCurrentDate()},null,null,attendancetable._ID+" DESC ");
        return c!=null &&c.moveToFirst();

    }

//
    public String getLeavesmonthlycount(String startdate,String enddate) throws JSONException {
        String leaves = "0";
        Log.d("beforeleaves",leaves);
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();

//
        String query1= "  SELECT "+leavetable.LEAVEFROM +" FROM "+leavetable.TABLE_NAME;
        String query= "  SELECT SUM(Final.dayscount) AS TotalLeaves FROM (( SELECT  CASE "+
                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY('"+startdate+"')+1 )"+
                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+")-JULIANDAY('"+startdate+"')+1 ) "+
                " WHEN "+leavetable.LEAVEFROM+" >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
                " WHEN "+leavetable.LEAVEFROM+"  >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
                " ELSE (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
                " END AS dayscount,"+leavetable.LEAVETYPE+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    and "+leavetable.LEAVEDAYS+" !=0 AND ( "+leavetable.LEAVEFROM+"  >= '"+startdate+"' and  "+leavetable.LEAVETO+"  <= '"+enddate+"') or ( "+leavetable.LEAVEFROM+"  <= '"+enddate+"' and  "+leavetable.LEAVETO+"  >= '"+enddate+"')  or ( "+leavetable.LEAVEFROM+"  <= '"+startdate+"' and  "+leavetable.LEAVETO+"  >= '"+startdate+"') ORDER by  "+leavetable.LEAVEFROM+"  ASC ) AS Final ) " ;
//        String query= " SELECT SUM(Final.dayscount) AS TotalLeaves FROM (( SELECT CASE "+
//                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY('"+startdate+"')+1 )"+
//                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+")-JULIANDAY('"+startdate+"')+1 ) "+
//                " WHEN "+leavetable.LEAVEFROM+" >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
//                " WHEN "+leavetable.LEAVEFROM+"  >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
//                " ELSE (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
//                " END AS dayscount,  "+leavetable.LEAVETYPE+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    and "+leavetable.LEAVEDAYS+" !=0 AND ( "+leavetable.LEAVEFROM+"  >= '"+startdate+"' and  "+leavetable.LEAVETO+"  <= '"+enddate+"') or ( "+leavetable.LEAVEFROM+"  <= '"+enddate+"' and  "+leavetable.LEAVETO+"  >= '"+enddate+"')  or ( "+leavetable.LEAVEFROM+"  <= '"+startdate+"' and  "+leavetable.LEAVETO+"  >= '"+startdate+"') ORDER by  "+leavetable.LEAVEFROM+"  ASC) AS Final ) " ;
        Cursor c = sdb.rawQuery(query,null);
        if(c.moveToFirst()){
            Log.d("c count",""+c.getCount());
            //do{
            try {
                if(c.getString(c.getColumnIndexOrThrow("TotalLeaves"))==null)
                {
                    leaves ="0";
                }
                else {
                    leaves = c.getString(c.getColumnIndexOrThrow("TotalLeaves"));
                }
            }catch(Throwable  t)
            {
                Log.d("Message",t.getCause().getMessage());
                leaves = "0";
            }
            Log.d("leaves",leaves.toString());
//               leaves = String.valueOf(c.getCount());
           // }while(c.moveToNext());
        }

        return leaves;
    }
    public ArrayList<String> getLeavesmonthlydates(String startdate, String enddate)  {
        String leavefromvalue = null;
        String leavetovalue = null;
        Date leavefromvalue_date = null;
        Date leavetovalue_date = null;
        Date startdate_date = null;
        Date enddate_date = null;
        ArrayList<String> Leave_dates  = new ArrayList<>();
        Set<String> set = new HashSet<>(Leave_dates);//To avoid duplicates
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        //        String query= "  ( WITH RECURSIVE Listdates(Alldates) AS ("+
//                "VALUES('"+startdate+"')"+
//                "UNION ALL"+
//                "SELECT Alldates(date, '+1 day')"+
//               " FROM "+leavetable.TABLE_NAME   +
//                "WHERE Alldates < '"+enddate+"')"+
//        "SELECT Alldates FROM Listdates) " ;
//
        String query= "  SELECT "+leavetable.LEAVETYPE+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    and "+leavetable.LEAVEDAYS+" !=0 AND ( "+leavetable.LEAVEFROM+"  >= '"+startdate+"' and  "+leavetable.LEAVETO+"  <= '"+enddate+"') or ( "+leavetable.LEAVEFROM+"  <= '"+enddate+"' and  "+leavetable.LEAVETO+"  >= '"+enddate+"')  or ( "+leavetable.LEAVEFROM+"  <= '"+startdate+"' and  "+leavetable.LEAVETO+"  >= '"+startdate+"') ORDER by  "+leavetable.LEAVEFROM+"  ASC  " ;
        Cursor c = sdb.rawQuery(query,null);
        Calendar cal1 = null;
        Calendar cal2 = null;
        if(c.moveToFirst()){
            do{
                leavefromvalue = c.getString(c.getColumnIndexOrThrow(leavetable.LEAVEFROM));
                leavetovalue = c.getString(c.getColumnIndexOrThrow(leavetable.LEAVETO));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                     leavefromvalue_date = format.parse(leavefromvalue);
                     leavetovalue_date = format.parse(leavetovalue);
                    startdate_date = format.parse(startdate);
                    enddate_date = format.parse(enddate);


                } catch (ParseException e) {
                    e.printStackTrace();
                }
                 cal1 = Calendar.getInstance();
                 cal2 = Calendar.getInstance();

//                Toast.makeText(mContext, "leavefromvalue_date"+leavefromvalue_date, Toast.LENGTH_SHORT).show();
//                Toast.makeText(mContext, "leavetovalue_date"+leavetovalue_date, Toast.LENGTH_SHORT).show();
//                Toast.makeText(mContext, "startdate_date"+startdate_date, Toast.LENGTH_SHORT).show();
//                Toast.makeText(mContext, "enddate_date"+enddate_date, Toast.LENGTH_SHORT).show();

            if(startdate_date.compareTo(leavefromvalue_date)>0 && leavetovalue_date.compareTo(enddate_date)>0 ) // leavefromvalue_date > startdate_date
            {
//                Toast.makeText(mContext, "case1", Toast.LENGTH_SHORT).show();
                cal1.setTime(startdate_date);
                cal2.setTime(enddate_date);
                while(!cal1.after(cal2))
                {
                    set.add(format.format(cal1.getTime()).toString());
                    cal1.add(Calendar.DATE, 1);
                }

            }
            else if(startdate_date.compareTo(leavefromvalue_date)>0 && enddate_date.compareTo(leavetovalue_date)>0 )
            {
//                Toast.makeText(mContext, "case2", Toast.LENGTH_SHORT).show();
                cal1.setTime(startdate_date);
                cal2.setTime(leavetovalue_date);
                while(!cal1.after(cal2))
                {
                    set.add(format.format(cal1.getTime()).toString());
                    cal1.add(Calendar.DATE, 1);
                }

            }
            else if(leavefromvalue_date.compareTo(startdate_date)>0 && leavetovalue_date.compareTo(enddate_date)>0 )
            {
//                Toast.makeText(mContext, "case3", Toast.LENGTH_SHORT).show();
                cal1.setTime(leavefromvalue_date);
                cal2.setTime(enddate_date);
                while(!cal1.after(cal2))
                {
                    set.add(format.format(cal1.getTime()).toString());
                    cal1.add(Calendar.DATE, 1);
                }

            }
            else if(leavefromvalue_date.compareTo(startdate_date)>0 && enddate_date.compareTo(leavetovalue_date)>0 )
            {
//                Toast.makeText(mContext, "case4", Toast.LENGTH_SHORT).show();
                cal1.setTime(leavefromvalue_date);
                cal2.setTime(leavetovalue_date);
                while(!cal1.after(cal2))
                {
                    set.add(format.format(cal1.getTime()).toString());
                    cal1.add(Calendar.DATE, 1);
                }

            }

//               leaves = String.valueOf(c.getCount());
             }while(c.moveToNext());
            Leave_dates.addAll(set);
//            Toast.makeText(mContext, "leavedate="+Leave_dates, Toast.LENGTH_SHORT).show();
        }

        return Leave_dates;
    }
    public ArrayList<String> getLeavedetail_selecteddate(String selecteddate) {
        ArrayList<String> Leave_details  = new ArrayList<>();
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
//Toast.makeText(mContext, "selecteddate=" + selecteddate, Toast.LENGTH_SHORT).show();
//        String query= "  SELECT "+leavetable.LEAVETYPE+", "+leavetable.PERMISSIONDATE+", "+leavetable.PERMISSIONFROM+", "+leavetable.PERMISSIONTO+", "+leavetable.PERMISSIONINMINUTES+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    AND (('"+selecteddate+"' >= "+leavetable.LEAVEFROM+"  and  '"+selecteddate+"' <= "+leavetable.LEAVETO+") OR ("+leavetable.PERMISSIONDATE +"= '"+selecteddate+"')) ORDER by  "+leavetable.LEAVEFROM+"  ASC  " ;
        String query= "  SELECT "+leavetable.LEAVETYPE+", "+leavetable.PERMISSIONDATE+", "+leavetable.PERMISSIONFROM+", "+leavetable.PERMISSIONTO+", "+leavetable.PERMISSIONINMINUTES+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending' AND "+leavetable.LEAVEDAYS+" !=0   AND (('"+selecteddate+"' >= "+leavetable.LEAVEFROM+"  and  '"+selecteddate+"' <= "+leavetable.LEAVETO+") ) ORDER by  "+leavetable.LEAVEFROM+"  ASC  " ;

        Cursor c = sdb.rawQuery(query,null);
        if (c != null) {
            if(c.getCount() > 0) {
                c.moveToFirst();
                //do{
//                if(c.getString(c.getColumnIndex(leavetable.LEAVETYPE)).equalsIgnoreCase("permission"))
//                {
//
//
////                        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
////                        SimpleDateFormat formatter2 = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
//
//                Leave_details.add(changetimeformat(c.getString(c.getColumnIndex(leavetable.PERMISSIONFROM))));
//                    Leave_details.add(changetimeformat(c.getString(c.getColumnIndex(leavetable.PERMISSIONTO))));
//                    Leave_details.add(c.getString(c.getColumnIndex(leavetable.PERMISSIONINMINUTES)));
//                }
//                else {
                    try {

                        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                        SimpleDateFormat formatter2 = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
                        Leave_details.add(formatter2.format(formatter1.parse(c.getString(c.getColumnIndexOrThrow(leavetable.LEAVEFROM)))).toString());
//                Leave_details.add(c.getString(c.getColumnIndex(leavetable.LEAVEFROM)));
                        Leave_details.add(formatter2.format(formatter1.parse(c.getString(c.getColumnIndexOrThrow(leavetable.LEAVETO)))).toString());
                    } catch (Exception e) {
                    }
                    Leave_details.add(c.getString(c.getColumnIndexOrThrow(leavetable.LEAVEDAYS)));
//                }
                Leave_details.add(c.getString(c.getColumnIndexOrThrow(leavetable.REASONFORLEAVEORPERMISSION)));
                Leave_details.add(c.getString(c.getColumnIndexOrThrow(leavetable.LEAVETYPE)));
//               leaves = String.valueOf(c.getCount());
                // }while(c.moveToNext());

            }
            c.close();
        }
//        Toast.makeText(mContext, "c.getcount =" + c.getCount(), Toast.LENGTH_SHORT).show();

        return Leave_details;
    }
//    public int getcurrentmonth_present(String startdate,String endate)  {
//        int count =0;
//        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
//        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.DATE+ " <= ' ? ' AND "+attendancetable.DATE+ " >= ' ? ' ",new String[]{endate,startdate},null,null,null);
//       // JSONArray jsonArray=new JSONArray();
//        if(c.moveToFirst()){
//           count = c.getCount();
//        }
//
//        return count;
//
//    }
    private String changetimeformat(String input) {
        TimeZone utc = TimeZone.getTimeZone("etc/UTC");
        DateFormat inputFormat = new SimpleDateFormat("HH:mm:ss",
                Locale.US);
        inputFormat.setTimeZone(utc);
        DateFormat outputFormat = new SimpleDateFormat("hh:mm aa",
                Locale.US);
        outputFormat.setTimeZone(utc);

        Date date = null;
        try {
            date = inputFormat.parse(input);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String output = outputFormat.format(date);
        return output;
    }
}
