package com.b2lmobitech.fieldcloudplus.hcm.timesheet;

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityFacilityVisitsBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityTimesheetSummaryBinding
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.inRequestFormat
import com.b2lmobitech.fieldcloudplus.utils.setManager
import com.b2lmobitech.fieldcloudplus.utils.string
//import kotlinx.android.synthetic.main.activity_timesheet_summary.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class TimesheetSummaryActivity : AppCompatActivity() {

    private lateinit var adapter:TimesheetSummaryAdapter
    private lateinit var binding: ActivityTimesheetSummaryBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_timesheet_summary)
        binding = ActivityTimesheetSummaryBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar?.run {
            setDisplayHomeAsUpEnabled(true)
            setTitle("Timesheet Report")
        }

        setAdapter()
        getTimesheet()
    }

    private fun getTimesheet() {
        val preference = Preference.getInstance(this)

        val params: MutableMap<String, String> = HashMap()
        params["date"] = Date().string("yyyy-MM-dd")
        params["companyname"] = preference.getCompanyName()
        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_REPORT_TIMESHEET, params) { response ->
            try {
                val jsonObject = JSONObject(response)
                updateAdapter(jsonObject.getJSONArray("list"))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setAdapter(){
        binding.recyclerview.setManager(this)
        binding.recyclerview.addDivider(this)
        adapter = TimesheetSummaryAdapter(JSONArray())
        binding.recyclerview.adapter = adapter
    }

    private fun updateAdapter(jsonArray: JSONArray= JSONArray()){
        adapter.list = jsonArray
        adapter.notifyDataSetChanged()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        onBackPressed()
        return super.onOptionsItemSelected(item)
    }

}
