package com.b2lmobitech.fieldcloudplus.hcm.timesheet

import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
//import kotlinx.android.synthetic.main.custom_timesheet.view.*
import org.json.JSONArray
import org.json.JSONObject

/**
 * Created by home on 10/31/2017.
 */
class TimesheetSummaryAdapter(var list:JSONArray) : androidx.recyclerview.widget.RecyclerView.Adapter<TimesheetSummaryAdapter.viewHolder>() {


    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        val jsonObject = list.getJSONObject(holder.layoutPosition);
        holder.from.text = jsonObject.getString("starttime")
        holder.to.text = jsonObject.getString("endtime")
        holder.activity.text = jsonObject.getString("activity")
        holder.timesheetdate.text = jsonObject.getString("timesheetdate")
        holder.team.text = jsonObject.getString("employeename")
    }

    override fun getItemCount(): Int { return list.length() }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context)
                .inflate(R.layout.custom_timesheet, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView)
    {
        val from: TextView = itemView.findViewById(R.id.from)
        val to: TextView = itemView.findViewById(R.id.to)
        val activity: TextView = itemView.findViewById(R.id.activity)
        val timesheetdate: TextView = itemView.findViewById(R.id.timesheetdate)
        val team: TextView = itemView.findViewById(R.id.team)
    }

}