package com.b2lmobitech.fieldcloudplus.hcm.timesheet

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import android.app.TimePickerDialog
import android.app.TimePickerDialog.OnTimeSetListener
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import android.content.Context
import android.content.Intent
import android.content.IntentSender.SendIntentException
import android.content.pm.PackageManager
import android.location.Address
import android.location.Geocoder
import android.net.ConnectivityManager
import android.os.Bundle
import android.os.Looper
import com.google.android.material.snackbar.Snackbar
import androidx.core.app.ActivityCompat
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import android.util.Log
import android.view.View
import android.widget.Button
import android.widget.EditText
import android.widget.ProgressBar
import android.widget.TextView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.TimeSheetVM
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.utils.DistanceCalculator
import com.b2lmobitech.fieldcloudplus.utils.format
import com.b2lmobitech.fieldcloudplus.utils.toast
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import java.text.SimpleDateFormat
import java.util.*

class addtimesheet : AppCompatActivity() {

    private var from: EditText? = null
    private var to: EditText? = null
    private var activity: EditText? = null
    private var mycontext: Context? = null
    private var snackBar: Snackbar? = null
    private var hour_from = ""
    private var minute_from = ""

    private var fromTime = Calendar.getInstance();
    private val toTime = Calendar.getInstance();


    private var registeredcompany = ""
    private var registeredemailid = ""

    private var submitbutton: Button? = null
    private var mDbHelper: sqldatabase? = null
    private var progressBar: ProgressBar? = null

    private var timesheet_latitude = "0.0"
    private var timesheet_longitude = "0.0"
    private var timesheet_location = "not found"
    private var timesheet_activity = ""
    private var timesheet_fromtime = ""
    private var timesheet_totime = ""
    private var timesheet_date = ""
    private var timesheet_dateandtime = ""
    private var currentlocation = "Not found"
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0

    private var addresses: List<Address>? = null

    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    private lateinit var mLocationRequest: LocationRequest

    private lateinit var dbViewModel: TimeSheetVM

    //Geo Fence Details
    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0
    private var facilityId = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_addtimesheet)
        val toolbar = findViewById<View>(R.id.toolbar) as Toolbar
        setSupportActionBar(toolbar)
        mycontext = this
        mDbHelper = sqldatabase(mycontext)
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate time", Snackbar.LENGTH_INDEFINITE)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0)
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "")!!
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "")!!

        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(TimeSheetVM::class.java)

        geoFenceEnabled = intent.getBooleanExtra("geo", false)
        geoLat = intent.getDoubleExtra("lat", 0.0)
        geoLon = intent.getDoubleExtra("lon", 0.0)
        geoDistance = intent.getIntExtra("distance", 0)
        facilityId = intent.getStringExtra("facility")?:""

        widgets()
        setListeners()
    }

    private fun widgets() {
        from = findViewById<View>(R.id.from) as EditText
        to = findViewById<View>(R.id.to) as EditText
        val date = findViewById<View>(R.id.date) as TextView
        activity = findViewById<View>(R.id.details) as EditText
        submitbutton = findViewById<View>(R.id.submitbutton) as Button
        progressBar = findViewById<View>(R.id.addtimesheetprogressBar) as ProgressBar
        val sdf2 = SimpleDateFormat("dd MMMM yyyy,EEEE")
        date.text = sdf2.format(Date())
    }

    private fun setListeners() {
        fromTime = Calendar.getInstance()
        val hour = fromTime[Calendar.HOUR_OF_DAY]
        val minute = fromTime[Calendar.MINUTE]
        hour_from = if (hour < 10) {
            "0$hour"
        } else {
            "" + hour
        }
        minute_from = if (minute < 10) {
            "0$minute"
        } else {
            "" + minute
        }

        from!!.setText("$hour_from:$minute_from")


        /*  from!!.setOnClickListener {
              to!!.setText("")
              fromTime = Calendar.getInstance()
              val hour = fromTime[Calendar.HOUR_OF_DAY]
              val minute = fromTime[Calendar.MINUTE]
              val mTimePicker = TimePickerDialog(mycontext, OnTimeSetListener { timePicker, selectedHour, selectedMinute ->
                  fromTime.set(Calendar.HOUR_OF_DAY,selectedHour)
                  fromTime.set(Calendar.MINUTE,selectedMinute)
                  fromTime.set(Calendar.SECOND,0)

                  snackBar!!.dismiss()
                  hour_from = if (selectedHour < 10) {
                      "0$selectedHour"
                  } else {
                      "" + selectedHour
                  }
                  minute_from = if (selectedMinute < 10) {
                      "0$selectedMinute"
                  } else {
                      "" + selectedMinute
                  }
                  from!!.setText("$hour_from:$minute_from")
              }, hour, minute, true)
              mTimePicker.setTitle("24 Hour Time format")
              mTimePicker.show()
          }*/

        to!!.setOnClickListener {
            if (from!!.text.toString().equals("", ignoreCase = true)) {
                snackBar!!.dismiss()
                snackBar = Snackbar.make(findViewById(android.R.id.content), "Please give from", Snackbar.LENGTH_INDEFINITE)
                toast()
            } else {
                toTime.time = fromTime.time
                val hour = toTime[Calendar.HOUR_OF_DAY]
                val minute = toTime[Calendar.MINUTE]

                val mTimePicker = TimePickerDialog(mycontext, OnTimeSetListener { timePicker, selectedHour, selectedMinute ->

                    toTime.time = Date(fromTime.timeInMillis)
                    toTime.set(Calendar.HOUR_OF_DAY, selectedHour)
                    toTime.set(Calendar.MINUTE, selectedMinute)
                    toTime.set(Calendar.SECOND, 0)

                    val diff = toTime.time.time - fromTime.time.time

                    val Mins = (diff / (1000 * 60)).toInt()

                    if (Mins > 0) {
                        snackBar!!.dismiss()
                        hour_from = if (selectedHour < 10) {
                            "0$selectedHour"
                        } else {
                            "" + selectedHour
                        }
                        minute_from = if (selectedMinute < 10) {
                            "0$selectedMinute"
                        } else {
                            "" + selectedMinute
                        }
                        to!!.setText("$hour_from:$minute_from")

                    } else {
                        snackBar!!.dismiss()
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Invalidate time", Snackbar.LENGTH_INDEFINITE)
                        toast()
                        to!!.setText("")
                    }
                }, hour, minute, true)
                mTimePicker.setTitle("24 Hour Time format")
                mTimePicker.show()
            }
        }
        submitbutton!!.setOnClickListener {
            if (activity!!.text.toString().equals("", ignoreCase = true) || from!!.text.toString().equals("", ignoreCase = true)
                    || to!!.text.toString().equals("", ignoreCase = true)) {
                snackBar!!.dismiss()
                snackBar = Snackbar.make(findViewById(android.R.id.content), "All fields are manditory.", Snackbar.LENGTH_INDEFINITE)
                toast()
            } else {
                validateTimesheet()
            }
        }
    }

    private fun validateTimesheet() {
        timesheet_latitude = currentlocationlaltitue.toString()
        timesheet_longitude = currentlocationlongitude.toString()
        timesheet_location = currentlocation
        timesheet_activity = activity!!.text.toString()
        timesheet_fromtime = fromTime.format("HH:mm:") + "00"
        timesheet_totime = toTime.format("HH:mm:") + "00"

        val onlydate = SimpleDateFormat("yyyy-MM-dd")
        val dateandtime = SimpleDateFormat("HH:mm:ss")

        timesheet_date = Calendar.getInstance().format("yyyy-MM-dd")
        timesheet_dateandtime = Calendar.getInstance().format("yyyy-MM-dd HH:mm:ss")

        val query = dbViewModel.validateTimesheet(
                startTime = fromTime.format("HH:mm:") + "00",
                endTime = toTime.format("HH:mm:") + "00",
                date = timesheet_date)
        val observer = object : Observer<List<TimesheetEntity>> {
//            override fun onChanged(it: List<TimesheetEntity>?) {
//
//                query.removeObserver(this)
//                if (it == null || it.isEmpty()) {
//                    connectLocation()
//                } else {
//                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the submitted Timesheet and try again.", Snackbar.LENGTH_INDEFINITE)
//                    toast()
//                }
//
//            }

            override fun onChanged(it: List<TimesheetEntity>) {
                query.removeObserver(this)
                if (it == null || it.isEmpty()) {
                    connectLocation()
                } else {
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check the submitted Timesheet and try again.", Snackbar.LENGTH_INDEFINITE)
                    toast()
                }

            }
        }
        query.observe(this, observer)
    }

    private fun insertTimesheet() {
        val preference = Preference.getInstance(this)


        val timeSheet = TimesheetEntity(companyname = registeredcompany,
                employeemailid = registeredemailid,
                attendancegroup = preference.getString(globalvariables.logout_group),
                attendancesubgroup = preference.getString(globalvariables.logout_subgroup),
                attendenceteam = preference.getString(globalvariables.logout_team),
                activity = timesheet_activity, latitude = currentlocationlaltitue.toString(),
                longitude = currentlocationlongitude.toString(), location = currentlocation,
                timesheetdate = timesheet_date,
                starttime = fromTime.format("HH:mm:ss"),
                endtime = toTime.format("HH:mm:ss"),
                dateandtime = timesheet_dateandtime, sync = "No", facility_id = facilityId)

        dbViewModel.saveTimesheet(timeSheet, object : TimeSheetVM.CompletedCallBack {
            override fun onTaskCompleted() {
                finish()
            }
        })


    }

    private fun toast() {
        snackBar!!.setAction("CLOSE") { snackBar!!.dismiss() }.setActionTextColor(resources.getColor(android.R.color.holo_blue_dark)).show()
    }

    override fun onDestroy() {
        mDbHelper!!.close()
        super.onDestroy()
    }

    //	Log.d("wifi connectivity", "wifi not connected");// do your stuff
    // 	Log.d("wifi connectivity", "connected");
    // if no network is available networkInfo will be null
    // otherwise check if we are connected
    fun isNetworkAvailable(): Boolean {
        val cm = mycontext!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val networkInfo = cm.activeNetworkInfo
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected) {
            if (cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI)?.isConnectedOrConnecting == true) { // do your stuff
//			    Log.d("wifi connectivity", "connected");
            } else { //			    	   Log.d("wifi connectivity", "wifi not connected");
            }
            return true
        }
        return false
    }

    fun findlocation() {
        val geocoder = Geocoder(mycontext!!, Locale.getDefault())
        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }
        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener {
            it.result?.let { location ->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + "" + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude
                try {
                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1) // Here 1 represent max location result to returned, by documents it recommended 1 to 5
                    val address = addresses?.get(0)
                    currentlocation = if (address != null) {
                        address.getAddressLine(0)
                    } else {
                        "$currentlocationlaltitue,$currentlocationlongitude"
                    }
                } catch (e: Exception) { // TODO Auto-generated catch block
//										e.printStackTrace();
                    currentlocation = "$currentlocationlaltitue,$currentlocationlongitude"
                } finally {
                    calculateDistance()
                }
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }
    }

    fun connectLocation() {
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 10000
        locationRequest.fastestInterval = 10000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())
        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                // All location settings are satisfied. The client can initialize location
                findlocation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(
                                this@addtimesheet,
                                REQUEST_CHECK_SETTINGS)
                    } catch (e: SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            REQUEST_CHECK_SETTINGS -> when (resultCode) {
                Activity.RESULT_OK -> findlocation()
                Activity.RESULT_CANCELED -> RequestProgress.getInstance(this).hideProgressBar()
                else -> {
                }
            }
        }
    }

    private fun calculateDistance(lat: Double = currentlocationlaltitue, lon: Double = currentlocationlongitude) {
        val distance = DistanceCalculator.distance(geoLat, geoLon, lat, lon)
        Log.d("location","$geoLat, $geoLon, $lat, $lon")
        if (!geoFenceEnabled || distance <= geoDistance) {
            insertTimesheet()
        } else {
            alertNotInFacility()
        }
    }

    private fun alertNotInFacility() {
        val alertdialog = AlertDialog.Builder(this)
        alertdialog.setMessage("It seems you are out of the geofence")
        alertdialog.setPositiveButton("Close"
        ) { dialog, whichButton -> finish() }.create()
        alertdialog.setCancelable(false)
        alertdialog.show()
    }

    companion object {
        const val REQUEST_CHECK_SETTINGS = 1
    }

}