package com.b2lmobitech.fieldcloudplus.hcm.timesheet

import android.app.DatePickerDialog
import android.app.DatePickerDialog.OnDateSetListener
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.paging.PagedList
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.os.Bundle
import androidx.coordinatorlayout.widget.CoordinatorLayout
import com.google.android.material.floatingactionbutton.FloatingActionButton
import com.google.android.material.snackbar.Snackbar
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import android.view.LayoutInflater
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import android.widget.*
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.hcm.adapter.timesheetadapter
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.TimeSheetVM
import com.b2lmobitech.fieldcloudplus.hcm.new_wroks.ChooseFacilityFragment
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.others.utils.Preference
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class timesheet : AppCompatActivity() {

    private var mycontext: Context? = null
    private var fab: FloatingActionButton? = null
    private var fab1: FloatingActionButton? = null
    private var fab2: FloatingActionButton? = null
    private var fab_open: Animation? = null
    private var fab_close: Animation? = null
    private var rotate_forward: Animation? = null
    private var rotate_backward: Animation? = null
    private var isFabOpen = false

    private var registeredcompany = ""
    private var registeredemailid = ""
    private var month_from = ""
    private var day_from = ""
    private var month_to = ""
    private var day_to = ""

    private var addtimesheettext: TextView? = null
    private var addfiltertext: TextView? = null
    private var history: TextView? = null
    private var pull: TextView? = null
    private var refreshicon: ImageView? = null
    private var swipeContainer: androidx.swiperefreshlayout.widget.SwipeRefreshLayout? = null
    private var snackBar: Snackbar? = null

    private var timesheetdates = ArrayList<String>()
    private var teams = ArrayList<String>()
    private var starttimes = ArrayList<String>()
    private var endtimes = ArrayList<String>()
    private var activities = ArrayList<String>()
    private var sync = ArrayList<String>()

    private var timesheetlistview: ListView? = null
    private var coordinatorLayout: androidx.coordinatorlayout.widget.CoordinatorLayout? = null

    private lateinit var dbViewModel: TimeSheetVM

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_timesheet)
        val toolbar = findViewById<View>(R.id.toolbar) as Toolbar
        setSupportActionBar(toolbar)
        mycontext = this
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0)
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "")!!
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "")!!

        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(TimeSheetVM::class.java)

        getwidgets()
        setListeners()
        getFacilities()
    }




    private fun getFacilities() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = Preference.getInstance(this).emailId

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITIES, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                dbViewModel.addAllFacilities(jsonArray)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getFacilitiesOffline() {

        dbViewModel.getAllFacilities().removeObservers(this)

        dbViewModel.getAllFacilities().observe(this, Observer { facilityEntities ->
            dbViewModel.getAllFacilities().removeObservers(this)
            showChooseFacilityDialog(facilityEntities)
        })
    }

    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0
    private var geoFacility = "NA"

    private fun showChooseFacilityDialog(facilityEntities: List<FacilityEntity>?) {
        val chooseFacilityFragment = ChooseFacilityFragment()
        chooseFacilityFragment.setfacilityEntities(facilityEntities!!)
        val facilitySelectedListener: ChooseFacilityFragment.FacilitySelectedListener = object : ChooseFacilityFragment.FacilitySelectedListener {
            override fun onFacilitySelected(facilityEntity: FacilityEntity) {
                if (facilityEntity.geofencing.equals("enable", ignoreCase = true)) {
                    geoFenceEnabled = true
                    geoLat = facilityEntity.latitude.toDouble()
                    geoLon = facilityEntity.longitude.toDouble()
                    geoDistance = facilityEntity.geo_distance.toInt()
                    geoFacility = facilityEntity.atmid
                } else {
                    geoFenceEnabled = false
                }
                if (chooseFacilityFragment.isAdded) chooseFacilityFragment.dismiss()
                showTimesheet()
            }
        }
        chooseFacilityFragment.setFacilitySelectedListener(facilitySelectedListener)
        if (facilityEntities.isEmpty()) {
            showTimesheet()
        } else if (facilityEntities.size == 1) {
            facilitySelectedListener.onFacilitySelected(facilityEntities[0])
        } else {
            chooseFacilityFragment.show(supportFragmentManager, "facility_dialog")
        }
    }

    private fun showTimesheet(){
        val intent = Intent(mycontext, addtimesheet::class.java)
        val extras = Bundle()
        extras.putBoolean("geo", geoFenceEnabled)
        extras.putDouble("lat", geoLat)
        extras.putDouble("lon", geoLon)
        extras.putInt("distance", geoDistance)
        extras.putString("facility", geoFacility)
        intent.putExtras(extras)
        startActivity(intent)
        try {
            animateFAB()
        } catch (ignored: Exception) {
        }
    }

    override fun onResume() {
        super.onResume()
        setAdapter()
        syncData()
    }

    private fun getwidgets() {
            fab_open = AnimationUtils.loadAnimation(applicationContext, R.anim.fab_open)
            fab_close = AnimationUtils.loadAnimation(applicationContext, R.anim.fab_close)
            rotate_forward = AnimationUtils.loadAnimation(applicationContext, R.anim.rotate_forward)
            rotate_backward = AnimationUtils.loadAnimation(applicationContext, R.anim.rotate_backward)
            fab = findViewById(R.id.fab)
            fab1 = findViewById(R.id.fab1)
            fab2 = findViewById(R.id.fab2)
            addtimesheettext = findViewById(R.id.addtimesheettext)
            addfiltertext = findViewById(R.id.addfiltertext)
            timesheetlistview = findViewById(R.id.timesheetlistview)
            history = findViewById(R.id.history)
            refreshicon = findViewById(R.id.refreshicon)
            pull = findViewById(R.id.pull)
            swipeContainer = findViewById(R.id.swipeContainer)
            timesheetdates = ArrayList()
            teams = ArrayList()
            starttimes = ArrayList()
            endtimes = ArrayList()
            activities = ArrayList()
            sync = ArrayList()
        }

    private fun setListeners() {
        fab!!.setOnClickListener {
            try {
                animateFAB()
            } catch (ignored: Exception) {
            }
        }
        fab1!!.setOnClickListener {
           getFacilitiesOffline()
        }
        fab2!!.setOnClickListener { showTimesheetFilterAlert() }

        swipeContainer?.setOnRefreshListener {
            swipeContainer?.isRefreshing = false
            syncData()
            setAdapter()
        }

    }

    val startDate = Calendar.getInstance()
    val endDate = Calendar.getInstance()

    private fun showTimesheetFilterAlert() {



        val dialogBuilder = AlertDialog.Builder(mycontext!!)
        val inflater = mycontext!!.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val dialogView = inflater.inflate(R.layout.custom_timesheet_filter, null)
        dialogBuilder.setView(dialogView)
        val fromfilter = dialogView.findViewById<View>(R.id.fromcalendervalue) as EditText
        val tofilter = dialogView.findViewById<View>(R.id.tocalendervalue) as EditText
        val cancel = dialogView.findViewById<View>(R.id.cancel) as Button
        val apply = dialogView.findViewById<View>(R.id.apply) as Button
        val alertDialog = dialogBuilder.create()
        alertDialog.show()
        fromfilter.setOnClickListener {
            tofilter.setText("")
            val c = Calendar.getInstance()
            val mYear = c[Calendar.YEAR] // current year
            val mMonth = c[Calendar.MONTH] // current month
            val mDay = c[Calendar.DAY_OF_MONTH] // current day

            // date picker dialog
            val datePickerDialog = DatePickerDialog(this,
                    OnDateSetListener { view, year, monthOfYear, dayOfMonth ->
                        // set day of month , month and year value in the edit text
                        startDate[Calendar.YEAR] = year
                        startDate[Calendar.MONTH] = monthOfYear
                        startDate[Calendar.DAY_OF_MONTH] = dayOfMonth

                        var monthOfYear = monthOfYear
                        monthOfYear = monthOfYear + 1
                        month_from = if (monthOfYear < 10) {
                            "0$monthOfYear"
                        } else {
                            "" + monthOfYear
                        }
                        day_from = if (dayOfMonth < 10) {
                            "0$dayOfMonth"
                        } else {
                            "" + dayOfMonth
                        }
                        fromfilter.setText("$year-$month_from-$day_from")

                    }, mYear, mMonth, mDay)
            datePickerDialog.show()
        }
        tofilter.setOnClickListener {
            if (fromfilter.text.toString().equals("", ignoreCase = true)) {
                Toast.makeText(mycontext, "please give from", Toast.LENGTH_LONG).show()
            } else {
                val c = Calendar.getInstance()
                val mYear = c[Calendar.YEAR] // current year
                val mMonth = c[Calendar.MONTH] // current month
                val mDay = c[Calendar.DAY_OF_MONTH] // current day
                // date picker dialog
                val datePickerDialog = DatePickerDialog(this,
                        OnDateSetListener { view, year, monthOfYear, dayOfMonth ->
                            // set day of month , month and year value in the edit text

                            endDate[Calendar.YEAR] = year
                            endDate[Calendar.MONTH] = monthOfYear
                            endDate[Calendar.DAY_OF_MONTH] = dayOfMonth
                            var monthOfYear = monthOfYear
                            monthOfYear = monthOfYear + 1
                            month_to = if (monthOfYear < 10) {
                                "0$monthOfYear"
                            } else {
                                "" + monthOfYear
                            }
                            day_to = if (dayOfMonth < 10) {
                                "0$dayOfMonth"
                            } else {
                                "" + dayOfMonth
                            }
                            tofilter.setText("$year-$month_to-$day_to")
                            val fromdays = fromfilter.text.toString().split("-").toTypedArray()
                            val fromyear = Integer.valueOf(fromdays[0])
                            val frommonth = Integer.valueOf(fromdays[1])
                            val fromday = Integer.valueOf(fromdays[2])
                            val myCalendar_from = Calendar.getInstance()
                            myCalendar_from[Calendar.YEAR] = fromyear
                            myCalendar_from[Calendar.MONTH] = frommonth - 1
                            myCalendar_from[Calendar.DAY_OF_MONTH] = fromday
                            val myCalendar_to = Calendar.getInstance()
                            myCalendar_to[Calendar.YEAR] = year
                            myCalendar_to[Calendar.MONTH] = monthOfYear - 1
                            myCalendar_to[Calendar.DAY_OF_MONTH] = dayOfMonth
                            val diff = (myCalendar_to.time.time - myCalendar_from.time.time) / (1000 * 60 * 60 * 24)
                            //permissionindays = diff;
// Toast.makeText(mycontext, "myCalendar_from.getTime()=" + myCalendar_from.getTime(), Toast.LENGTH_LONG).show();
//Toast.makeText(mycontext, "myCalendar_to.getTime()=" + myCalendar_to.getTime(), Toast.LENGTH_LONG).show();
//Toast.makeText(mycontext, "diff=" + diff, Toast.LENGTH_LONG).show();
                            if (diff > 0) {
                                if (snackBar != null && snackBar!!.isShown) {
                                    snackBar!!.dismiss()
                                }
                                tofilter.setText("$year-$month_to-$day_to")
                            } else {
                                showSnack("Invalidate date.", true)
                                tofilter.setText("")
                            }
                        }, mYear, mMonth, mDay)
                datePickerDialog.show()
            }
        }
        cancel.setOnClickListener { alertDialog.dismiss() }
        apply.setOnClickListener {
            if (fromfilter.text.toString().equals("", ignoreCase = true)) {
                Toast.makeText(mycontext, "Please give from", Toast.LENGTH_LONG).show()
            } else {
                alertDialog.dismiss()
                animateFAB()
                setAdapter(fromfilter.text.toString(), tofilter.text.toString())
            }
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean { // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.attendance, menu)
        return super.onCreateOptionsMenu(menu)
        // return true;
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean { // Handle action bar item clicks here. The action bar will
// automatically handle clicks on the Home/Up button, so long
// as you specify a parent activity in AndroidManifest.xml.
        val id = item.itemId
        if (id == R.id.attendance_sync) {
            try {
                if (isNetworkAvailable()) {
                    showSnack("Please wait", true)
                    syncData()
                } else {
                    showSnack("Please check internet connection", true)
                }
            } catch (e: Exception) { // TODO Auto-generated catch block
                e.printStackTrace()
            }
            return true
        }
        return super.onOptionsItemSelected(item)
    }

    fun animateFAB() {
        if (isFabOpen) {
            fab!!.startAnimation(rotate_backward)
            fab1!!.startAnimation(fab_close)
            fab2!!.startAnimation(fab_close)
            addtimesheettext!!.visibility = View.GONE
            addfiltertext!!.visibility = View.GONE
            fab1!!.isClickable = false
            fab2!!.isClickable = false
            isFabOpen = false
            // Log.d("Raj", "close");
        } else {
            fab!!.startAnimation(rotate_forward)
            fab1!!.startAnimation(fab_open)
            fab2!!.startAnimation(fab_open)
            addtimesheettext!!.visibility = View.VISIBLE
            addfiltertext!!.visibility = View.VISIBLE
            fab1!!.isClickable = true
            fab2!!.isClickable = true
            isFabOpen = true
            // Log.d("Raj","open");
        }
    }
    //			    	   Log.d("wifi connectivity", "wifi not connected");// do your stuff
    // 			    Log.d("wifi connectivity", "connected");
    // if no network is available networkInfo will be null
    // otherwise check if we are connected
    fun isNetworkAvailable(): Boolean {
            val cm = mycontext!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val networkInfo = cm.activeNetworkInfo
            // if no network is available networkInfo will be null
// otherwise check if we are connected
            if (networkInfo != null && networkInfo.isConnected) {
                if (cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI)?.isConnectedOrConnecting == true) { // do your stuff
//			    Log.d("wifi connectivity", "connected");
                } else { //			    	   Log.d("wifi connectivity", "wifi not connected");
                }
                return true
            }
            return false
        }

    private fun showSnack(text: String, infinity: Boolean) {
        if (coordinatorLayout == null) {
            coordinatorLayout = findViewById(R.id.coordinatorLayout)
        }
        if (snackBar != null && snackBar!!.isShown) {
            snackBar!!.dismiss()
        }
        snackBar = Snackbar.make(coordinatorLayout!!, text, Snackbar.LENGTH_LONG)
        if (infinity) {
            snackBar!!.duration = Snackbar.LENGTH_INDEFINITE
        }
        snackBar!!.setAction("CLOSE") { snackBar!!.dismiss() }
        snackBar!!.setActionTextColor(resources.getColor(android.R.color.holo_blue_dark))
        snackBar!!.show()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    private fun syncData() {

        fun sync(it: List<TimesheetEntity>){
            if (snackBar != null && snackBar!!.isShown) {
                snackBar!!.dismiss()
            }
            Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_SHORT)
                    .setAction("Action", null).show()
            val params: MutableMap<String, String> = HashMap()
            params["JSON"] = dbViewModel.toJSON(it).toString()
            MyRequestQueue.getInstance(this@timesheet).addToQueue(HCMURL.INSERT_TIMESHEET, params) { response ->
                try {
                    val jsonObject = JSONObject(response)
                    dbViewModel.updateAttendanceSynced(jsonObject.getJSONArray("list"),object : DBViewModel.CompletedCallBack{
                        override fun onTaskCompleted() {
                            showSnack("Data is synced.", true)
                             setAdapter()
                        }
                    })

                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        }

        val query = dbViewModel.getNotSynced()
        val observer =object : Observer<List<TimesheetEntity>>{
//                        override fun onChanged(it: List<TimesheetEntity>?) {
//                query.removeObserver(this)
//                if(it == null || it.isEmpty()){
//
//                }else{
//                   sync(it)
//                }
//            }
            override fun onChanged(it: List<TimesheetEntity>) {
                query.removeObserver(this)
                if(it == null || it.isEmpty()){

                }else{
                    sync(it)
                }
            }
        }
        query.observe(this,observer)

    }

    private fun setAdapter(startDate: String="",endDate: String="") {

        val query = dbViewModel.getAllTS(
                startDate=if(startDate.isEmpty()) "" else startDate.format("yyyy-MM-dd"),
                endDate= if(endDate.isEmpty()) startDate.format("yyyy-MM-dd") else endDate.format("yyyy-MM-dd") )

        val observer = object : Observer<PagedList<TimesheetEntity>>{
            override fun onChanged(it: PagedList<TimesheetEntity>) {
            //            override fun onChanged(it: PagedList<TimesheetEntity>?) {
                query.removeObserver(this)
                timesheetdates.clear()
                teams.clear()
                starttimes.clear()
                endtimes.clear()
                activities.clear()
                sync.clear()

                it?.forEach {
                    timesheetdates.add(it.timesheetdate)
                    teams.add(it.attendenceteam)
                    starttimes.add(it.starttime)
                    endtimes.add(it.endtime)
                    activities.add(it.activity)
                    sync.add(it.sync)
                }

                runOnUiThread {
                    val adapter = timesheetadapter(mycontext, timesheetdates, teams, starttimes, endtimes, activities, sync)
                    if(it ==  null || it.isEmpty()){
                        history?.visibility = View.VISIBLE
                        refreshicon?.visibility = View.VISIBLE
                        pull?.visibility = View.VISIBLE
                    }else {
                        history?.visibility = View.GONE
                        refreshicon?.visibility = View.GONE
                        pull?.visibility = View.GONE
                    }
                    timesheetlistview?.adapter = adapter
                }
            }
//            override fun onChanged(value: PagedList<TimesheetEntity>) {
//                TODO("Not yet implemented")
//            }
        }

        try {
            runOnUiThread {
                query.observe(this@timesheet,observer)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

}