package com.b2lmobitech.fieldcloudplus.kyc

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.URL
import com.b2lmobitech.fieldcloudplus.databinding.ActivityAadharBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityNewDefectReportBinding
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.expense.getText
import com.b2lmobitech.fieldcloudplus.expense.isEmpty
import com.b2lmobitech.fieldcloudplus.kyc.api.RetrofitFactory
import com.b2lmobitech.fieldcloudplus.kyc.model.Document
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.activity_aadhar.*
//import kotlinx.android.synthetic.main.activity_aadhar.btn_update
//import kotlinx.android.synthetic.main.activity_aadhar.img_back
//import kotlinx.android.synthetic.main.activity_aadhar.img_front
//import kotlinx.android.synthetic.main.activity_license.*
//import kotlinx.android.synthetic.main.activity_pan_card.*
import kotlinx.coroutines.launch
import java.io.File

class AadharActivity : BaseActivity("Aadhar Card") {
    private lateinit var binding: ActivityAadharBinding
    private var frontImage: File? = null
    private var backImage: File? = null
    private var document: Document? = null
    private var canUpdate = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_aadhar)
        binding = ActivityAadharBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        var actionBar = getSupportActionBar()

        if (actionBar != null) {

            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);

        }
        intent.getParcelableExtra<Document>("document")?.let {
            document = it
        }

        document?.let {
            canUpdate = it.status.equals("rejected", true)
        }

        binding.frontaadharbutton.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    frontImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgFront)

                }
            }
        }

        binding.backaadharbutton.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    backImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgBack)

                }
            }
        }

        binding.btnUpdate.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            if (isValid()) {
                uploadImage()
            }
        }

        document?.let {

            if(!canUpdate) {
                binding.inputAadhar.editText?.isEnabled = false
                binding.inputAddress.editText?.isEnabled = false
                binding.btnUpdate.visibility = View.GONE
            }

            binding.inputAadhar.editText?.setText(document!!.document_number)
            binding.inputAddress.editText?.setText(document!!.document_address)

            Glide.with(this).load(URL.image + document!!.front_image).into(binding.imgFront)
            Glide.with(this).load(URL.image + document!!.back_image).into(binding.imgBack)

        }

    }

    fun isValid(): Boolean {
        if (binding.inputAadhar.isEmpty()) {
            showToast("Enter valid Aadhar number")
            return false
        }

        if (binding.inputAddress.isEmpty()) {
            showToast("Enter valid Address")
            return false
        }

        if (frontImage == null) {
            showToast("Please capture Front Image")
            return false
        }

        if (backImage == null) {
            showToast("Please capture Back Image")
            return false
        }

        return true
    }

    fun uploadImage() {
        lifecycleScope.launch {
            showLoading()

            val result = RetrofitFactory.api.updateDocument(
                    id = document?.id ?: 0,
                    cname = companyName,
                    email = email,
                    number = binding.inputAadhar.getText(),
                    address = binding.inputAddress.getText(),
                    fimage = convertImageFileToBase64(frontImage!!),
                    bimage = convertImageFileToBase64(backImage!!),
                    type = KycActivity.AADHAR
            )
            if (result.isSuccessful && result.body() == true) {
                showToast("Updated Successfully")
                finish()
            } else {
                showToast("Error")
            }
            hideLoading()
        }
    }
    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_submit, menu)
        val item = menu!!.findItem(R.id.submit_tick)
        if (!canUpdate) {
            item.setVisible(false)
        }
        else
        {
            item.setVisible(true)
        }
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
//            android.R.id.home -> onBackPressed()
            R.id.submit_tick ->  //if (!canUpdate) return@setOnClickListener
                if (isValid()) {
                    uploadImage()
                }
            else -> return super.onOptionsItemSelected(item)
        }
        return true

    }


}