package com.b2lmobitech.fieldcloudplus.kyc

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.URL
import com.b2lmobitech.fieldcloudplus.databinding.ActivityAadharBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityBankBinding
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.expense.getText
import com.b2lmobitech.fieldcloudplus.expense.isEmpty
import com.b2lmobitech.fieldcloudplus.kyc.api.RetrofitFactory
import com.b2lmobitech.fieldcloudplus.kyc.model.Bank
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.activity_bank.*
//import kotlinx.android.synthetic.main.activity_bank.btn_update
//import kotlinx.android.synthetic.main.activity_bank.img_front
//import kotlinx.android.synthetic.main.activity_pan_card.*
import kotlinx.coroutines.launch
import java.io.File


class BankActivity : BaseActivity("Bank Details") {
    private lateinit var binding: ActivityBankBinding
    private var bank: Bank? = null
    private var canUpdate = true
    private var frontImage: File? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_bank)
        binding = ActivityBankBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        var actionBar = getSupportActionBar()

        if (actionBar != null) {

            // Customize the back button
            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);
//            val colorDrawable = ColorDrawable(Color.parseColor("#0F9D58"))

            // Set BackgroundDrawable

            // Set BackgroundDrawable
//            actionBar.setBackgroundDrawable(colorDrawable)
        }
        intent?.getParcelableExtra<Bank?>("bank")?.let{
            bank = it
        }

        bank?.let {
            canUpdate = it.status.equals("rejected", true)
            binding.inputBankName.editText?.setText(it.bank_name)
            binding.inputIfcAccountNumber.editText?.setText(it.account_number)
            binding.inputIfcConfirmaccountNumber.editText?.setText(it.account_number)
            binding.inputBranch.editText?.setText(it.branch)
            binding.inputIfscCode.editText?.setText(it.ifsc)
            Glide.with(this).load(URL.image + it.image).into(binding.imgFront)
            if (!canUpdate) {
                binding.inputBankName.isEnabled = false
                binding.inputIfcAccountNumber.isEnabled = false
                binding.inputBranch.isEnabled = false
                binding.inputIfscCode.isEnabled = false
                binding.btnUpdate.visibility = View.GONE
                binding.inputIfcConfirmaccountNumber.visibility = View.GONE
            }
        }

        binding.btnUpdate.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            if (isValid()) {
                updateBankDetails()
            }
        }

        binding.pod.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    frontImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgFront)

                }
            }
        }
    }


    private fun updateBankDetails() {
        lifecycleScope.launch {
            showLoading()
            val result = RetrofitFactory.api.updateBankDetails(
                    id = bank?.id ?: 0,
                    email = email,
                    cname = companyName,
                    branch = binding.inputBranch.getText(),
                    bank = binding.inputBankName.getText(),
                    number = binding.inputIfcAccountNumber.getText(),
                    ifsc = binding.inputIfscCode.getText(),
                    fimage = convertImageFileToBase64(frontImage!!)
            )
            hideLoading()
            if (result.isSuccessful && result.body() == true) {
                showToast("Updated Successfully")
                finish()
            } else {
                showToast("Error")
            }
        }
    }

    fun isValid(): Boolean {
        if (binding.inputBankName.isEmpty()) {
            showToast("Enter valid bank name")
            return false
        }
        if (binding.inputBranch.isEmpty()) {
            showToast("Enter valid branch")
            return false
        }
        if (binding.inputIfcAccountNumber.isEmpty()) {
            showToast("Enter valid account number")
            return false
        }
        if (!(binding.inputIfcAccountNumber.getText().toString().equals(binding.inputIfcConfirmaccountNumber.getText().toString()))) {
            showToast("Account Number is not matching")
            return false
        }
        if (binding.inputIfscCode.isEmpty()) {
            showToast("Enter ifsc code")
            return false
        }

        if (frontImage == null) {
            showToast("Please capture Passbook")
            return false
        }

        return true
    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_submit, menu)
        val item = menu!!.findItem(R.id.submit_tick)
        if (!canUpdate) {
          item.setVisible(false)
        }
        else
        {
            item.setVisible(true)
        }
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
//            android.R.id.home -> onBackPressed()
            R.id.submit_tick ->  //if (!canUpdate) return@setOnClickListener
                if (isValid()) {
                    updateBankDetails()
                }
            else -> return super.onOptionsItemSelected(item)
        }
        return true

    }

}