package com.b2lmobitech.fieldcloudplus.kyc

import android.content.Intent
import android.graphics.Color
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.databinding.ActivityBankBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityKycBinding
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.kyc.api.RetrofitFactory
import com.b2lmobitech.fieldcloudplus.kyc.model.KycResponse
import com.google.android.material.textview.MaterialTextView
//import kotlinx.android.synthetic.main.activity_kyc.*
import kotlinx.coroutines.launch

class KycActivity : BaseActivity("KYC") {

    private var kycResponse = KycResponse(emptyList(), emptyList())
    private lateinit var binding: ActivityKycBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_kyc)
        binding = ActivityKycBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        var actionBar = getSupportActionBar()

        if (actionBar != null) {


            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);
        }
        binding.cardBank.setOnClickListener {
            startActivity(Intent(applicationContext, BankActivity::class.java).apply {
                kycResponse.bank.firstOrNull()?.let {
                    putExtra("bank", it)
                }
            })
        }

        binding.cardAadhar.setOnClickListener {
            startActivity(Intent(applicationContext, AadharActivity::class.java).apply {
                kycResponse.documents.filter {
                    it.document_type.equals(AADHAR, true)
                }.firstOrNull()?.let {
                    putExtra("document", it)
                }
            })
        }

        binding.cardLicense.setOnClickListener {
            startActivity(Intent(applicationContext, LicenseActivity::class.java).apply {
                kycResponse.documents.filter {
                    it.document_type.equals(LICENSE, true)
                }.firstOrNull()?.let {
                    putExtra("document", it)
                }
            })
        }

        binding.cardPan.setOnClickListener {
            startActivity(Intent(applicationContext, PanCardActivity::class.java).apply {
                kycResponse.documents.filter {
                    it.document_type.equals(PANCARD, true)
                }.firstOrNull()?.let {
                    putExtra("document", it)
                }
            })
        }

    }

    override fun onResume() {
        super.onResume()
        getKycStatus()
    }

    private fun getKycStatus() {
        lifecycleScope.launch {
            showLoading()

            RetrofitFactory.api.getKyStatus(cname = companyName, email = email).body()?.let {
                kycResponse = it
            }
            setKycStatus()

            hideLoading()
        }
    }

    private fun setKycStatus() {

        kycResponse.bank.firstOrNull()?.let {
            setKycStatus(binding.txtBankStatus, it.status,it.rejected_reason?:"")
        }

        kycResponse.documents.forEach {
            if (it.document_type.equals(PANCARD, true)) {
                setKycStatus(binding.txtPanStatus, it.status, it.rejected_reason ?: "")
            } else if (it.document_type.equals(AADHAR, true)) {
                setKycStatus(binding.txtAadharStatus, it.status, it.rejected_reason ?: "")
            } else if (it.document_type.equals(LICENSE, true)) {
                setKycStatus(binding.txtLicenseStatus, it.status, it.rejected_reason ?: "")
            }
        }

    }

    private fun setKycStatus(textView: MaterialTextView, status: String, reason: String) {
        textView.text = status
        if (status.equals("PENDING", true)) {
            textView.setTextColor(ContextCompat.getColor(applicationContext, R.color.material_yellow_900))
        } else if (status.equals("APPROVED", true)) {
            textView.setTextColor(ContextCompat.getColor(applicationContext, R.color.material_green_900))
        } else if (status.equals("REJECTED", true)) {
            textView.setTextColor(ContextCompat.getColor(applicationContext, R.color.material_red_900))
            if(reason.isNotEmpty()) {
                textView.text = status.plus(" ( ").plus(reason).plus(" )")
            }
        }
        textView.visibility = View.VISIBLE
    }

    companion object {
        val PANCARD = "PAN_CARD"
        val LICENSE = "LICENSE"
        val AADHAR = "AADHAR"
    }


}