package com.b2lmobitech.fieldcloudplus.kyc

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.URL
import com.b2lmobitech.fieldcloudplus.databinding.ActivityKycBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityLicenseBinding
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.expense.getText
import com.b2lmobitech.fieldcloudplus.expense.isEmpty
import com.b2lmobitech.fieldcloudplus.kyc.api.RetrofitFactory
import com.b2lmobitech.fieldcloudplus.kyc.model.Document
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.activity_aadhar.*
//import kotlinx.android.synthetic.main.activity_license.*
//import kotlinx.android.synthetic.main.activity_license.btn_update
//import kotlinx.android.synthetic.main.activity_license.img_back
//import kotlinx.android.synthetic.main.activity_license.img_front
import kotlinx.coroutines.launch
import java.io.File

class LicenseActivity : BaseActivity("License") {
    private lateinit var binding: ActivityLicenseBinding
    private var frontImage: File? = null
    private var backImage: File? = null
    private var document: Document? = null
    private var canUpdate = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_license)
        binding = ActivityLicenseBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        var actionBar = getSupportActionBar()

        if (actionBar != null) {

            // Customize the back button
            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);

        }
        intent.getParcelableExtra<Document>("document")?.let {
            document = it
            canUpdate = it.status.equals("rejected", true)
        }

        binding.frontimagebutton.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    frontImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgFront)

                }
            }
        }

        binding.backimagebutton.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    backImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgBack)

                }
            }
        }

        binding.btnUpdate.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            if(isValid()) uploadImage()
        }

        document?.let {
            if (!canUpdate) {
                binding.inputLicense.editText?.isEnabled = false
                binding.btnUpdate.visibility = View.GONE
                Glide.with(this).load(URL.image + document!!.front_image).into(binding.imgFront)
                Glide.with(this).load(URL.image + document!!.back_image).into(binding.imgBack)
            }
            binding.inputLicense.editText?.setText(document!!.document_number)

        }

    }


    fun isValid(): Boolean {
        if (binding.inputLicense.isEmpty()) {
            showToast("Enter valid License number")
            return false
        }

        if (frontImage == null) {
            showToast("Please capture Front Image")
            return false
        }

        if (backImage == null) {
            showToast("Please capture Back Image")
            return false
        }

        return true
    }

    private fun uploadImage() {
        lifecycleScope.launch {
            showLoading()

            val result = RetrofitFactory.api.updateDocument(
                    id = document?.id ?: 0,
                    cname = companyName,
                    email = email,
                    number = binding.inputLicense.getText(),
                    fimage = convertImageFileToBase64(frontImage!!),
                    bimage = convertImageFileToBase64(backImage!!),
                    type = KycActivity.LICENSE
            )
            if (result.isSuccessful && result.body() == true) {
                showToast("Updated Successfully")
                finish()
            } else {
                showToast("Error")
            }
            hideLoading()
        }
    }
    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_submit, menu)
        val item = menu!!.findItem(R.id.submit_tick)
        if (!canUpdate) {
            item.setVisible(false)
        }
        else
        {
            item.setVisible(true)
        }
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
//            android.R.id.home -> onBackPressed()
            R.id.submit_tick ->  //if (!canUpdate) return@setOnClickListener
                if (isValid()) {
                    uploadImage()
                }
            else -> return super.onOptionsItemSelected(item)
        }
        return true

    }
}