package com.b2lmobitech.fieldcloudplus.kyc

import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.URL
import com.b2lmobitech.fieldcloudplus.databinding.ActivityLicenseBinding
import com.b2lmobitech.fieldcloudplus.databinding.ActivityPanCardBinding
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.expense.getText
import com.b2lmobitech.fieldcloudplus.expense.isEmpty
import com.b2lmobitech.fieldcloudplus.kyc.api.RetrofitFactory
import com.b2lmobitech.fieldcloudplus.kyc.model.Document
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.activity_pan_card.*
import kotlinx.coroutines.launch
import java.io.File
import java.util.regex.Pattern

class PanCardActivity : BaseActivity("Pan Card") {
    private lateinit var binding: ActivityPanCardBinding
    private var frontImage: File? = null
    private var document: Document? = null
    private var canUpdate = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_pan_card)
        binding = ActivityPanCardBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        var actionBar = getSupportActionBar()
        if (actionBar != null) {
            actionBar.setHomeAsUpIndicator(R.drawable.ic_action_backarrow);
        }
        intent.getParcelableExtra<Document>("document")?.let { document = it }

        binding.panimagebutton.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            openCamera {
                it.firstOrNull()?.file?.let {
                    frontImage = it
                    Glide.with(this)
                            .load(it)
                            .centerCrop()
                            .into(binding.imgFront)

                }
            }
        }
        binding.btnUpdate.setOnClickListener {
            if (!canUpdate) return@setOnClickListener
            if(isValid()) uploadImage()
        }

        document?.let {
            canUpdate = it.status.equals("rejected", true)
            binding.inputPanCard.editText?.setText(it.document_number)

            if (!canUpdate) {
                binding.inputPanCard.editText?.isEnabled = false
                binding.btnUpdate.visibility = View.GONE
                Glide.with(this).load(URL.image + it.front_image).into(binding.imgFront)
            }

        }
    }

    fun isValid(): Boolean {
        if (isValidPan(binding.inputPanCard.getText())) {
            showToast("Enter valid PAN")
            return false
        }

        if (frontImage == null) {
            showToast("Please capture PAN CARD")
            return false
        }

        return true
    }

    private fun uploadImage() {
        lifecycleScope.launch {
            showLoading()

            val result = RetrofitFactory.api.updateDocument(id = document?.id ?: 0,
                    cname = companyName, email = email, number = binding.inputPanCard.getText(), fimage = convertImageFileToBase64(frontImage!!), type = KycActivity.PANCARD

            )
            if (result.isSuccessful && result.body() == true) {
                showToast("Updated Successfully")
                finish()
            } else {
                showToast("Error")
            }
            hideLoading()
        }
    }

    private fun isValidPan(panCardNo: String): Boolean {
        val regex = "[A-Z]{5}[0-9]{4}[A-Z]{1}"
        val p = Pattern.compile(regex)
        if (panCardNo.isNotEmpty()) {
            return false
        }
        val m = p.matcher(panCardNo)
        return m.matches()
    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_submit, menu)
        val item = menu!!.findItem(R.id.submit_tick)
        if (!canUpdate) {
            item.setVisible(false)
        }
        else
        {
            item.setVisible(true)
        }
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
//            android.R.id.home -> onBackPressed()
            R.id.submit_tick ->  //if (!canUpdate) return@setOnClickListener
                if (isValid()) {
                    uploadImage()
                }
            else -> return super.onOptionsItemSelected(item)
        }
        return true

    }
}