package com.b2lmobitech.fieldcloudplus.kyc.api

import com.b2lmobitech.fieldcloudplus.expense.data.Report
import com.b2lmobitech.fieldcloudplus.kyc.model.KycResponse
import org.json.JSONObject
import retrofit2.Response
import retrofit2.http.*

interface ApiHelper {

    @FormUrlEncoded
    @POST("update_bank_details.php")
    suspend fun updateBankDetails(@Field("cname") cname: String,
                                  @Field("email") email: String,
                                  @Field("id") id: Int = 0,
                                  @Field("bank") bank: String,
                                  @Field("branch") branch: String,
                                  @Field("ifsc") ifsc: String,
                                  @Field("fimage") fimage: String,
                                  @Field("number") number: String): Response<Boolean>

    @GET("get_kyc_status.php")
    suspend fun getKyStatus(@Query("cname") cname: String,
                            @Query("email") email: String): Response<KycResponse>


    @FormUrlEncoded
    @POST("update_document.php")
    suspend fun updateDocument(@Field("id") id: Int = 0,
                               @Field("cname") cname: String,
                               @Field("email") email: String,
                               @Field("number") number: String,
                               @Field("fimage") fimage: String,
                               @Field("bimage") bimage: String = "",
                               @Field("address") address: String = "",
                               @Field("type") type: String): Response<Boolean>

}