package com.b2lmobitech.fieldcloudplus.kyc.model

import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

@Parcelize
data class Bank(
        val id: Int,
        val email: String,
        val bank_name: String,
        val branch: String,
        val ifsc: String,
        val account_number: String,
        val status: String,
        val image: String? = "",
        val rejected_reason: String? = ""
) : Parcelable

@Parcelize
data class Document(
        val id: Int,
        val email: String,
        val status: String,
        val document_number: String,
        val document_type: String,
        val front_image: String,
        val document_address: String,
        val back_image: String,
        val created_datetime: String,
        val updated_datetime: String,
        val rejected_reason: String? = ""
) : Parcelable

data class KycResponse(
        val bank: List<Bank>,
        val documents: List<Document>
)