package com.b2lmobitech.fieldcloudplus.notes

import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.widget.EditText
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.notes.api.NotesApi
import com.b2lmobitech.fieldcloudplus.notes.room.NoteEntity
import com.b2lmobitech.fieldcloudplus.task.encap.Notes
import kotlinx.coroutines.launch
import java.util.*

class AddNotesActivity : BaseActivity() {

    var submit: MenuItem? = null
    lateinit var titleTxt: EditText
    lateinit var description: EditText
    var arrayList: ArrayList<Notes>? = ArrayList()
    var editing = false
    var noteEntity: NoteEntity? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_addnotes)

        titleTxt = findViewById(R.id.notes_title)
        description = findViewById(R.id.notes_description)

        supportActionBar!!.title = "Add Note"
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)

        noteEntity = intent.getParcelableExtra("notes")

        if (noteEntity != null) {
            titleTxt.setText(noteEntity!!.title)
            description.setText(noteEntity!!.notes)
            editing = true
        }

    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        val inflater = menuInflater
        inflater.inflate(R.menu.menu_form, menu)
        submit = findViewById(R.id.done)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            R.id.done ->                // showDialog();
                addNotes()
            android.R.id.home -> finish()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun addNotes() {

        if (!titleTxt.text.toString().isEmpty() && !description.text.toString().isEmpty()) {
            if (editing) {
                lifecycleScope.launch {
                    showLoading()
                    val result = NotesApi.api.updateNote(
                        title = titleTxt.text.toString(),
                        id = noteEntity!!.id,
                        notes = description.text.toString(),
                    )
                    if (result.body() == true) {
                        setResult(RESULT_OK)
                        finish()
                    }
                    hideLoading()
                }

            } else {
                lifecycleScope.launch {
                    showLoading()
                    val result = NotesApi.api.addNote(
                        cname = companyName,
                        email = email,
                        notes = description.text.toString(),
                        title = titleTxt.text.toString()
                    )
                    if (result.body() == true) {
                        setResult(RESULT_OK)
                        finish()
                    }
                    hideLoading()
                }
            }
        }
    }
}