package com.b2lmobitech.fieldcloudplus.notes

import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.view.MenuItem
import android.view.View
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.notes.api.NotesApi
import com.b2lmobitech.fieldcloudplus.notes.room.LocalDatabase
import com.b2lmobitech.fieldcloudplus.notes.room.NoteEntity
import com.b2lmobitech.fieldcloudplus.notes.room.NotesDAO
import com.b2lmobitech.fieldcloudplus.utils.EndlessRecyclerViewScrollListener
import com.b2lmobitech.fieldcloudplus.utils.PaginationScrollListener
import com.b2lmobitech.fieldcloudplus.utils.visible
import com.google.android.material.floatingactionbutton.FloatingActionButton
//import kotlinx.android.synthetic.main.activity_bank.*
//import kotlinx.android.synthetic.main.activity_new_defect_report.*
//import kotlinx.android.synthetic.main.layout_defect_list.*
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import java.util.*
import kotlin.collections.ArrayList

class NotesActivity : BaseActivity() {

    lateinit var addNotes: FloatingActionButton
    lateinit var recyclerView: RecyclerView

    var arrayList = ArrayList<NoteEntity>()

    lateinit var notesAdapter: NotesAdapter
    lateinit var notesDAO: NotesDAO

    private var isRequestInProgress= false
    private var isFullPageLoaded = false

    var page = 0


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_notes)

        LocalDatabase.getAppDataBase(applicationContext)?.let {
            notesDAO = it.notesDAO()
        }
        addNotes = findViewById(R.id.fab)

        addNotes.setOnClickListener {
            val intent = Intent(this@NotesActivity, AddNotesActivity::class.java)
            startActivityForResult(intent, 111)
        }
        supportActionBar?.run {
            title = "Notes"
            setDisplayHomeAsUpEnabled(true)
        }

        recyclerView = findViewById(R.id.recycle_view)
        recyclerView.layoutManager = LinearLayoutManager(this)

        notesAdapter = NotesAdapter(arrayList) {
            val intent = Intent(this, ViewNotesActivity::class.java)
            intent.putExtra("notes", it)
            startActivityForResult(intent, 111)
        }
        recyclerView.adapter = notesAdapter

        recyclerView.addOnScrollListener(object :
            PaginationScrollListener(recyclerView.layoutManager as LinearLayoutManager) {
           /* override fun onLoadMore(page: Int, totalItemsCount: Int, view: RecyclerView?) {
                if (!isRequestInProgress && !isFullPageLoaded) {
                    isRequestInProgress = true
                  //  paginationProgress.visible(true)
                    getNotes()
                }
            }*/

            override fun isLastPage(): Boolean {
                return isFullPageLoaded
            }

            override fun isLoading(): Boolean {
               return isRequestInProgress
            }

            override fun loadMoreItems() {
                if(isRequestInProgress.not()){
                    isRequestInProgress = true
                    getNotes()
                }

            }
        })



        getNotes()

    }

    private fun getNotes() {
        lifecycleScope.launch {
            showLoading()
            val result = NotesApi.api.getNotes(cname = companyName, email = email, page = page)
            lifecycleScope.launch(Dispatchers.IO) {
                result.body()?.forEach {
                    notesDAO.save(
                        NoteEntity(
                            id = it.id,
                            notes = it.notes,
                            createdOn = it.created_on,
                            updatedOn = it.updated_on,
                            title = it.title
                        )
                    )
                }
                page ++
                isRequestInProgress = false
                if(result.body()?.isEmpty() == true) isFullPageLoaded = true
                val query = notesDAO.getAll(arrayList.size.plus(10))

                lifecycleScope.launch(Dispatchers.Main) {
                    query.observe(this@NotesActivity) {
                        arrayList = ArrayList(it ?: ArrayList())
                        updateAdapter()
                        query.removeObservers(this@NotesActivity)
                    }
                }
            }

            hideLoading()
        }
    }

    private fun updateAdapter() {
        notesAdapter.arrayList = arrayList
        notesAdapter.notifyDataSetChanged()
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == RESULT_OK) {
            page = 0
            isFullPageLoaded = false
            getNotes()
        }
    }

    override fun onRestart() {
        super.onRestart()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

}