package com.b2lmobitech.fieldcloudplus.notes

import com.b2lmobitech.fieldcloudplus.notes.room.NoteEntity
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import android.view.LayoutInflater
import com.b2lmobitech.fieldcloudplus.R
import android.content.Intent
import android.view.View
import android.widget.TextView
import androidx.cardview.widget.CardView
import java.util.ArrayList

/**
 * Created by home on 12/18/2017.
 */
class NotesAdapter(var arrayList: ArrayList<NoteEntity>,val onSelected:(noteEntity:NoteEntity)->Unit) :
    RecyclerView.Adapter<NotesAdapter.viewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context).inflate(R.layout.list_notes, parent, false)
        return viewHolder(itemView)
    }

    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        holder.title.text = arrayList[position].title

        var ss: String = arrayList[position].notes
        if (ss.length > 50) {
            ss = ss.substring(0, 50) + "..."
        }
        holder.description.text = ss
        holder.cardView.setOnClickListener {
            onSelected( arrayList[position])
        }
    }

    override fun getItemCount(): Int {
        return arrayList.size
    }

    inner class viewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var title: TextView
        var description: TextView
        var cardView: CardView

        init {
            title = itemView.findViewById(R.id.notes_title)
            description = itemView.findViewById(R.id.notes_description)
            cardView = itemView.findViewById(R.id.card_view)
        }
    }

}