package com.b2lmobitech.fieldcloudplus.notes

import android.content.DialogInterface
import android.content.Intent
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.widget.TextView
import androidx.appcompat.app.AlertDialog
import androidx.lifecycle.lifecycleScope
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.expense.BaseActivity
import com.b2lmobitech.fieldcloudplus.notes.api.NotesApi
import com.b2lmobitech.fieldcloudplus.notes.room.LocalDatabase
import com.b2lmobitech.fieldcloudplus.notes.room.NoteEntity
import com.b2lmobitech.fieldcloudplus.notes.room.NotesDAO
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**
 * Created by home on 12/19/2017.
 */
class ViewNotesActivity : BaseActivity() {

    var submit: MenuItem? = null

    lateinit var titleTxt: TextView
    lateinit var description: TextView
    lateinit var notesDAO: NotesDAO

    var noteEntity: NoteEntity? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_view_notes)

        titleTxt = findViewById(R.id.notes_title)
        description = findViewById(R.id.notes_description)

        LocalDatabase.getAppDataBase(applicationContext)?.let {
            notesDAO = it.notesDAO()
        }

        noteEntity = intent.getParcelableExtra("notes")

        supportActionBar?.run {
            title = "Notes"
            setDisplayHomeAsUpEnabled(true)
        }


        if (noteEntity != null) {
            titleTxt.text = noteEntity!!.title
            description.text = noteEntity!!.notes
        }

    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        val inflater = menuInflater
        inflater.inflate(R.menu.menu_notes_edit, menu)
        submit = findViewById(R.id.done)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val intent = Intent(this, AddNotesActivity::class.java)
        when (item.itemId) {
            R.id.done -> {
                intent.putExtra("notes", noteEntity)
                startActivityForResult(intent,111)
            }
            R.id.delete -> showDialog()
            android.R.id.home -> finish()
        }
        return super.onOptionsItemSelected(item)
    }

    private fun showDialog() {
        AlertDialog.Builder(this).setMessage("Notes will be deleted")
            .setPositiveButton("Delete") { _: DialogInterface?, _: Int ->
                deleteNote()
            }
            .setNegativeButton("cancel") { _: DialogInterface?, _: Int -> }.show()
    }

    private fun deleteNote() {
        lifecycleScope.launch {
            showLoading()
            val result = NotesApi.api.deleteNote(noteEntity?.id ?: 0)
            lifecycleScope.launch(Dispatchers.IO) {
                if (result.body() == true) {
                    noteEntity?.let { notesDAO.delete(it) }
                    setResult(RESULT_OK)
                    finish()
                }
            }
            hideLoading()
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if(resultCode == RESULT_OK){
            setResult(RESULT_OK)
            finish()
        }
    }
}