package com.b2lmobitech.fieldcloudplus.notes.api

import retrofit2.Response
import retrofit2.http.*

interface ApiHelper {

    @FormUrlEncoded
    @POST("add_note.php")
    suspend fun addNote(
        @Field("cname") cname: String,
        @Field("email") email: String,
        @Field("title") title: String,
        @Field("notes") notes: String
    ): Response<Boolean>

    @GET("get_notes.php")
    suspend fun getNotes(
        @Query("cname") cname: String,
        @Query("email") email: String,
        @Query("page") page: Int
    ): Response<List<Note>>

    @FormUrlEncoded
    @POST("update_note.php")
    suspend fun updateNote(
        @Field("id") id: Int = 0,
        @Field("title") title: String,
        @Field("notes") notes: String,
    ): Response<Boolean>

    @FormUrlEncoded
    @POST("delete_note.php")
    suspend fun deleteNote(
        @Field("id") id: Int = 0,
    ): Response<Boolean>

}