package com.b2lmobitech.fieldcloudplus.notes.room

import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import android.content.Context


@Database(entities = [NoteEntity::class], version = 3)
@TypeConverters(Converters::class)
 abstract class LocalDatabase: RoomDatabase() {

    abstract fun notesDAO(): NotesDAO

    companion object {

        @Volatile var INSTANCE: LocalDatabase? = null

        fun getAppDataBase(context: Context): LocalDatabase? {

            Room.databaseBuilder(context.applicationContext,
                    LocalDatabase::class.java, "feeds")
                    .build()

            if (INSTANCE == null){
                synchronized(LocalDatabase::class){
                    INSTANCE = Room.databaseBuilder(context.applicationContext, LocalDatabase::class.java, "feeds").build()
                }
            }
            return INSTANCE
        }

        fun destroyDataBase(){
            INSTANCE = null
        }
    }
}