package com.b2lmobitech.fieldcloudplus.notes.room

import androidx.lifecycle.LiveData
import androidx.room.*

@Dao
interface NotesDAO {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun save(key: NoteEntity): Long?

    @Update
    fun merge(key: NoteEntity)

    @Delete
    fun delete(key: NoteEntity)

    @Query("SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC")
    fun getAll() : LiveData<List<NoteEntity>>

    @Query("SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC LIMIT :limit")
    fun getAll(limit:Int) : LiveData<List<NoteEntity>>

}