package com.b2lmobitech.fieldcloudplus.others.encaps;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import java.util.ArrayList;

/**
 * Created by home on 2/17/2018.
 */

public class DashBoardGridAdapter extends RecyclerView.Adapter<DashBoardGridAdapter.viewHolder>{

    Activity activity;
    ArrayList<Grid> arrayList;

    public DashBoardGridAdapter(Activity activity, ArrayList<Grid> arrayList) {
        this.activity = activity;
        this.arrayList = arrayList;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.grid_single,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        final Grid grid=arrayList.get(position);

        if(grid.getTitle().equalsIgnoreCase("admin")){
            holder.textView.setTextColor(Color.parseColor("#0000ff"));
        }else{
            holder.textView.setTextColor(Color.parseColor("#000000"));
        }
        holder.imageView.setImageResource(grid.getId());
        holder.textView.setText(grid.getTitle());


        holder.linearLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        activity.startActivity(new Intent(activity, grid.getaClass()));
                    }catch(Exception E)
                    {
                        Toast.makeText(activity, E.toString(), Toast.LENGTH_SHORT).show();
                    }
                }
        });

    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder {
        TextView textView,bulb;
        ImageView imageView;
        LinearLayout linearLayout;

        public viewHolder(View grid) {
            super(grid);
            textView = grid.findViewById(R.id.grid_text);
            bulb =  grid.findViewById(R.id.bulb);
            imageView = grid.findViewById(R.id.grid_image);
            linearLayout=grid.findViewById(R.id.main_layout);
        }

    }

}
