package com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.graphics.Bitmap;
import android.util.Log;

import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripExpenseTable;
import com.b2lmobitech.fieldcloudplus.hcm.sql.tables.TripTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.NotesTable;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskNotification;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskRequestTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskSequenceTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.answerstable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.attendancetable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.leavetable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.locationtable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.ticketstable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.timesheettable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.sparestable;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstablelocal;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.answerstablelocal;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

import org.json.JSONException;

/**
 * Created by HP on 30-01-2017.
 */

public class sqldatabase extends SQLiteOpenHelper {
    public static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "hcm.db3";

    public sqldatabase(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    public void onCreate(SQLiteDatabase db) {

        db.execSQL(attendancetable.CREATE_TABLE);
        db.execSQL(locationtable.CREATE_TABLE);
        db.execSQL(leavetable.CREATE_TABLE);
        db.execSQL(timesheettable.CREATE_TABLE);
        db.execSQL(dynamicquestionstable.CREATE_TABLE);
        db.execSQL(dynamicquestionstablelocal.CREATE_TABLE);
        db.execSQL(answerstable.CREATE_TABLE);
        db.execSQL(answerstablelocal.CREATE_TABLE);
        db.execSQL(ticketstable.CREATE_TABLE);
        db.execSQL(sparestable.CREATE_TABLE);
        db.execSQL(TripTable.CREATE_TABLE);
        db.execSQL(TripExpenseTable.CREATE_TABLE);

        db.execSQL("CREATE TABLE IF NOT EXISTS " + NotesTable.TABLE_NAME + " ("
                + NotesTable._ID + " INTEGER PRIMARY KEY ,"
                + NotesTable.DATETIME + " TEXT,"
                + NotesTable.TITLE + " TEXT,"
                + NotesTable.DESCRIPTION + " TEXT,"
                + "CONSTRAINT request_unique UNIQUE ("+NotesTable.DATETIME+"));");

        ContentValues cv = new ContentValues();
        cv.put(NotesTable.TITLE,"Field Cloud");
        cv.put(NotesTable.DATETIME, "0000-00-00 00:00:00");
        cv.put(NotesTable.DESCRIPTION, "You can save your notes here");
        db.insertWithOnConflict(NotesTable.TABLE_NAME, null, cv, SQLiteDatabase.CONFLICT_REPLACE);

    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // This database is only a cache for online data, so its upgrade policy is
        // to simply to discard the data and start over
        db.execSQL("DROP TABLE IF EXISTS " + attendancetable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + locationtable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + dynamicquestionstable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + answerstable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + dynamicquestionstablelocal.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + answerstablelocal.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + ticketstable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + leavetable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + timesheettable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + sparestable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TaskRequestTable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TaskProgress.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TaskSequenceTable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TaskTable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + TaskNotification.TABLE_NAME);

        onCreate(db);

    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        onUpgrade(db, oldVersion, newVersion);
    }

    //--attendance
    public void insert_attendancetable(String Companyname,String emailid,String date,String checkintime,String checkouttime,String checkinlocation,String checkoutlocation,String status,String toaltime,String Insync,String Outsync,Bitmap attendanceimage,String Imagepath,Bitmap signature,String signaturepath) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.COMPANYNAME, Companyname);
            cv.put(attendancetable.EMAILID, emailid);
            cv.put(attendancetable.DATE, date);
            cv.put(attendancetable.CHECKINTIME, checkintime);
            cv.put(attendancetable.CHECKOUTTIME, checkouttime);
            cv.put(attendancetable.CHECKINLOCATION, checkinlocation);
            cv.put(attendancetable.CHECKOUTLOCATION, checkoutlocation);
            cv.put(attendancetable.STATUS, status);
            cv.put(attendancetable.TOTALTIME, toaltime);
            cv.put(attendancetable.INSYNC, Insync);
            cv.put(attendancetable.OUTSYNC, Outsync);
            cv.put(attendancetable.ATTENDANCEIMAGE, globalvariables.getBytes(attendanceimage));
            cv.put(attendancetable.IMAGEPATH, Imagepath);
            cv.put(attendancetable.SIGNATURE, globalvariables.getBytes(signature));
            cv.put(attendancetable.SIGNATUREPATH, signaturepath);
            sdb.insert(attendancetable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void insert_attendancetable_dump(String Companyname,String emailid,String date,String checkintime,String checkouttime,String checkinlocation,String checkoutlocation,String status,String toaltime,String Insync,String Outsync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.COMPANYNAME, Companyname);
            cv.put(attendancetable.EMAILID, emailid);
            cv.put(attendancetable.DATE, date);
            cv.put(attendancetable.CHECKINTIME, checkintime);
            cv.put(attendancetable.CHECKOUTTIME, checkouttime);
            cv.put(attendancetable.CHECKINLOCATION, checkinlocation);
            cv.put(attendancetable.CHECKOUTLOCATION, checkoutlocation);
            cv.put(attendancetable.STATUS, status);
            cv.put(attendancetable.TOTALTIME, toaltime);
            cv.put(attendancetable.INSYNC, Insync);
            cv.put(attendancetable.OUTSYNC, Outsync);

            sdb.insert(attendancetable.TABLE_NAME,null, cv);


        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_attendancetable_dump(String date,String Insync,String Outsync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.INSYNC, Insync);
            cv.put(attendancetable.OUTSYNC, Outsync);
            sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.DATE+" = ? ", new String[]{date});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void insert_spares(String Companyname,String combinationname,String combinationtype,String ticketnumber,String sku,String item,String amount,String quantity,String total,String date) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(sparestable.COMPANYNAME, Companyname);
            cv.put(sparestable.COMBINATIONNAME, combinationname);
            cv.put(sparestable.COMBINATIONTYPE, combinationtype);
            cv.put(sparestable.TICKETNUMBER, ticketnumber);
            cv.put(sparestable.SKU, sku);
            cv.put(sparestable.ITEM_NAME, item);
            cv.put(sparestable.QUANTITY, quantity);
            cv.put(sparestable.AMOUNT, amount);
            cv.put(sparestable.TOTALAMOUNT, total);
            cv.put(sparestable.DATE_TIME, date);

            sdb.insert(sparestable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_attendancetable_checkout(String Companyname,String emailid,String date,String checkouttime,String checkoutlocation,String status,String toaltime) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.CHECKOUTTIME, checkouttime);
            cv.put(attendancetable.CHECKOUTLOCATION, checkoutlocation);
            cv.put(attendancetable.STATUS, status);
            cv.put(attendancetable.TOTALTIME, toaltime);
            sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.COMPANYNAME+ " = ?  AND "+attendancetable.EMAILID+" = ? AND "+attendancetable.DATE+" = ? ", new String[]{Companyname,emailid,date});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_attendancetable_sync(String Companyname,String emailid,String date,String Insync,String Outsync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        Log.e("inset sync","called");
        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.INSYNC, Insync);
            cv.put(attendancetable.OUTSYNC, Outsync);
            sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.COMPANYNAME+ " = ?  AND "+attendancetable.EMAILID+" = ? AND "+attendancetable.DATE+" = ? ", new String[]{Companyname,emailid,date});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_attendancetable_sync(String Companyname,String emailid,String date,String Outsync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(attendancetable.OUTSYNC, Outsync);
            sdb.update(attendancetable.TABLE_NAME, cv ,attendancetable.COMPANYNAME+ " = ?  AND "+attendancetable.EMAILID+" = ? AND "+attendancetable.DATE+" = ? ", new String[]{Companyname,emailid,date});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void update_timesheettable_sync(String emailid,String sync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(timesheettable.SYNC, sync);
            sdb.update(timesheettable.TABLE_NAME, cv ,timesheettable.EMPLOYEEEMAILID+" = ? ", new String[]{emailid});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_categories_updated(String category) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(dynamicquestionstable.CATEGORYSTATUS, "enable");
            sdb.update(dynamicquestionstable.TABLE_NAME, cv ,dynamicquestionstable.CATEGORY+" = ? ", new String[]{category});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_attendancetable(String Companyname,String emailid) {
        SQLiteDatabase sdb = getReadableDatabase();

        String[] col={attendancetable.COMPANYNAME,attendancetable.EMAILID,attendancetable.DATE,attendancetable.CHECKINTIME,
                attendancetable.CHECKOUTTIME,attendancetable.CHECKINLOCATION,attendancetable.CHECKOUTLOCATION,
                attendancetable.STATUS,attendancetable.TOTALTIME,attendancetable.INSYNC,attendancetable.OUTSYNC };

        //attendancetable.ATTENDANCEIMAGE,attendancetable.IMAGEPATH,attendancetable.SIGNATURE,attendancetable.SIGNATUREPATH

        Cursor c = sdb.query(attendancetable.TABLE_NAME,col,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? ",new String[]{Companyname,emailid},null,null,attendancetable._ID+" DESC ");
        return c;

//        Cursor mCursor = sdb.rawQuery("SELECT "+attendancetable.COMPANYNAME+","
//                +attendancetable.EMAILID+","
//                +attendancetable.DATE+","
//                +attendancetable.CHECKINTIME+","
//                +attendancetable.CHECKOUTTIME+","
//                +attendancetable.CHECKINLOCATION+","
//                +attendancetable.CHECKOUTLOCATION+","
//                +attendancetable.STATUS+","
//                +attendancetable.TOTALTIME+","
//                +attendancetable.INSYNC+","
//                +attendancetable.OUTSYNC+" FROM "+attendancetable.TABLE_NAME+" where "+attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? ",new String[] {Companyname,emailid}, null);
//        if (mCursor != null) {
//            if(mCursor.getCount() > 0)
//            {
//                return mCursor;
//            }
//        }
//        return null;

    }

    public Cursor get_attendancetable_checkin(String Companyname,String emailid,String date) {
        SQLiteDatabase sdb = getReadableDatabase();

        String[] col={attendancetable.COMPANYNAME,attendancetable.EMAILID,attendancetable.DATE,attendancetable.CHECKINTIME,
                attendancetable.CHECKOUTTIME,attendancetable.CHECKINLOCATION,attendancetable.CHECKOUTLOCATION,
                attendancetable.STATUS,attendancetable.TOTALTIME,attendancetable.INSYNC,attendancetable.OUTSYNC };

        Cursor c = sdb.query(attendancetable.TABLE_NAME,col,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.DATE+ " = ? ",new String[]{Companyname,emailid,date},null,null,null);
        return c;
    }



    public Cursor get_attendancetable_checkout(String Companyname,String emailid,String date) {
        SQLiteDatabase sdb = getReadableDatabase();

        String[] col={attendancetable.COMPANYNAME,attendancetable.EMAILID,attendancetable.DATE,attendancetable.CHECKINTIME,
                attendancetable.CHECKOUTTIME,attendancetable.CHECKINLOCATION,attendancetable.CHECKOUTLOCATION,
                attendancetable.STATUS,attendancetable.TOTALTIME,attendancetable.INSYNC,attendancetable.OUTSYNC };

        Cursor c = sdb.query(attendancetable.TABLE_NAME,col,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.DATE+ " = ? AND ( "+attendancetable.CHECKOUTTIME+" = ? OR "+attendancetable.CHECKOUTTIME+" = ? )",new String[]{Companyname,emailid,date,"","00:00:00"},null,null,null);
        return c;




    }

    public Cursor get_attendancetable_datewise(String Companyname,String emailid,String date) {
        SQLiteDatabase sdb = getReadableDatabase();

        String[] col={attendancetable.COMPANYNAME,attendancetable.EMAILID,attendancetable.DATE,attendancetable.CHECKINTIME,
                attendancetable.CHECKOUTTIME,attendancetable.CHECKINLOCATION,attendancetable.CHECKOUTLOCATION,
                attendancetable.STATUS,attendancetable.TOTALTIME,attendancetable.INSYNC,attendancetable.OUTSYNC };

        Cursor c = sdb.query(attendancetable.TABLE_NAME,col,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.DATE+ " = ? ",new String[]{Companyname,emailid,date},null,null,attendancetable._ID+" DESC ");
        return c;


//        Cursor mCursor = sdb.rawQuery("SELECT "+attendancetable.COMPANYNAME+","
//                +attendancetable.EMAILID+","
//                +attendancetable.DATE+","
//                +attendancetable.CHECKINTIME+","
//                +attendancetable.CHECKOUTTIME+","
//                +attendancetable.CHECKINLOCATION+","
//                +attendancetable.CHECKOUTLOCATION+","
//                +attendancetable.STATUS+","
//                +attendancetable.TOTALTIME+","
//                +attendancetable.INSYNC+","
//                +attendancetable.OUTSYNC+" FROM "+attendancetable.TABLE_NAME+" where "+attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.DATE+ " = ? ",new String[] {Companyname,emailid,date}, null);
//        if (mCursor != null) {
//            if(mCursor.getCount() > 0)
//            {
//                return mCursor;
//            }
//        }
//        return null;

    }

    public Cursor get_attendancetable_notsynced(String Companyname,String emailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.INSYNC+ " = ? AND "+attendancetable.OUTSYNC+ " = ? ",new String[]{Companyname,emailid,"No","No"},null,null,attendancetable._ID+" DESC ");
        return c;
    }

    public Cursor get_attendancetable_updatenotsynced(String Companyname,String emailid,String status) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.STATUS+ " = ? AND "+attendancetable.INSYNC+ " = ? AND "+attendancetable.OUTSYNC+ " = ? ",new String[]{Companyname,emailid,"Present","Yes","No"},null,null,attendancetable._ID+" DESC ");
        return c;
    }

    public Cursor get_attendancetable_checksynced(String Companyname,String emailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(attendancetable.TABLE_NAME,null,attendancetable.COMPANYNAME+ " = ? AND "+attendancetable.EMAILID+ " = ? AND "+attendancetable.OUTSYNC+ " = ? ",new String[]{Companyname,emailid,"No"},null,null,attendancetable._ID+" DESC ");
        return c;
    }

    //---location
    public void insert_locationtable(String Companyname,String emailid,String location,String checkinname,String latitude,String longitude,String date,String time,String sync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(locationtable.COMPANYNAME, Companyname);
            cv.put(locationtable.EMAILID, emailid);
            cv.put(locationtable.LOCATION, location);
            cv.put(locationtable.CHECKINNAME, checkinname);
            cv.put(locationtable.LATITUDE, latitude);
            cv.put(locationtable.LONGITUDE, longitude);
            cv.put(locationtable.DATE, date);
            cv.put(locationtable.TIME, time);
            cv.put(locationtable.SYNC, sync);

            sdb.insert(locationtable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_location_duplicacy(String Companyname,String emailid,String date,String time) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(locationtable.TABLE_NAME,null,locationtable.COMPANYNAME+ " = ? AND "+locationtable.EMAILID+ " = ? AND "+locationtable.DATE+ " = ? AND "+locationtable.TIME+" = ? ",new String[]{Companyname,emailid,date,time},null,null,null);
        return c;
    }

    public Cursor get_location(String Companyname,String emailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(locationtable.TABLE_NAME,null,locationtable.COMPANYNAME+ " = ? AND "+locationtable.EMAILID+ " = ? ",new String[]{Companyname,emailid},null,null,locationtable._ID+" DESC ");
        return c;
    }

    public Cursor get_locationtable_notsynced(String Companyname,String emailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(locationtable.TABLE_NAME,null,locationtable.COMPANYNAME+ " = ? AND "+locationtable.EMAILID+ " = ? AND "+locationtable.SYNC+ " = ? ",new String[]{Companyname,emailid,"No"},null,null,locationtable._ID+" DESC ");
        return c;
    }

    public void update_locationtable_sync(String Companyname,String emailid,String date,String time,String sync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(locationtable.SYNC, sync);
            sdb.update(locationtable.TABLE_NAME, cv ,locationtable.COMPANYNAME+ " = ?  AND "+locationtable.EMAILID+" = ? AND "+locationtable.DATE+" = ? AND "+locationtable.TIME+" = ? ", new String[]{Companyname,emailid,date,time});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_location_datewise(String Companyname,String emailid,String date) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(locationtable.TABLE_NAME,null,locationtable.COMPANYNAME+ " = ? AND "+locationtable.EMAILID+ " = ? AND "+locationtable.DATE+ " = ? ",new String[]{Companyname,emailid,date},null,null,locationtable._ID+" DESC ");
        return c;
    }

    //---dynamic questions
    public void insert_dynamicquestionstable(String Companyname,String customername,String questionnumber,String category,String subcategory,String question,String typeofquestion,String count,String optionforanswers,String dateandtime,String correctanswer,String questionmode,String customertype,String combinationname) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(dynamicquestionstable.COMPANYNAME, Companyname);
            cv.put(dynamicquestionstable.CUSTOMERNAME, customername);
            cv.put(dynamicquestionstable.QUESTIONNUMBER, questionnumber);
            cv.put(dynamicquestionstable.CATEGORY, category);
            cv.put(dynamicquestionstable.SUBCATEGORY, subcategory);
            cv.put(dynamicquestionstable.QUESTION, question);
            cv.put(dynamicquestionstable.TYPEOFQUESTION, typeofquestion);
            cv.put(dynamicquestionstable.COUNT, count);
            cv.put(dynamicquestionstable.OPTIONFORANSWERS, optionforanswers);
            cv.put(dynamicquestionstable.DATEANDTIME, dateandtime);
            cv.put(dynamicquestionstable.CORRECTANSWER, correctanswer);
            cv.put(dynamicquestionstable.QUESTIONMODE, questionmode);
            cv.put(dynamicquestionstable.CUSTOMERTYPE, customertype);
            cv.put(dynamicquestionstable.COMBINATIONNAME, combinationname);
            sdb.insert(dynamicquestionstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void insert_dynamicquestionstable_local(String Companyname,String customername,String facility,String questionmode,String customertype,String combinationname,String combinationtype,String category,String subcategory,String questionnumber,String question,String typeofquestion,String count,String optionforanswers,String correctanswer,String dateandtime,String date) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        Log.e("Insert local","called");

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();

            cv.put(dynamicquestionstablelocal.COMPANYNAME, Companyname);
            cv.put(dynamicquestionstablelocal.CUSTOMERNAME, customername);
            cv.put(dynamicquestionstablelocal.FACILITY, facility);
            cv.put(dynamicquestionstablelocal.QUESTIONMODE, questionmode);
            cv.put(dynamicquestionstablelocal.CUSTOMERTYPE, customertype);
            cv.put(dynamicquestionstablelocal.COMBINATIONNAME, combinationname);
            cv.put(dynamicquestionstablelocal.COMBINATIONTYPE, combinationtype);

            cv.put(dynamicquestionstablelocal.CATEGORY, category);
            cv.put(dynamicquestionstablelocal.SUBCATEGORY, subcategory);
            cv.put(dynamicquestionstablelocal.QUESTIONNUMBER, questionnumber);
            cv.put(dynamicquestionstablelocal.QUESTION, question);
            cv.put(dynamicquestionstablelocal.TYPEOFQUESTION, typeofquestion);
            cv.put(dynamicquestionstablelocal.COUNT, count);
            cv.put(dynamicquestionstablelocal.OPTIONFORANSWERS, optionforanswers);
            cv.put(dynamicquestionstablelocal.CORRECTANSWER, correctanswer);
            cv.put(dynamicquestionstablelocal.DATEANDTIME, dateandtime);
            cv.put(dynamicquestionstablelocal.DOWNLOADDATE, date);


            sdb.insert(dynamicquestionstablelocal.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_dynamicquestions_combination(String combinationname,String combinationtype,String customertype,String questionmode,String Customername,String facility) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstablelocal.TABLE_NAME,null,dynamicquestionstablelocal.COMBINATIONNAME+ " = ? AND "+dynamicquestionstablelocal.COMBINATIONTYPE+ " = ? AND "+dynamicquestionstablelocal.CUSTOMERTYPE+ " = ? AND "+dynamicquestionstablelocal.QUESTIONMODE+ " = ? AND "+dynamicquestionstablelocal.CUSTOMERNAME+ " = ? AND "+dynamicquestionstablelocal.FACILITY+ " = ? ",new String[]{combinationname,combinationtype,customertype,questionmode,Customername,facility},null,null,"CAST("+dynamicquestionstablelocal.QUESTIONNUMBER+" AS UNSIGNED) ASC ");
        if (c != null) {
            if(c.getCount() > 0)
            {
                return c;
            }
        }
        return null;


    }

    public Cursor get_dynamicquestions_combination_date(String combinationname,String combinationtype,String customertype,String questionmode,String Customername,String facility,String date) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstablelocal.TABLE_NAME,null,dynamicquestionstablelocal.COMBINATIONNAME+ " = ? AND "+dynamicquestionstablelocal.COMBINATIONTYPE+ " = ? AND "+dynamicquestionstablelocal.CUSTOMERTYPE+ " = ? AND "+dynamicquestionstablelocal.QUESTIONMODE+ " = ? AND "+dynamicquestionstablelocal.CUSTOMERNAME+ " = ? AND "+dynamicquestionstablelocal.FACILITY+ " = ? AND "+dynamicquestionstablelocal.DOWNLOADDATE+ " = ? ",new String[]{combinationname,combinationtype,customertype,questionmode,Customername,facility,date},null,null,"CAST("+dynamicquestionstablelocal.QUESTIONNUMBER+" AS UNSIGNED) ASC ");
        if (c != null) {
            if(c.getCount() > 0)
            {
                return c;
            }
        }
        return null;


    }

    public Cursor get_dynamicquestionstable(String Companyname) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? ",new String[]{Companyname},null,null,dynamicquestionstable._ID+" ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_category(String Companyname) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? ",new String[]{Companyname},dynamicquestionstable.CATEGORY,null,"CAST("+dynamicquestionstable.QUESTIONNUMBER+" AS UNSIGNED) ASC ");
        return c;
    }

    public Cursor get_answers_category(String Companyname,String combinationname,String questionmode,String customertype,String customername,String facility) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(answerstablelocal.TABLE_NAME,null,answerstablelocal.COMPANYNAME+ " = ? AND "+answerstablelocal.COMBINATIONNAME+ " = ? AND "+answerstablelocal.QUESTIONMODE+ " = ? AND "+answerstablelocal.CUSTOMERTYPE+ " = ? AND "+answerstablelocal.CUSTOMERNAME+ " = ? AND "+answerstablelocal.ATMID+ " = ? ",new String[]{Companyname,combinationname,questionmode,customertype,customername,facility},dynamicquestionstable.CATEGORY,null,"CAST("+dynamicquestionstable.QUESTIONNUMBER+" AS UNSIGNED) ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_subcategoryfull(String Companyname,String category) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? ",new String[]{Companyname,category},null,null,"CAST("+dynamicquestionstable.QUESTIONNUMBER+" AS UNSIGNED) ASC ");
        return c;
    }
    //    public Cursor get_dynamicquestions_subcategory(String Companyname,String category) {
//        SQLiteDatabase sdb = getReadableDatabase();
//        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? ",new String[]{Companyname,category},dynamicquestionstable.SUBCATEGORY,null,dynamicquestionstable.TYPEOFQUESTION+" ASC ,CAST("+dynamicquestionstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
//        return c;
//    }
    public Cursor get_dynamicquestions_subcategory(String Companyname,String category) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? ",new String[]{Companyname,category},dynamicquestionstable.SUBCATEGORY,null,dynamicquestionstable.TYPEOFQUESTION+" ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_category_subcategory(String Companyname,String category,String subcategory) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? AND "+dynamicquestionstable.SUBCATEGORY+ " = ? ",new String[]{Companyname,category,subcategory},null,null,"CAST("+dynamicquestionstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_dynamicquestions_all(String Companyname,String status) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+  " = ? AND "+dynamicquestionstable.CATEGORYSTATUS+" != ? ",new String[]{Companyname,status},null,null,"CAST("+dynamicquestionstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }


    public Cursor get_dynamicquestions_local_all(String Companyname) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstablelocal.TABLE_NAME,null,dynamicquestionstablelocal.COMPANYNAME+ " = ? ",new String[]{Companyname},null,null,"CAST("+dynamicquestionstablelocal.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }
    public Cursor get_dynamicquestions_type(String Companyname,String category,String subcategory,String question) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? AND "+dynamicquestionstable.SUBCATEGORY+ " = ? AND "+dynamicquestionstable.QUESTION+" = ? ",new String[]{Companyname,category,subcategory,question},null,null,null);
        return c;
    }
    public Cursor get_dynamicquestions_correctanswer(String Companyname,String customername,String questionnumber,String category,String subcategory,String question) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(dynamicquestionstable.TABLE_NAME,null,dynamicquestionstable.COMPANYNAME+ " = ? AND "+dynamicquestionstable.CUSTOMERNAME+ " = ? AND "+dynamicquestionstable.QUESTIONNUMBER+ " = ? AND "+dynamicquestionstable.CATEGORY+ " = ? AND "+dynamicquestionstable.SUBCATEGORY+ " = ? AND "+dynamicquestionstable.QUESTION+" = ? AND "+dynamicquestionstable.TYPEOFQUESTION,new String[]{Companyname,customername,questionnumber,category,subcategory,question,"boolean"},null,null,null);
        return c;
    }

  /*  public Cursor get_spareparts(String ticketnumber) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(sparestable.TABLE_NAME,null,sparestable.TICKETNUMBER+ " = ? ",new String[]{ticketnumber},null,null,null);
        return c;
    }*/

    public Cursor get_spareparts(String ticketnumber) throws SQLException
    {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM " + sparestable.TABLE_NAME + " WHERE \n" +
                "" + sparestable.TICKETNUMBER + " = ? ",new String[]{ticketnumber} , null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;

    }


    public Cursor get_dynamicquestions_local() throws SQLException
    {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+dynamicquestionstablelocal.TABLE_NAME,null , null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;

    }

    public int getspareamount(String ticketnumber) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT sum("+sparestable.TOTALAMOUNT+") as total FROM "+sparestable.TABLE_NAME+" WHERE "+sparestable.TICKETNUMBER+ " = ? ",new String[]{ticketnumber} , null);

        if (cursor.getCount() < 1) {
            cursor.close();
            return 0;
        }
        cursor.moveToFirst();
        int total = cursor.getInt(cursor.getColumnIndex("total"));
        cursor.close();
        return total;
    }

    public void delete_dynamicquestionstable() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("dynamicquestionstable", null, null);
    }

    public void delete_dynamicquestions_local_all() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("dynamicquestionstablelocal", null, null);
    }

    public void delete_answers_local_all() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("answerstablelocal", null, null);
    }

    public int deletespares(String sku,String name)throws SQLException
    {
        SQLiteDatabase sdb = getWritableDatabase();
        String where = "sku=? AND itemname=?";
        int numberOFEntriesDeleted = sdb.delete("sparestable", where,
                new String[] { sku,name });
        return numberOFEntriesDeleted;
    }

    public int deletesparesnew(String id,String sku,String name)throws SQLException
    {
        SQLiteDatabase sdb = getWritableDatabase();
        String where = "sku=? AND itemname=? AND "+sparestable._ID+"=?";
        int numberOFEntriesDeleted = sdb.delete("sparestable", where,
                new String[] { sku,name,id });
        return numberOFEntriesDeleted;
    }


    public int delete_attendancetable(String start,String end)throws SQLException
    {
        SQLiteDatabase sdb = getWritableDatabase();
        String where = attendancetable.DATE+"<?";
        int numberOFEntriesDeleted = sdb.delete("attendancetable", where,
                new String[] { start});
        return numberOFEntriesDeleted;
    }

    //---answers
    public void insert_answerstable(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        //   Log.e("image",image);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.COMPANYNAME, Companyname);
            cv.put(answerstable.CUSTOMERNAME, customername);
            cv.put(answerstable.ATMID, atmid);
            cv.put(answerstable.EMAILID, emailid);
            cv.put(answerstable.CATEGORY, category);
            cv.put(answerstable.SUBCATEGORY, subcategory);
            cv.put(answerstable.QUESTIONNUMBER, questionnumber);
            cv.put(answerstable.QUESTION, question);
            cv.put(answerstable.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            cv.put(answerstable.IMAGE,  globalvariables.getBytes(image));
            sdb.insert(answerstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void insert_answerstablelocal(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue,String customertype,String questionmode,String combinationname,String uniqueid)
    {
         // sqldatabase mDbHelper = new sqldatabase(mycontext);
         Log.e("insert answer local","coming");

        try {

            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstablelocal.COMPANYNAME, Companyname);
            cv.put(answerstablelocal.CUSTOMERNAME, customername);
            cv.put(answerstablelocal.ATMID, atmid);
            cv.put(answerstablelocal.EMAILID, emailid);
            cv.put(answerstablelocal.CATEGORY, category);
            cv.put(answerstablelocal.SUBCATEGORY, subcategory);
            cv.put(answerstablelocal.QUESTIONNUMBER, questionnumber);
            cv.put(answerstablelocal.QUESTION, question);
            cv.put(answerstablelocal.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstablelocal.ANSWER, answer);
            cv.put(answerstablelocal.IMAGEPATH, imagepath);
            cv.put(answerstablelocal.DATEANDTIME, dateandtime);
            cv.put(answerstablelocal.ISSUE, issue);
          //  cv.put(answerstablelocal.IMAGE,  globalvariables.getBytes(image));
            cv.put(answerstablelocal.CUSTOMERTYPE, customertype);
            cv.put(answerstablelocal.QUESTIONMODE, questionmode);
            cv.put(answerstablelocal.COMBINATIONNAME, combinationname);
            cv.put(answerstablelocal.UNIQUEID, uniqueid);
            cv.put(answerstablelocal.SYNC, "No");
            sdb.insert(answerstablelocal.TABLE_NAME,null, cv);

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void insert_answerstablelocal_image(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue,String customertype,String questionmode,String combinationname,String uniqueid)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        Log.e("insert answer local","coming");

        try {

            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstablelocal.COMPANYNAME, Companyname);
            cv.put(answerstablelocal.CUSTOMERNAME, customername);
            cv.put(answerstablelocal.ATMID, atmid);
            cv.put(answerstablelocal.EMAILID, emailid);
            cv.put(answerstablelocal.CATEGORY, category);
            cv.put(answerstablelocal.SUBCATEGORY, subcategory);
            cv.put(answerstablelocal.QUESTIONNUMBER, questionnumber);
            cv.put(answerstablelocal.QUESTION, question);
            cv.put(answerstablelocal.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstablelocal.ANSWER, answer);
            cv.put(answerstablelocal.IMAGEPATH, imagepath);
            cv.put(answerstablelocal.DATEANDTIME, dateandtime);
            cv.put(answerstablelocal.ISSUE, issue);
             cv.put(answerstablelocal.IMAGE,  globalvariables.getBytes(image));
            cv.put(answerstablelocal.CUSTOMERTYPE, customertype);
            cv.put(answerstablelocal.QUESTIONMODE, questionmode);
            cv.put(answerstablelocal.COMBINATIONNAME, combinationname);
            cv.put(answerstablelocal.UNIQUEID, uniqueid);
            cv.put(answerstablelocal.SYNC, "No");
            sdb.insert(answerstablelocal.TABLE_NAME,null, cv);

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public void insert_answerstable_edit(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        //   Log.e("image",image);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.COMPANYNAME, Companyname);
            cv.put(answerstable.CUSTOMERNAME, customername);
            cv.put(answerstable.ATMID, atmid);
            cv.put(answerstable.EMAILID, emailid);
            cv.put(answerstable.CATEGORY, category);
            cv.put(answerstable.SUBCATEGORY, subcategory);
            cv.put(answerstable.QUESTIONNUMBER, questionnumber);
            cv.put(answerstable.QUESTION, question);
            cv.put(answerstable.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.insert(answerstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void insert_answerstable_date(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        //   Log.e("image",image);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.COMPANYNAME, Companyname);
            cv.put(answerstable.CUSTOMERNAME, customername);
            cv.put(answerstable.ATMID, atmid);
            cv.put(answerstable.EMAILID, emailid);
            cv.put(answerstable.CATEGORY, category);
            cv.put(answerstable.SUBCATEGORY, subcategory);
            cv.put(answerstable.QUESTIONNUMBER, questionnumber);
            cv.put(answerstable.QUESTION, question);
            cv.put(answerstable.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.insert(answerstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void insert_answerstable_radio(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        //   Log.e("image",image);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.COMPANYNAME, Companyname);
            cv.put(answerstable.CUSTOMERNAME, customername);
            cv.put(answerstable.ATMID, atmid);
            cv.put(answerstable.EMAILID, emailid);
            cv.put(answerstable.CATEGORY, category);
            cv.put(answerstable.SUBCATEGORY, subcategory);
            cv.put(answerstable.QUESTIONNUMBER, questionnumber);
            cv.put(answerstable.QUESTION, question);
            cv.put(answerstable.TYPEOFQUESTION, typeofquestion);
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.insert(answerstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public Cursor get_answerstable(String Companyname,String emailid,String category,String subcategory,String question) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(answerstable.TABLE_NAME,null,answerstable.COMPANYNAME+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTION+ " = ? ",new String[]{Companyname,emailid,category,subcategory,question},null,null,null);
        return c;
    }
    public Cursor get_answerstable_summary(String Companyname,String emailid,String category) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(answerstable.TABLE_NAME,null,answerstable.COMPANYNAME+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? ",new String[]{Companyname,emailid,category},null,null,"CAST("+answerstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_answerstablelocal_summary(String Companyname,String emailid,String sync) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(answerstablelocal.TABLE_NAME,null,answerstablelocal.COMPANYNAME+ " = ? AND "+answerstablelocal.EMAILID+ " = ? AND "+answerstablelocal.SYNC+ " = ? ",new String[]{Companyname,emailid,sync},null,null,"CAST("+answerstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_answerstablelocal_synced(String Companyname,String emailid,String sync) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(answerstablelocal.TABLE_NAME,null,answerstablelocal.COMPANYNAME+ " = ? AND "+answerstablelocal.EMAILID+" = ? AND "+answerstablelocal.SYNC+ " = ? ",new String[]{Companyname,emailid,sync},null,null,"CAST("+answerstable.QUESTIONNUMBER+"  AS UNSIGNED) ASC");
        return c;
    }


    public void update_answerstable(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,Bitmap image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        Log.e("question number",questionnumber);
        Log.e("question",question);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, globalvariables.getBytes(image));
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.COMPANYNAME+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{Companyname,emailid,category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void update_answerstable_summaryimage(String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,Bitmap image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        Log.e("question number",questionnumber);
        Log.e("question",question);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, globalvariables.getBytes(image));
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_answerstable_submit(String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,Bitmap image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        Log.e("question number",questionnumber);
        Log.e("question",question);
        Log.e("answer",answer);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }



    public void update_spareparts(String id,String quantity,String total)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);



        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(sparestable.QUANTITY, quantity);
            cv.put(sparestable.TOTALAMOUNT, total);
            sdb.update(sparestable.TABLE_NAME, cv ,sparestable._ID+" = ? ", new String[]{id});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void update_answerstable_edit(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        Log.e("question number",questionnumber);
        Log.e("question",question);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void update_answerstable_date(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        Log.e("question number",questionnumber);
        Log.e("question",question);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public void update_answerstable_radio(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion,String answer,String image,String imagepath,String dateandtime,String issue)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);
        Log.e("question number",questionnumber);
        Log.e("question",question);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(answerstable.ANSWER, answer);
            cv.put(answerstable.IMAGE, image);
            cv.put(answerstable.IMAGEPATH, imagepath);
            cv.put(answerstable.DATEANDTIME, dateandtime);
            cv.put(answerstable.ISSUE, issue);
            sdb.update(answerstable.TABLE_NAME, cv ,answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question,typeofquestion});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    public void update_answerstable_local(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question) {
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put(answerstablelocal.SYNC, "Yes");

        sdb.update(answerstablelocal.TABLE_NAME, cv ,answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question});
    }


    public void delete_answerstable(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question) {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("answerstable",answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question});
    }



    public void delete_answerstable_edit(String Companyname,String customername,String atmid,String emailid,String category,String subcategory,String questionnumber,String question,String typeofquestion) {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("answerstable",answerstable.COMPANYNAME+ " = ? AND "+answerstable.CUSTOMERNAME+ " = ? AND "+answerstable.ATMID+ " = ? AND "+answerstable.EMAILID+ " = ? AND "+answerstable.CATEGORY+ " = ? AND "+answerstable.SUBCATEGORY+ " = ? AND "+answerstable.QUESTIONNUMBER+ " = ? AND "+answerstable.QUESTION+ " = ? AND "+answerstable.TYPEOFQUESTION+" = ? ", new String[]{Companyname,customername,atmid,emailid,category,subcategory,questionnumber,question,typeofquestion});
    }

    public void delete_answerstablefull() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("answerstable", null, null);
    }

    public void delete_sparestablefull() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("sparestable", null, null);
    }

    //--ticketstable
    public void insert_ticketstable(String Companyname,String assignedto,String rejectedby,String ticketstatus,String ticketstage,String ticketnumber,String customername,String atmid,String source,String priority,String createddateandtime,String assigneddateandtime,String questionorcallreason,String acceptedby,String accepteddateandtime,String rejecteddateandtime,String reasonforrejection,String Brand,String product,String model,String serialnumber,String questionmode,String questiontype,String combinationname,String combinationtype)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(ticketstable.COMPANYNAME, Companyname);
            cv.put(ticketstable.ASSIGNEDTO, assignedto);
            cv.put(ticketstable.REJECTEDBY, rejectedby);
            cv.put(ticketstable.TICKETSTATUS, ticketstatus);
            cv.put(ticketstable.TICKETSTAGE, ticketstage);
            cv.put(ticketstable.TICKETNUMBER, ticketnumber);
            cv.put(ticketstable.CUSTOMERNAME, customername);
            cv.put(ticketstable.ATMID, atmid);
            cv.put(ticketstable.SOURCE, source);
            cv.put(ticketstable.PRIORITY, priority);
            cv.put(ticketstable.CREATEDDATEANDTIME, createddateandtime);
            cv.put(ticketstable.ASSIGNEDDATEANDTIME, assigneddateandtime);
            cv.put(ticketstable.QUESTIONORCALLREASON, questionorcallreason);
            cv.put(ticketstable.ACCEPTEDBY,acceptedby );
            cv.put(ticketstable.ACCEPTEDDATEANDTIME, accepteddateandtime);
            cv.put(ticketstable.REJECTEDDATEANDTIME, rejecteddateandtime);
            cv.put(ticketstable.REASONFORREJECTION, reasonforrejection);
            cv.put(ticketstable.BRAND, Brand);
            cv.put(ticketstable.PRODUCT, product);
            cv.put(ticketstable.MODEL, model);
            cv.put(ticketstable.SERIALNUMBER, serialnumber);
            cv.put(ticketstable.QUESTIONMODE, questionmode);
            cv.put(ticketstable.QUESTIONTYPE, questiontype);
            cv.put(ticketstable.COMBINATIONNAME, combinationname);
            cv.put(ticketstable.COMBINATIONTYPE, combinationtype);
            sdb.insert(ticketstable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public Cursor get_tickets_open(String Companyname,String assignedto,String rejectedby) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(ticketstable.TABLE_NAME,null,ticketstable.COMPANYNAME+ " = ? AND "+ticketstable.ASSIGNEDTO+ " = ? AND "+ticketstable.REJECTEDBY+ " != ? AND "+ticketstable.TICKETSTAGE+" = ? AND ( "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? )",new String[]{Companyname,assignedto,rejectedby,"open","assigned","underprogress","Complete","Incomplete"},null,null,ticketstable.ASSIGNEDDATEANDTIME+ " DESC");
        return c;
    }
    public Cursor get_tickets_close(String Companyname,String assignedto) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(ticketstable.TABLE_NAME,null,ticketstable.COMPANYNAME+ " = ? AND "+ticketstable.ASSIGNEDTO+ " = ? AND "+ticketstable.TICKETSTAGE+" = ? AND ( "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? OR "+ticketstable.TICKETSTATUS+" = ? )",new String[]{Companyname,assignedto,"close","assigned","underprogress","Complete","Incomplete"},null,null,ticketstable.ASSIGNEDDATEANDTIME+ " DESC");
        return c;
    }
    public void delete_ticketstable() {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("ticketstable", null, null);
    }
    public void update_accept(String Companyname,String ticketnumber,String acceptedby,String accepteddateandtime)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(ticketstable.ACCEPTEDBY, acceptedby);
            cv.put(ticketstable.ACCEPTEDDATEANDTIME, accepteddateandtime);
            cv.put(ticketstable.TICKETSTATUS, "underprogress");
            sdb.update(ticketstable.TABLE_NAME, cv ,ticketstable.COMPANYNAME+ " = ?  AND "+ticketstable.TICKETNUMBER+" = ? ", new String[]{Companyname,ticketnumber});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public void update_reject(String Companyname,String ticketnumber,String rejectedby,String rejecteddateandtime)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(ticketstable.REJECTEDBY, rejectedby);
            cv.put(ticketstable.REJECTEDDATEANDTIME, rejecteddateandtime);
            cv.put(ticketstable.TICKETSTATUS, "unresolved");
            sdb.update(ticketstable.TABLE_NAME, cv ,ticketstable.COMPANYNAME+ " = ?  AND "+ticketstable.TICKETNUMBER+" = ? ", new String[]{Companyname,ticketnumber});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public void update_ticketreport(String Companyname,String ticketnumber,String ticketstatus,String brand,String product,String model,String serialnumber)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(ticketstable.TICKETSTATUS,ticketstatus);
            cv.put(ticketstable.BRAND, brand);
            cv.put(ticketstable.PRODUCT, product);
            cv.put(ticketstable.MODEL, model);
            cv.put(ticketstable.SERIALNUMBER, serialnumber);
            sdb.update(ticketstable.TABLE_NAME, cv ,ticketstable.COMPANYNAME+ " = ?  AND "+ticketstable.TICKETNUMBER+" = ? ", new String[]{Companyname,ticketnumber});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    //---leavetable
    public void insert_leavetable(String Companyname,String employeemailid,String leavetype,String leavefrom,String leaveto,String leavedays,String permissiondate,String permissionfrom,String permissionto,String permissioninminutes,String appliedateandtime,String reasonforleave,String sync)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(leavetable.COMPANYNAME, Companyname);
            cv.put(leavetable.EMPLOYEEEMAILID, employeemailid);
            cv.put(leavetable.LEAVETYPE, leavetype);
            cv.put(leavetable.LEAVEFROM, leavefrom);
            cv.put(leavetable.LEAVETO, leaveto);
            cv.put(leavetable.LEAVEDAYS, leavedays);
            cv.put(leavetable.PERMISSIONDATE, permissiondate);
            cv.put(leavetable.PERMISSIONFROM, permissionfrom);
            cv.put(leavetable.PERMISSIONTO, permissionto);
            cv.put(leavetable.PERMISSIONINMINUTES, permissioninminutes);
            cv.put(leavetable.APPLIEDDATEANDTIME, appliedateandtime);
            cv.put(leavetable.REASONFORLEAVEORPERMISSION, reasonforleave);
            cv.put(leavetable.STATUS, "pending");
            cv.put(leavetable.ACCEPTEDORREJECTEDDATEANDTIME, "0000-00-00 00:00:00");
            cv.put(leavetable.REJECTEDREASON, "no data available");
            cv.put(leavetable.PRIORITY, "no data available");
            cv.put(leavetable.SYNC, sync);
            cv.put(leavetable.SYNCWITHSERVER, "No");
            sdb.insert(leavetable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public Cursor get_leavetable_duplicacycheck(String Companyname,String employeemailid,String leavetype,String applieddateandtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.LEAVETYPE+ " = ? AND "+leavetable.APPLIEDDATEANDTIME+ " = ? ",new String[]{Companyname,employeemailid,leavetype,applieddateandtime},null,null,leavetable._ID+" DESC");
        return c;
    }
    public Cursor get_leavetable(String Companyname,String employeemailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? ",new String[]{Companyname,employeemailid},null,null,leavetable._ID+" DESC");
        return c;
    }
    public Cursor get_leavetable_filter(String Companyname,String employeemailid,String leavetype,String status) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = null;
        if(leavetype.equalsIgnoreCase("All")&&status.equalsIgnoreCase("All"))
        {
            c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? ",new String[]{Companyname,employeemailid},null,null,leavetable._ID+" DESC");
        }
        else if(leavetype.equalsIgnoreCase("All")&&(!status.equalsIgnoreCase("All")))
        {
            c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.STATUS+" = ? ",new String[]{Companyname,employeemailid,status},null,null,leavetable._ID+" DESC");
        }
        else if((!leavetype.equalsIgnoreCase("All"))&&status.equalsIgnoreCase("All"))
        {
            c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.LEAVETYPE+" = ? ",new String[]{Companyname,employeemailid,leavetype},null,null,leavetable._ID+" DESC");
        }
        else {
            c = sdb.query(leavetable.TABLE_NAME, null, leavetable.COMPANYNAME + " = ? AND " + leavetable.EMPLOYEEEMAILID + " = ? AND " + leavetable.LEAVETYPE + " = ? AND " + leavetable.STATUS+" = ? ", new String[]{Companyname, employeemailid, leavetype, status}, null, null, leavetable._ID + " DESC");
        }
        return c;
    }
    public Cursor get_leavetable_notsynced(String Companyname,String employeemailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.SYNC+ " = ? ",new String[]{Companyname,employeemailid,"No"},null,null,leavetable._ID+" ASC ");
        return c;
    }
    public void update_leavetable_tosync(String Companyname,String employeemailid,String leavetype,String apllieddateandtime,String sync)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(leavetable.SYNC, sync);
            sdb.update(leavetable.TABLE_NAME, cv ,leavetable.COMPANYNAME+ " = ?  AND "+leavetable.EMPLOYEEEMAILID+" = ? AND "+leavetable.LEAVETYPE+" = ? AND "+leavetable.APPLIEDDATEANDTIME+" = ? ", new String[]{Companyname,employeemailid,leavetype,apllieddateandtime});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public void update_leavetablestatus(String Companyname,String employeemailid,String leavetype,String appliedateandtime,String status,String acceptedorrejecteddateandtime,String rejectedreason,String syncwithserver)
    {

        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(leavetable.STATUS, status);
        cv.put(leavetable.ACCEPTEDORREJECTEDDATEANDTIME, acceptedorrejecteddateandtime);
        cv.put(leavetable.REJECTEDREASON, rejectedreason);
        cv.put(leavetable.SYNCWITHSERVER, syncwithserver);
        sdb.update(leavetable.TABLE_NAME, cv ,leavetable.COMPANYNAME+ " = ?  AND "+leavetable.EMPLOYEEEMAILID+" = ? AND "+leavetable.LEAVETYPE+" = ? AND "+leavetable.APPLIEDDATEANDTIME+" = ? ", new String[]{Companyname,employeemailid,leavetype,appliedateandtime});
    }
    public Cursor get_leavetablefull(String Companyname,String employeemailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? ",new String[]{Companyname,employeemailid},null,null,leavetable._ID+" ASC ");
        return c;
    }
    public Cursor get_leavetable_tosyncwithserver(String Companyname,String employeemailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(leavetable.TABLE_NAME,null,leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.SYNCWITHSERVER+ " = ? ",new String[]{Companyname,employeemailid,"Yes"},null,null,leavetable._ID+" ASC ");
        return c;
    }
    public void update_leavetable_tosyncwithserver(String Companyname,String employeemailid,String leavetype,String apllieddateandtime,String syncwithserver)
    {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(leavetable.SYNCWITHSERVER, syncwithserver);
            sdb.update(leavetable.TABLE_NAME, cv ,leavetable.COMPANYNAME+ " = ?  AND "+leavetable.EMPLOYEEEMAILID+" = ? AND "+leavetable.LEAVETYPE+" = ? AND "+leavetable.APPLIEDDATEANDTIME+" = ? ", new String[]{Companyname,employeemailid,leavetype,apllieddateandtime});
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void insert_leavetablefull(String Companyname,String employeemailid,String leavetype,String leavefrom,String leaveto,String leavedays,String permissiondate,String permissionfrom,String permissionto,String permissioninminutes,String appliedateandtime,String reasonforleave,String status,String acceptedorrejecteddateandtime,String rejectedreason,String priority) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(leavetable.COMPANYNAME, Companyname);
            cv.put(leavetable.EMPLOYEEEMAILID, employeemailid);
            cv.put(leavetable.LEAVETYPE, leavetype);
            cv.put(leavetable.LEAVEFROM, leavefrom);
            cv.put(leavetable.LEAVETO, leaveto);
            cv.put(leavetable.LEAVEDAYS, leavedays);
            cv.put(leavetable.PERMISSIONDATE, permissiondate);
            cv.put(leavetable.PERMISSIONFROM, permissionfrom);
            cv.put(leavetable.PERMISSIONTO, permissionto);
            cv.put(leavetable.PERMISSIONINMINUTES, permissioninminutes);
            cv.put(leavetable.APPLIEDDATEANDTIME, appliedateandtime);
            cv.put(leavetable.REASONFORLEAVEORPERMISSION, reasonforleave);
            cv.put(leavetable.STATUS, status);
            cv.put(leavetable.ACCEPTEDORREJECTEDDATEANDTIME, acceptedorrejecteddateandtime);
            cv.put(leavetable.REJECTEDREASON, rejectedreason);
            cv.put(leavetable.PRIORITY, priority);
            cv.put(leavetable.SYNC, "Yes");
            cv.put(leavetable.SYNCWITHSERVER, "No");
            sdb.insert(leavetable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_leavetable_validationfordatesrange1(String Companyname,String employeemailid,String currentstartdate,String currentenddate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" !=  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+" ( ( '"+currentstartdate+"' BETWEEN "+leavetable.LEAVEFROM+" AND "+leavetable.LEAVETO+" ) OR  ( '"+currentenddate+"' BETWEEN "+leavetable.LEAVEFROM+" AND "+leavetable.LEAVETO+" ) ) " , null);
        return c;
    }

    public Cursor get_leavetable_validationfordatesrange2(String Companyname,String employeemailid,String currentstartdate,String currentenddate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" !=  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.LEAVETO+" != '0000-00-00' "+" AND  ( '"+currentstartdate+"' <= "+leavetable.LEAVEFROM+" AND '"+currentenddate+"' >= "+leavetable.LEAVETO+" )   " , null);
        return c;
    }

    public Cursor get_leavetable_validationfordatesrange3(String Companyname,String employeemailid,String currentstartdate,String currentenddate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" !=  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.LEAVETO+" = '0000-00-00' "+" AND  ( '"+currentstartdate+"' <= "+leavetable.LEAVEFROM+" AND '"+currentenddate+"' >= "+leavetable.LEAVEFROM+" )   " , null);
        return c;
    }

    public Cursor get_leavetable_validationforoneday1(String Companyname,String employeemailid,String currentdate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" !=  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.LEAVEFROM+ " = '"+currentdate+"' " , null);
        return c;
    }

    public Cursor get_leavetable_validationforoneday2(String Companyname,String employeemailid,String currentdate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" !=  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+" ( '"+currentdate+"' BETWEEN "+leavetable.LEAVEFROM+" AND "+leavetable.LEAVETO+" ) " , null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission1(String Companyname,String employeemailid,String todaydate,String currentstarttime,String currentendtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" =  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.PERMISSIONDATE+" =  '"+todaydate +"' AND ( ( '"+currentstarttime+"' BETWEEN "+leavetable.PERMISSIONFROM+" AND "+leavetable.PERMISSIONTO+" ) OR  ( '"+currentendtime+"' BETWEEN "+leavetable.PERMISSIONFROM+" AND "+leavetable.PERMISSIONTO+" ) ) " , null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission2(String Companyname,String employeemailid,String todaydate,String currentstarttime,String currentendtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.LEAVETYPE+" =  'Permission' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.PERMISSIONDATE+" =  '"+todaydate +"' AND ( '"+currentstarttime+"' < "+leavetable.PERMISSIONFROM+" AND '"+currentendtime+"' > "+leavetable.PERMISSIONTO+" )   " , null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission3(String Companyname,String employeemailid,String todaydate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + leavetable.TABLE_NAME + " where "+leavetable.COMPANYNAME+" = '"+Companyname+"' AND "+leavetable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+leavetable.STATUS+" !=  'rejected' AND "+leavetable.LEAVETYPE+" !=  'Permission'  AND  ( '"+todaydate+"' >= "+leavetable.LEAVEFROM+" AND '"+todaydate+"' <= "+leavetable.LEAVETO+" ) " , null);
        return c;
    }

    public void delete_leavetable(String Companyname,String employeemailid,String leavetype,String applieddatenadtime) {
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete("leavetable",leavetable.COMPANYNAME+ " = ? AND "+leavetable.EMPLOYEEEMAILID+ " = ? AND "+leavetable.LEAVETYPE+ " = ? AND "+leavetable.APPLIEDDATEANDTIME+ " = ? ", new String[]{Companyname,employeemailid,leavetype,applieddatenadtime});
    }

    //----timesheet
    public void insert_timesheet(String Companyname,String employeemailid,String attendancegroup,String attendancesubgroup,String attendaceteam,String activity,String latitude,String longitude,String location,String timesheetdate,String starttime,String endtime,String dateandtime,String sync) {
        // sqldatabase mDbHelper = new sqldatabase(mycontext);

        try {
            SQLiteDatabase sdb = getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(timesheettable.COMPANYNAME, Companyname);
            cv.put(timesheettable.EMPLOYEEEMAILID, employeemailid);
            cv.put(timesheettable.ATTENDACEGROUP, attendancegroup);
            cv.put(timesheettable.ATTENDANCESUBGROUP, attendancesubgroup);
            cv.put(timesheettable.ATTENDANCETEAM, attendaceteam);
            cv.put(timesheettable.ACTIVITY, activity);
            cv.put(timesheettable.LATITUDE, latitude);
            cv.put(timesheettable.LONGITUDE, longitude);
            cv.put(timesheettable.LOCATION, location);
            cv.put(timesheettable.TIMESHEETDATE, timesheetdate);
            cv.put(timesheettable.STARTTIME, starttime);
            cv.put(timesheettable.ENDTIME, endtime);
            cv.put(timesheettable.DATEANDTIME, dateandtime);
            cv.put(timesheettable.SYNC, sync);

            sdb.insert(timesheettable.TABLE_NAME,null, cv);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public Cursor get_timesheetduplicacycheck(String Companyname,String employeemailid,String dateandtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.COMPANYNAME+ " = ? AND "+timesheettable.EMPLOYEEEMAILID+ " = ? AND "+timesheettable.DATEANDTIME+" = ? ",new String[]{Companyname,employeemailid,dateandtime},null,null,timesheettable._ID+" DESC ");
        return c;
    }

    public Cursor get_timesheet(String Companyname,String employeemailid) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.COMPANYNAME+ " = ? AND "+timesheettable.EMPLOYEEEMAILID+ " = ? ",new String[]{Companyname,employeemailid},null,null,timesheettable._ID+" DESC ");
        return c;
    }

    public Cursor get_timesheettable_notsynced(String Companyname) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.COMPANYNAME+ " = ? AND "+timesheettable.SYNC+ " = ? ",new String[]{Companyname,"no"},null,null,timesheettable._ID+" ASC ");
        return c;
    }

    public Cursor get_timesheet_validationfortime1(String Companyname,String employeemailid,String todaydate,String currentstarttime,String currentendtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + timesheettable.TABLE_NAME + " where "+timesheettable.COMPANYNAME+" = '"+Companyname+"' AND "+timesheettable.EMPLOYEEEMAILID+" = '"+employeemailid+"' AND "+timesheettable.TIMESHEETDATE+" =  '"+todaydate
                +"' AND ( " +
                "( '"+currentstarttime+"' BETWEEN "+timesheettable.STARTTIME+" AND "+timesheettable.ENDTIME+" ) OR  " +
                "( '"+currentendtime+"' BETWEEN "+timesheettable.STARTTIME+" AND "+timesheettable.ENDTIME+" ) ) " , null);
        return c;
    }

    public Cursor get_timesheet_validationfortime2(String Companyname,String employeemailid,String todaydate,String currentstarttime,String currentendtime) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c= sdb.rawQuery("select * from " + timesheettable.TABLE_NAME + " where "+
                timesheettable.COMPANYNAME+" = '"+Companyname+"' AND "+timesheettable.EMPLOYEEEMAILID+" = '"+employeemailid+"' " +
                "AND "+timesheettable.TIMESHEETDATE+" =  '"+todaydate +"' " +
                "AND ( '"+currentstarttime+"' < "+timesheettable.STARTTIME+" AND '"+currentendtime+"' > "+timesheettable.ENDTIME+" )   " , null);
        return c;
    }

    public Cursor get_timesheet_selecteddate(String Companyname,String employeemailid,String fromdate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.COMPANYNAME+ " = ? AND "+timesheettable.EMPLOYEEEMAILID+ " = ? AND "+timesheettable.TIMESHEETDATE+" = ? ",new String[]{Companyname,employeemailid,fromdate},null,null,timesheettable._ID+" DESC ");
        return c;
    }

    public Cursor get_timesheet_selecteddaterange(String Companyname,String employeemailid,String fromdate,String todate) {
        SQLiteDatabase sdb = getReadableDatabase();
        Cursor c = sdb.query(timesheettable.TABLE_NAME,null,timesheettable.COMPANYNAME+ " = ? AND "+timesheettable.EMPLOYEEEMAILID+ " = ? AND "+timesheettable.TIMESHEETDATE+ " >= ? AND "+timesheettable.TIMESHEETDATE+ " <= ? ",new String[]{Companyname,employeemailid,fromdate,todate},null,null,timesheettable._ID+" DESC ");
        return c;
    }
//    public String getLeavesmonthlycount(String startdate,String enddate) throws JSONException {
//        String leaves = "0";
//        SQLiteDatabase sdb = getReadableDatabase();
////        String query="SELECT * FROM "+ TripTable.TABLENAME +" WHERE "+TripTable.STATUS+"='"+startdate+"'";
////        Cursor c = sdb.rawQuery(query,null);
////        return cursorToArray(c); //leavetable
//        String query= "  SELECT  "+leavetable.LEAVETYPE+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    and "+leavetable.LEAVEDAYS+" !=0  ORDER by  "+leavetable.LEAVEFROM+"  ASC " ;
////        String query= " SELECT SUM(Final.dayscount) AS TotalLeaves FROM (( SELECT CASE "+
////                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY('"+startdate+"')+1 )"+
////                " WHEN "+leavetable.LEAVEFROM+" < '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+")-JULIANDAY('"+startdate+"')+1 ) "+
////                " WHEN "+leavetable.LEAVEFROM+" >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  > '"+enddate+"' THEN (JULIANDAY('"+enddate+"')-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
////                " WHEN "+leavetable.LEAVEFROM+"  >= '"+startdate+"' AND  "+leavetable.LEAVETO+"  <= '"+enddate+"' THEN (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
////                " ELSE (JULIANDAY( "+leavetable.LEAVETO+" )-JULIANDAY( "+leavetable.LEAVEFROM+" )+1 ) "+
////                " END AS dayscount,  "+leavetable.LEAVETYPE+", "+leavetable.LEAVEFROM+" ,"+leavetable.LEAVETO+","+leavetable.LEAVEDAYS+","+leavetable.STATUS+","+leavetable.REASONFORLEAVEORPERMISSION+" FROM "+leavetable.TABLE_NAME+" where  "+leavetable.STATUS+" != 'pending'    and "+leavetable.LEAVEDAYS+" !=0 AND ( "+leavetable.LEAVEFROM+"  >= '"+startdate+"' and  "+leavetable.LEAVETO+"  <= '"+enddate+"') or ( "+leavetable.LEAVEFROM+"  <= '"+enddate+"' and  "+leavetable.LEAVETO+"  >= '"+enddate+"')  or ( "+leavetable.LEAVEFROM+"  <= '"+startdate+"' and  "+leavetable.LEAVETO+"  >= '"+startdate+"') ORDER by  "+leavetable.LEAVEFROM+"  ASC) AS Final ) " ;
//        Cursor c = sdb.rawQuery(query,null);
//        if(c.moveToFirst()){
//            //do{
//            leaves=c.getString(c.getColumnIndex(leavetable.LEAVETYPE));
//            // }while(c.moveToNext());
//        }
//
//        return leaves;
//    }

}
