package com.b2lmobitech.fieldcloudplus.others.utils;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import androidx.fragment.app.Fragment;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;


import java.util.Map;

/**
 * Created by home on 3/24/2018.
 */

public class MyRequestQueue {
    private static Activity activity;
    private RequestQueue mRequestQueue;
    private static ProgressBar progressBar;
    private static Window window;
    private static ConnectivityManager cm;

    private MyRequestQueue(Activity activity){
        MyRequestQueue.activity = activity;
        progressBar=activity.findViewById(R.id.progressBar);
        mRequestQueue = getRequestQueue();
        window=activity.getWindow();
        cm = (ConnectivityManager) activity.getSystemService(Context.CONNECTIVITY_SERVICE);
    }

    public static synchronized MyRequestQueue getInstance(Activity activity){
        return new MyRequestQueue(activity);
    }

    public static synchronized MyRequestQueue getInstance(Fragment fragment){
        return new MyRequestQueue(fragment.getActivity());
    }

    private RequestQueue getRequestQueue(){
        if(mRequestQueue == null){
            mRequestQueue = Volley.newRequestQueue(activity.getApplicationContext());
        }
        return mRequestQueue;
    }

    public void addToQueue(String URL, final Map<String, String> params, final MyRequestFinishedListener myRequestFinishedListener){

        showProgressBar();
        StringRequest postRequest = new StringRequest(Request.Method.POST,URL,
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        hideProgressBar();
                        myRequestFinishedListener.requestResult(response);
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        hideProgressBar();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                return params;
            }
        };
        postRequest.setRetryPolicy(new DefaultRetryPolicy(240 * 1000, 1, 1.0f));
        mRequestQueue.add(postRequest);
    }

    public void showProgressBar(){
        if(progressBar!=null) {
            progressBar.setVisibility(View.VISIBLE);
        }
        window.setFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);
    }

    public void hideProgressBar(){
        if(progressBar!=null) {
            progressBar.setVisibility(View.GONE);
        }
        window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);
    }

    public boolean isNoNetwork() {
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if(networkInfo != null && networkInfo.isConnected()){
            return false;
        }else{
            Toast.makeText(activity.getApplicationContext(),"No Inernet Connection",Toast.LENGTH_SHORT).show();
            return true;
        }
    }

    public boolean isNoInternet() {
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
//        Log.d("netinfo", networkInfo.toString());
        return networkInfo == null || !networkInfo.isConnected();
    }

    public boolean isInternetAvailable() {
        ConnectivityManager cm = (ConnectivityManager) activity.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm != null) {
            Network network = cm.getActiveNetwork();
//            Log.d("network", "[" + network.toString() + "]");
            if (network != null) {
                NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
                Log.d("capabilities", "here" + capabilities);
                if (capabilities != null) {
                    Log.d("capabilities", "here" + capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI));
                    Log.d("capabilities", "here" + capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR));
                    Log.d("capabilities", "here" + capabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET));
                    return !(capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)
                            || capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)
                            || capabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET));
                }
            }
        }
        return true;
    }

}
