package com.b2lmobitech.fieldcloudplus.others.utils;

import android.content.Context;
import android.os.Vibrator;
import com.google.android.material.textfield.TextInputLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;

import com.b2lmobitech.fieldcloudplus.R;

import fr.ganfra.materialspinner.MaterialSpinner;


/**
 * Created by home on 3/23/2018.
 */

public class Validations {

    public static Animation animShake;
    public static Vibrator vib;

    private static Validations ourInstance;

    private Validations(Context context){
        animShake = AnimationUtils.loadAnimation(context, R.anim.shake);
        vib = (Vibrator) context.getSystemService(Context.VIBRATOR_SERVICE);
    }

    public static synchronized Validations getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(ourInstance == null){
            ourInstance = new Validations(context);
        }
        // Return MySingleton new Instance
        return ourInstance;
    }

    public void setError(final TextInputLayout til, String str){
        til.setError(str);
        til.setAnimation(animShake);
        til.startAnimation(animShake);
        vib.vibrate(200);


        til.getEditText().addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                clearError(til);
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }

    public void setError(final MaterialSpinner til, String str){
        til.setError(str);
        til.setAnimation(animShake);
        til.startAnimation(animShake);
        vib.vibrate(200);


        til.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                til.setError(null);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
    }

    public void clearError(final TextInputLayout til){
        til.setErrorEnabled(false);
        til.clearAnimation();
    }

}
