package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class AddSpareActivity extends AppCompatActivity {

    AutoCompleteTextView spareName,spareUnit;
    EditText spareAmount;
    JSONArray jsonArray;
    ArrayList<String> sparesList=new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addspare);
        getSupportActionBar().setTitle("Add Spare");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        try {
            jsonArray=new JSONArray(getIntent().getStringExtra("json"));
            sparesList=getIntent().getStringArrayListExtra("spares");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        getWidgets();
    }

    private void getWidgets(){
        spareName=findViewById(R.id.spareName);
        ArrayAdapter<String> adapter = new ArrayAdapter<String>
                (this, android.R.layout.select_dialog_item, sparesList);
        spareName.setAdapter(adapter);
        spareName.setThreshold(1);//will start working from first character
        spareUnit=findViewById(R.id.spareUnit);
        spareAmount=findViewById(R.id.spareAmount);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                try {
                    setResult();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


    private void setResult() throws JSONException {
        if(isValid() && !alreadyExists()){
            Bundle bundle=new Bundle();
            JSONObject jsonObject=new JSONObject();
            jsonObject.put("name",spareName.getText().toString());
            jsonObject.put("amount",spareAmount.getText().toString());
            jsonObject.put("unit",spareUnit.getText().toString());
            jsonObject.put("total",Integer.parseInt(spareUnit.getText().toString())*Integer.parseInt(spareAmount.getText().toString()));
            bundle.putString("json",jsonObject.toString());
            setResult(Activity.RESULT_OK,new Intent().putExtras(bundle));
            finish();
        }else if(alreadyExists()){
            Toast.makeText(getApplicationContext(),"Spare Already Exists",Toast.LENGTH_SHORT).show();
        }else{
            Toast.makeText(getApplicationContext(),"Fill All Fields",Toast.LENGTH_SHORT).show();
        }
    }

    private boolean isValid() {
        return !spareUnit.getText().toString().equals("0") && !spareName.getText().toString().isEmpty() && !spareUnit.getText().toString().isEmpty() && !spareAmount.getText().toString().isEmpty();
    }

    private boolean alreadyExists(){
        for(int i=0; i<jsonArray.length(); i++){
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if(spareName.getText().toString().equalsIgnoreCase(jsonObject.getString("name"))){
                    return true;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

}
