package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.Address;
import android.location.Geocoder;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.adapter.CategoryAdapter;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TypeTable;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CategoryActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    TextView errorText;
    String id,date,cat,assignid,lat,lon;
    JSONArray jsonArray;
    private static final int REQUEST=1;
    MenuItem start,done;
    String status="";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_category);
        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Category");
        id=getIntent().getStringExtra("id");
        date=getIntent().getStringExtra("date");
        cat=getIntent().getStringExtra("cat");
        assignid=getIntent().getStringExtra("assignid");
        lat=getIntent().getStringExtra("lat");
        lon=getIntent().getStringExtra("lon");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getCategories();
    }

    private void getCategories(){
        jsonArray= ServiceDatabase.getInstance(this).getQuestionsCategory(assignid);
        CategoryAdapter categoryAdapter=new CategoryAdapter(this,jsonArray);
        recyclerView.setAdapter(categoryAdapter);
        try {
            status=jsonArray.getJSONObject(0).getString(AssignTable.STATUS);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        checkforMenuCreated();

    }

    @Override
    public void itemClicked(int position) {
        if("assigned".equals(status)){
            Toast.makeText(getApplicationContext(),"Please start the Inspection",Toast.LENGTH_SHORT).show();
            return;
        }

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            if(!jsonObject.getBoolean("isCompleted") && !jsonObject.getBoolean("inOffline")) {
                Intent intent = new Intent(getApplicationContext(), QuestionActivity.class);
                intent.putExtra("id", id);
                intent.putExtra("date", date);
                intent.putExtra("cat", jsonObject.getString(TypeTable.CATEGORY));
                intent.putExtra("assignid", assignid);
                startActivity(intent);
            }else{
                Toast.makeText(getApplicationContext(),"Already Answered",Toast.LENGTH_SHORT).show();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(ServiceDatabase.getInstance(this).checkAllCategoriesCompleted(assignid)) {
                    if(!MyRequestQueue.getInstance(this).isNoNetwork()){
                        checkforUnCompleted();
                    }
                }else{
                    Toast.makeText(getApplicationContext(),"Complete All Categories",Toast.LENGTH_SHORT).show();
                }
                break;
            case R.id.start:
                startInspection();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void updateCompleted(){
        final ServiceDatabase database=ServiceDatabase.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("id", assignid);
        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.UPDATE_COMPLETED, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        Toast.makeText(getApplicationContext(),"Completed Sucessfully",Toast.LENGTH_SHORT).show();
                        database.updateCompleted(assignid);
                        finish();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkforUnCompleted(){
        ServiceDatabase database=ServiceDatabase.getInstance(this);
        String unsyncedCat= null;
        try {
            unsyncedCat = database.getUnSyncedCategory(assignid);
            Log.e("unsynced cat", String.valueOf(unsyncedCat));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if(unsyncedCat==null){
            updateCompleted();
            return;
        }
        try {
            insertAnswers(unsyncedCat);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void insertAnswers(final String catId) throws JSONException {
        Preference preference = Preference.getInstance(this);
        final ServiceDatabase database = ServiceDatabase.getInstance(this);

        Geocoder geocoder = new Geocoder(this, Locale.getDefault());
        List<Address> addresses = null;
        String location_data;

        try {
            // Convert string lat/lon safely to double
            double latitude = Double.parseDouble(lat);
            double longitude = Double.parseDouble(lon);

            addresses = geocoder.getFromLocation(latitude, longitude, 1);
            if (addresses != null && !addresses.isEmpty()) {
                location_data = addresses.get(0).getAddressLine(0);
            } else {
                location_data = "Unknown location";
            }
        } catch (IOException | NumberFormatException e) {
            e.printStackTrace();
            location_data = "Location not available";
        }

        // 🔹 Get all unsynced answers for this category
        List<JSONObject> answersList = database.getAnswersList(assignid, catId);

        if (answersList == null || answersList.isEmpty()) {
            Log.e("InsertAnswers", "No answers found for category " + catId);
            updateCompleted(); // or skip to next category
            return;
        }

        // 🔹 Upload each answer one by one
        for (int i = 0; i < answersList.size(); i++) {
            JSONObject jsonObject = answersList.get(i);

            // Add additional parameters
            jsonObject.put("email", preference.getEmailId());
            jsonObject.put("facility", id);
            jsonObject.put("cat", catId);
            jsonObject.put("lat", lat);
            jsonObject.put("lon", lon);
            jsonObject.put("location", location_data);

            Map<String, String> params = new HashMap<>();
            params.put("JSON", jsonObject.toString());

            // Send to server
            MyRequestQueue.getInstance(this).addToQueue(SERVICEURL.INSERT_ANSWERS, params, new MyRequestFinishedListener() {
                @Override
                public void requestResult(String response) {
                    try {
                        JSONObject res = new JSONObject(response);
                        if (res.getInt("s") == 1) {
                            database.updateSynced(assignid, catId);
                            checkforUnCompleted();
                        } else {
                            Toast.makeText(getApplicationContext(), "Unable to submit the answers", Toast.LENGTH_SHORT).show();
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.service_preventive, menu);
        start=menu.findItem(R.id.start);
        done=menu.findItem(R.id.done);
        return true;
    }

    private void checkforMenuCreated(){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                if(start!=null){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        updateMenu();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    private void updateMenu(){
        start.setVisible("assigned".equals(status));
        done.setVisible(!"assigned".equals(status));
    }

    private void startInspection(){
        Map<String, String> params = new HashMap<>();
        params.put("id", assignid);
        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.START_INSPECTION, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        ServiceDatabase.getInstance(getApplicationContext()).updateStarted(assignid);
                        Toast.makeText(getApplicationContext(),"Started Sucessfully",Toast.LENGTH_SHORT).show();
                        getCategories();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onBackPressed() {
        AlertDialog.Builder alertdialog = new AlertDialog.Builder(this);

        alertdialog.setIcon(R.drawable.ic_action_submit);
        alertdialog.setMessage("Answers will be deleted");
        alertdialog.setPositiveButton("CLose",   new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {

            }
        });

        alertdialog.setPositiveButton("Go Back",   new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {
                finish();
            }
        });

        alertdialog.show();


    }
}
