package com.b2lmobitech.fieldcloudplus.service.activities

import android.Manifest
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Bundle
import android.util.Log
import android.view.MenuItem
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.recyclerview.widget.LinearLayoutManager
import com.b2lmobitech.fieldcloudplus.databinding.ActivityPreventiveBinding
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.adapter.PreventiveAdapter
import com.b2lmobitech.fieldcloudplus.service.listener.PreventiveListener
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase
import com.b2lmobitech.fieldcloudplus.service.sql.tables.*
import com.b2lmobitech.fieldcloudplus.service.v2.HistoryListActivity
import com.b2lmobitech.fieldcloudplus.service.v2.SelectComboActivity
import com.b2lmobitech.fieldcloudplus.task.others.Preference
//import kotlinx.android.synthetic.main.activity_preventive.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class PreventiveActivity : AppCompatActivity(), OnItemClickListener, PreventiveListener {

    private lateinit var adapter: PreventiveAdapter
    private var cats = JSONArray()
    private var subcats = JSONArray()
    private lateinit var binding: ActivityPreventiveBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_preventive)
        binding = ActivityPreventiveBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        binding.recyclerView.setLayoutManager(LinearLayoutManager(this))
        binding.recyclerView.addItemDecoration(DividerItemDecoration(this, LinearLayoutManager.VERTICAL))
        binding.recyclerView.setHasFixedSize(true)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = "Forms"

        binding.cardNew.setOnClickListener {
            val intent = Intent(this,SelectComboActivity::class.java).apply {
                putExtra("cats",cats.toString())
                putExtra("subcats",subcats.toString())
            }
            startActivity(intent)
        }

        binding.cardCompleted.setOnClickListener {
            val intent = Intent(this,HistoryListActivity::class.java)
            startActivity(intent)
        }
    }

    override fun onResume() {
        super.onResume()

        Runnable {
            val database = ServiceDatabase.getInstance(this)
            database.deleteAll()
            Log.d("called","called")
        }.run()

    }

    private fun getinspections() {
            val preference = Preference.getInstance(this)
            val params: MutableMap<String, String> = HashMap()
            params["mail"] = preference.emailId
            params["cname"] = preference.companyName
            val myRequestQueue = MyRequestQueue.getInstance(this)
            myRequestQueue.addToQueue(SERVICEURL.GET_INSPECTIONS, params) { response ->
                try {
                    getInspections(JSONObject(response))
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
    }

    @Throws(JSONException::class)
    private fun getInspections(jsonObject: JSONObject) {
        /* JSONArray jsonArray=jsonObject.getJSONArray("list");
        adapter=new PreventiveAdapter(this,jsonArray);
        recyclerView.setAdapter(adapter);*/
        cats = jsonObject.getJSONArray("cat")
        subcats = jsonObject.getJSONArray("subcat")
        Log.d("dummmy","here2")

        val database = ServiceDatabase.getInstance(this)
        database.insertIntoTable(jsonObject.getJSONArray("brand"), BrandTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("model"), ModelTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("product"), ProductTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("serial"), SerialTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("cat"), CategoryTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("subcat"), SubCatTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("type"), TypeTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("combs"), CombinationTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("assign"), AssignTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("facility"), FacilityTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ques"), QuestionTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("qcat"), QCategoryTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("qsubcat"), QSubCatTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_questions"),
            FlexibleFormQuestionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_sections"),
            FlexibleFormSectionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_options"),
            FlexibleFormOptionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_response"),
            FlexibleFormResponsesTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_dataresponse"),
            FlexibleFormResponsesDataTable.TABLENAME)

/*
        if(jsonArray.length()==0){
            errorText.setText("No Inspections");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }*/setAdapter()
    }

    private fun setAdapter() {
        val parcelable = binding.recyclerView!!.layoutManager!!.onSaveInstanceState()
        val database = ServiceDatabase.getInstance(this)
        val jsonArray = database.preventive
        adapter = PreventiveAdapter(this, jsonArray)
        binding.recyclerView!!.adapter = adapter
        binding.recyclerView!!.layoutManager!!.onRestoreInstanceState(parcelable)
        binding.errorText!!.text = "No Forms found"
        binding.errorText!!.visibility = if (jsonArray.length() == 0) View.VISIBLE else View.GONE
    }

    override fun itemClicked(position: Int) {
        try {
            val jsonObject = adapter!!.jsonArray.getJSONObject(position)
            var intent: Intent? = null
            if (jsonObject.getString(AssignTable.TYPE).toLowerCase().contains("product")) {
                intent = Intent(applicationContext, ProductCombinationActivity::class.java)
            } else if (jsonObject.getString(AssignTable.TYPE).toLowerCase().contains("service")) {
                intent = Intent(applicationContext, ServiceCombinationActivity::class.java)
            }
            intent!!.putExtra("id", jsonObject.getString(AssignTable.FACILITY))
            intent.putExtra("date", jsonObject.getString(AssignTable.ASSIGNDATE))
            intent.putExtra("assignid", jsonObject.getString(AssignTable.ASSIGNID))
            startActivity(intent)
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    override fun callCustomer(position: Int) {
        try {
            val jsonObject = adapter!!.jsonArray.getJSONObject(position)
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.CALL_PHONE) !=
                    PackageManager.PERMISSION_GRANTED) {
                return
            }
            startActivity(Intent(Intent.ACTION_CALL, Uri.parse("tel:" + jsonObject.getString(FacilityTable.MOBILE))))
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    override fun openMap(position: Int) {
        try {
            val jsonObject = adapter!!.jsonArray.getJSONObject(position)
            val gmmIntentUri = Uri.parse("geo:" + jsonObject.getString(FacilityTable.LAT) + ","
                    + jsonObject.getString(FacilityTable.LON)
                    + "?q=" + jsonObject.getString(FacilityTable.LAT) + ","
                    + jsonObject.getString(FacilityTable.LON))
            val mapIntent = Intent(Intent.ACTION_VIEW, gmmIntentUri)
            mapIntent.setPackage("com.google.android.apps.maps")
            startActivity(mapIntent)
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

}