package com.b2lmobitech.fieldcloudplus.service.activities

import android.Manifest
import android.app.Activity
import android.app.DatePickerDialog
import android.app.TimePickerDialog
import android.content.Intent
import android.content.IntentSender.SendIntentException
import android.content.pm.PackageManager
import android.content.res.Resources
import android.gesture.GestureOverlayView
import android.graphics.Bitmap
import android.graphics.Color
import android.location.Address
import android.location.Geocoder
import android.location.Location
import android.net.Uri
import android.os.Bundle
import android.provider.MediaStore
import android.provider.OpenableColumns
import android.text.Editable
import android.text.InputFilter
import android.text.InputFilter.LengthFilter
import android.text.InputType
import android.text.TextWatcher
import android.util.Log
import android.view.*
import android.widget.*
import android.widget.AdapterView.OnItemSelectedListener
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.app.ActivityCompat
import androidx.core.content.FileProvider
import androidx.core.widget.NestedScrollView
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable
import com.b2lmobitech.fieldcloudplus.task.others.Preference
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.utils.toBase64String
import com.b2lmobitech.fieldcloudplus.utils.toBitmap
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import com.google.android.material.tabs.TabLayout
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.File
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.service.adapter.RankingAdapter
import com.b2lmobitech.fieldcloudplus.service.others.ApiService
import com.b2lmobitech.fieldcloudplus.service.others.FormAnswerManager
import com.b2lmobitech.fieldcloudplus.service.others.FormPreviewManager
import com.b2lmobitech.fieldcloudplus.service.others.UploadResponse
import com.b2lmobitech.fieldcloudplus.service.sql.DbSection
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormOptionsTable
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormQuestionsTable
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormResponsesTable
import com.bumptech.glide.Glide
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.MultipartBody
import okhttp3.RequestBody.Companion.toRequestBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.io.ByteArrayOutputStream
import kotlin.toString

class PreviewActivity : AppCompatActivity() {

    var mainLayout: LinearLayout? = null
    var nestedScrollView: NestedScrollView? = null
    var imageView: ImageView? = null
    var tabLayout: TabLayout? = null
    var masterJSON = JSONObject()
    var tempjosn: JSONObject? = null
    var imageUri: Uri? = null
    var cameraQuestionId: String? = null
    var mediaFile: File? = null
    var subcats: JSONArray = JSONArray()
    var id: String? = null
    var date: String? = null
    var cat: String? = null
    var assignid: String? = null
    var sectionKey: String ? = "General"
    var sectionID: String? = null
    var location_data: String? = null
    var latitude_data: String? = null
    var longitude_data: String? = null
    var currentFormId: String? = null
    var sectionList: MutableList<String> = mutableListOf()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_question)
        id = intent.getStringExtra("id")
        date = intent.getStringExtra("date")
        cat = intent.getStringExtra("cat")
        assignid = intent.getStringExtra("assignid")
        mainLayout = findViewById(R.id.mainLayout)
        nestedScrollView = findViewById(R.id.nestedScrollView)
        tabLayout = findViewById(R.id.tablayout)
        val toolbar = findViewById<Toolbar>(R.id.toolbar)
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = ""
        try {
            addTabs()
        } catch (e: JSONException) {
            e.printStackTrace()
        }
        findViewById<View>(R.id.btn_submit).setOnClickListener { submit() }
        val button = findViewById<Button>(R.id.btn_submit)
        button.text = "Submit"
    }

    @Throws(JSONException::class)
    private fun addTabs() {
        val database = ServiceDatabase.getInstance(this)
        subcats = database.getSubCategories(id, date, cat, assignid)
//        Log.e("subcats length","${subcats!!.length()}")
        val formId = subcats.getJSONObject(0).getString(QuestionTable.FORM_ID)

        currentFormId = formId

        // Fetch section IDs and names
        val sections: List<DbSection> = database.getSections(formId)

        // Fallback: if no sections, create a "General" section with null ID
        val finalSections: List<DbSection> =
            if (sections.isEmpty()) listOf(DbSection(null, "General")) else sections

        val responsesArray = JSONArray(database.getAnswersList(assignid, cat))
        for ((index, section) in finalSections.withIndex()) {
            val sectionObj = JSONObject()
            sectionObj.put("filled", true)

//            val responsesArray = JSONArray(database.getAnswersList(assignid, cat)) // outer array
//            Log.e("responseArray", "$responsesArray")
//            Log.d("responseArray","${responsesArray.length()}")

// Instead of looping through outer + inner blindly, directly collect from each "list"
            for (i in 0 until responsesArray.length()) {
                val resp = responsesArray.getJSONObject(i)

                // inner list contains the real answers
                val innerList = resp.getJSONArray("list")

                for (j in 0 until innerList.length()) {
                    val ans = innerList.getJSONObject(j)

                    val questionID = ans.getString("question_id")
                    val questionId = ans.getString("question_id")
                    val formId = ans.getString("form_id")
                    val optionText = ans.getString("answer")
                    val rowIndex = ans.getString("row_index")
                    val issue = ans.getString("issue")

                    // Get or create questionObj only for this questionId
                    val questionObj = sectionObj.optJSONObject(questionID) ?: JSONObject()

                    // Add new iteration index under this question
                    val nextIndex = (questionObj.length() + 1).toString()

                    val ansObj = JSONObject().apply {
                        put("form_id", formId)
                        put("question_id", questionId)
                        put("option_text", optionText)
                        put("row_index", rowIndex)
                        put("answered", true)
                        put("issue", issue)
                    }

                    if (questionID == ansObj.getString("question_id")) {
                        questionObj.put(nextIndex, ansObj)
                        sectionObj.put(questionID, questionObj)
                    }
                }
            }

            masterJSON.put(section.name, sectionObj)

            tabLayout!!.addTab(
                tabLayout!!.newTab().setText(section.name),
                index == 0
            )
            sectionList.add(section.name)
        }

        // Load questions for the first tab
        try {
            val firstSection = finalSections[0]
            getQuestions(formId, firstSection.id, firstSection.name) // pass ID (can be null for General)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        tabLayout!!.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
            override fun onTabSelected(tab: TabLayout.Tab) {
                try {
                    val section = finalSections[tab.position]
                    getQuestions(formId, section.id, section.name) // ID will decide which questions to load
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {}
            override fun onTabReselected(tab: TabLayout.Tab) {}
        })
    }

    @Throws(JSONException::class)
    private fun getQuestions(formId: String, sectionId: String?, sectionName: String?) {
        mainLayout!!.removeAllViews()
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val jsonArray = serviceDatabase.getQuestions(id, date, cat, assignid, sectionId)
        sectionKey = sectionName ?: "General"
        sectionID = sectionId ?: null
        for (i in 0 until jsonArray.length()) {
            val jsonObject = jsonArray.getJSONObject(i)
            val n = i + 1
            when (jsonObject.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).toLowerCase()) {
                "edittext", "integer", "single line text", "multiline text", "number", "boolean", "email", "phone", "decimal", "currency", "website", "slider", "linear scale", "net promoter score", "rating", "file upload" -> try {
                    addNonImageView(n, jsonObject)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
                "single choice", "multiple choice", "dropdown", "ranking" -> addChoiceView(n, jsonObject)
                "date", "time", "datetime", "monthyear" -> addDatetime(n, jsonObject)
                "image" -> addImageView(n, jsonObject)
                "unique", "random" -> addUniqueView(n, jsonObject)
                "single choice image", "multiple choice image", "signature" -> addChoiceImageView(n, jsonObject)
                "division video" -> addDivisionVideo(n, jsonObject)
                "division image" -> addDivisionImage(n, jsonObject)
                "division titledescription" -> addDivisionTitle(n, jsonObject)
                "single choice grid", "multiple choice grid" -> addGridView(n, jsonObject)
                "address", "first last name" -> addAddressView(n, jsonObject)
            }
        }
    }

    private fun showAlertDialog(jsonObject: JSONObject, answerView: View) {
//        Log.d("debug", "showAlertDialog called with type=${jsonObject.getString(FlexibleFormQuestionsTable.ANSWER_TYPE)}")
        try {
            when (jsonObject.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).toLowerCase()) {
                "edittext", "integer", "single line text", "multiline text", "number", "email", "phone", "decimal", "currency", "website" -> editText(jsonObject, answerView)
//                "dropdown" -> setSpinner(jsonObject, answerView)
                "signature" -> setSignatureAlert(jsonObject, answerView)
                "boolean" -> radioBox(jsonObject, answerView)
                "address" -> address(jsonObject, answerView)
                "single choice" -> singleChoiceAlert(jsonObject, answerView)
                "multiple choice" -> multipleChoiceAlert(jsonObject, answerView)
                "single choice grid" -> singleChoiceGridAlert(jsonObject, answerView)
                "multiple choice grid" -> multipleChoiceGridAlert(jsonObject, answerView)
                "single choice image" -> singleChoiceImageAlert(jsonObject, answerView)
                "multiple choice image" -> multipleChoiceImageAlert(jsonObject, answerView)
                "ranking" -> rankingQuestionAlert(jsonObject, answerView)
                "rating" -> ratingQuestionAlert(jsonObject, answerView)
                "net promoter score" -> netPromoterScoreAlert(jsonObject, answerView)
                "linear scale" -> linearScaleAlert(jsonObject, answerView)
                "slider" -> sliderQuestionAlert(jsonObject, answerView)
                "dropdown" -> dropDownAlert(jsonObject, answerView)
                "first last name" -> fullName(jsonObject, answerView)
                "file upload" ->setFileUploadAlert(jsonObject, answerView)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    @Throws(JSONException::class)
    private fun datetime(json: JSONObject, textView: TextView) {
        try {
            if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("date", ignoreCase = true)) {
                setDatePicker(textView, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("datetime", ignoreCase = true)) {
                setDateTimePicker(textView, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("time", ignoreCase = true)) {
                setTimePicker(textView, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("monthyear", ignoreCase = true)) {
                setMonthYearPicker(textView, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            }
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

//    private fun setDatePicker(textView: TextView, questionId: String) {
//        val myCalendar = Calendar.getInstance()
//        val listenr = OnDateSetListener { view, year, monthOfYear, dayOfMonth -> // TODO Auto-generated method stub
//            myCalendar[Calendar.YEAR] = year
//            myCalendar[Calendar.MONTH] = monthOfYear
//            myCalendar[Calendar.DAY_OF_MONTH] = dayOfMonth
//            val myFormat = "dd/MM/yyyy" //In which you need put here
//            var sdf = SimpleDateFormat(myFormat, Locale.US)
//            sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
//            textView.text = sdf.format(myCalendar.time)
//            val answerJson = JSONObject()
//            try {
//                answerJson.put("answered", true)
//                answerJson.put("answer", sdf.format(myCalendar.time))
//                answerJson.put("issue", "no")
//                answerJson.put("remarks", "")
//                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
//            } catch (e: JSONException) {
//                e.printStackTrace()
//            }
//        }
//        val datePicker = DatePickerDialog(this, listenr, myCalendar[Calendar.YEAR], myCalendar[Calendar.MONTH],
//                myCalendar[Calendar.DAY_OF_MONTH])
//        datePicker.show()
//    }
//
//    private fun setTimePicker(textView: TextView, questionId: String) {
//        val myCalendar = Calendar.getInstance()
//        val hour = myCalendar[Calendar.HOUR_OF_DAY]
//        val minute = myCalendar[Calendar.MINUTE]
//        val listenr = OnTimeSetListener { view, hourOfDay, minute ->
//            myCalendar[Calendar.HOUR] = hourOfDay
//            myCalendar[Calendar.MINUTE] = minute
//            val myFormat = "HH:mm:ss" //In which you need put here
//            val sdf = SimpleDateFormat(myFormat, Locale.getDefault())
//            textView.text = sdf.format(myCalendar.time)
//            val answerJson = JSONObject()
//            try {
//                answerJson.put("answered", true)
//                answerJson.put("answer", sdf.format(myCalendar.time))
//                answerJson.put("issue", "no")
//                answerJson.put("remarks", "")
//                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
//            } catch (e: JSONException) {
//                e.printStackTrace()
//            }
//        }
//        val timePickerDialog = TimePickerDialog(this, listenr, hour, minute, true)
//        timePickerDialog.show()
//    }
//
//    private fun setDateTimePicker(textView: TextView, questionId: String) {
//        val myCalendar = Calendar.getInstance()
//        val hour = myCalendar[Calendar.HOUR_OF_DAY]
//        val minute = myCalendar[Calendar.MINUTE]
//        val listenr2 = OnTimeSetListener { view, hourOfDay, minute ->
//            myCalendar[Calendar.HOUR] = hourOfDay
//            myCalendar[Calendar.MINUTE] = minute
//            val myFormat = "yyyy-MM-dd HH:mm:ss"
//            val sdf = SimpleDateFormat(myFormat, Locale.getDefault())
//            textView.text = sdf.format(myCalendar.time)
//            val answerJson = JSONObject()
//            try {
//                answerJson.put("answered", true)
//                answerJson.put("answer", sdf.format(myCalendar.time))
//                answerJson.put("issue", "no")
//                answerJson.put("remarks", "")
//                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
//                getQuestions("",sectionID, sectionKey)
//            } catch (e: JSONException) {
//                e.printStackTrace()
//            }
//        }
//        val timePickerDialog = TimePickerDialog(this, listenr2, hour, minute, true)
//        val listenr = OnDateSetListener { view, year, monthOfYear, dayOfMonth -> // TODO Auto-generated method stub
//            myCalendar[Calendar.YEAR] = year
//            myCalendar[Calendar.MONTH] = monthOfYear
//            myCalendar[Calendar.DAY_OF_MONTH] = dayOfMonth
//            timePickerDialog.show()
//        }
//        val datePicker = DatePickerDialog(this, listenr, myCalendar[Calendar.YEAR], myCalendar[Calendar.MONTH],
//                myCalendar[Calendar.DAY_OF_MONTH])
//        datePicker.show()
//    }
    // ----------------- DATE PICKER -----------------
    private fun setDatePicker(textView: TextView, questionId: String) {
        val myCalendar = Calendar.getInstance()

        // Preselect saved value if exists
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val savedDate = sectionObj?.optJSONObject(questionId)?.optJSONObject("1")?.optString("option_text", null)
        if (!savedDate.isNullOrEmpty()) {
            val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
            myCalendar.time = sdf.parse(savedDate) ?: Date()
            textView.text = savedDate
        }

        val listener = DatePickerDialog.OnDateSetListener { _, year, month, dayOfMonth ->
            myCalendar.set(year, month, dayOfMonth)
            val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
            val formatted = sdf.format(myCalendar.time)
            textView.text = formatted

            // Save safely in masterJSON
            if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
            val answerObj = JSONObject()
            val answerJson = JSONObject().apply {
                put("answered", true)
                put("option_text", formatted)
                put("row_index", "0")
                put("issue", "no")
                put("remarks", "")
            }
            answerObj.put("1",answerJson)
            masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)
        }

        val datePicker = DatePickerDialog(
            this,
            listener,
            myCalendar.get(Calendar.YEAR),
            myCalendar.get(Calendar.MONTH),
            myCalendar.get(Calendar.DAY_OF_MONTH)
        )
        datePicker.show()
    }

    // ----------------- TIME PICKER -----------------
    private fun setTimePicker(textView: TextView, questionId: String) {
        val myCalendar = Calendar.getInstance()

        // Preselect saved value if exists
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val savedTime = sectionObj?.optJSONObject(questionId)?.optJSONObject("1")?.optString("option_text", null)
        if (!savedTime.isNullOrEmpty()) {
            val sdf = SimpleDateFormat("HH:mm:ss", Locale.getDefault())
            myCalendar.time = sdf.parse(savedTime) ?: Date()
            textView.text = savedTime
        }

        val listener = TimePickerDialog.OnTimeSetListener { _, hourOfDay, minute ->
            myCalendar.set(Calendar.HOUR_OF_DAY, hourOfDay)
            myCalendar.set(Calendar.MINUTE, minute)
            val sdf = SimpleDateFormat("HH:mm:ss", Locale.getDefault())
            val formatted = sdf.format(myCalendar.time)
            textView.text = formatted

            // Save safely in masterJSON
            if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
            val answerObj = JSONObject()
            val answerJson = JSONObject().apply {
                put("answered", true)
                put("option_text", formatted)
                put("row_index", "0")
                put("issue", "no")
                put("remarks", "")
            }
            answerObj.put("1",answerJson)
            masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)
        }

        val timePickerDialog = TimePickerDialog(
            this,
            listener,
            myCalendar.get(Calendar.HOUR_OF_DAY),
            myCalendar.get(Calendar.MINUTE),
            true
        )
        timePickerDialog.show()
    }

    // ----------------- DATE & TIME PICKER -----------------
    private fun setDateTimePicker(textView: TextView, questionId: String) {
        val myCalendar = Calendar.getInstance()

        // Preselect saved value if exists
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val savedDateTime = sectionObj?.optJSONObject(questionId)?.optJSONObject("1")?.optString("option_text", null)
        if (!savedDateTime.isNullOrEmpty()) {
            val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
            myCalendar.time = sdf.parse(savedDateTime) ?: Date()
            textView.text = savedDateTime
        }

        // Step 1: Date picker
        val dateListener = DatePickerDialog.OnDateSetListener { _, year, month, dayOfMonth ->
            myCalendar.set(year, month, dayOfMonth)

            // Step 2: Time picker
            val timeListener = TimePickerDialog.OnTimeSetListener { _, hourOfDay, minute ->
                myCalendar.set(Calendar.HOUR_OF_DAY, hourOfDay)
                myCalendar.set(Calendar.MINUTE, minute)
                val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
                val formatted = sdf.format(myCalendar.time)
                textView.text = formatted

                // Save safely in masterJSON
                if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
                val answerObj = JSONObject()
                val answerJson = JSONObject().apply {
                    put("answered", true)
                    put("option_text", formatted)
                    put("row_index", "0")
                    put("issue", "no")
                    put("remarks", "")
                }
                answerObj.put("1",answerJson)
                masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)
            }

            TimePickerDialog(
                this,
                timeListener,
                myCalendar.get(Calendar.HOUR_OF_DAY),
                myCalendar.get(Calendar.MINUTE),
                true
            ).show()
        }

        DatePickerDialog(
            this,
            dateListener,
            myCalendar.get(Calendar.YEAR),
            myCalendar.get(Calendar.MONTH),
            myCalendar.get(Calendar.DAY_OF_MONTH)
        ).show()
    }

    private fun setMonthYearPicker(textView: TextView, questionId: String) {
        val myCalendar = Calendar.getInstance()

        // ---------------- Preselect saved value ----------------
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val savedValue = sectionObj?.optJSONObject(questionId)?.optJSONObject("1")?.optString("option_text", null)
        if (!savedValue.isNullOrEmpty()) {
            textView.text = savedValue
            // Try to parse saved month-year into calendar
            try {
                val sdf = SimpleDateFormat("MMMM, yyyy", Locale.getDefault())
                myCalendar.time = sdf.parse(savedValue) ?: Date()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        // ---------------- DatePicker for Month-Year ----------------
        val datePicker = DatePickerDialog(
            this,
            { _, year, month, _ ->
                val monthName = SimpleDateFormat("MMMM", Locale.getDefault())
                    .format(GregorianCalendar(year, month, 1).time)
                val formatted = "$monthName, $year"
                textView.text = formatted

                // Save safely in masterJSON
                if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
                val answerObj = JSONObject()
                val answerJson = JSONObject().apply {
                    put("answered", true)
                    put("option_text", formatted)
                    put("row_index", "0")
                    put("issue", "no")
                    put("remarks", "")
                }
                answerObj.put("1",answerJson)
                masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)
            },
            myCalendar.get(Calendar.YEAR),
            myCalendar.get(Calendar.MONTH),
            myCalendar.get(Calendar.DAY_OF_MONTH)
        )

        // Hide day field (works on most devices)
        try {
            val daySpinnerId = Resources.getSystem().getIdentifier("day", "id", "android")
            val daySpinner = datePicker.datePicker.findViewById<View>(daySpinnerId)
            daySpinner?.visibility = View.GONE
        } catch (e: Exception) {
            e.printStackTrace()
        }

        datePicker.show()
    }

//    @Throws(JSONException::class)
//    private fun setSignature(json: JSONObject, answerView: View) {
//        val view = layoutInflater!!.inflate(R.layout.model_signature, mainLayout, false)
//        val title = view.findViewById<TextView>(R.id.text_title)
//        title.text = String.format("%s.%s", json.getString(QuestionTable.NUMBER), json.getString(QuestionTable.QUESTION))
//        val gues = view.findViewById<GestureOverlayView>(R.id.signaturePad)
//        val clearButton = view.findViewById<Button>(R.id.clear_sign)
//        clearButton.setOnClickListener { gues.clear(true) }
//        gues.isDrawingCacheEnabled = true
//        gues.setOnTouchListener { v, event ->
//            nestedScrollView!!.requestDisallowInterceptTouchEvent(true) //very important
//            false
//        }
//        gues.addOnGestureListener(object : GestureOverlayView.OnGestureListener {
//            override fun onGestureStarted(overlay: GestureOverlayView, event: MotionEvent) {}
//            override fun onGesture(overlay: GestureOverlayView, event: MotionEvent) {}
//            override fun onGestureEnded(overlay: GestureOverlayView, event: MotionEvent) {
//                if (overlay.drawingCache != null) {
//                    try {
//                        tempjosn = JSONObject()
//                        tempjosn!!.put("answer", Utility.imgToString(overlay.drawingCache))
//                        tempjosn!!.put("answered", true)
//                        tempjosn!!.put("issue", "no")
//                        tempjosn!!.put("remarks", "")
//                    } catch (e: JSONException) {
//                        e.printStackTrace()
//                    }
//                }
//            }
//
//            override fun onGestureCancelled(overlay: GestureOverlayView, event: MotionEvent) {}
//        })
//        setAlertListeners(json, view, answerView)
//    }

    @Throws(JSONException::class)
    private fun setSignatureAlert(
        json: JSONObject,
        answerView: View
    ) {
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Inflate signature layout
        val contentView = layoutInflater.inflate(R.layout.model_signature, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val filename = contentView.findViewById<TextView>(R.id.uploaded_files_text)
        val signaturePad = contentView.findViewById<GestureOverlayView>(R.id.signaturePad)
        val clearBtn = contentView.findViewById<Button>(R.id.clear_sign)
        val saveButton = contentView.findViewById<Button>(R.id.save_sign)

        title.text = String.format(
            "%s. %s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        clearBtn.setOnClickListener { signaturePad.clear(true) }

        // Wrap inside dialog
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Save button (register listener immediately)
        saveButton.setOnClickListener {
            if (signaturePad.isGestureVisible) {
                signaturePad.isDrawingCacheEnabled = true
                signaturePad.buildDrawingCache()
                val bitmap = Bitmap.createBitmap(signaturePad.drawingCache)
                signaturePad.isDrawingCacheEnabled = false
//                Log.d("signature","saveButton clicked")

                dialogView.findViewById<Button>(R.id.model_cancel).visibility = View.GONE

                uploadSignatureToServer(
                    bitmap,
                    assignid.toString(),
                    questionId,
                    sectionKey.toString(),
                    filename,
                    answerView
                )
            } else {
                Toast.makeText(this, "Please draw a signature first", Toast.LENGTH_SHORT).show()
            }
        }

        // Submit button just dismisses after saving
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (!signaturePad.isGestureVisible) {
                Toast.makeText(this, "Please provide signature", Toast.LENGTH_SHORT).show()
            } else {
                alertDialog.dismiss()
            }
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    private fun uploadSignatureToServer(
        bitmap: Bitmap,
        assignId: String,
        questionId: String,
        sectionKey: String,
        uploadedFilesText: TextView?,
        answerView: View
    ) {
//        Log.d("signature","here")
        val retrofit = Retrofit.Builder()
            .baseUrl("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/") // XAMPP local server
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        val service = retrofit.create(ApiService::class.java)

        // Convert bitmap -> bytes -> RequestBody
        val baos = ByteArrayOutputStream()
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos)
        val imageBytes = baos.toByteArray()
        val fileName = "signature_${questionId}_${assignId}_${System.currentTimeMillis()}.png"
        val requestBody = imageBytes.toRequestBody("multipart/form-data".toMediaTypeOrNull())
        val filePart = MultipartBody.Part.createFormData("signature", fileName, requestBody)

        // Extra form fields
        val assignPart = MultipartBody.Part.createFormData("assignid", assignId)
        val questionPart = MultipartBody.Part.createFormData("questionid", questionId)

        val allParts = mutableListOf<MultipartBody.Part>().apply {
            add(assignPart)
            add(questionPart)
            add(filePart)
        }

        service.uploadSignature(allParts).enqueue(object : Callback<List<UploadResponse>> {
            override fun onResponse(
                call: Call<List<UploadResponse>>,
                response: Response<List<UploadResponse>>
            ) {
                if (response.isSuccessful) {
                    val uploaded = response.body() ?: emptyList()
                    val questionObj = JSONObject()

                    uploaded.forEach {
                        if (it.status == "success") {
                            val answerJson = JSONObject().apply {
                                put("answered", true)
                                put("option_text", it.file) // JSON array of file paths
                                put("row_index", "0")
                                put("issue", "no")
                                put("remarks", "")
                            }
                            questionObj.put("1", answerJson)
                        }
                    }

//                    Log.d("uploadsignaturetoserver","${questionObj.optJSONObject("1").getString("option_text")}")

                    if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
                    masterJSON.getJSONObject(sectionKey).put(questionId, questionObj)
//                    Log.e("masterjson", "$masterJSON")
                    FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)

                    val shortFileName = fileName.substringAfterLast("_0_")

                    uploadedFilesText?.text = shortFileName

                    if (answerView is ImageView) {
                        val fileUrl = questionObj.optJSONObject("1")?.optString("option_text", "")
                        if (!fileUrl.isNullOrEmpty()) {
                            Glide.with(this@PreviewActivity)
                                .load("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/$fileUrl")
                                .into(answerView)
                        }
                    }
                } else {
                    Toast.makeText(
                        this@PreviewActivity,
                        "Upload failed: ${response.code()}",
                        Toast.LENGTH_SHORT
                    ).show()
                }
            }

            override fun onFailure(call: Call<List<UploadResponse>>, t: Throwable) {
                Toast.makeText(
                    this@PreviewActivity,
                    "Upload error: ${t.message}",
                    Toast.LENGTH_SHORT
                ).show()
            }
        })
    }

    private val FILE_UPLOAD_REQUEST_CODE = 2001
    private var selectedFiles = mutableListOf<Uri>()
    private var allowedTypes = listOf<String>()
    private var maxFiles = 1
    private var maxSizeMB = 5
    private val fileTypeMappings = mapOf(
        "image" to listOf("jpg", "jpeg", "png", "gif", "bmp", "webp"),
        "document" to listOf("doc", "docx", "odt", "txt"),
        "spreadsheet" to listOf("xls", "xlsx", "csv", "ods"),
        "pdf" to listOf("pdf"),
        "video" to listOf("mp4", "avi", "mov", "wmv", "flv"),
        "presentation" to listOf("ppt", "pptx", "odp")
    )
    private var currentQuestionId: String? = null
    private var currentUploadedFilesText: TextView? = null
    private lateinit var currentUploadFileView: View

    private fun getFileName(uri: Uri): String {
        var name = ""
        contentResolver.query(uri, null, null, null, null)?.use { cursor ->
            val nameIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME)
            if (cursor.moveToFirst()) {
                name = cursor.getString(nameIndex)
            }
        }
        return name
    }

    private fun getFileSizeMB(uri: Uri): Int {
        var size = 0L
        contentResolver.query(uri, null, null, null, null)?.use { cursor ->
            val sizeIndex = cursor.getColumnIndex(OpenableColumns.SIZE)
            if (cursor.moveToFirst()) {
                size = cursor.getLong(sizeIndex)
            }
        }
        return (size / (1024 * 1024)).toInt()
    }

    @Throws(JSONException::class)
    private fun setFileUploadAlert(
        json: JSONObject,
        answerView: View
    ) {
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Inflate file upload layout
        val contentView = layoutInflater.inflate(R.layout.model_fileupload, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val uploadButton = contentView.findViewById<Button>(R.id.upload_button)
        val uploadedFilesText = contentView.findViewById<TextView>(R.id.uploaded_files_text)

        title.text = String.format(
            "%s. %s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        // Parse options (file-types, max-files, file-size)
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == questionId) {
                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE).lowercase()) {
                    "file-types" -> {
                        val raw = option.getString(FlexibleFormOptionsTable.OPTION_TEXT).split(",")
                            .map { it.trim().lowercase() }
                        allowedTypes = raw.flatMap { type -> fileTypeMappings[type] ?: listOf(type) }
                    }
                    "max-files" -> maxFiles =
                        option.getString(FlexibleFormOptionsTable.OPTION_TEXT).toIntOrNull() ?: 1
                    "file-size" -> maxSizeMB =
                        option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                            .replace("MB", "", true).toIntOrNull() ?: 5
                }
            }
        }

        // Wrap inside dialog
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Upload button → open file picker
        uploadButton.setOnClickListener {
            currentQuestionId = questionId
            currentUploadedFilesText = uploadedFilesText
            currentUploadFileView = answerView
            val intent = Intent(Intent.ACTION_GET_CONTENT).apply {
                type = "*/*"
                putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true)
            }
            startActivityForResult(intent, FILE_UPLOAD_REQUEST_CODE)
        }

        // Submit button → dismiss
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (uploadedFilesText.text.isNullOrEmpty()) {
                Toast.makeText(this, "Please upload at least one file", Toast.LENGTH_SHORT).show()
            } else {
                // Update answerView preview
                if (answerView is TextView) {
                    answerView.text = uploadedFilesText.text.toString()
                }
                alertDialog.dismiss()
            }
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    private fun uploadFilesToServer(files: List<Uri>, assignId: String, questionId: String, sectionKey: String, uploadedFilesText: TextView?, answerView: View) {
        val retrofit = Retrofit.Builder()
            .baseUrl("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/")
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        val service = retrofit.create(ApiService::class.java)

        val parts = files.map { uri ->
            val inputStream = contentResolver.openInputStream(uri)!!
            val fileName = getFileName(uri)
            val requestBody = inputStream.readBytes().toRequestBody("multipart/form-data".toMediaTypeOrNull())
            MultipartBody.Part.createFormData("files[]", fileName, requestBody)
        }

        val assignPart = MultipartBody.Part.createFormData("assignid", assignId)
        val questionPart = MultipartBody.Part.createFormData("questionid", questionId)

        val allParts = mutableListOf<MultipartBody.Part>()
        allParts.add(assignPart)
        allParts.add(questionPart)
        allParts.addAll(parts)

        service.uploadFiles(allParts).enqueue(object : Callback<List<UploadResponse>> {
            override fun onResponse(call: Call<List<UploadResponse>>, response: Response<List<UploadResponse>>) {
                if (response.isSuccessful) {
                    val uploaded = response.body() ?: emptyList()
                    val questionObj = JSONObject()

                    uploaded.forEach {
                        if (it.status == "success") {
                            val answerJson = JSONObject().apply {
                                put("answered", true)
                                put("option_text", it.file.toString()) // JSON array of file paths
                                put("row_index", "0")
                                put("issue", "no")
                                put("remarks", "")
                            }
                            questionObj.put("1", answerJson)
                        }
                    }


//                    val sectionJson = masterJSON.optJSONObject(sectionKey) ?: JSONObject().also {
//                        masterJSON.put(sectionKey, it)
//                    }
//                    sectionJson.put(questionId, questionObj)
//                    Log.d("uploadfilestoserver","${questionObj.optJSONObject("1").getString("option_text")}")

                    if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
                    masterJSON.getJSONObject(sectionKey).put(questionId, questionObj)
//                    Log.e("masterjson", "$masterJSON")
                    FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)

                    uploadedFilesText?.text = files.joinToString("\n") { getFileName(it) }
                    if (answerView is TextView) {
                        answerView.text = files.joinToString("\n") { getFileName(it) }
                    }
                } else {
                    Toast.makeText(this@PreviewActivity, "Upload failed: ${response.code()} ${response.message()}", Toast.LENGTH_SHORT).show()
                }
            }

            override fun onFailure(call: Call<List<UploadResponse>>, t: Throwable) {
                Toast.makeText(this@PreviewActivity, "Upload error: ${t.message}", Toast.LENGTH_SHORT).show()
            }
        })
    }

    @Throws(JSONException::class)
    private fun setSpinner(json: JSONObject, answerView: View) {

        val view = LayoutInflater.from(this).inflate(R.layout.model_spinner, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val S_Remarks = view.findViewById<EditText>(R.id.S_Remarks)
        val bu_s_remarks = view.findViewById<ImageView>(R.id.bu_s_remarks)
        S_Remarks.visibility = View.VISIBLE
        S_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
        val spinner = view.findViewById<Spinner>(R.id.spinner)
        title.text = String.format("%s.%s", json.getString(QuestionTable.NUMBER), json.getString(QuestionTable.QUESTION))
        val options = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()
        val arrayList = ArrayList<String>()
        for (anOptions2 in options) {
            if (anOptions2.isEmpty()) {
                arrayList.add("Select")
            } else {
                arrayList.add(anOptions2)
            }
        }

        val spinnerArrayAdapter: ArrayAdapter<String> = object : ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, arrayList) {
            override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
                val mView = super.getDropDownView(position, convertView, parent)
                val mTextView = mView as TextView
                if (position == 0) {
                    mTextView.setTextColor(Color.GRAY)
                } else {
                    mTextView.setTextColor(Color.BLACK)
                }
                return mView
            }

            override fun isEnabled(position: Int): Boolean {
                return position != 0
            }
        } //selected item will look like a spinner set from XML

        spinnerArrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        spinner.adapter = spinnerArrayAdapter
               tempjosn = JSONObject()
//        if(S_Remarks.text==null)
//        {
//            tempjosn!!.put("remarks", "")
//        }
//        else {
//            tempjosn!!.put("remarks", S_Remarks.text.toString())
//        }
        S_Remarks.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                if (s.length >= 500)
                {
                    Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                }
            }
            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                if (s.length >= 500)
                {
                    Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                }
            }
            override fun afterTextChanged(s: Editable) {
                try {

                    tempjosn!!.put("remarks", s.toString())
//                    if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getBoolean("answered")) {
                        masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).put("remarks",s.toString())

//                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        })
        var check:Int = 0
        spinner.onItemSelectedListener = object : OnItemSelectedListener {
            override fun onItemSelected(adapterView: AdapterView<*>?, view: View, i: Int, l: Long) {
                if (++check > 1) {
                    S_Remarks.addTextChangedListener(object : TextWatcher {
                        override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                            if (s.length >= 500)
                            {
                                Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                            }
                        }
                        override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                            if (s.length >= 500)
                            {
                                Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                            }
                        }
                        override fun afterTextChanged(s: Editable) {
                            try {

                                tempjosn!!.put("remarks", s.toString())
//                                if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getBoolean("answered")) {
                                    masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).put("remarks",s.toString())
//                                }
                            } catch (e: JSONException) {
                                e.printStackTrace()
                            }
                        }
                    })
                    try {
                        tempjosn!!.put("answer", options[i])
                        if (json.getInt(QuestionTable.CORRECTANSER) == i + 1) {
                            tempjosn!!.put("issue", "no")
                        } else {
                            tempjosn!!.put("issue", "yes")
                        }
//                    tempjosn!!.put("remarks", "")
                        tempjosn!!.put("answered", true)
                        if(S_Remarks.text==null)
        {
            tempjosn!!.put("remarks", "")
        }
        else {
            tempjosn!!.put("remarks", S_Remarks.text.toString())
        }
                        masterJSON.getJSONObject(subCat())
                            .put(json.getString(QuestionTable.NUMBER), tempjosn)
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }

            override fun onNothingSelected(adapterView: AdapterView<*>?) {}
        }
        for (i in options.indices) {
            if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("answer").equals(options[i], ignoreCase = true)) {
                spinner.setSelection(i)
                S_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
                tempjosn!!.put("answer", options[i])
                if (json.getInt(QuestionTable.CORRECTANSER) == i + 1) {
                    tempjosn!!.put("correct", true)
                } else {
                    tempjosn!!.put("correct", false)
                }
                tempjosn!!.put("answered", true)
                tempjosn!!.put("remarks", masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
            }
        }
        setAlertListeners(json, view, answerView)
    }

    @Throws(JSONException::class)
    private fun radioBox(json: JSONObject, answerView: View) {
        val view = layoutInflater!!.inflate(R.layout.model_radiobox, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.cb_title)
        val R_Remarks = view.findViewById<EditText>(R.id.R_Remarks)
        val bu_r_remarks = view.findViewById<ImageView>(R.id.bu_r_remarks)
        R_Remarks.visibility = View.VISIBLE
        R_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
        title.text = String.format("%s.%s", json.getString(QuestionTable.NUMBER), json.getString(QuestionTable.QUESTION))
        val radioGroup = view.findViewById<RadioGroup>(R.id.radio_group)
        val options2 = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()
        val arrayList = ArrayList<String>()
        for (anOptions2 in options2) {
            if (!anOptions2.isEmpty()) {
                arrayList.add(anOptions2)
            }
        }
        for (i in arrayList.indices) {
            val radioButton = RadioButton(this)
            radioButton.text = arrayList[i]
            radioButton.gravity = Gravity.CENTER_VERTICAL
              tempjosn = JSONObject()
//            if(R_Remarks.text==null)
//            {
//                tempjosn!!.put("remarks", "")
//            }
//            else {
//                tempjosn!!.put("remarks", R_Remarks.text.toString())
//            }
            R_Remarks.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun afterTextChanged(s: Editable) {
                    try {

                        tempjosn!!.put("remarks", s.toString())
//                        if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getBoolean("answered")) {
                            masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).put("remarks",s.toString())
//                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            })
            radioButton.setOnClickListener{
            R_Remarks.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun afterTextChanged(s: Editable) {
                    try {

                        tempjosn!!.put("remarks", s.toString())
//                        if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getBoolean("answered")) {
                            masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).put("remarks",s.toString())
//                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            })
                try {
//                    tempjosn = JSONObject()
                    tempjosn!!.put("answer", arrayList[i])
                    if (json.getInt(QuestionTable.CORRECTANSER) == i + 1) {
                        tempjosn!!.put("issue", "no")
                    } else {
                        tempjosn!!.put("issue", "yes")
                    }

                    tempjosn!!.put("answered", true)
//                    answerJson.put("remarks", R_Remarks.text.toString())
                        if(R_Remarks.text==null)
                        {
                            tempjosn!!.put("remarks", "")
                        }
                        else {
                            tempjosn!!.put("remarks", R_Remarks.text.toString())
                        }
                    masterJSON.put(subCat(), masterJSON.getJSONObject(subCat()).put(json.getString(QuestionTable.NUMBER), tempjosn))
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
            radioGroup.addView(radioButton)
            if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("answer").equals(arrayList[i], ignoreCase = true)) {
                radioButton.isChecked = true
                R_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
                 tempjosn = JSONObject()
                tempjosn!!.put("answer", arrayList[i])
                if (json.getInt(QuestionTable.CORRECTANSER) == i) {
                    tempjosn!!.put("correct", true)
                } else {
                    tempjosn!!.put("correct", false)
                }
                tempjosn!!.put("answered", true)
                tempjosn!!.put("remarks", masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(QuestionTable.NUMBER)).getString("remarks"))
            }
        }
        setAlertListeners(json, view, answerView)
    }

    @Throws(JSONException::class)
    private fun editText(json: JSONObject, answerView: View) {
        val view = layoutInflater!!.inflate(R.layout.model_edittext, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val editText = view.findViewById<EditText>(R.id.text_input)
        title.text = String.format("%s.%s", json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), json.getString(
            FlexibleFormQuestionsTable.QUESTION_TEXT))
        if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("edittext", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("integer", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("single line text", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("multiline text", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_TEXT_FLAG_MULTI_LINE
            editText.hint = "Multiple Lines"
            editText.setSingleLine(false)
            editText.minLines = 2
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("email", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS or InputType.TYPE_CLASS_TEXT
            editText.hint = "Email"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("number", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
            editText.hint = "Number"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("phone", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_PHONE
            editText.hint = "Phone"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("decimal", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_NUMBER_FLAG_DECIMAL or InputType.TYPE_CLASS_NUMBER
            editText.hint = "Decimal"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("currency", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
            editText.hint = "Currency ₹"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("website", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
            editText.hint = "Website link"
        }
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        val section = masterJSON.getJSONObject(sectionKey)
        val questionObj = section.getJSONObject(questionId).getJSONObject("1")
        editText.setText(questionObj.optString("option_text", ""))
        val filter = arrayOfNulls<InputFilter>(1)
        filter[0] = LengthFilter(200)
        editText.filters = filter
        editText.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}
            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {}
            override fun afterTextChanged(s: Editable) {
                try {
                    questionObj.put("option_text", s.toString())
                    questionObj.put("answered", s.isNotEmpty())
                    questionObj.put("issue", "no")
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        })
        FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)
        setAlertListeners(json, view, answerView)
    }

    private fun setAlertListeners(json: JSONObject, view: View, answerView: View) {
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null, false)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(view)

        val alertDialog = AlertDialog.Builder(this)
            .setView(dialogView)
            .setCancelable(false)
            .create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            try {
                val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
                val section = masterJSON.getJSONObject(sectionKey)
                val questionObj = section.getJSONObject(questionId).getJSONObject("1")
                val answer = questionObj.optString("option_text", "")
                if (answer.isNotEmpty() && answerView is TextView) {
                    answerView.text = answer
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun fullName(json: JSONObject, answerView: View) {
        // Inflate dialog layout
        val view = layoutInflater!!.inflate(R.layout.model_fullname, null, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        title.text = "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        val questionObj = masterJSON.getJSONObject(sectionKey).getJSONObject(questionId)

        val editTexts = listOf(
            view.findViewById<EditText>(R.id.text_input7),
            view.findViewById<EditText>(R.id.text_input8)
        )

        val hints = listOf("First Name", "Last Name")
        for (i in editTexts.indices) {
            val lineObj = questionObj.optJSONObject("${i + 1}") ?: JSONObject().apply { questionObj.put("${i + 1}", this) }
            editTexts[i].hint = hints[i]
            editTexts[i].setText(lineObj.optString("option_text", ""))
            editTexts[i].filters = arrayOf(InputFilter.LengthFilter(200))

            editTexts[i].addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}
                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {}
                override fun afterTextChanged(s: Editable?) {
                    lineObj.put("option_text", s.toString())
                    lineObj.put("row_index", i.toString())
                    lineObj.put("answered", s?.isNotEmpty() == true)
                    lineObj.put("issue", "no")
                    lineObj.put("remarks", "")
                }
            })
        }
        FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)

        setNameListeners(json, view, answerView)
    }

    private fun setNameListeners(json: JSONObject, view: View, answerView: View) {
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null, false)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(view)

        val alertDialog = AlertDialog.Builder(this)
            .setView(dialogView)
            .setCancelable(false)
            .create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            try {
                val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
                val questionObj = masterJSON.getJSONObject(sectionKey).getJSONObject(questionId)

                val addressLines = (1..2).map { i ->
                    questionObj.optJSONObject("$i")?.optString("option_text", "") ?: ""
                }.filter { it.isNotEmpty() }

                if (answerView is TextView) {
                    answerView.text = addressLines.joinToString(", ")
                }

            } catch (e: JSONException) {
                e.printStackTrace()
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun address(json: JSONObject, answerView: View) {
        // Inflate dialog layout
        val view = layoutInflater!!.inflate(R.layout.model_addresstext, null, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        title.text = "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        val questionObj = masterJSON.getJSONObject(sectionKey).getJSONObject(questionId)

        val editTexts = listOf(
            view.findViewById<EditText>(R.id.text_input1),
            view.findViewById<EditText>(R.id.text_input2),
            view.findViewById<EditText>(R.id.text_input3),
            view.findViewById<EditText>(R.id.text_input4),
            view.findViewById<EditText>(R.id.text_input5),
            view.findViewById<EditText>(R.id.text_input6)
        )

        val hints = listOf("Address Line 1", "Address Line 2", "City", "State", "Country", "Pincode")
        for (i in editTexts.indices) {
            val lineObj = questionObj.optJSONObject("${i + 1}") ?: JSONObject().apply { questionObj.put("${i + 1}", this) }
            editTexts[i].hint = hints[i]
            editTexts[i].setText(lineObj.optString("option_text", ""))
            editTexts[i].filters = arrayOf(InputFilter.LengthFilter(200))

            editTexts[i].addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}
                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {}
                override fun afterTextChanged(s: Editable?) {
                    lineObj.put("option_text", s.toString())
                    lineObj.put("row_index", i.toString())
                    lineObj.put("answered", s?.isNotEmpty() == true)
                    lineObj.put("issue", "no")
                    lineObj.put("remarks", "")
                }
            })
        }
        FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)

        setAddressListeners(json, view, answerView)
    }

    private fun setAddressListeners(json: JSONObject, view: View, answerView: View) {
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null, false)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(view)

        val alertDialog = AlertDialog.Builder(this)
            .setView(dialogView)
            .setCancelable(false)
            .create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            try {
                val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
                val questionObj = masterJSON.getJSONObject(sectionKey).getJSONObject(questionId)

                val addressLines = (1..6).map { i ->
                    questionObj.optJSONObject("$i")?.optString("option_text", "") ?: ""
                }.filter { it.isNotEmpty() }

                if (answerView is TextView) {
                    answerView.text = addressLines.joinToString(", ")
                }

            } catch (e: JSONException) {
                e.printStackTrace()
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    private var alertDialog: AlertDialog? = null
    override fun onDestroy() {
        alertDialog?.dismiss()
        super.onDestroy()
    }

    private fun singleChoiceAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate layout
        val view = layoutInflater!!.inflate(R.layout.model_singlechoice, null)
        val title = view.findViewById<TextView>(R.id.text_title)
        val optionsLayout = view.findViewById<LinearLayout>(R.id.options_layout)

        title.text =
            "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        val sectionObj = masterJSON.getJSONObject(sectionKey)

        // Ensure question object exists
        val questionObj = sectionObj.optJSONObject(questionId)
            ?: JSONObject().apply { put("1", JSONObject()); sectionObj.put(questionId, this) }

        val optionObj = questionObj.optJSONObject("1") ?: JSONObject()

        // Pre-select already chosen option
        val preSelectedId = optionObj.optString("option_text", null)
        var selectedText: String? = null
        var selectedId: String? = preSelectedId

        // Create RadioButtons manually
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) != questionId) continue

            val radioButton = RadioButton(this)
            radioButton.text = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
            radioButton.tag = option.getString(FlexibleFormOptionsTable.OPTION_ID)

            // Pre-select
            if (preSelectedId != null && preSelectedId == radioButton.tag.toString()) {
                radioButton.isChecked = true
                selectedText = radioButton.text.toString()
            }

            radioButton.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) {
                    // Uncheck other RadioButtons manually
                    for (j in 0 until optionsLayout.childCount) {
                        val child = optionsLayout.getChildAt(j)
                        if (child is RadioButton && child != radioButton) {
                            child.isChecked = false
                        }
                    }
                    selectedId = radioButton.tag.toString()
                    selectedText = radioButton.text.toString()
                }
            }

            optionsLayout.addView(radioButton)
        }

        // AlertDialog
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(view)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (selectedId != null) {
                val optionObj = JSONObject().apply {
                    put("option_text", selectedId)
                    put("row_index","0")
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                questionObj.put("1", optionObj)
                sectionObj.put(questionId, questionObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, questionObj)

                if (answerView is TextView) answerView.text = selectedText
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    private fun multipleChoiceAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate layout
        val view = layoutInflater!!.inflate(R.layout.model_multiplechoice, null)
        val title = view.findViewById<TextView>(R.id.text_title)
        val optionsLayout = view.findViewById<LinearLayout>(R.id.options_layout)

        title.text = "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Ensure question object exists in masterJSON
        val questionObj = masterJSON.getJSONObject(sectionKey).optJSONObject(questionId)
            ?: JSONObject().apply { put("1", JSONObject()); masterJSON.getJSONObject(sectionKey).put(questionId, this) }

//        Log.d("questionObj lenfth","${questionObj.length()}")
        val selectedIds = mutableSetOf<String>()
        for (i in 0 until questionObj.length()) selectedIds.add(questionObj.optJSONObject("${i+1}")?.getString("option_text").toString())


//        Log.d("multiplechoice selectedid","$selectedIds")

        // Map option IDs to option texts for UI
        val selectedTexts = mutableSetOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == questionId &&
                selectedIds.contains(option.getString(FlexibleFormOptionsTable.OPTION_ID))
            ) {
                selectedTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Create CheckBoxes and pre-select from masterJSON
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) != questionId) continue

            val checkBox = CheckBox(this)
            checkBox.text = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
            checkBox.tag = option.getString(FlexibleFormOptionsTable.OPTION_ID)
            checkBox.isChecked = selectedIds.contains(checkBox.tag) // pre-select from masterJSON

            checkBox.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) {
                    selectedIds.add(checkBox.tag.toString())
                    selectedTexts.add(checkBox.text.toString())
                } else {
                    selectedIds.remove(checkBox.tag.toString())
                    selectedTexts.remove(checkBox.text.toString())
                }
            }

            optionsLayout.addView(checkBox)
        }

        // AlertDialog
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(view)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (selectedIds.isNotEmpty()) {
                val idsList = selectedIds.toList()
                val newQuestionObj = JSONObject()
//                Log.d("multiplechoice modelsubmit","$idsList")
                for (i in idsList.indices) {
                    val optionObj = JSONObject().apply {
                        put("option_text", idsList[i])
                        put("row_index","0")
                        put("answered", true)
                        put("issue", "no")
                        put("remarks", "")
                    }
                    newQuestionObj.put((i+1).toString(), optionObj)
                }
                masterJSON.getJSONObject(sectionKey).remove(questionId)
                masterJSON.getJSONObject(sectionKey).put(questionId, newQuestionObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, newQuestionObj)
//                Log.d("masterjson","$masterJSON")

                // Update UI with option texts
                if (answerView is TextView) answerView.text = selectedTexts.joinToString(", ")
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun singleChoiceGridAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate grid layout
        val gridView = layoutInflater.inflate(R.layout.model_singlechoicegrid, null)
        val title = gridView.findViewById<TextView>(R.id.text_title)
        val table = gridView.findViewById<TableLayout>(R.id.grid_table)
        title.text = "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val rows = mutableListOf<String>()
        val cols = mutableListOf<String>()
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Collect rows and columns
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) != questionId) continue
            when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                "choice-grid-row" -> rows.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                "choice-grid-column" -> cols.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        val selectedAnswers = mutableMapOf<String, String>() // rowIndex -> col

        // Restore saved answers
        val savedObj = masterJSON.getJSONObject(sectionKey).optJSONObject(questionId)
        if (savedObj != null) {
            for (i in 0 until savedObj.length()) {
                val savedArr = savedObj?.optJSONObject((i+1).toString())
                val entry_column = savedArr?.getString("option_text")
                val entry_row = savedArr?.getString("row_index")
                // Convert row index to string key
                selectedAnswers[entry_row.toString()] = entry_column.toString()
            }
        }

        // Build table header
        val headerRow = TableRow(this)
        headerRow.addView(TextView(this)) // empty top-left cell
        for (col in cols) {
            val tv = TextView(this)
            tv.text = col
            tv.textAlignment = TextView.TEXT_ALIGNMENT_CENTER
            tv.setPadding(16, 8, 16, 8)
            headerRow.addView(tv)
        }
        table.addView(headerRow)

        // Build table rows with radio buttons
        for ((rowIndex, row) in rows.withIndex()) {
            val tableRow = TableRow(this)
            val rowLabel = TextView(this)
            rowLabel.text = row
            rowLabel.setPadding(8, 8, 16, 8)
            tableRow.addView(rowLabel)

            val buttonList = mutableListOf<RadioButton>()
            for (col in cols) {
                val rb = RadioButton(this)
                rb.tag = Pair(rowIndex, col)

                // Preselect if saved
                if (selectedAnswers[rowIndex.toString()] == col) rb.isChecked = true

                rb.setOnClickListener {
                    buttonList.forEach { other -> if (other != rb) other.isChecked = false }
                    val (r, c) = rb.tag as Pair<Int, String>
                    selectedAnswers[r.toString()] = c
                }

                val cell = LinearLayout(this)
                cell.gravity = Gravity.CENTER
                cell.addView(rb)
                tableRow.addView(cell)
                buttonList.add(rb)
            }
            table.addView(tableRow)
        }

        // --- AlertDialog ---
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(gridView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {

            val answerObj = JSONObject()
            var i = 1
            val displayList = mutableListOf<String>()

            selectedAnswers.forEach { (r, c) ->
                val answerJson = JSONObject().apply {
                    put("option_text", c)
                    put("row_index", r.toString())
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                answerObj.put(i.toString(), answerJson)
                displayList.add("[${r.toInt()}, $c]")
                i++
            }

            if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
            masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)

            if (answerView is TextView) answerView.text = displayList.joinToString(", ")
            alertDialog.dismiss()
        }

        dialogView.findViewById<View>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun multipleChoiceGridAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val gridView = layoutInflater!!.inflate(R.layout.model_multiplechoicegrid, null)
        val title = gridView.findViewById<TextView>(R.id.text_title)
        val table = gridView.findViewById<TableLayout>(R.id.grid_table)
        title.text = "${json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)}.${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}"

        val rows = mutableListOf<String>()
        val cols = mutableListOf<String>()
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Collect rows and columns
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) != questionId) continue
            when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                "choice-grid-row" -> rows.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                "choice-grid-column" -> cols.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        val selectedAnswers = mutableMapOf<String, MutableSet<String>>() // row -> set of columns

        // Restore saved answers
        val savedObj = masterJSON.getJSONObject(sectionKey).optJSONObject(questionId)
        if (savedObj != null) {
            for (i in 0 until savedObj.length()) {
                val savedArr = savedObj.optJSONObject((i+1).toString())
                val row = savedArr?.optString("row_index") ?: continue
                val col = savedArr.optString("option_text")
                selectedAnswers.getOrPut(row) { mutableSetOf() }.add(col)
            }
        }

        // Header row
        val headerRow = TableRow(this)
        headerRow.addView(TextView(this))
        for (col in cols) {
            val tv = TextView(this)
            tv.text = col
            tv.textAlignment = TextView.TEXT_ALIGNMENT_CENTER
            tv.setPadding(16, 8, 16, 8)
            headerRow.addView(tv)
        }
        table.addView(headerRow)

        // Table rows with checkboxes
        for ((rowIndex, row) in rows.withIndex()) {
            val tableRow = TableRow(this)
            val rowLabel = TextView(this)
            rowLabel.text = row
            rowLabel.setPadding(8, 8, 16, 8)
            tableRow.addView(rowLabel)

            for (col in cols) {
                val cb = CheckBox(this)
                cb.tag = Pair(rowIndex, col)

                // Preselect if saved
                if (selectedAnswers[rowIndex.toString()]?.contains(col) == true) cb.isChecked = true

                cb.setOnCheckedChangeListener { _, isChecked ->
                    val set = selectedAnswers.getOrPut(rowIndex.toString()) { mutableSetOf() }
                    if (isChecked) set.add(col) else set.remove(col)
                }

                val cell = LinearLayout(this)
                cell.gravity = Gravity.CENTER
                cell.addView(cb)
                tableRow.addView(cell)
            }

            table.addView(tableRow)
        }

        // --- AlertDialog ---
        val dialogView = layoutInflater!!.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(gridView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val answerObj = JSONObject()
            var i = 1
            val displayList = mutableListOf<String>()

            selectedAnswers.forEach { (r, colSet) ->
                colSet.forEach { col ->
                    val answerJson = JSONObject()
                    answerJson.put("option_text", col)
                    answerJson.put("row_index", r)
                    answerJson.put("answered", true)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")

                    answerObj.put(i.toString(), answerJson)
                    displayList.add("[${r.toInt()}, $col]")
                    i++
                }
            }

            if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
            masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)

            if (answerView is TextView) {
                answerView.text = displayList.joinToString(", ")
            }

            alertDialog.dismiss()
        }

        dialogView.findViewById<View>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        if (!(isFinishing || isDestroyed)) alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun singleChoiceImageAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate main content layout for the dialog
        val contentView = layoutInflater.inflate(R.layout.model_singlechoiceimage, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val radioGroup = contentView.findViewById<LinearLayout>(R.id.radio_group)
        title.text = String.format("%s.%s", json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val optionIds = mutableListOf<String>()
        val optionImages = mutableListOf<String>()
        val radioButtons = mutableListOf<RadioButton>()
        val baseUrl = "http://fieldcloud.in/"

        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
                optionImages.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Restore saved answer temporarily
        var tempAnswer: String? = null
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null) {
                tempAnswer = ansObj.optJSONObject("1")?.optString("option_text")
            }
        }

        // Populate radio buttons + images
        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val imageResOrUrl = optionImages[i]

            val itemView = layoutInflater.inflate(R.layout.item_singlechoiceimahe, radioGroup, false)
            val radioButton = itemView.findViewById<RadioButton>(R.id.radio_button)
            val imageView = itemView.findViewById<ImageView>(R.id.option_image)

            radioButton.tag = optionId
            radioButton.isChecked = tempAnswer == optionId
            radioButtons.add(radioButton)

            val resId = resources.getIdentifier(imageResOrUrl, "drawable", packageName)
            if (resId != 0) imageView.setImageResource(resId)
            else Glide.with(this).load(baseUrl + imageResOrUrl).into(imageView)

            // Click image = select radio
            imageView.setOnClickListener { radioButton.isChecked = true }

            radioButton.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) radioButtons.forEach { if (it != radioButton) it.isChecked = false }
            }

            radioGroup.addView(itemView)
        }

        // --- AlertDialog ---
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val selectedRadio = radioButtons.find { it.isChecked }
            if (selectedRadio != null) {
                val questionObj = JSONObject()
                val answerJson = JSONObject().apply {
                    put("option_text", selectedRadio.tag.toString())
                    put("row_index", "0")
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                questionObj.put("1", answerJson)
                masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), questionObj)
//                Log.d("masterjson","$masterJSON")
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(
                    FlexibleFormQuestionsTable.QUESTION_ID), questionObj)

                if (answerView is ImageView) Glide.with(this).load(baseUrl + optionImages[optionIds.indexOf(selectedRadio.tag.toString())]).into(answerView)
                else if (answerView is TextView) answerView.text = selectedRadio.tag.toString()
            }
            alertDialog.dismiss()
        }

        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun multipleChoiceImageAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val contentView = layoutInflater.inflate(R.layout.model_multiplechoiceimage, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val container = contentView.findViewById<LinearLayout>(R.id.checkbox_group)
        title.text = String.format(
            "%s.%s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        val optionIds = mutableListOf<String>()
        val optionImages = mutableListOf<String>()
        val checkBoxes = mutableListOf<CheckBox>()
        val optionMap = mutableMapOf<String, String>()
        val baseUrl = "http://fieldcloud.in/"

        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                val optionId = option.getString(FlexibleFormOptionsTable.OPTION_ID)
                val optionPath = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                optionIds.add(optionId)
                optionImages.add(optionPath)
                optionMap[optionId] = optionPath
            }
        }

        // Restore saved answers
        val tempSelected = mutableSetOf<String>()
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null) {
                for (i in 0 until ansObj.length()) {
                    val savedOptionId = ansObj.optJSONObject("${i+1}")?.getString("option_text")
                    if (!savedOptionId.isNullOrEmpty()) {
                        tempSelected.add(savedOptionId) // matches optionId
                    }
                }
            }
        }

        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val imageResOrUrl = optionImages[i]

            val itemView = layoutInflater.inflate(R.layout.item_multiplechoiceimage, container, false)
            val checkBox = itemView.findViewById<CheckBox>(R.id.checkbox)
            val imageView = itemView.findViewById<ImageView>(R.id.option_image)

            checkBox.tag = optionId
            checkBox.isChecked = tempSelected.contains(optionId)
            checkBoxes.add(checkBox)

            val resId = resources.getIdentifier(imageResOrUrl, "drawable", packageName)
            if (resId != 0) imageView.setImageResource(resId)
            else Glide.with(this).load(baseUrl + imageResOrUrl)
                .placeholder(R.drawable.placeholder_image)
                .error(R.drawable.error_image)
                .into(imageView)

            imageView.setOnClickListener { checkBox.isChecked = !checkBox.isChecked }
            container.addView(itemView)
        }

        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val selectedIds = checkBoxes.filter { it.isChecked }.map { it.tag.toString() }
            if (selectedIds.isNotEmpty()) {
                val newQuestionObj = JSONObject()
                selectedIds.forEachIndexed { i, id ->
                    val optionObj = JSONObject().apply {
                        put("form_id", json.getString(FlexibleFormQuestionsTable.FORM_ID))
                        put("question_id", json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                        put("option_text", id) // store OPTION_ID
                        put("row_index", "0")
                        put("answered", true)
                        put("issue", "no")
                        put("remarks", "")
                    }
                    newQuestionObj.put((i + 1).toString(), optionObj)
                }
                masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), newQuestionObj)
//                Log.d("masterjson","$masterJSON")
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), newQuestionObj)

                // Update preview layout
                // Update preview layout
                if (answerView is LinearLayout) {
                    // Keep index 0 (question text row), clear everything else
                    while (answerView.childCount > 1) {
                        answerView.removeViewAt(1)
                    }

                    // Rebuild images for selected options
                    selectedIds.forEachIndexed { index, id ->
                        val filePath = optionMap[id] ?: return@forEachIndexed
                        val img = ImageView(this)
                        val params = LinearLayout.LayoutParams(
                            LinearLayout.LayoutParams.MATCH_PARENT,
                            LinearLayout.LayoutParams.WRAP_CONTENT
                        )
                        img.layoutParams = params
                        Glide.with(this).load(baseUrl + filePath)
                            .placeholder(R.drawable.placeholder_image)
                            .error(R.drawable.error_image)
                            .into(img)
                        answerView.addView(img) // add after question row
                    }
                }
            }
            alertDialog.dismiss()
        }

        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun rankingQuestionAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate ranking layout
        val contentView = layoutInflater.inflate(R.layout.model_ranking, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val recyclerView = contentView.findViewById<RecyclerView>(R.id.recycler_ranking)
        title.text = String.format("%s.%s", json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Collect options
        val optionIds = mutableListOf<String>()
        val optionTexts = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Restore previous ranking
        val savedRanking = mutableListOf<String>()
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
//            Log.d("masterjson","$masterJSON")

            for (i in 0 until ansObj.length()) {
                savedRanking.add(ansObj.getJSONObject((i+1).toString()).getString("option_text"))
            }

        }

        // Reorder options according to saved ranking
        if (savedRanking.isNotEmpty()) {
            val reordered = mutableListOf<Pair<String, String>>()
            savedRanking.forEach { id ->
                val idx = optionIds.indexOf(id)
                if (idx >= 0) reordered.add(id to optionTexts[idx])
            }
            optionIds.clear()
            optionTexts.clear()
            reordered.forEach {
                optionIds.add(it.first)
                optionTexts.add(it.second)
            }
        }

        val optionIdToText = mutableMapOf<String, String>()
        for (i in optionIds.indices) {
            optionIdToText[optionIds[i]] = optionTexts[i]
        }

        // Setup RecyclerView
        recyclerView.layoutManager = LinearLayoutManager(this)
        val questionObj = JSONObject()
        val rankingList = mutableListOf<String>()
        val adapter = RankingAdapter(optionIds, optionTexts) { updatedIds->
            // Save on reorder
            updatedIds.forEachIndexed { index, optId ->
                val optionObj = JSONObject().apply {
                    put("option_text", optId)
                    put("row_index", (index+1).toString())
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                questionObj.put("${index+1}",optionObj)
                rankingList.add(index,optId)
            }

        }
        recyclerView.adapter = adapter
        val touchHelper = ItemTouchHelper(adapter.itemTouchHelperCallback)
        touchHelper.attachToRecyclerView(recyclerView)

        // Inflate alert dialog
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (questionObj != null) {
                masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), questionObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), questionObj)
                // Update TextView or other view if needed
                if (answerView is TextView) {
                    val selectedTexts = rankingList.mapNotNull { optionIdToText[it] }
                    answerView.text = selectedTexts.joinToString(", ")
                }
            }
            alertDialog.dismiss()
        }

        // Cancel
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun ratingQuestionAlert(json: JSONObject, answerView: View) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate the rating layout
        val contentView = layoutInflater.inflate(R.layout.model_rating, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val ratingContainer = contentView.findViewById<LinearLayout>(R.id.rating_container)

        title.text = String.format("%s.%s", json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        var symbol = "star"
        var count = 5

        // Parse option_text like "5-star", "7-heart", etc.
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                val optionText = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                if (optionText.contains("-")) {
                    val parts = optionText.split("-")
                    count = parts[0].toIntOrNull() ?: 5
                    symbol = parts[1] // star, heart, smiley, etc.
                }
            }
        }

        val icons = mutableListOf<ImageView>()
        var selectedRating = 0

        // Restore saved response
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val savedObj = masterJSON.optJSONObject(sectionKey)
                ?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            val savedAns = savedObj?.optJSONObject("1")
            if (savedAns != null) {
                selectedRating = savedAns.optString("option_text").toIntOrNull() ?: 0
            }
        }

        // Create rating icons
        for (i in 1..count) {
            val icon = ImageView(this)
            val params = LinearLayout.LayoutParams(100, 100)
            params.setMargins(8, 8, 8, 8)
            icon.layoutParams = params
            icon.tag = i

            if (i <= selectedRating) icon.setImageResource(getSelectedIcon(symbol))
            else icon.setImageResource(getUnselectedIcon(symbol))

            icon.setOnClickListener {
                selectedRating = it.tag as Int
                // Update icons
                for (j in icons.indices) {
                    if (j < selectedRating) icons[j].setImageResource(getSelectedIcon(symbol))
                    else icons[j].setImageResource(getUnselectedIcon(symbol))
                }
            }

            icons.add(icon)
            ratingContainer.addView(icon)
        }

        // Inflate alert dialog layout (with Submit/Cancel buttons)
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val answerJson = JSONObject().apply {
                put("option_text", selectedRating.toString())
                put("row_index", "0")
                put("answered", selectedRating > 0)
                put("issue", "no")
                put("remarks", "")
            }
            val answerObj = JSONObject().apply {
                put("1", answerJson)
            }
            masterJSON.getJSONObject(sectionKey)
                .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerObj)
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerObj)

            // Optionally update a TextView showing the rating
            if (answerView is TextView) {
                answerView.text = "$selectedRating"
            }

            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    // helper functions
    private fun getSelectedIcon(symbol: String): Int {
        return when (symbol.lowercase()) {
            "heart" -> R.drawable.ic_heart_filled
            "smiley" -> R.drawable.ic_smiley_filled
            "thumbsup" -> R.drawable.ic_thumbsup_filled
            "trophy" -> R.drawable.ic_trophy_filled
            "ribbon" -> R.drawable.ic_ribbon_filled
            else -> R.drawable.ic_star_filled
        }
    }

    private fun getUnselectedIcon(symbol: String): Int {
        return when (symbol.lowercase()) {
            "heart" -> R.drawable.ic_heart_outline
            "smiley" -> R.drawable.ic_smiley_outline
            "thumbsup" -> R.drawable.ic_thumbsup_outline
            "trophy" -> R.drawable.ic_trophy_outline
            "ribbon" -> R.drawable.ic_ribbon_outline
            else -> R.drawable.ic_star_outline
        }
    }

    @Throws(JSONException::class)
    private fun netPromoterScoreAlert(json: JSONObject, answerView: View?) {
        // Inflate NPS layout
        val contentView = layoutInflater.inflate(R.layout.model_netpromoter_boxes, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val container = contentView.findViewById<LinearLayout>(R.id.box_container)
        val leftLabel = contentView.findViewById<TextView>(R.id.label_left)
        val rightLabel = contentView.findViewById<TextView>(R.id.label_right)

        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        title.text = String.format(
            "%s.%s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )
        leftLabel.text =
            if (optionsArray.length() > 0) optionsArray.getJSONObject(0).getString("option_text") else "Less Likely"
        rightLabel.text =
            if (optionsArray.length() > 1) optionsArray.getJSONObject(1).getString("option_text") else "More Likely"

        // Restore saved value from masterJSON
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        var selectedValue: String? = null
        val savedAnswer = sectionObj?.optJSONObject(questionId)?.getJSONObject((1).toString())?.optString("option_text", null)

        if (!savedAnswer.isNullOrEmpty()) {
            selectedValue = savedAnswer
        }

        // Create 0–10 boxes
        for (i in 1..10) {
            val box = TextView(this)
            box.text = i.toString()
            box.gravity = Gravity.CENTER
            box.setPadding(24, 24, 24, 24)
            box.setBackgroundResource(R.drawable.nps_box_unselected)
            box.setTextColor(Color.BLACK)

            val params = LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.WRAP_CONTENT,
                LinearLayout.LayoutParams.WRAP_CONTENT
            )
            params.setMargins(8, 8, 8, 8)
            box.layoutParams = params

            // Preselect saved box
            if (savedAnswer != null && savedAnswer == i.toString()) {
                box.setBackgroundResource(R.drawable.nps_box_selected)
                box.setTextColor(Color.WHITE)
            }

            // OnClick
            box.setOnClickListener {
                // Reset all
                for (j in 0 until container.childCount) {
                    val child = container.getChildAt(j) as TextView
                    child.setBackgroundResource(R.drawable.nps_box_unselected)
                    child.setTextColor(Color.BLACK)
                }
                // Highlight selected
                box.setBackgroundResource(R.drawable.nps_box_selected)
                box.setTextColor(Color.WHITE)
                selectedValue = box.text.toString()
            }

            container.addView(box)
        }

        // Inflate AlertDialog layout
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            if (selectedValue != null) {
                val answerJson = JSONObject().apply {
                    put("option_text", selectedValue) // 🔹 save under option_text
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                sectionObj?.put(questionId, answerJson)
                sectionObj?.put("filled", true)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)

                if (answerView is TextView) {
                    answerView.text = selectedValue
                }
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun sliderQuestionAlert(json: JSONObject, answerView: View?) {
        // Inflate Slider layout
        val contentView = layoutInflater.inflate(R.layout.model_slider, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val slider = contentView.findViewById<SeekBar>(R.id.slider)
        val label = contentView.findViewById<TextView>(R.id.slider_value)

        title.text = String.format(
            "%s.%s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        slider.max = 100

        // Restore saved value if exists
        val sectionObj = masterJSON.getJSONObject(sectionKey)
        var selectedValue = 0

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        if (sectionObj.optBoolean("filled")) {
            val ansObj = sectionObj.optJSONObject(questionId).optJSONObject((1).toString())
            if (ansObj != null && ansObj.optBoolean("answered")) {
                selectedValue = ansObj.optString("option_text").toIntOrNull() ?: 0
            }
        }

        // Set the slider to saved value
        slider.progress = selectedValue
        label.text = "Value: $selectedValue"

        slider.setOnSeekBarChangeListener(object : SeekBar.OnSeekBarChangeListener {
            override fun onProgressChanged(seekBar: SeekBar, progress: Int, fromUser: Boolean) {
                label.text = "Value: $progress"
                selectedValue = progress
            }

            override fun onStartTrackingTouch(seekBar: SeekBar) {}
            override fun onStopTrackingTouch(seekBar: SeekBar) {}
        })

        // Inflate AlertDialog layout
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val answerJson = JSONObject().apply {
                put("option_text", selectedValue.toString()) // save to option_text
                put("answered", true)
                put("issue", "no")
                put("remarks", "")
            }
            sectionObj.put(questionId, answerJson)
            sectionObj.put("filled", true) // mark section as filled
            FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)

            if (answerView is TextView) {
                answerView.text = "$selectedValue"
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun linearScaleAlert(json: JSONObject, answerView: View?) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate LinearScale layout
        val contentView = layoutInflater.inflate(R.layout.model_linearscale, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val radioGroup = contentView.findViewById<RadioGroup>(R.id.radio_group)
        val leftLabel = contentView.findViewById<TextView>(R.id.left_label)
        val rightLabel = contentView.findViewById<TextView>(R.id.right_label)

        title.text = String.format(
            "%s.%s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        var range = "1-5"
        val linearLabels = mutableListOf<String>()

        // Get range + labels
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {

                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                    "linear-range" -> range = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                    "linear-label" -> linearLabels.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                }
            }
        }

        leftLabel.text = if (linearLabels.isNotEmpty()) linearLabels[0] else "Less Likely"
        rightLabel.text = if (linearLabels.size > 1) linearLabels[1] else "More Likely"

        val parts = range.split("-")
        val start = parts[0].toInt()
        val end = parts[1].toInt()

        radioGroup.removeAllViews()
        for (num in start..end) {
            val rb = RadioButton(this)
            rb.text = num.toString()
            rb.id = View.generateViewId()
            radioGroup.addView(rb)
        }

        // ---------------- Restore saved answer (first time also works) ----------------
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        var savedValue: String? = null

        if (sectionObj != null && sectionObj.has(questionId)) {
            val ansObj = sectionObj.optJSONObject(questionId).optJSONObject((1).toString())
            if (ansObj != null && ansObj.optBoolean("answered")) {
                // if you save with "answer"
                savedValue = ansObj.optString("option_text", null)
                // if you save with "option_text" (like NPS) then use this instead:
                // savedValue = ansObj.optString("option_text", null)
            }
        }

        if (!savedValue.isNullOrEmpty()) {
            for (i in 0 until radioGroup.childCount) {
                val rb = radioGroup.getChildAt(i) as RadioButton
                if (rb.text.toString() == savedValue) {
                    rb.isChecked = true
                    break
                }
            }
        }

        // Inflate AlertDialog layout
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val selectedRbId = radioGroup.checkedRadioButtonId
            if (selectedRbId != -1) {
                val selected = radioGroup.findViewById<RadioButton>(selectedRbId).text.toString()
                val answerJson = JSONObject().apply {
                    put("option_text", selected)   // or "option_text" if you want consistency with NPS
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }

                if (sectionObj != null) {
                    sectionObj.put(questionId, answerJson)
                    sectionObj.put("filled", true)
                    FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
                } else {
                    val newSection = JSONObject()
                    newSection.put(questionId, answerJson)
                    newSection.put("filled", true)
                    masterJSON.put(sectionKey, newSection)
                    FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
                }

                if (answerView is TextView) {
                    answerView.text = selected
                }
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun dropDownAlert(json: JSONObject, answerView: View?) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate dropdown layout
        val contentView = layoutInflater.inflate(R.layout.model_spinner, null)
        val title = contentView.findViewById<TextView>(R.id.text_title)
        val spinner = contentView.findViewById<Spinner>(R.id.spinner)

        title.text = String.format(
            "%s.%s",
            json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER),
            json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        )

        // Collect all options
        val optionTexts = mutableListOf<String>()
        val optionIds = mutableListOf<String>()
        optionTexts.add("Select Answer")
        optionIds.add("")

        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
            }
        }

        // Setup adapter with disabled first item
        val spinnerArrayAdapter: ArrayAdapter<String> = object :
            ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, optionTexts) {
            override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
                val mView = super.getDropDownView(position, convertView, parent)
                val mTextView = mView as TextView
                if (position == 0) {
                    mTextView.setTextColor(Color.GRAY)
                } else {
                    mTextView.setTextColor(Color.BLACK)
                }
                return mView
            }

            override fun isEnabled(position: Int): Boolean {
                return position != 0
            }
        }
        spinnerArrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        spinner.adapter = spinnerArrayAdapter

        // ---------------- Restore saved option_text ----------------
        val sectionObj = masterJSON.optJSONObject(sectionKey)
        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
        val savedText = sectionObj?.optJSONObject(questionId)?.optJSONObject("1")?.optString("option_text", null) // assuming option_text is stored under "answer"

        if (!savedText.isNullOrEmpty()) {
            val pos = optionIds.indexOf(savedText)
            if (pos >= 0) spinner.setSelection(pos)
        }

        // Inflate AlertDialog layout
        val dialogView = layoutInflater.inflate(R.layout.model_alert, null)
        val linearLayout = dialogView.findViewById<LinearLayout>(R.id.alert_layout)
        linearLayout.addView(contentView)

        val dialogBuilder = AlertDialog.Builder(this)
        dialogBuilder.setView(dialogView)
        val alertDialog = dialogBuilder.create()

        // Submit button
        dialogView.findViewById<Button>(R.id.model_submit).setOnClickListener {
            val pos = spinner.selectedItemPosition
            if (pos > 0) {
                val selectedId = optionIds[pos]
                val selectedText = optionTexts[pos]
                val answerObj = JSONObject()
                val answerJson = JSONObject().apply {
                    put("option_text", selectedId) // store option_text
                    put("row_index", "0")
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }
                answerObj.put("1",answerJson)
                if (!masterJSON.has(sectionKey)) masterJSON.put(sectionKey, JSONObject())
                masterJSON.getJSONObject(sectionKey).put(questionId, answerObj)
                FormPreviewManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerObj)

                if (answerView is TextView) {
                    answerView.text = selectedText
                }
            }
            alertDialog.dismiss()
        }

        // Cancel button
        dialogView.findViewById<Button>(R.id.model_cancel).setOnClickListener {
            alertDialog.dismiss()
        }

        alertDialog.setCancelable(false)
        alertDialog.show()
    }

    @Throws(JSONException::class)
    private fun addNonImageView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("title","${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}")
        val answer = view.findViewById<TextView>(R.id.pre_answer)
//        Log.e("masterJson","$masterJSON")
        if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE) == "file upload"){
            val filename = masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text")
            val shortFileName = filename.substringAfterLast("_0_")
            answer.text = shortFileName
        } else {
            answer.text = masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text")
        }
//        Log.d("answer","${answer.text}")

        val answerJson = JSONObject().apply {
            put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
            put("row_index", "0")
            put("answered", true)
            put("issue", "no")
            put("remarks", "")
        }

        FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
            FlexibleFormQuestionsTable.QUESTION_ID),answerJson)

        val imageView = view.findViewById<ImageView>(R.id.edit)
        imageView.setOnClickListener { showAlertDialog(json, answer) }
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addAddressView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("title","${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}")
        val answer = view.findViewById<TextView>(R.id.pre_answer)
//        Log.e("masterJson","$masterJSON")
        val answerTextList = mutableListOf<String>()
        for (i in 0 until (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).length())){
            answerTextList.add(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("${i+1}").getString("option_text"))
            val answerJson = JSONObject().apply {
                put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                    FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("${i+1}").getString("option_text"))
                put("row_index", "$i")
                put("answered", true)
                put("issue", "no")
                put("remarks", "")
            }

            FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
        }
        answer.text = answerTextList.joinToString(", ")
//        Log.d("answer","${answer.text}")

        val imageView = view.findViewById<ImageView>(R.id.edit)
        imageView.setOnClickListener { showAlertDialog(json, answer) }
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addGridView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("title","${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}")
        val answer = view.findViewById<TextView>(R.id.pre_answer)
//        Log.e("masterJson","$masterJSON")
        val questionObj = masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
        val displayList = mutableListOf<String>()
        for(i in 0 until questionObj.length()) {
            displayList.add("[${questionObj.optJSONObject((i+1).toString()).getString("row_index")}, ${questionObj.optJSONObject((i+1).toString()).getString("option_text")}]")
            val answerJson = JSONObject().apply {
                put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                    FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("${i+1}").getString("option_text"))
                put("row_index", "$i")
                put("answered", true)
                put("issue", "no")
                put("remarks", "")
            }

            FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
        }
        answer.text = displayList.joinToString(", ")
//        Log.d("answer","${answer.text}")
        val imageView = view.findViewById<ImageView>(R.id.edit)
        imageView.setOnClickListener { showAlertDialog(json, answer) }
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addChoiceView(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        val answer = view.findViewById<TextView>(R.id.pre_answer)
        val imageView = view.findViewById<ImageView>(R.id.edit)

        // Set question title
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("title","${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}")

        val questionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)

        // Get stored option_id (or option_ids for multiple choice) from masterJSON
        val storedOptionIds = masterJSON.getJSONObject(sectionKey)
            .getJSONObject(questionId)
            .getJSONObject("1")
            .optString("option_text", "") // can be comma-separated for multiple choice

        val selectedOptions = mutableListOf<String>()
        val questionJson = masterJSON.getJSONObject(sectionKey).getJSONObject(questionId)
        for(i in 0 until questionJson.length()){
            selectedOptions.add(questionJson.optJSONObject("${i+1}")?.getString("option_text").toString())
            val answerJson = JSONObject().apply {
                put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                    FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("${i+1}").getString("option_text"))
                if(json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE) == "ranking") {
                    put("row_index", "${i+1}")
                }else {
                    put("row_index", "0")
                }
                put("answered", true)
                put("issue", "no")
                put("remarks", "")
            }

            FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
        }

        // Map option_id(s) to human-readable option_text(s)
        val optionTextList = mutableListOf<String>()
        if (selectedOptions.isNotEmpty()) {
            val storedIds = storedOptionIds.split(",").map { it.trim() }
            val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

            for (i in 0 until optionsArray.length()) {
                val option = optionsArray.getJSONObject(i)
                if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) != questionId) continue
                if (selectedOptions.contains(option.getString(FlexibleFormOptionsTable.OPTION_ID))) {
                    optionTextList.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                }
            }
        }

        // Display the human-readable option_text
        answer.text = optionTextList.joinToString(", ")
//        Log.d("answer","${answer.text}")

        // Edit click listener
        imageView.setOnClickListener { showAlertDialog(json, answer) }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addUniqueView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("title","${json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)}")
        val answer = view.findViewById<TextView>(R.id.pre_answer)
//        Log.e("masterJson","$masterJSON")
        answer.text = masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
            FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text")
        val answerJson = JSONObject().apply {
            put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
            put("row_index", "0")
            put("answered", true)
            put("issue", "no")
            put("remarks", "")
        }

        FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
            FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
//        Log.d("answer","${answer.text}")
        mainLayout!!.addView(view)
        val imageView = view.findViewById<ImageView>(R.id.edit)
        imageView.visibility = View.GONE
    }

    @Throws(JSONException::class)
    private fun addImageView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_imge, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        val snappedImage = view.findViewById<ImageView>(R.id.pre_image)
        try {
            title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
            snappedImage.setImageBitmap(Utility.bitmap(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID))
                    .getString("answer")))
            val edit = view.findViewById<ImageView>(R.id.edit)
            edit.visibility = View.VISIBLE
            if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).toLowerCase().equals("image", ignoreCase = true)) {
                edit.setOnClickListener {
                    imageView = snappedImage
                    captureImage()
                }
            } else {
                edit.setOnClickListener { showAlertDialog(json, snappedImage) }
            }
            mainLayout!!.addView(view)
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    @Throws(JSONException::class)
    private fun addChoiceImageView(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_imge, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        val snappedImage = view.findViewById<ImageView>(R.id.pre_image)
        val edit = view.findViewById<ImageView>(R.id.edit)

        try {
            title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

            val savedAnswersObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))

            val serviceDatabase = ServiceDatabase.getInstance(this)
            val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)
            val optionMap = mutableMapOf<String, String>()

            for (i in 0 until optionsArray.length()) {
                val option = optionsArray.getJSONObject(i)
                if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                    json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
                ) {
                    optionMap[option.getString(FlexibleFormOptionsTable.OPTION_ID)] =
                        option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                }
            }

            val baseUrl = if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE) == "signature"){
                "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/"
            } else {
                "http://fieldcloud.in/"
            }
            val keys = savedAnswersObj.keys()
            var firstLoaded = false

            // clear old previews except first
            (view as LinearLayout).removeViews(2, view.childCount - 2)

            while (keys.hasNext()) {
                val key = keys.next()
                val optionId = savedAnswersObj.getJSONObject(key).getString("option_text")
                val filePath = optionMap[optionId]

                if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE) == "signature") {
                    Glide.with(this).load(baseUrl + optionId)
                        .placeholder(R.drawable.placeholder_image)
                        .error(R.drawable.error_image)
                        .into(snappedImage)
//                    Log.d("sig op","${baseUrl + optionId}")
                    val answerJson = JSONObject().apply {
                        put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                            FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
                        put("row_index", "0")
                        put("answered", true)
                        put("issue", "no")
                        put("remarks", "")
                    }

                    FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                        FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
                } else {
                    if (!filePath.isNullOrEmpty()) {
                        if (!firstLoaded) {
                            Glide.with(this)
                                .load(baseUrl + filePath)
                                .placeholder(R.drawable.placeholder_image)
                                .error(R.drawable.error_image)
                                .into(snappedImage)

                            firstLoaded = true
                            val answerJson = JSONObject().apply {
                                put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
                                put("row_index", "0")
                                put("answered", true)
                                put("issue", "no")
                                put("remarks", "")
                            }

                            FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                                FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
                        } else {
                            val extraImg = ImageView(this)
                            val params = snappedImage.layoutParams as LinearLayout.LayoutParams
                            extraImg.layoutParams = LinearLayout.LayoutParams(params)

                            Glide.with(this)
                                .load(baseUrl + filePath)
                                .placeholder(R.drawable.placeholder_image)
                                .error(R.drawable.error_image)
                                .into(extraImg)

                            view.addView(extraImg)
                            val answerJson = JSONObject().apply {
                                put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
                                put("row_index", "0")
                                put("answered", true)
                                put("issue", "no")
                                put("remarks", "")
                            }

                            FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
                                FlexibleFormQuestionsTable.QUESTION_ID),answerJson)
                        }
                    }
                }
            }

            edit.visibility = View.VISIBLE
            when (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).lowercase()) {
                "single choice image" -> {
                    edit.setOnClickListener { singleChoiceImageAlert(json, snappedImage) }
                }
                "multiple choice image" -> {
                    edit.setOnClickListener { multipleChoiceImageAlert(json, view) }
                }
                "signature" -> {
                    edit.setOnClickListener { setSignatureAlert(json, snappedImage) }
                }
            }

            mainLayout!!.addView(view)

        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    @Throws(JSONException::class)
    private fun addDivisionVideo(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val titleText = json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        var videoUrl: String? = "https://www.youtube.com/watch?v=_3PZmfQtZNs"

        // Get video URL from optionsArray for this questionId
//        for (i in 0 until optionsArray.length()) {
//            val option = optionsArray.getJSONObject(i)
//            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
//                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
//            ) {
//                videoUrl = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
//                break
//            }
//        }

        if (videoUrl.isNullOrEmpty()) return

        // Check type of video
        when {
            videoUrl.contains("youtube.com") || videoUrl.contains("youtu.be") -> {
                // YouTube Video
                val view = layoutInflater.inflate(R.layout.model_division_youtube, mainLayout, false)
                val title = view.findViewById<TextView>(R.id.text_title)
                val youTubePlayerView = view.findViewById<com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView>(R.id.youtube_player)

                title.text = titleText

                lifecycle.addObserver(youTubePlayerView)

                youTubePlayerView.addYouTubePlayerListener(object : com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener() {
                    override fun onReady(youTubePlayer: com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer) {
                        val videoId = extractYouTubeId(videoUrl)
                        if (!videoId.isNullOrEmpty()) {
                            youTubePlayer.loadVideo(videoId, 0f)
                        }
                    }
                })

                mainLayout!!.addView(view)
            }

            videoUrl.contains("drive.google.com") -> {
                // Google Drive Video: convert to direct download link
                val fileId = Regex("/d/([a-zA-Z0-9_-]+)").find(videoUrl)?.groupValues?.get(1)
                val directUrl = fileId?.let { "https://drive.google.com/uc?export=download&id=$it" }
                if (!directUrl.isNullOrEmpty()) {
                    addVideoView(titleText, directUrl, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                }
            }

            else -> {
                // Normal MP4 or server video
                addVideoView(titleText, videoUrl, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            }
        }
    }

    // Helper to create VideoView dynamically
    private fun addVideoView(titleText: String, videoUrl: String, questionId: String) {
        val view = layoutInflater.inflate(R.layout.model_division_video, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val videoView = view.findViewById<VideoView>(R.id.video_view)

        title.text = titleText

        val mediaController = MediaController(this)
        mediaController.setAnchorView(videoView)
        videoView.setMediaController(mediaController)
        videoView.setVideoURI(Uri.parse(videoUrl))
        videoView.requestFocus()
        videoView.start()

        mainLayout!!.addView(view)
    }

    // Extract YouTube video ID from URL
    private fun extractYouTubeId(url: String): String? {
        val regex = "(?<=watch\\?v=|/videos/|youtu.be/|/embed/)[^#&?]*"
        return Regex(regex).find(url)?.value
    }

    @Throws(JSONException::class)
    private fun addDivisionTitle(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater.inflate(R.layout.model_divisiontitle, mainLayout, false)

        val title = view.findViewById<TextView>(R.id.text_title)
        val description = view.findViewById<TextView>(R.id.text_description)

        // questionText → Title
        title.text = String.format("%s", json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Get description from optionArray
        val optionTexts = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }
        if (optionTexts.isNotEmpty()) {
            if (optionTexts[0].isNotEmpty()) {
                description.visibility = View.VISIBLE
                description.text = optionTexts[0]
            } else {
                description.visibility = View.GONE
            }
        } else {
            description.visibility = View.GONE
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addDivisionImage(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater.inflate(R.layout.model_divisionimage, mainLayout, false)

        val title = view.findViewById<TextView>(R.id.text_title)
        val imageView = view.findViewById<ImageView>(R.id.image_division)

        // Set title from question text
        title.text = String.format("%s", json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val optionTexts = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }
//        Log.d("image","${optionTexts}")

        // Load the image if path exists
        if (optionTexts.isNotEmpty()) {
            imageView.visibility = View.VISIBLE

            // Full URL (assuming images are served from XAMPP folder smartforms/images/)
            val fullUrl = "http://fieldcloud.in/${optionTexts[0]}"
            Glide.with(this)
                .load(fullUrl)
                .placeholder(R.drawable.placeholder_image) // optional
                .error(R.drawable.error_image) // optional
                .into(imageView)
        } else {
            imageView.visibility = View.GONE
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun addDatetime(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_nonimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.pre_question)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        val answer = view.findViewById<TextView>(R.id.pre_answer)
        answer.text = masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
            FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text")
        val imageView = view.findViewById<ImageView>(R.id.edit)
        val answerJson = JSONObject().apply {
            put("option_text", masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(
                FlexibleFormQuestionsTable.QUESTION_ID)).getJSONObject("1").getString("option_text"))
            put("row_index", "0")
            put("answered", true)
            put("issue", "no")
            put("remarks", "")
        }

        FormPreviewManager.saveAnswer(sectionKey.toString(),sectionID.toString(),json.getString(
            FlexibleFormQuestionsTable.QUESTION_ID),answerJson)

        imageView.setOnClickListener {
            try {
                datetime(json, answer)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        mainLayout!!.addView(view)
    }


    private fun captureImage() {

        fun getoutputMediaFileUri(): File {
            val mediaFile: File = Utility.getSignFile(this)
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            val mediaFile: File = Utility.getSignFile(this)

            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            val fileUri = FileProvider.getUriForFile(this, BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, CAPTURE_NUMBER)
        } catch (e: Exception) {

            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, CAPTURE_NUMBER)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
                e.printStackTrace()
            }

        }

    }

    private var picturefilename = "no data available"
    private var imagefilepath: File? = null

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

        if (requestCode == CAPTURE_NUMBER && resultCode == Activity.RESULT_OK) {

            imagefilepath?.apply {
                imageView?.setImageBitmap(this.toBitmap())
                try {
                    val answerJson = JSONObject()
                    answerJson.put("name", this.toBase64String())
                    answerJson.put("answered", true)
                    masterJSON.put(cameraQuestionId, answerJson)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }

        } else if (requestCode == REQUEST_CHECK_SETTINGS) {
            when (resultCode) {
                Activity.RESULT_OK ->                     // All required changes were successfully made
                    lcoation()
                Activity.RESULT_CANCELED -> RequestProgress.getInstance(this).hideProgressBar()
                else -> {
                }
            }
        } else if (requestCode == FILE_UPLOAD_REQUEST_CODE && resultCode == RESULT_OK) {
            if (data == null) return

            val newUris = mutableListOf<Uri>()
            if (data.clipData != null) {
                for (i in 0 until data.clipData!!.itemCount) {
                    newUris.add(data.clipData!!.getItemAt(i).uri)
                }
            } else if (data.data != null) {
                newUris.add(data.data!!)
            }

            val validUris = mutableListOf<Uri>()
            for (uri in newUris) {
                val name = getFileName(uri)
                val ext = name.substringAfterLast('.', "").lowercase()
                val sizeMB = getFileSizeMB(uri)

                if (allowedTypes.isNotEmpty() && !allowedTypes.contains(ext)) {
                    Toast.makeText(this, "Invalid type: $name", Toast.LENGTH_SHORT).show()
                    continue
                }
                if (sizeMB > maxSizeMB) {
                    Toast.makeText(this, "Too large: $name", Toast.LENGTH_SHORT).show()
                    continue
                }
                validUris.add(uri)
            }

            if (validUris.size > maxFiles) {
                Toast.makeText(this, "Max $maxFiles files allowed", Toast.LENGTH_SHORT).show()
                return
            }

            selectedFiles.clear()
            selectedFiles.addAll(validUris)

            val names = selectedFiles.joinToString("\n") { getFileName(it) }
            currentUploadedFilesText?.text = names

            val cancelBtn = (currentUploadFileView.rootView as? ViewGroup)
                ?.findViewById<Button>(R.id.model_cancel)
            cancelBtn?.visibility = View.GONE

            // upload to server
            uploadFilesToServer(
                selectedFiles,
                assignid.toString(),
                currentQuestionId.toString(),
                sectionKey.toString(),
                currentUploadedFilesText,
                currentUploadFileView
            )
        }
        if (mediaFile != null) {
            mediaFile!!.delete()
        }
    }

    @Throws(JSONException::class)
    private fun subCat(): String {
        return subcats!!.getJSONObject(tabLayout!!.selectedTabPosition).getString(QuestionTable.SUBCAT)
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        val inflater = menuInflater
        inflater.inflate(R.menu.menu_form, menu)
        return true
    }

    private fun submit() {
        if (MyRequestQueue.getInstance(this).isNoInternet) {
            Log.e("here","here offline")
            alertOffline()
        } else {
            Log.e("here","here loc")
            connectLocation()
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            R.id.done -> if (MyRequestQueue.getInstance(this).isNoInternet) {
                alertOffline()
            } else {
//                Log.e("1","connect location")
                connectLocation()
            }
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    // do work here
//    private val lcoation: Unit
//        private get() {
    private fun lcoation(){
//            Log.e("4","location get() ")
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return
            }
            val requestProgress = RequestProgress.getInstance(this)
            requestProgress.showProgressBar()
            LocationServices.getFusedLocationProviderClient(this).getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY,null).addOnCompleteListener {
                val location = it.result
//                Log.e("location","${lcoation.toString()}")
                if (location != null) {
                    try {
//                        Log.e("5","location get() try")
                        getAddress(location)
                    } catch (e: JSONException) {
                        Toast.makeText(applicationContext, "No lcoation", Toast.LENGTH_SHORT).show()
                        e.printStackTrace()
                    }
                } else {
                    Toast.makeText(applicationContext, "Unable to find lcoation", Toast.LENGTH_SHORT).show()
                }
            }.addOnFailureListener {
                Toast.makeText(applicationContext, "Unable to find lcoation", Toast.LENGTH_SHORT).show()
            }
        }

    private fun connectLocation() {
//        Log.e("2","connect  location inside function")
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 100
        locationRequest.fastestInterval = 100 / 2.toLong()
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())
        task.addOnCompleteListener { task ->
            try {
                val response = task.getResult(ApiException::class.java)
                // All location settings are satisfied. The client can initialize location
//                Log.e("3","connect location inside try")
                lcoation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> alertLocation(exception)
                }
            }
        }
    }


    @Throws(JSONException::class)
    private fun insertAnswers(lat: String, lon: String, address: String) {
//        Log.e("8","insert answers location")
        val database = ServiceDatabase.getInstance(this)
//        Log.e("json master","$masterJSON")
        latitude_data = lat
        longitude_data = lon
        location_data = address
        val masterjsonObj = FormPreviewManager.getFormJson()
//        Log.e("FormPreview","$masterjsonObj")
//        Log.e("other","$id, $date, $cat, $assignid")
        if (sectionKey != "General"){
            for(sectionName in sectionList) {
//                Log.e("9", "inserst answers loc i")
                val jsonArray = database.getQuestions(id, date, cat, assignid, masterjsonObj.optJSONObject(sectionName).getString("sectionId"))
//                Log.e("json array length", "${jsonArray.length()}")
                for (j in 0 until jsonArray.length()) {
//                    Log.e("10", "inserst answers loc j")
                    try {
                        val answerJSON = masterJSON.getJSONObject(sectionName)
                        val questionJSON = jsonArray.getJSONObject(j)
                        val questionId = jsonArray.getJSONObject(j)
                            .getString(FlexibleFormQuestionsTable.QUESTION_ID)
                        val questionType = jsonArray.getJSONObject(j)
                            .getString(FlexibleFormQuestionsTable.ANSWER_TYPE)
                        val jsonObject = JSONObject()
//                        Log.e("answer json", "$answerJSON")
                        if (!answerJSON.has(questionId)) continue

                        val questionAnswer = answerJSON.getJSONObject(questionId)

                        // For multi-part answers (address, multi-choice grid)
                        if (questionAnswer.has("1")) {
                            database.deleteAddress(questionId)
                            for (k in 0 until questionAnswer.length()) {
                                val part = questionAnswer.getJSONObject((k + 1).toString())
                                jsonObject.put(
                                    FlexibleFormResponsesTable.FORM_ID,
                                    questionJSON.getString(FlexibleFormQuestionsTable.FORM_ID)
                                )
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionId)
                                jsonObject.put(
                                    FlexibleFormResponsesTable.OPTION_TEXT,
                                    part.getString("option_text")
                                )
                                jsonObject.put(
                                    FlexibleFormResponsesTable.ROW_INDEX,
                                    part.getString("row_index")
                                )
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(
                                    FlexibleFormResponsesTable.ISSUE,
                                    part.optString("issue", "no")
                                )
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "0")
                                jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
                                jsonObject.put(FlexibleFormResponsesTable.LATITUDE, latitude_data)
                                jsonObject.put(FlexibleFormResponsesTable.LONGITUDE, longitude_data)
                                jsonObject.put(FlexibleFormResponsesTable.LOCATION, location_data)
                                database.insertIntoTable(
                                    jsonObject,
                                    FlexibleFormResponsesTable.TABLENAME
                                )
                            }
                        } else {
                            // Single-value answers (slider, address, date, time, etc.)
                            jsonObject.put(
                                FlexibleFormResponsesTable.FORM_ID,
                                questionJSON.getString(FlexibleFormQuestionsTable.FORM_ID)
                            )
                            jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionId)
                            jsonObject.put(
                                FlexibleFormResponsesTable.OPTION_TEXT,
                                questionAnswer.getString("option_text")
                            )
                            jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, "0")
                            jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                            jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                            jsonObject.put(
                                FlexibleFormResponsesTable.ISSUE,
                                questionAnswer.optString("issue", "no")
                            )
                            jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "0")
                            jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
                            jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
                            jsonObject.put(FlexibleFormResponsesTable.LATITUDE, latitude_data)
                            jsonObject.put(FlexibleFormResponsesTable.LONGITUDE, longitude_data)
                            jsonObject.put(FlexibleFormResponsesTable.LOCATION, location_data)
                            database.deleteAddress(questionId)
                            database.insertIntoTable(
                                jsonObject,
                                FlexibleFormResponsesTable.TABLENAME
                            )
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
        } else {
            for (i in 0 until subcats!!.length()) {
//                Log.e("9", "inserst answers loc i")
//            val subcatId = subcats!!.getJSONObject(i).getString(QuestionTable.SUBCAT)
//            Log.d("subcat Id", subcatId)
                val jsonArray = database.getQuestions(id, date, cat, assignid, sectionID)
//                Log.e("json array length", "${jsonArray.length()}")
                for (j in 0 until jsonArray.length()) {
                    Log.e("10", "inserst answers loc j")
                    try {
                        val answerJSON = masterJSON.getJSONObject(sectionKey)
                        val questionJSON = jsonArray.getJSONObject(j)
                        val questionId = jsonArray.getJSONObject(j)
                            .getString(FlexibleFormQuestionsTable.QUESTION_ID)
                        val questionType = jsonArray.getJSONObject(j)
                            .getString(FlexibleFormQuestionsTable.ANSWER_TYPE)
                        val jsonObject = JSONObject()
//                        Log.e("answer json", "$answerJSON")
//                    if (questionType.equals("address", ignoreCase = true)) {
//                        val addrObj = answerJSON.getJSONObject(questionId)
//                        for (i in 0 until addrObj.length()) {
//                            val lineObj = addrObj.getJSONObject((i+1).toString())
//                            Log.e("","${lineObj.getString("option_text")}")
//                            val jsonObject = JSONObject()
//                            jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(FlexibleFormQuestionsTable.FORM_ID))
//                            jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionId)
//                            jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, lineObj.getString("option_text"))
//                            jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, i)
//                            jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
//                            jsonObject.put(FlexibleFormResponsesTable.ISSUE, lineObj.getString("issue"))
//                            jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
//                            jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                            database.deleteAddress(questionId)
//                            database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
//                        }
//                    } else if (FlexibleFormQuestionsTable.ANSWER_TYPE == "division titledescription" || FlexibleFormQuestionsTable.ANSWER_TYPE == "division image" || FlexibleFormQuestionsTable.ANSWER_TYPE == "division video") {
//
//                    } else {
//                        jsonObject.put(
//                            FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
//                                FlexibleFormQuestionsTable.FORM_ID
//                            )
//                        )
//                        jsonObject.put(
//                            FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
//                                FlexibleFormQuestionsTable.QUESTION_ID
//                            )
//                        )
//                        jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT,
//                            answerJSON.getJSONObject(questionId).getJSONObject((1).toString())
//                                .getString("option_text")
//                        )
//                        jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
//                        jsonObject.put(FlexibleFormResponsesTable.ISSUE,
//                            answerJSON.getJSONObject(questionId).getJSONObject((1).toString())
//                                .getString("issue")
//                        )
//                        jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
//                        jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
////                    jsonObject.put(AnswerTable.REMARKS, answerJSON.getJSONObject(questionId).getString("remarks"))
////                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
////                    {
////                        jsonObject.put(
////                            AnswerTable.REMARKS,
////                            ""
////                        )
////                    }
////                    else {
////                        jsonObject.put(
////                            AnswerTable.REMARKS,
////                            answerJSON.getJSONObject(questionId).getString("remarks")
////                        )
////                    }
////                    jsonObject.put(AnswerTable.PREVIEW, "0")
////                    jsonObject.put(AnswerTable.SYNCED, "0")
////                    jsonObject.put(AnswerTable.LAT, lat)
////                    jsonObject.put(AnswerTable.LON, lon)
////                    jsonObject.put(AnswerTable.LOCATION, address)
////                    jsonObject.put(AnswerTable.DATETIME, Utility.getCurrentDateTime())
//                        database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
//                    }
                        if (!answerJSON.has(questionId)) continue

                        val questionAnswer = answerJSON.getJSONObject(questionId)

                        // For multi-part answers (address, multi-choice grid)
                        if (questionAnswer.has("1")) {
                            database.deleteAddress(questionId)
                            for (k in 0 until questionAnswer.length()) {
                                val part = questionAnswer.getJSONObject((k + 1).toString())
                                jsonObject.put(
                                    FlexibleFormResponsesTable.FORM_ID,
                                    questionJSON.getString(FlexibleFormQuestionsTable.FORM_ID)
                                )
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionId)
                                jsonObject.put(
                                    FlexibleFormResponsesTable.OPTION_TEXT,
                                    part.getString("option_text")
                                )
                                jsonObject.put(
                                    FlexibleFormResponsesTable.ROW_INDEX,
                                    part.getString("row_index")
                                )
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(
                                    FlexibleFormResponsesTable.ISSUE,
                                    part.optString("issue", "no")
                                )
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "0")
                                jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
                                database.insertIntoTable(
                                    jsonObject,
                                    FlexibleFormResponsesTable.TABLENAME
                                )
                            }
                        } else {
                            // Single-value answers (slider, address, date, time, etc.)
                            jsonObject.put(
                                FlexibleFormResponsesTable.FORM_ID,
                                questionJSON.getString(FlexibleFormQuestionsTable.FORM_ID)
                            )
                            jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionId)
                            jsonObject.put(
                                FlexibleFormResponsesTable.OPTION_TEXT,
                                questionAnswer.getString("option_text")
                            )
                            jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, "0")
                            jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                            jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                            jsonObject.put(
                                FlexibleFormResponsesTable.ISSUE,
                                questionAnswer.optString("issue", "no")
                            )
                            jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "0")
                            jsonObject.put(FlexibleFormResponsesTable.SYNCED, "0")
                            jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
                            database.deleteAddress(questionId)
                            database.insertIntoTable(
                                jsonObject,
                                FlexibleFormResponsesTable.TABLENAME
                            )
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
        }
        if (MyRequestQueue.getInstance(this).isNoInternet) {
            setResult(Activity.RESULT_OK)
            finish()
        } else {
            Log.e("11","inserst answers loc insert_answersfun")
            insertAnswers()
        }
    }

    @Throws(JSONException::class)
    private fun getAddress(location: Location) {
//        Log.e("6","get address")
        val mGeocoder = Geocoder(this, Locale.getDefault())
        var addresses: List<Address>? = null
        try {
//            Log.e("7","get address try")
            addresses = mGeocoder.getFromLocation(location.latitude, location.longitude, 1)
            insertAnswers(location.latitude.toString() + "", location.longitude.toString() + "", addresses?.get(0)!!.getAddressLine(0))
//            addresses?.get(0)?.let { insertAnswers(location.latitude.toString() + "", location.longitude.toString() + "", it.getAddressLine(0)) }
        } catch (e: Exception) {
            insertAnswers(location.latitude.toString() + "", location.longitude.toString() + "", "")
            //e.printStackTrace();
        }
    }

    @Throws(JSONException::class)
    private fun insertAnswers() {
//        Log.e("12","inserst answers server")
        val preference = Preference.getInstance(this)
        val database = ServiceDatabase.getInstance(this)
        val list = database.getAnswersList(assignid, cat)

        var inserted = 0
//        val jsonObject:JSONObject= list.get(inserted)

        fun insert(jsonObject: JSONObject){
            val params: MutableMap<String, String> = HashMap()
            jsonObject.put("email", preference.emailId)
            jsonObject.put("facility", id)
            jsonObject.put("cat", cat)
            jsonObject.put("lat",latitude_data)
            jsonObject.put("lon",longitude_data)
            jsonObject.put("location",location_data)
            params["JSON"] = jsonObject.toString()
//            Log.e("params","$params")
            MyRequestQueue.getInstance(this).addToQueue(SERVICEURL.INSERT_ANSWERS, params) { response ->
                try {
                    inserted++
//                    Log.d("list and inserted","${list.size},${inserted}")
                    if(inserted < list.size){
                        insert(list.get(inserted))
//                        Log.d("if","if")
                    }else{
                        insertAnswers(JSONObject(response))
//                        Log.d("else","else")
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        }
        insert(list.get(inserted) )
    }

    @Throws(JSONException::class)
    private fun insertAnswers(jsonObject: JSONObject) {
        if (jsonObject.getInt("s") == 1) {
            ServiceDatabase.getInstance(this).updateSynced(assignid, cat)
        }
        setResult(Activity.RESULT_OK)
        FormAnswerManager.formAnswers.clear()
        FormPreviewManager.formAnswers.clear()
        finish()
    }

    private fun alertOffline() {
        val builder = AlertDialog.Builder(this)

        /*  builder.setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // User clicked OK button
              connectLocation();
            }
        });*/builder.setNegativeButton("CLOSE") { dialog, id ->
            // User clicked OK button
        }
        builder.setTitle("No Internet Connection")
        //builder.setMessage("Save answers in offline");
        val dialog = builder.create()
        dialog.show()
        connectLocation()
    }

    private fun alertLocation(exception: ApiException) {
        val builder = AlertDialog.Builder(this)
        builder.setNegativeButton("OK") { dialog, id ->
            try {
                val resolvable = exception as ResolvableApiException
                resolvable.startResolutionForResult(
                        this@PreviewActivity,
                        REQUEST_CHECK_SETTINGS)
            } catch (e: SendIntentException) {
                // Ignore the error.
            } catch (e: ClassCastException) {
                // Ignore, should be an impossible error.
            }
        }
        builder.setMessage("Please enable your location")
        val dialog = builder.create()
        dialog.show()
    }

    override fun onBackPressed() {
        val builder = AlertDialog.Builder(this)
        builder.setPositiveButton("LEAVE") { dialog, id -> // User clicked OK button
            setResult(Activity.RESULT_OK)
            ServiceDatabase.getInstance(this).deleteResponses(assignid, currentFormId)
            FormAnswerManager.formAnswers.clear()
            FormPreviewManager.formAnswers.clear()
            finish()
        }
        builder.setNegativeButton("STAY") { dialog, id ->
            // User clicked OK button
        }
        builder.setMessage("Back button pressed!")
        val dialog = builder.create()
        dialog.show()
    }

    companion object {
        private const val CAPTURE_NUMBER = 2
        const val REQUEST_CHECK_SETTINGS = 3
    }
}