package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.adapter.ProductCombinationAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;

import org.json.JSONArray;
import org.json.JSONException;

public class ProductCombinationActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    TextView errorText;
    ProductCombinationAdapter adapter;
    String id,date,assignid;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_productcombination);
        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Products");
        id=getIntent().getStringExtra("id");
        date=getIntent().getStringExtra("date");
        assignid=getIntent().getStringExtra("assignid");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getProducts();
    }

    private void getProducts(){
        jsonArray= ServiceDatabase.getInstance(this).getCombinations(id,date);
        if(jsonArray.length()==0){
            finish();
        }
        adapter=new ProductCombinationAdapter(this,jsonArray);
        recyclerView.setAdapter(adapter);
        if(jsonArray.length()==0){
            errorText.setText("No Inspections");
            errorText.setVisibility(View.VISIBLE);
        }else if(errorText.getVisibility()==View.VISIBLE){
            errorText.setVisibility(View.GONE);
        }
    }

    @Override
    public void itemClicked(int position) {
            Intent intent=new Intent(getApplicationContext(),CategoryActivity.class);
            intent.putExtra("id",id);
            intent.putExtra("date",date);
        try {
            intent.putExtra("assignid",jsonArray.getJSONObject(position).getString(AssignTable.ASSIGNID));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
