package com.b2lmobitech.fieldcloudplus.service.activities

//import android.util.Log
import android.app.Activity
import android.app.DatePickerDialog
import android.app.DatePickerDialog.OnDateSetListener
import android.app.TimePickerDialog
import android.app.TimePickerDialog.OnTimeSetListener
import android.content.Intent
import android.content.res.Resources
import android.gesture.GestureOverlayView
import android.graphics.Bitmap
import android.graphics.Color
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.ColorDrawable
import android.graphics.drawable.Drawable
import android.net.Uri
import android.os.Bundle
import android.provider.MediaStore
import android.provider.OpenableColumns
import android.text.Editable
import android.text.InputFilter
import android.text.InputFilter.LengthFilter
import android.text.InputType
import android.text.TextWatcher
import android.util.Log
import android.view.*
import android.widget.*
import android.widget.AdapterView.OnItemSelectedListener
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.content.FileProvider
import androidx.core.widget.NestedScrollView
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.service.adapter.RankingAdapter
import com.b2lmobitech.fieldcloudplus.service.sql.DbSection
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormOptionsTable
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormQuestionsTable
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormResponsesTable
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable
import com.b2lmobitech.fieldcloudplus.task.others.Utility
import com.b2lmobitech.fieldcloudplus.utils.toBase64String
import com.b2lmobitech.fieldcloudplus.utils.toBitmap
import com.bumptech.glide.Glide
import com.google.android.material.tabs.TabLayout
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.File
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*
import android.widget.TextView
import android.widget.Toast
import com.b2lmobitech.fieldcloudplus.service.others.ApiService
import com.b2lmobitech.fieldcloudplus.service.others.FormAnswerManager
import com.b2lmobitech.fieldcloudplus.service.others.UploadResponse
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.MultipartBody
import okhttp3.RequestBody.Companion.toRequestBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.io.ByteArrayOutputStream
import kotlin.toString

class QuestionActivity : AppCompatActivity() {
    var id: String? = null
    var date: String? = null
    var cat: String? = null
    var assignid: String? = null
    var mainLayout: LinearLayout? = null
    var masterJSON = JSONObject()
    var nestedScrollView: NestedScrollView? = null
    var imageUri: Uri? = null
    var cameraQuestionId: String? = null
    var imageView: ImageView? = null
    var mediaFile: File? = null
    var tabLayout: TabLayout? = null
    var subcats: JSONArray = JSONArray()
    var sectionKey: String ? = "General"
    var sectionID: String? = null
    private var currentQuestionId: String? = null
    private var currentUploadedFilesText: TextView? = null
    var sectionList: MutableList<String> = mutableListOf()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_question)
        id = intent.getStringExtra("id")
        date = intent.getStringExtra("date")
        cat = intent.getStringExtra("cat")
        assignid = intent.getStringExtra("assignid")
        mainLayout = findViewById(R.id.mainLayout)
        nestedScrollView = findViewById(R.id.nestedScrollView)
        tabLayout = findViewById(R.id.tablayout)
        val toolbar = findViewById<Toolbar>(R.id.toolbar)
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = ""
        try {
            addTabs()
        } catch (e: JSONException) {
            e.printStackTrace()
        }
        initCallbacks()
    }

    @Throws(JSONException::class)
    private fun addTabs() {
        val database = ServiceDatabase.getInstance(this)
        subcats = database.getSubCategories(id, date, cat, assignid)

        val formId = subcats.getJSONObject(0).getString(QuestionTable.FORM_ID)

        // Fetch section IDs and names
        val sections: List<DbSection> = database.getSections(formId)

        // Fallback: if no sections, create a "General" section with null ID
        val finalSections: List<DbSection> =
            if (sections.isEmpty()) listOf(DbSection(null, "General")) else sections

        for ((index, section) in finalSections.withIndex()) {
            val jsonObject = JSONObject()
            jsonObject.put("filled", false)
            jsonObject.put("sectionId", section.id)
            masterJSON.put(section.name, jsonObject)

            tabLayout!!.addTab(
                tabLayout!!.newTab().setText(section.name),
                index == 0
            )
            sectionList.add(section.name)
        }

        // Load questions for the first tab
        try {
            val firstSection = finalSections[0]
            getQuestions(formId, firstSection.id, firstSection.name) // pass ID (can be null for General)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        tabLayout!!.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
            override fun onTabSelected(tab: TabLayout.Tab) {
                try {
                    val section = finalSections[tab.position]
                    getQuestions(formId, section.id, section.name) // ID will decide which questions to load
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {}
            override fun onTabReselected(tab: TabLayout.Tab) {}
        })
    }


//    @Throws(JSONException::class)
//    private fun getQuestions(subcat: String) {
//        val serviceDatabase = ServiceDatabase.getInstance(this)
//        val questionArray = serviceDatabase.getQuestions(id, date, cat, subcat, assignid)
////        Log.d("JSON_before", questionArray.toString())
//        Log.d("JSON_before", masterJSON.toString())
//        mainLayout!!.removeAllViews()
//        for (i in 0 until questionArray.length()) {
//            val jsonObject = questionArray.getJSONObject(i)
//            if (!masterJSON.getJSONObject(subcat).getBoolean("filled")) {
//                val answerJson = JSONObject()
//                answerJson.put("answered", false)
//                masterJSON.getJSONObject(subcat).put(jsonObject.getString(QuestionTable.NUMBER), answerJson)
//            }
//            val j = i + 1
//            when (jsonObject.getString(QuestionTable.TYPE).toLowerCase()) {
//                "edittext", "integer" -> editText(j, jsonObject)
//                "dropdown" -> setSpinner(j, jsonObject)
//                "date", "time" -> datetime(j, jsonObject)
//                "signature" -> setSignature(j, jsonObject)
//                "image" -> camera(j, jsonObject)
//                "boolean" -> radioBox(j, jsonObject)
//            }
//        }
//        Log.d("JSON_after", masterJSON.toString())
//        masterJSON.put(subcat, masterJSON.getJSONObject(subcat).put("filled", true))
//        Log.d("JSON_end", masterJSON.toString())
//    }
    @Throws(JSONException::class)
    private fun getQuestions(formId: String, sectionId: String?, sectionName: String?) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
//        Log.d("dummydata","${id}, $date,$cat,$assignid,$sectionId}")
        val questionArray = serviceDatabase.getQuestions(id, date, cat, assignid, sectionId)
        sectionID = sectionId ?: null
        sectionKey = sectionName ?: "General"
        if (!masterJSON.has(sectionKey)) {
            masterJSON.put(sectionKey, JSONObject().put("filled", false))
        }

        val sectionJSON = masterJSON.getJSONObject(sectionKey)
//        Log.d("JSON_before", questionArray.toString())
//        Log.d("JSON_before2", masterJSON.toString())
        mainLayout!!.removeAllViews()
        for (i in 0 until questionArray.length()) {
            val jsonObject = questionArray.getJSONObject(i)
            val qId = jsonObject.getString(FlexibleFormQuestionsTable.QUESTION_ID)

            if (!sectionJSON.has(qId)) {
                sectionJSON.put(qId, JSONObject().put("answered", false))
            }
            val j = i + 1
//            Log.d("dummyquestion","$j, ${jsonObject.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).toLowerCase()}")
            when (jsonObject.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).toLowerCase()) {
                "edittext", "integer", "single line text", "multiline text", "number", "email", "phone", "website", "currency", "decimal" -> editText(j, jsonObject)
                "dropdown" -> dropDown(j, jsonObject)
                "date", "time", "datetime", "monthyear" -> datetime(j, jsonObject)
                "signature" -> setSignature(j, jsonObject)
                "image" -> camera(j, jsonObject)
                "boolean" -> radioBox(j, jsonObject)
                "file upload" -> fileUpload(j, jsonObject)
                "single choice" -> singleChoice(j, jsonObject)
                "multiple choice" -> multipleChoice(j, jsonObject)
                "address" -> address(j, jsonObject)
                "random", "unique" -> uniqueId(j, jsonObject)
                "first last name" -> fullName(j, jsonObject)
                "slider" -> sliderQuestion(j, jsonObject)
                "linear scale" -> linearScale(j, jsonObject)
                "net promoter score" -> netPromoterScoreBoxes(j, jsonObject)
                "rating" -> ratingQuestion(j, jsonObject)
                "single choice grid" -> singleChoiceGrid(j, jsonObject)
                "multiple choice grid" -> multipleChoiceGrid(j, jsonObject)
                "single choice image" -> singleChoiceImage(j, jsonObject)
                "multiple choice image" -> multipleChoiceImage(j, jsonObject)
                "ranking" -> rankingQuestion(j, jsonObject)
                "division titledescription" -> divisionTitle(j, jsonObject)
                "division image" -> divisionImage(j, jsonObject)
                "division video" -> divisionVideo(j, jsonObject)
            }
        }

//        for (i in 0 until questionArray.length()) {
//            val question = questionArray.getJSONObject(i)
//            val questionText = question.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
//            val answerType = question.getString(FlexibleFormQuestionsTable.ANSWER_TYPE)
//
//            Log.d("dummyquestion", "${i + 1}, $answerType, $questionText")
//
//            // For now, just show all questions as text
//            editText(i + 1, question)
//        }


//        Log.d("JSON_after", masterJSON.toString())
        masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put("filled", true))
//        Log.d("JSON_end", masterJSON.toString())
    }

    @Throws(JSONException::class)
    private fun editText(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_edittext, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val editText = view.findViewById<EditText>(R.id.text_input)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("titleQuestion","${title.text}")
//        val options = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()
        if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("edittext", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("single line text", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
            editText.hint = "Single Line"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("multiline text", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_TEXT_FLAG_MULTI_LINE
            editText.hint = "Multiple Lines"
            editText.setSingleLine(false)
            editText.minLines = 2
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("email", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS or InputType.TYPE_CLASS_TEXT
            editText.hint = "Email"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("integer", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("number", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
            editText.hint = "Number"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("phone", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_PHONE
            editText.hint = "Phone"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("decimal", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_NUMBER_FLAG_DECIMAL or InputType.TYPE_CLASS_NUMBER
            editText.hint = "Decimal"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("currency", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_NUMBER
            editText.hint = "Currency ₹"
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("website", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
            editText.hint = "Website link"
        }
        val filter = arrayOfNulls<InputFilter>(1)
//        filter[0] = LengthFilter(json.getInt(QuestionTable.COUNT))
        filter[0] = LengthFilter(200)
        editText.filters = filter
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                editText.setText(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer"))
            }
        }
        editText.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}
            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {}
            override fun afterTextChanged(s: Editable) {
                try {
                    val answerJson = JSONObject()
                    answerJson.put("answer", s)
                    answerJson.put("answered", true)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")
                    masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        })
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun address(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_addresstext, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val editTexts = listOf(
            view.findViewById<EditText>(R.id.text_input1),
            view.findViewById<EditText>(R.id.text_input2),
            view.findViewById<EditText>(R.id.text_input3),
            view.findViewById<EditText>(R.id.text_input4),
            view.findViewById<EditText>(R.id.text_input5),
            view.findViewById<EditText>(R.id.text_input6)
        )

        val labels = listOf("Address Line 1", "Address Line 2", "City", "State", "Country", "Pincode")

        if (masterJSON.optJSONObject(sectionKey)?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))?.optBoolean("answered") == true) {
            val savedArray = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                .getJSONArray("answer")

            for (i in 0 until editTexts.size) {
                if (i < savedArray.length()) {
                    editTexts[i].setText(savedArray.getJSONObject(i).optString("value", ""))
                }
            }
        }

        editTexts.forEachIndexed { index, et ->
            et.hint = labels[index]
            et.inputType = InputType.TYPE_CLASS_TEXT

            et.addTextChangedListener(object : TextWatcher {
                override fun afterTextChanged(s: Editable) {
                    try {
                        val answerJson = JSONObject()
                        val addrArray = JSONArray()

                        editTexts.forEachIndexed { index, e ->
                            val part = JSONObject()
                            part.put("label", labels[index])
                            part.put("value", e.text.toString())
                            addrArray.put(part)
                        }

                        answerJson.put("answer", addrArray)
                        answerJson.put("answered", true)
                        answerJson.put("issue", "no")
                        answerJson.put("remarks", "")

                        masterJSON.put(
                            sectionKey,
                            masterJSON.getJSONObject(sectionKey).put(
                                json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                                answerJson
                            )
                        )
                        FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }

                override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}
                override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {}
            })
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun fullName(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_fullname, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val editTexts = listOf(
            view.findViewById<EditText>(R.id.text_input7),
            view.findViewById<EditText>(R.id.text_input8)
        )

        val labels = listOf("First Name", "Last Name")

        if (masterJSON.optJSONObject(sectionKey)?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))?.optBoolean("answered") == true) {
            val savedArray = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                .getJSONArray("answer")

            for (i in 0 until editTexts.size) {
                if (i < savedArray.length()) {
                    editTexts[i].setText(savedArray.getJSONObject(i).optString("value", ""))
                }
            }
        }

        editTexts.forEachIndexed { index, et ->
            et.hint = labels[index]
            et.inputType = InputType.TYPE_CLASS_TEXT

            et.addTextChangedListener(object : TextWatcher {
                override fun afterTextChanged(s: Editable) {
                    try {
                        val answerJson = JSONObject()
                        val addrArray = JSONArray()

                        editTexts.forEachIndexed { index, e ->
                            val part = JSONObject()
                            part.put("label", labels[index])
                            part.put("value", e.text.toString())
                            addrArray.put(part)
                        }

                        answerJson.put("answer", addrArray)
                        answerJson.put("answered", true)
                        answerJson.put("issue", "no")
                        answerJson.put("remarks", "")

                        masterJSON.put(
                            sectionKey,
                            masterJSON.getJSONObject(sectionKey).put(
                                json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                                answerJson
                            )
                        )
                        FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }

                override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}
                override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {}
            })
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun uniqueId(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)
        val view = layoutInflater!!.inflate(R.layout.model_edittext, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val editText = view.findViewById<EditText>(R.id.text_input)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("titleQuestion","${title.text}")
//        val options = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()

        if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("unique", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
            editText.isFocusable = false
            editText.isClickable = false

            val optionTexts = mutableListOf<String>()
            val optionTypes = mutableListOf<String>()
            for (i in 0 until optionsArray.length()) {
                val option = optionsArray.getJSONObject(i)
                if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                    optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                    optionTypes.add(option.getString(FlexibleFormOptionsTable.OPTION_TYPE))
                }
            }

            if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
                if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                    editText.setText(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer"))
                }
            }

//            Log.d("options","$optionsArray")
            val prefix = optionTexts.getOrNull(optionTypes.indexOf("prefix")) ?: ""
            val suffix = optionTexts.getOrNull(optionTypes.indexOf("suffix")) ?: ""
            val lastNumber = serviceDatabase.getLastNumberPart(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), prefix, suffix)
            val newNumber = lastNumber + 1
            val uniqueId = "$prefix$newNumber$suffix"
            editText.setText(uniqueId)

            if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
                if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                    editText.setText(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer"))
                }
            }

            val answerJson = JSONObject()
            answerJson.put("answer", uniqueId)
            answerJson.put("answered", true)
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")
            masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("random", ignoreCase = true)) {
            editText.inputType = InputType.TYPE_CLASS_TEXT
            editText.hint = "Random Id"
            val randomId = (100000..999999).random()
            editText.setText(randomId.toString())
            editText.isFocusable = false
            editText.isClickable = false

            val answerJson = JSONObject()
            answerJson.put("answer", randomId.toString())
            answerJson.put("answered", true)
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")
            masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        }
        val filter = arrayOfNulls<InputFilter>(1)
//        filter[0] = LengthFilter(json.getInt(QuestionTable.COUNT))
        filter[0] = LengthFilter(200)
        editText.filters = filter
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                editText.setText(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer"))
            }
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun sliderQuestion(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_slider, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val slider = view.findViewById<SeekBar>(R.id.slider)
        val label = view.findViewById<TextView>(R.id.slider_value)

        // Question title
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Configure slider range (if you have min/max from DB, set it dynamically)
        slider.max = 100
        slider.progress = 0
        label.text = "Value: 0"

        // Restore if already filled

        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON
                .getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj.getBoolean("answered")) {
                val savedValue = ansObj.getString("answer").toIntOrNull() ?: 0
                slider.progress = savedValue
                label.text = "Value: $savedValue"
            }
        }

        slider.setOnSeekBarChangeListener(object : SeekBar.OnSeekBarChangeListener {
            override fun onProgressChanged(seekBar: SeekBar, progress: Int, fromUser: Boolean) {
                label.text = "Value: $progress"
                try {
                    val answerJson = JSONObject()
                    answerJson.put("answer", progress.toString())
                    answerJson.put("answered", true)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")

                    masterJSON.put(
                        sectionKey,
                        masterJSON.getJSONObject(sectionKey).put(
                            json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                            answerJson
                        )
                    )
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }

            override fun onStartTrackingTouch(seekBar: SeekBar) {}
            override fun onStopTrackingTouch(seekBar: SeekBar) {}
        })

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun linearScale(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_linearscale, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val radioGroup = view.findViewById<RadioGroup>(R.id.radio_group)
        val leftLabel = view.findViewById<TextView>(R.id.left_label)
        val rightLabel = view.findViewById<TextView>(R.id.right_label)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        var range = "1-5"
        val linearLabels = mutableListOf<String>()

        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                    "linear-range" -> range = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                    "linear-label" -> linearLabels.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                }
            }
        }

        val left = if (linearLabels.isNotEmpty()) linearLabels[0] else "Less Likely"
        val right = if (linearLabels.size > 1) linearLabels[1] else "MoreLikely"

        leftLabel.text = left
        rightLabel.text = right

        // Parse range
        val parts = range.split("-")
        val start = parts[0].toInt()
        val end = parts[1].toInt()

        // Add radio buttons dynamically
        for (num in start..end) {
            val rb = RadioButton(this)
            rb.text = num.toString()
            rb.id = View.generateViewId()
            radioGroup.addView(rb)
        }

        // Restore saved answer if any
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj.getBoolean("answered")) {
                val saved = ansObj.getString("answer")
                for (i in 0 until radioGroup.childCount) {
                    val rb = radioGroup.getChildAt(i) as RadioButton
                    if (rb.text.toString() == saved) {
                        rb.isChecked = true
                        break
                    }
                }
            }
        }

        // Handle selection
        radioGroup.setOnCheckedChangeListener { group, checkedId ->
            val rb = group.findViewById<RadioButton>(checkedId)
            val selected = rb.text.toString()

            val answerJson = JSONObject()
            answerJson.put("answer", selected)
            answerJson.put("answered", true)
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")

            masterJSON.put(
                sectionKey,
                masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            )
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun dropDown(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        // Inflate layout (make one like model_dropdown.xml)
        val view = layoutInflater!!.inflate(R.layout.model_spinner, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val spinner = view.findViewById<Spinner>(R.id.spinner)

        // Question title
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Collect all option_texts for this question_id
        val optionTexts = mutableListOf<String>()
        val optionIds = mutableListOf<String>()
        optionTexts.add("Select Answer")
        optionIds.add("")
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
            }
        }

        // Setup adapter
//        val adapter = ArrayAdapter(this, android.R.layout.simple_spinner_item, optionTexts)
//        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
//        spinner.adapter = adapter

        val spinnerArrayAdapter: ArrayAdapter<String> = object : ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, optionTexts) {
            override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
                val mView = super.getDropDownView(position, convertView, parent)
                val mTextView = mView as TextView
                if (position == 0) {
                    mTextView.setTextColor(Color.GRAY)
                } else {
                    mTextView.setTextColor(Color.BLACK)
                }
                return mView
            }

            override fun isEnabled(position: Int): Boolean {
                return position != 0
            }
        } //selected item will look like a spinner set from XML
        spinnerArrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        spinner.adapter = spinnerArrayAdapter

        // Restore saved answer if any
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj.getBoolean("answered")) {
                val saved = ansObj.getString("answer")
//                Log.e("saved dropdown","$saved")
                val pos = optionIds.indexOf(saved)
                if (pos >= 0) spinner.setSelection(pos)
            }
        }

        // Handle selection
        spinner.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onItemSelected(parent: AdapterView<*>, view: View?, position: Int, id: Long) {
                val selected = optionIds[position]

                val answerJson = JSONObject()
                answerJson.put("answer", selected)
                answerJson.put("answered", true)
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")

                masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            }

            override fun onNothingSelected(parent: AdapterView<*>) {}
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun netPromoterScoreBoxes(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_netpromoter_boxes, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val container = view.findViewById<LinearLayout>(R.id.box_container)
        val leftLabel = view.findViewById<TextView>(R.id.label_left)
        val rightLabel = view.findViewById<TextView>(R.id.label_right)
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        leftLabel.text = if (optionsArray.length() > 0) optionsArray.getJSONObject(0).getString("option_text") else "Less Likely"
        rightLabel.text = if (optionsArray.length() > 1) optionsArray.getJSONObject(1).getString("option_text") else "More Likely"

        var selectedValue: String? = null

        val savedAnswer = if (masterJSON.optJSONObject(sectionKey)
                ?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                ?.optBoolean("answered") == true
        ) {
            masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                .getString("answer")
        } else null

        // Create 0–10 boxes
        for (i in 1..10) {
            val box = TextView(this)
            box.text = i.toString()
            box.gravity = Gravity.CENTER
            box.setPadding(24, 24, 24, 24)
            box.setBackgroundResource(R.drawable.nps_box_unselected)
            box.setTextColor(Color.BLACK)

            val params = LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.WRAP_CONTENT,
                LinearLayout.LayoutParams.WRAP_CONTENT
            )
            params.setMargins(8, 8, 8, 8)
            box.layoutParams = params

            if (savedAnswer != null && savedAnswer == box.text.toString()) {
                box.setBackgroundResource(R.drawable.nps_box_selected)
                box.setTextColor(Color.WHITE)
                selectedValue = savedAnswer
            }

            box.setOnClickListener {
                // Reset all boxes
                for (j in 0 until container.childCount) {
                    val child = container.getChildAt(j) as TextView
                    child.setBackgroundResource(R.drawable.nps_box_unselected)
                    child.setTextColor(Color.BLACK)
                }
                // Highlight selected
                box.setBackgroundResource(R.drawable.nps_box_selected)
                box.setTextColor(Color.WHITE)

                selectedValue = box.text.toString()

                // Save JSON
                val answerJson = JSONObject()
                answerJson.put("answer", selectedValue)
                answerJson.put("answered", true)
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")
                masterJSON.put(
                    sectionKey,
                    masterJSON.getJSONObject(sectionKey)
                        .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                )

                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            }

            container.addView(box)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun ratingQuestion(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_rating, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val ratingContainer = view.findViewById<LinearLayout>(R.id.rating_container)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        var symbol = "star"
        var count = 5

        // Parse option_text like "5-star", "7-heart", "3-smiley"
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                val optionText = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                if (optionText.contains("-")) {
                    val parts = optionText.split("-")
                    count = parts[0].toIntOrNull() ?: 5
                    symbol = parts[1] // star, heart, smiley, trophy, ribbon...
                }
            }
        }

        // Create icons dynamically
        val icons = mutableListOf<ImageView>()
        for (i in 1..count) {
            val icon = ImageView(this)
            val params = LinearLayout.LayoutParams(100, 100)
            params.setMargins(8, 8, 8, 8)
            icon.layoutParams = params

            icon.setImageResource(getUnselectedIcon(symbol))
            icon.tag = i

            icon.setOnClickListener {
                val selected = it.tag as Int

                // highlight up to selected
                for (j in icons.indices) {
                    if (j < selected) {
                        icons[j].setImageResource(getSelectedIcon(symbol))
                    } else {
                        icons[j].setImageResource(getUnselectedIcon(symbol))
                    }
                }

                // save into masterJSON (option_text = number)
                val answerJson = JSONObject().apply {
                    put("answer", selected.toString())
                    put("answered", true)
                    put("issue", "no")
                    put("remarks", "")
                }

                masterJSON.put(
                    sectionKey,
                    masterJSON.getJSONObject(sectionKey)
                        .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                )

                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            }

            icons.add(icon)
            ratingContainer.addView(icon)
        }

        // Restore saved response
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj.getBoolean("answered")) {
                val saved = ansObj.getString("answer").toInt()
                for (j in icons.indices) {
                    if (j < saved) {
                        icons[j].setImageResource(getSelectedIcon(symbol))
                    } else {
                        icons[j].setImageResource(getUnselectedIcon(symbol))
                    }
                }
            }
        }

        mainLayout!!.addView(view)
    }

    // helper functions
    private fun getSelectedIcon(symbol: String): Int {
        return when (symbol.lowercase()) {
            "heart" -> R.drawable.ic_heart_filled
            "smiley" -> R.drawable.ic_smiley_filled
            "thumbsup" -> R.drawable.ic_thumbsup_filled
            "trophy" -> R.drawable.ic_trophy_filled
            "ribbon" -> R.drawable.ic_ribbon_filled
            else -> R.drawable.ic_star_filled
        }
    }

    private fun getUnselectedIcon(symbol: String): Int {
        return when (symbol.lowercase()) {
            "heart" -> R.drawable.ic_heart_outline
            "smiley" -> R.drawable.ic_smiley_outline
            "thumbsup" -> R.drawable.ic_thumbsup_outline
            "trophy" -> R.drawable.ic_trophy_outline
            "ribbon" -> R.drawable.ic_ribbon_outline
            else -> R.drawable.ic_star_outline
        }
    }


    @Throws(JSONException::class)
    private fun radioBox(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_radiobox, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.cb_title)
        val R_Remarks = view.findViewById<EditText>(R.id.R_Remarks)
        val bu_r_remarks = view.findViewById<ImageView>(R.id.bu_r_remarks)
        title.text = String.format(Locale.getDefault(), "%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        val radioGroup = view.findViewById<RadioGroup>(R.id.radio_group)
        val options2 = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()
        val arrayList = ArrayList<String>()
        bu_r_remarks.setOnClickListener(View.OnClickListener {
            if(R_Remarks.visibility == View.VISIBLE)
            {
                R_Remarks.visibility = View.GONE
            }
            else
            {
                R_Remarks.visibility = View.VISIBLE
            }
        })
        for (anOptions2 in options2) {
            if (!anOptions2.isEmpty()) {
                arrayList.add(anOptions2)
            }
        }
        for (i in arrayList.indices) {

            val radioButton = RadioButton(this)
            radioButton.text = arrayList[i]
            radioButton.gravity = Gravity.CENTER_VERTICAL

//            answerJson.put("remarks", "")
            val answerJson = JSONObject()
            R_Remarks.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                    if (s.length >= 500)
                    {
                        Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                    }
                }
                override fun afterTextChanged(s: Editable) {
                    try {

                        answerJson.put("remarks", s.toString())
                        if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                            masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).put("remarks",s.toString())
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            })
            radioButton.setOnClickListener {
//                val answerJson = JSONObject()
                R_Remarks.addTextChangedListener(object : TextWatcher {
                    override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                        if (s.length >= 500)
                        {
                            Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                        }
                    }
                    override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                        if (s.length >= 500)
                        {
                            Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                        }
                    }
                    override fun afterTextChanged(s: Editable) {
                        try {

                            answerJson.put("remarks", s.toString())
                            if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                                masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).put("remarks",s.toString())
                            }

                        } catch (e: JSONException) {
                            e.printStackTrace()
                        }
                    }
                })
                try {
//                    val answerJson = JSONObject()
                    answerJson.put("answer", arrayList[i])
                    if (json.getInt(QuestionTable.CORRECTANSER) == i + 1) {
                        answerJson.put("issue", "no")
                    } else {
                        answerJson.put("issue", "yes")
                    }
                    answerJson.put("answered", true)
//                    answerJson.put("remarks", R_Remarks.text.toString())
                    if(R_Remarks.text==null)
                    {
                        answerJson!!.put("remarks", "")
                    }
                    else {
                        answerJson!!.put("remarks", R_Remarks.text.toString())
                    }
                    masterJSON.put(subCat(), masterJSON.getJSONObject(subCat()).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), answerJson))
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
            radioGroup.addView(radioButton)
            if (masterJSON.getJSONObject(subCat()).getBoolean("filled")) {
                if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                    if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getString("answer").equals(arrayList[i], ignoreCase = true)) {
                        radioButton.isChecked = true
                        R_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getString("remarks"))
                    }
                }
            }
        }
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun setSpinner(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_spinner, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val spinner = view.findViewById<Spinner>(R.id.spinner)
        val S_Remarks = view.findViewById<EditText>(R.id.S_Remarks)
        val bu_s_remarks = view.findViewById<ImageView>(R.id.bu_s_remarks)
        title.text = String.format(Locale.getDefault(), "%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        val options = json.getString(QuestionTable.OPTIONS).split("#@").toTypedArray()
        val arrayList = ArrayList<String>()
        bu_s_remarks.setOnClickListener(View.OnClickListener {
            if(S_Remarks.visibility == View.VISIBLE)
            {
                S_Remarks.visibility = View.GONE
            }
            else
            {
                S_Remarks.visibility = View.VISIBLE
            }
        })
        for (anOptions2 in options) {
            if (anOptions2.isEmpty()) {
                arrayList.add("Select")
            } else {
                arrayList.add(anOptions2)
            }
        }
        val spinnerArrayAdapter: ArrayAdapter<String> = object : ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, arrayList) {
            override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
                val mView = super.getDropDownView(position, convertView, parent)
                val mTextView = mView as TextView
                if (position == 0) {
                    mTextView.setTextColor(Color.GRAY)
                } else {
                    mTextView.setTextColor(Color.BLACK)
                }
                return mView
            }

            override fun isEnabled(position: Int): Boolean {
                return position != 0
            }
        } //selected item will look like a spinner set from XML
        spinnerArrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        spinner.adapter = spinnerArrayAdapter
        val answerJson = JSONObject()
//        answerJson.put("remarks", "")

        S_Remarks.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {
                if (s.length >= 500)
                {
                    Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                }
            }

            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                if (s.length >= 500)
                {
                    Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                }
            }
            override fun afterTextChanged(s: Editable) {
                try {

                    answerJson.put("remarks", s.toString())
//                    Log.d("answerJson",answerJson.toString())
                    if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                        masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).put("remarks",s.toString())
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        })

        var check:Int = 0
        spinner.onItemSelectedListener = object : OnItemSelectedListener {
            override fun onItemSelected(adapterView: AdapterView<*>?, view: View, i: Int, l: Long) {
                if (++check > 1) {
//                    val answerJson = JSONObject()
                    S_Remarks.addTextChangedListener(object : TextWatcher {
                        override fun beforeTextChanged(
                            s: CharSequence,
                            start: Int,
                            count: Int,
                            after: Int
                        ) {
                            if (s.length >= 500)
                            {
                                Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                            }
                        }

                        override fun onTextChanged(
                            s: CharSequence,
                            start: Int,
                            before: Int,
                            count: Int
                        ) {
                            if (s.length >= 500)
                            {
                                Toast.makeText(applicationContext, "Remarks cannot exceed more than 500 characters", Toast.LENGTH_SHORT).show()
                            }
                        }

                        override fun afterTextChanged(s: Editable) {
                            try {
//                                Log.d("answerJson2",answerJson.toString())
                                answerJson.put("remarks", s.toString())
                                if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                                    masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).put("remarks",s.toString())
                                }
                            } catch (e: JSONException) {
                                e.printStackTrace()
                            }
                        }
                    })
                    try {
//                    val answerJson = JSONObject()
                        answerJson.put("answer", options[i])
                        if (json.getInt(QuestionTable.CORRECTANSER) == i + 1) {
                            answerJson.put("issue", "no")
                        } else {
                            answerJson.put("issue", "yes")
                        }
                        answerJson.put("answered", true)
//                        answerJson.put("remarks", S_Remarks.text.toString())
//                        Log.d("answerJson3",answerJson.toString())
                        if(S_Remarks.text==null)
                        {
                            answerJson!!.put("remarks", "")
                        }
                        else {
                            answerJson!!.put("remarks", S_Remarks.text.toString())
                        }
                        masterJSON.getJSONObject(subCat())
                            .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER), answerJson)
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            }
            override fun onNothingSelected(adapterView: AdapterView<*>?) {}
        }


        if (masterJSON.getJSONObject(subCat()).getBoolean("filled")) {
            if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                for (i in options.indices) {
                    if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getString("answer").equals(options[i], ignoreCase = true)) {
                        spinner.setSelection(i)
                        S_Remarks.setText(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getString("remarks"))
                    }
                }
            }
        }
        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun camera(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_camera, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        val openCamera = view.findViewById<ImageView>(R.id.open_camera)
        val snappedImage = view.findViewById<ImageView>(R.id.snapped_image)
        openCamera.setOnClickListener {
            try {
                cameraQuestionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
            captureImage()
            imageView = snappedImage

        }
        if (masterJSON.getJSONObject(subCat()).getBoolean("filled")) {
            if (masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER)).getBoolean("answered")) {
                snappedImage.setImageBitmap(Utility.bitmap(masterJSON.getJSONObject(subCat()).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ORDER))
                    .getString("answer")))
            }
        }
        mainLayout!!.addView(view)
    }

//    @Throws(JSONException::class)
//    private fun setSignature(n: Int, json: JSONObject) {
//        val view = layoutInflater!!.inflate(R.layout.model_signature, mainLayout, false)
//        val title = view.findViewById<TextView>(R.id.text_title)
//        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        val gues = view.findViewById<GestureOverlayView>(R.id.signaturePad)
//        val clearButton = view.findViewById<Button>(R.id.clear_sign)
//        clearButton.setOnClickListener {
//            gues.drawingCacheBackgroundColor = Color.WHITE
//            gues.clear(true)
//            try {
//                val answerJson = JSONObject()
//                answerJson.put("answered", false)
//                masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
//            } catch (e: JSONException) {
//                e.printStackTrace()
//            }
//        }
//        gues.isDrawingCacheEnabled = true
//        gues.setOnTouchListener { v, event ->
//            nestedScrollView!!.requestDisallowInterceptTouchEvent(true) //very important
//            false
//        }
//        gues.addOnGestureListener(object : GestureOverlayView.OnGestureListener {
//            override fun onGestureStarted(overlay: GestureOverlayView, event: MotionEvent) {
//                gues.drawingCacheBackgroundColor = Color.WHITE
//            }
//
//            override fun onGesture(overlay: GestureOverlayView, event: MotionEvent) {}
//            override fun onGestureEnded(overlay: GestureOverlayView, event: MotionEvent) {
//                if (overlay.drawingCache != null) {
//                    try {
//                        val answerJson = JSONObject()
//                        answerJson.put("answer", Utility.imgToString(overlay.drawingCache))
//                        answerJson.put("answered", true)
//                        answerJson.put("issue", "no")
//                        answerJson.put("remarks", "")
//                        masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
//                    } catch (e: JSONException) {
//                        e.printStackTrace()
//                    }
//                }
//            }
//
//            override fun onGestureCancelled(overlay: GestureOverlayView, event: MotionEvent) {}
//        })
//        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
//            if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
//                val d: Drawable = BitmapDrawable(resources, Utility.bitmap(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer")))
//                gues.background = d
//            }
//        }
//        // gues.setImageBitmap(Utility.bitmap(masterJSON.getJSONObject(json.getString(QuestionTable.QUESTION)).getString("answer")));
//        mainLayout!!.addView(view)
//    }

    @Throws(JSONException::class)
    private fun setSignature(n: Int, json: JSONObject) {
        val view = layoutInflater!!.inflate(R.layout.model_signature, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val filename = view.findViewById<TextView>(R.id.uploaded_files_text)
        val gues = view.findViewById<GestureOverlayView>(R.id.signaturePad)
        val clearButton = view.findViewById<Button>(R.id.clear_sign)
        val saveButton = view.findViewById<Button>(R.id.save_sign)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // --- Restore previous signature ---
        val savedAnswerObj = masterJSON.optJSONObject(sectionKey)?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
        val savedArray = savedAnswerObj?.optJSONArray("answer")
        if (savedArray != null && savedArray.length() > 0) {
            // For simplicity, show the first uploaded file name in the TextView
            val savedFile = savedArray.getJSONObject(0).optString("file")
            filename.text = savedFile.substringAfterLast("_0_") // or keep full path if needed
        }

        // Clear signature + reset answer
        clearButton.setOnClickListener {
            gues.clear(true)
            gues.background = ColorDrawable(Color.WHITE)
            filename.text = ""
            try {
                val answerJson = JSONObject()
                answerJson.put("answered", false)
                answerJson.remove("utility")
                masterJSON.optJSONObject(sectionKey)?.put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }

        gues.isDrawingCacheEnabled = true
        gues.setOnTouchListener { _, _ ->
            nestedScrollView!!.requestDisallowInterceptTouchEvent(true)
            false
        }


        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                val d: Drawable = BitmapDrawable(resources, Utility.bitmap(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("utility")))
                gues.background = d
            }
        }

        // When drawing ends, capture + upload
        gues.addOnGestureListener(object : GestureOverlayView.OnGestureListener {
            override fun onGestureStarted(overlay: GestureOverlayView, event: MotionEvent) {}
            override fun onGesture(overlay: GestureOverlayView, event: MotionEvent) {}
            override fun onGestureEnded(overlay: GestureOverlayView, event: MotionEvent) {
                saveButton.setOnClickListener {
                    gues.isDrawingCacheEnabled = true
                    gues.buildDrawingCache()
                    val bitmap = Bitmap.createBitmap(gues.drawingCache)
                    val utility = Utility.imgToString(overlay.drawingCache)
                    gues.isDrawingCacheEnabled = false

                    uploadSignatureToServer(
                        bitmap,
                        assignid.toString(),
                        json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                        sectionKey.toString(),
                        filename,
                        utility
                    )
                }
            }
            override fun onGestureCancelled(overlay: GestureOverlayView, event: MotionEvent) {}
        })

        mainLayout!!.addView(view)
    }


    @Throws(JSONException::class)
    private fun datetime(n: Int, json: JSONObject) {
        val editTextView = layoutInflater!!.inflate(R.layout.model_datetime, mainLayout, false)
        val title = editTextView.findViewById<TextView>(R.id.text_title)
        val editText = editTextView.findViewById<EditText>(R.id.text_input)
        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            if (masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getBoolean("answered")) {
                editText.setText(masterJSON.getJSONObject(sectionKey).getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID)).getString("answer"))
            }
        }
        editText.setOnClickListener {
            try {
                if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("date", ignoreCase = true)) {
                    setDatePicker(editText, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("datetime", ignoreCase = true)) {
                    setDateTimePicker(editText, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("time", ignoreCase = true)) {
                    setTimePicker(editText, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                } else if (json.getString(FlexibleFormQuestionsTable.ANSWER_TYPE).equals("monthyear", ignoreCase = true)) {
                    setMonthYearPicker(editText, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        mainLayout!!.addView(editTextView)
    }

    private fun setDatePicker(editText: EditText, questionId: String) {
        val myCalendar = Calendar.getInstance()
        val listenr = OnDateSetListener { view, year, monthOfYear, dayOfMonth -> // TODO Auto-generated method stub
            myCalendar[Calendar.YEAR] = year
            myCalendar[Calendar.MONTH] = monthOfYear
            myCalendar[Calendar.DAY_OF_MONTH] = dayOfMonth
            var sdf = SimpleDateFormat("dd/MM/yyyy", Locale.getDefault())
            sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
            editText.setText(sdf.format(myCalendar.time))
            val answerJson = JSONObject()
            try {
                answerJson.put("answered", true)
                answerJson.put("answer", sdf.format(myCalendar.time))
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")
                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        val datePicker = DatePickerDialog(this, listenr, myCalendar[Calendar.YEAR], myCalendar[Calendar.MONTH],
            myCalendar[Calendar.DAY_OF_MONTH])
        datePicker.show()
    }

    private fun setTimePicker(editText: EditText, questionId: String) {
        val myCalendar = Calendar.getInstance()
        val hour = myCalendar[Calendar.HOUR_OF_DAY]
        val minute = myCalendar[Calendar.MINUTE]
        val listenr = OnTimeSetListener { view, hourOfDay, minute ->
            myCalendar[Calendar.HOUR] = hourOfDay
            myCalendar[Calendar.MINUTE] = minute
            val sdf = SimpleDateFormat("HH:mm:ss", Locale.getDefault())
            editText.setText(sdf.format(myCalendar.time))
            val answerJson = JSONObject()
            try {
                answerJson.put("answered", true)
                answerJson.put("answer", sdf.format(myCalendar.time))
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")
                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        val timePickerDialog = TimePickerDialog(this, listenr, hour, minute, true)
        timePickerDialog.show()
    }

    private fun setDateTimePicker(editText: EditText, questionId: String) {
        val myCalendar = Calendar.getInstance()
        val hour = myCalendar[Calendar.HOUR_OF_DAY]
        val minute = myCalendar[Calendar.MINUTE]
        val listenr2 = OnTimeSetListener { view, hourOfDay, minute ->
            myCalendar[Calendar.HOUR] = hourOfDay
            myCalendar[Calendar.MINUTE] = minute
            val sdf = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())
            editText.setText(sdf.format(myCalendar.time))
            val answerJson = JSONObject()
            try {
                answerJson.put("answered", true)
                answerJson.put("answer", sdf.format(myCalendar.time))
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")
                masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        val timePickerDialog = TimePickerDialog(this, listenr2, hour, minute, true)
        val listenr = OnDateSetListener { view, year, monthOfYear, dayOfMonth -> // TODO Auto-generated method stub
            myCalendar[Calendar.YEAR] = year
            myCalendar[Calendar.MONTH] = monthOfYear
            myCalendar[Calendar.DAY_OF_MONTH] = dayOfMonth
            timePickerDialog.show()
        }
        val datePicker = DatePickerDialog(this, listenr, myCalendar[Calendar.YEAR], myCalendar[Calendar.MONTH],
            myCalendar[Calendar.DAY_OF_MONTH])
        datePicker.show()
    }

    private fun setMonthYearPicker(editText: EditText, questionId: String) {
        val myCalendar = Calendar.getInstance()

        val datePicker = DatePickerDialog(
            this,
            { _, year, month, _ ->
                val monthName = SimpleDateFormat("MMMM", Locale.getDefault())
                    .format(GregorianCalendar(year, month, 1).time)
                val formatted = "$monthName, $year"
                editText.setText(formatted)

                val answerJson = JSONObject()
                try {
                    answerJson.put("answered", true)
                    answerJson.put("answer", formatted)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")
                    masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            },
            myCalendar.get(Calendar.YEAR),
            myCalendar.get(Calendar.MONTH),
            myCalendar.get(Calendar.DAY_OF_MONTH)
        )

        // Hide day field (not officially supported, but works on most devices)
        try {
            val daySpinnerId = Resources.getSystem().getIdentifier("day", "id", "android")
            val daySpinner = datePicker.datePicker.findViewById<View>(daySpinnerId)
            daySpinner?.visibility = View.GONE
        } catch (e: Exception) {
            e.printStackTrace()
        }

        datePicker.show()
    }

    private val FILE_UPLOAD_REQUEST_CODE = 2001
    private var selectedFiles = mutableListOf<Uri>()
    private var allowedTypes = listOf<String>()
    private var maxFiles = 1
    private var maxSizeMB = 5
    private val fileTypeMappings = mapOf(
        "image" to listOf("jpg", "jpeg", "png", "gif", "bmp", "webp"),
        "document" to listOf("doc", "docx", "odt", "txt"),
        "spreadsheet" to listOf("xls", "xlsx", "csv", "ods"),
        "pdf" to listOf("pdf"),
        "video" to listOf("mp4", "avi", "mov", "wmv", "flv"),
        "presentation" to listOf("ppt", "pptx", "odp")
    )

    @Throws(JSONException::class)
    private fun fileUpload(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_fileupload, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val uploadButton = view.findViewById<Button>(R.id.upload_button)
        val uploadedFilesText = view.findViewById<TextView>(R.id.uploaded_files_text)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // --- Restore previous uploaded files ---
        val savedAnswerObj = masterJSON
            .optJSONObject(sectionKey)
            ?.optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))

        val savedArray = savedAnswerObj?.optJSONArray("answer")
        if (savedAnswerObj != null && savedAnswerObj.optBoolean("answered") && savedArray != null) {
            val restoredNames = mutableListOf<String>()
            for (i in 0 until savedArray.length()) {
                val obj = savedArray.getJSONObject(i)
                val filePath = obj.optString("file")
                restoredNames.add(filePath.substringAfterLast("_0_"))
            }
            uploadedFilesText.text = restoredNames.joinToString("\n")
        }

        // parse options (file-types, max-files, file-size)
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE).lowercase()) {
                    "file-types" -> {
                        val raw = option.getString(FlexibleFormOptionsTable.OPTION_TEXT).split(",")
                            .map { it.trim().lowercase() }
                        allowedTypes = raw.flatMap { type ->
                            fileTypeMappings[type] ?: listOf(type)
                        }
                    }
                    "max-files" -> maxFiles =
                        option.getString(FlexibleFormOptionsTable.OPTION_TEXT).toIntOrNull() ?: 1
                    "file-size" -> maxSizeMB =
                        option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
                            .replace("MB", "", true).toIntOrNull() ?: 5
                }
            }
        }

        uploadButton.setOnClickListener {
            currentQuestionId = json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            currentUploadedFilesText = uploadedFilesText
            val intent = Intent(Intent.ACTION_GET_CONTENT).apply {
                type = "*/*"
                putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true)
            }
            startActivityForResult(intent, FILE_UPLOAD_REQUEST_CODE)
        }

        // save empty by default
        if (!masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val answerJson = JSONObject().apply {
                put("answered", false)
                put("answer", JSONArray())
                put("issue", "no")
                put("remarks", "")
            }
            masterJSON.getJSONObject(sectionKey)
                .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        }

        mainLayout!!.addView(view)
    }

    private fun getFileName(uri: Uri): String {
        var name = ""
        contentResolver.query(uri, null, null, null, null)?.use { cursor ->
            val nameIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME)
            if (cursor.moveToFirst()) {
                name = cursor.getString(nameIndex)
            }
        }
        return name
    }

    private fun getFileSizeMB(uri: Uri): Int {
        var size = 0L
        contentResolver.query(uri, null, null, null, null)?.use { cursor ->
            val sizeIndex = cursor.getColumnIndex(OpenableColumns.SIZE)
            if (cursor.moveToFirst()) {
                size = cursor.getLong(sizeIndex)
            }
        }
        return (size / (1024 * 1024)).toInt()
    }

    @Throws(JSONException::class)
    private fun divisionTitle(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater.inflate(R.layout.model_divisiontitle, mainLayout, false)

        val title = view.findViewById<TextView>(R.id.text_title)
        val description = view.findViewById<TextView>(R.id.text_description)

        // questionText → Title
        title.text = String.format("%s", json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Get description from optionArray
        val optionTexts = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }
        if (optionTexts.isNotEmpty()) {
            if (optionTexts[0].isNotEmpty()) {
                description.visibility = View.VISIBLE
                description.text = optionTexts[0]
            } else {
                description.visibility = View.GONE
            }
        } else {
            description.visibility = View.GONE
        }

        val answerJson = JSONObject()
        try {
            answerJson.put("answered", true)
            answerJson.put("answer", "Division Title")
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")
            masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun divisionImage(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater.inflate(R.layout.model_divisionimage, mainLayout, false)

        val title = view.findViewById<TextView>(R.id.text_title)
        val imageView = view.findViewById<ImageView>(R.id.image_division)

        // Set title from question text
        title.text = String.format("%s", json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val optionTexts = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }
//        Log.d("image","${optionTexts}")

        // Load the image if path exists
        if (optionTexts.isNotEmpty()) {
            imageView.visibility = View.VISIBLE

            // Full URL (assuming images are served from XAMPP folder smartforms/images/)
            val fullUrl = "http://fieldcloud.in/${optionTexts[0]}"
            Glide.with(this)
                .load(fullUrl)
                .placeholder(R.drawable.placeholder_image) // optional
                .error(R.drawable.error_image) // optional
                .into(imageView)
        } else {
            imageView.visibility = View.GONE
        }

        val answerJson = JSONObject()
        try {
            answerJson.put("answered", true)
            answerJson.put("answer", "Division Image")
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")
            masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun divisionVideo(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val titleText = json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT)
        var videoUrl: String? = "https://www.youtube.com/watch?v=_3PZmfQtZNs"

        // Get video URL from optionsArray for this questionId
//        for (i in 0 until optionsArray.length()) {
//            val option = optionsArray.getJSONObject(i)
//            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
//                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
//            ) {
//                videoUrl = option.getString(FlexibleFormOptionsTable.OPTION_TEXT)
//                break
//            }
//        }

        if (videoUrl.isNullOrEmpty()) return

        // Check type of video
        when {
            videoUrl.contains("youtube.com") || videoUrl.contains("youtu.be") -> {
                // YouTube Video
                val view = layoutInflater.inflate(R.layout.model_division_youtube, mainLayout, false)
                val title = view.findViewById<TextView>(R.id.text_title)
                val youTubePlayerView = view.findViewById<com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView>(R.id.youtube_player)

                title.text = titleText

                lifecycle.addObserver(youTubePlayerView)

                youTubePlayerView.addYouTubePlayerListener(object : com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener() {
                    override fun onReady(youTubePlayer: com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer) {
                        val videoId = extractYouTubeId(videoUrl)
                        if (!videoId.isNullOrEmpty()) {
                            youTubePlayer.loadVideo(videoId, 0f)
                        }
                    }
                })

                val answerJson = JSONObject()
                try {
                    answerJson.put("answered", true)
                    answerJson.put("answer", "Division Video")
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")
                    masterJSON.getJSONObject(sectionKey).put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                mainLayout!!.addView(view)
            }

            videoUrl.contains("drive.google.com") -> {
                // Google Drive Video: convert to direct download link
                val fileId = Regex("/d/([a-zA-Z0-9_-]+)").find(videoUrl)?.groupValues?.get(1)
                val directUrl = fileId?.let { "https://drive.google.com/uc?export=download&id=$it" }
                if (!directUrl.isNullOrEmpty()) {
                    addVideoView(titleText, directUrl, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
                }
            }

            else -> {
                // Normal MP4 or server video
                addVideoView(titleText, videoUrl, json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            }
        }
    }

    // Helper to create VideoView dynamically
    private fun addVideoView(titleText: String, videoUrl: String, questionId: String) {
        val view = layoutInflater.inflate(R.layout.model_division_video, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val videoView = view.findViewById<VideoView>(R.id.video_view)

        title.text = titleText

        val mediaController = MediaController(this)
        mediaController.setAnchorView(videoView)
        videoView.setMediaController(mediaController)
        videoView.setVideoURI(Uri.parse(videoUrl))
        videoView.requestFocus()
//        videoView.start()

        val answerJson = JSONObject()
        try {
            answerJson.put("answered", true)
            answerJson.put("answer", "Division Title")
            answerJson.put("issue", "no")
            answerJson.put("remarks", "")
            masterJSON.getJSONObject(sectionKey).put(questionId, answerJson)
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        mainLayout!!.addView(view)
    }

    // Extract YouTube video ID from URL
    private fun extractYouTubeId(url: String): String? {
        val regex = "(?<=watch\\?v=|/videos/|youtu.be/|/embed/)[^#&?]*"
        return Regex(regex).find(url)?.value
    }

    @Throws(JSONException::class)
    private fun singleChoice(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_singlechoice, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val optionsLayout = view.findViewById<LinearLayout>(R.id.options_layout)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("titleQuestion", "${title.text}")

        // Collect options for this question
        val optionTexts = mutableListOf<String>()
        val optionIds = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
            }
        }

        // Initialize masterJSON if not filled
        if (!masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val answerJson = JSONObject()
            answerJson.put("answered", false)
            masterJSON.getJSONObject(sectionKey).put(
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                answerJson
            )
        }

        var selectedAnswer: String? = null

        // Restore previous answer if exists
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val answerObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (answerObj.getBoolean("answered")) {
                selectedAnswer = answerObj.getString("answer")
            }
        }

        // Create RadioButtons dynamically
        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val optionText = optionTexts[i]

            val radioButton = RadioButton(this)
            radioButton.text = optionText
            radioButton.tag = optionId
            radioButton.isChecked = selectedAnswer == optionId

            radioButton.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) {
                    selectedAnswer = optionId

                    // Uncheck other radio buttons
                    for (j in 0 until optionsLayout.childCount) {
                        val child = optionsLayout.getChildAt(j)
                        if (child is RadioButton && child != radioButton) {
                            child.isChecked = false
                        }
                    }

                    // Update masterJSON
                    val answerJson = JSONObject()
                    answerJson.put("answer", selectedAnswer) // save option_id
                    answerJson.put("answered", true)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")
                    masterJSON.put(
                        sectionKey,
                        masterJSON.getJSONObject(sectionKey)
                            .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    )
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                }
            }

            optionsLayout.addView(radioButton)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun multipleChoice(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_multiplechoice, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val optionsLayout = view.findViewById<LinearLayout>(R.id.options_layout)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))
//        Log.d("titleQuestion", "${title.text}")

        // Collect options for this question
        val optionTexts = mutableListOf<String>()
        val optionIds = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                optionTexts.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
            }
        }

        // Initialize masterJSON if not filled
        if (!masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val answerJson = JSONObject()
            answerJson.put("answered", false)
            masterJSON.getJSONObject(sectionKey).put(
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID),
                answerJson
            )
        }

        val selectedAnswers = mutableSetOf<String>()

        // Restore previous answers if exist
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val answerObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (answerObj.getBoolean("answered")) {
                val saved = answerObj.getString("answer")
//                Log.e("saved multiple choice","$saved")
                try {
                    val jsonArray = JSONArray(saved)
                    for (i in 0 until jsonArray.length()) {
                        selectedAnswers.add(jsonArray.getString(i))
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
//                Log.e("selected multiple choice", "$selectedAnswers")
            }
        }

        // Create CheckBoxes dynamically
        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val optionText = optionTexts[i]
            val checkBox = CheckBox(this)
            checkBox.text = optionText
            checkBox.tag = optionId
            checkBox.isChecked = selectedAnswers.contains(optionId)

            checkBox.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) selectedAnswers.add(optionId) else selectedAnswers.remove(optionId)

                // Update masterJSON
                val answerJson = JSONObject()
                answerJson.put("answer", JSONArray(selectedAnswers.toList()))
                answerJson.put("answered", selectedAnswers.isNotEmpty())
                answerJson.put("issue", "no")
                answerJson.put("remarks", "")
                masterJSON.put(sectionKey, masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson))
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            }

            optionsLayout.addView(checkBox)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun singleChoiceGrid(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_singlechoicegrid, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val table = view.findViewById<TableLayout>(R.id.grid_table)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val rows = mutableListOf<String>()
        val cols = mutableListOf<String>()

        // Separate rows and columns
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                    "choice-grid-row" -> rows.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                    "choice-grid-column" -> cols.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                }
            }
        }

        // Header row
        val headerRow = TableRow(this)
        headerRow.addView(TextView(this)) // blank corner
        for (col in cols) {
            val tv = TextView(this)
            tv.text = col
            tv.setPadding(16, 8, 16, 8)
            tv.textAlignment = TextView.TEXT_ALIGNMENT_CENTER
            headerRow.addView(tv)
        }
        table.addView(headerRow)

        // Load saved answers
        val savedAnswers = mutableMapOf<String, String>()
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .getJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj.getBoolean("answered")) {
                val saved = ansObj.getJSONArray("answer")
                for (i in 0 until saved.length()) {
                    val entry = saved.getJSONObject(i)
                    savedAnswers[entry.getString("row")] = entry.getString("col")
                }
            }
        }

        // Table rows
        for ((rowIndex, row) in rows.withIndex()) {
            val tableRow = TableRow(this)

            val rowLabel = TextView(this)
            rowLabel.text = row
            rowLabel.setPadding(8, 8, 16, 8)
            tableRow.addView(rowLabel)

            // Track all radios in this row
            val buttonList = mutableListOf<RadioButton>()

            for (col in cols) {
                val rb = RadioButton(this)
                rb.tag = Pair(rowIndex, col)

                // Restore selection
                if (savedAnswers[rowIndex.toString()] == col) rb.isChecked = true

                rb.setOnClickListener {
                    // Uncheck other radios in this row
                    buttonList.forEach { other ->
                        if (other != rb) other.isChecked = false
                    }

                    // Save the answer
                    val (r, c) = rb.tag as Pair<Int, String>
                    savedAnswers[r.toString()] = c

                    val answersArray = JSONArray()
                    savedAnswers.forEach { (rowKey, colVal) ->
                        val obj = JSONObject()
                        obj.put("row", rowKey.toInt())
                        obj.put("col", colVal)
                        answersArray.put(obj)
                    }

                    val answerJson = JSONObject()
                    answerJson.put("answer", answersArray)
                    answerJson.put("answered", answersArray.length() > 0)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")

                    masterJSON.put(
                        sectionKey,
                        masterJSON.getJSONObject(sectionKey)
                            .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    )
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                }

                buttonList.add(rb)

                // Place rb in a centered cell
                val cell = LinearLayout(this)
                cell.gravity = Gravity.CENTER
                cell.addView(rb)
                tableRow.addView(cell)
            }

            table.addView(tableRow)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun multipleChoiceGrid(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_multiplechoicegrid, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val table = view.findViewById<TableLayout>(R.id.grid_table)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val rows = mutableListOf<String>()
        val cols = mutableListOf<String>()

        // separate rows and columns
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) == json.getString(FlexibleFormQuestionsTable.QUESTION_ID)) {
                when (option.getString(FlexibleFormOptionsTable.OPTION_TYPE)) {
                    "choice-grid-row" -> rows.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                    "choice-grid-column" -> cols.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
                }
            }
        }

        // --- Restore Saved Answers ---
        val savedAnswers = mutableMapOf<String, MutableSet<String>>()
        if (masterJSON.getJSONObject(sectionKey).getBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null && ansObj.optBoolean("answered")) {
                val saved = ansObj.getJSONArray("answer")
                for (i in 0 until saved.length()) {
                    val entry = saved.getJSONObject(i)
                    val row = entry.getString("row")
                    val col = entry.getString("col")
                    if (!savedAnswers.containsKey(row)) {
                        savedAnswers[row] = mutableSetOf()
                    }
                    savedAnswers[row]?.add(col)
                }
            }
        }

        // --- Header row ---
        val headerRow = TableRow(this)
        headerRow.addView(TextView(this)) // blank corner
        for (col in cols) {
            val tv = TextView(this)
            tv.text = col
            tv.setPadding(16, 8, 16, 8)
            tv.textAlignment = TextView.TEXT_ALIGNMENT_CENTER
            headerRow.addView(tv)
        }
        table.addView(headerRow)

        // --- Table rows ---
        for ((rowIndex, row) in rows.withIndex()) {
            val tableRow = TableRow(this)

            val rowLabel = TextView(this)
            rowLabel.text = row
            rowLabel.setPadding(8, 8, 16, 8)
            tableRow.addView(rowLabel)

            for (col in cols) {
                val cb = CheckBox(this)
                cb.tag = Pair(rowIndex, col)

                // restore state
                if (savedAnswers[rowIndex.toString()]?.contains(col) == true) cb.isChecked = true

                cb.setOnCheckedChangeListener { _, isChecked ->
                    if (!savedAnswers.containsKey(rowIndex.toString())) {
                        savedAnswers[rowIndex.toString()] = mutableSetOf()
                    }

                    if (isChecked) {
                        savedAnswers[rowIndex.toString()]?.add(col)
                    } else {
                        savedAnswers[rowIndex.toString()]?.remove(col)
                    }

                    // build answers array
                    val answersArray = JSONArray()
                    savedAnswers.forEach { (rowKey, colSet) ->
                        colSet.forEach { colVal ->
                            val obj = JSONObject()
                            obj.put("row", rowKey.toInt())
                            obj.put("col", colVal)
                            answersArray.put(obj)
                        }
                    }

                    val answerJson = JSONObject().apply {
                        put("answer", answersArray)
                        put("answered", answersArray.length() > 0)
                        put("issue", "no")
                        put("remarks", "")
                    }

                    // save back
                    masterJSON.getJSONObject(sectionKey)
                        .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)

                }

                val cell = LinearLayout(this)
                cell.gravity = Gravity.CENTER
                cell.addView(cb)
                tableRow.addView(cell)
            }

            table.addView(tableRow)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun singleChoiceImage(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_singlechoiceimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val radioGroup = view.findViewById<LinearLayout>(R.id.radio_group) // keep LinearLayout instead of RadioGroup

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val optionIds = mutableListOf<String>()
        val optionImages = mutableListOf<String>()
        val radioButtons = mutableListOf<RadioButton>() // track all radio buttons

        // Collect options for this question
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
                optionImages.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Restore saved answer (if exists)
        var selectedAnswer: String? = null
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null && ansObj.optBoolean("answered")) {
                selectedAnswer = ansObj.optString("answer")
            }
        }

        val baseUrl = "http://fieldcloud.in/"

        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val imageResOrUrl = optionImages[i]

            val itemView = layoutInflater.inflate(R.layout.item_singlechoiceimahe, radioGroup, false)
            val radioButton = itemView.findViewById<RadioButton>(R.id.radio_button)
            val imageView = itemView.findViewById<ImageView>(R.id.option_image)

            radioButton.tag = optionId
            radioButton.isChecked = selectedAnswer == optionId

            // Track all buttons
            radioButtons.add(radioButton)

            // Load image (local drawable or URL)
            val resId = resources.getIdentifier(imageResOrUrl, "drawable", packageName)
            if (resId != 0) {
                imageView.setImageResource(resId)
            } else {
                Glide.with(this).load(baseUrl + imageResOrUrl).into(imageView)
            }

            // Clicking image selects the radio button
            imageView.setOnClickListener {
                radioButton.isChecked = true
            }

            // Handle selection
            radioButton.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) {
                    // Uncheck all others
                    radioButtons.forEach { if (it != radioButton) it.isChecked = false }

                    selectedAnswer = optionId
                    val answerJson = JSONObject().apply {
                        put("answer", selectedAnswer)
                        put("answered", true)
                        put("issue", "no")
                        put("remarks", "")
                    }
                    masterJSON.getJSONObject(sectionKey)
                        .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                }
            }

            radioGroup.addView(itemView)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun multipleChoiceImage(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_multiplechoiceimage, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val container = view.findViewById<LinearLayout>(R.id.checkbox_group) // LinearLayout

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        val optionIds = mutableListOf<String>()
        val optionImages = mutableListOf<String>()

        // Collect options for this question
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
                optionImages.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Restore saved answers (if exist)
        val selectedAnswers = mutableSetOf<String>()
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null && ansObj.optBoolean("answered")) {
                val saved = ansObj.optJSONArray("answer")
                if (saved != null) {
                    for (i in 0 until saved.length()) {
                        selectedAnswers.add(saved.getString(i))
                    }
                }
            }
        }

        val baseUrl = "http://fieldcloud.in/"

        for (i in optionIds.indices) {
            val optionId = optionIds[i]
            val imageResOrUrl = optionImages[i]

            val itemView = layoutInflater.inflate(R.layout.item_multiplechoiceimage, container, false)
            val checkBox = itemView.findViewById<CheckBox>(R.id.checkbox)
            val imageView = itemView.findViewById<ImageView>(R.id.option_image)

            checkBox.tag = optionId
            checkBox.isChecked = selectedAnswers.contains(optionId)

            // Load image (local drawable or URL)
            val resId = resources.getIdentifier(imageResOrUrl, "drawable", packageName)
            if (resId != 0) {
                imageView.setImageResource(resId)
            } else {
                Glide.with(this).load(baseUrl + imageResOrUrl).into(imageView)
            }

            // Clicking image toggles the checkbox
            imageView.setOnClickListener {
                checkBox.isChecked = !checkBox.isChecked
            }

            // Handle selection
            checkBox.setOnCheckedChangeListener { _, isChecked ->
                if (isChecked) {
                    selectedAnswers.add(optionId)
                } else {
                    selectedAnswers.remove(optionId)
                }

                val answerJson = JSONObject().apply {
                    put("answer", JSONArray(selectedAnswers.toList()))
                    put("answered", selectedAnswers.isNotEmpty())
                    put("issue", "no")
                    put("remarks", "")
                }
                masterJSON.getJSONObject(sectionKey)
                    .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
                FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            }

            container.addView(itemView)
        }

        mainLayout!!.addView(view)
    }

    @Throws(JSONException::class)
    private fun rankingQuestion(n: Int, json: JSONObject) {
        val serviceDatabase = ServiceDatabase.getInstance(this)
        val optionsArray = serviceDatabase.getOptions(id, date, cat, assignid)

        val view = layoutInflater!!.inflate(R.layout.model_ranking, mainLayout, false)
        val title = view.findViewById<TextView>(R.id.text_title)
        val recyclerView = view.findViewById<RecyclerView>(R.id.recycler_ranking)

        title.text = String.format("%d.%s", n, json.getString(FlexibleFormQuestionsTable.QUESTION_TEXT))

        // Collect options for this question
        val optionList = mutableListOf<String>()
        val optionIds = mutableListOf<String>()
        for (i in 0 until optionsArray.length()) {
            val option = optionsArray.getJSONObject(i)
            if (option.getString(FlexibleFormOptionsTable.QUESTION_ID) ==
                json.getString(FlexibleFormQuestionsTable.QUESTION_ID)
            ) {
                optionIds.add(option.getString(FlexibleFormOptionsTable.OPTION_ID))
                optionList.add(option.getString(FlexibleFormOptionsTable.OPTION_TEXT))
            }
        }

        // Restore saved ranking
        val savedRanking = mutableListOf<String>()
        if (masterJSON.getJSONObject(sectionKey).optBoolean("filled")) {
            val ansObj = masterJSON.getJSONObject(sectionKey)
                .optJSONObject(json.getString(FlexibleFormQuestionsTable.QUESTION_ID))
            if (ansObj != null && ansObj.optBoolean("answered")) {
                val saved = ansObj.getJSONArray("answer")
                for (i in 0 until saved.length()) {
                    savedRanking.add(saved.getJSONObject(i).getString("option_id"))
                }
//                Log.e("saved ranking","$savedRanking")
            }
        }

        // If saved exists, reorder list accordingly
        if (savedRanking.isNotEmpty()) {
            val reordered = mutableListOf<Pair<String, String>>() // (id, text)
            savedRanking.forEach { id ->
                val idx = optionIds.indexOf(id)
                if (idx >= 0) reordered.add(optionIds[idx] to optionList[idx])
            }
            // Add missing (new) options if any
            optionIds.forEachIndexed { i, id ->
                if (!savedRanking.contains(id)) reordered.add(id to optionList[i])
            }
            optionIds.clear()
            optionList.clear()
            reordered.forEach {
                optionIds.add(it.first)
                optionList.add(it.second)
            }
        }

        // Setup RecyclerView
        recyclerView.layoutManager = LinearLayoutManager(this)
        val adapter = RankingAdapter(optionIds, optionList) { updatedIds ->
            // Save on reorder
            val rankingArray = JSONArray()
            updatedIds.forEachIndexed { index, optId ->
                val obj = JSONObject()
                obj.put("option_id", optId)
                obj.put("rank", index + 1)
                rankingArray.put(obj)
            }

            val answerJson = JSONObject().apply {
                put("answer", rankingArray)
                put("answered", rankingArray.length() > 0)
                put("issue", "no")
                put("remarks", "")
            }

            masterJSON.getJSONObject(sectionKey)
                .put(json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
            FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), json.getString(FlexibleFormQuestionsTable.QUESTION_ID), answerJson)
        }
        recyclerView.adapter = adapter

        // Attach drag-and-drop helper
        val touchHelper = ItemTouchHelper(adapter.itemTouchHelperCallback)
        touchHelper.attachToRecyclerView(recyclerView)

        mainLayout!!.addView(view)
    }


    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        //processImage(resultCode,requestCode);
        if (requestCode == CAPTURE_NUMBER && resultCode == Activity.RESULT_OK) {

            imagefilepath?.apply {
                imageView?.setImageBitmap(this.toBitmap())
                try {
                    val answerJson = JSONObject()
                    answerJson.put("answer", this.toBase64String())
                    answerJson.put("answered", true)
                    answerJson.put("issue", "no")
                    answerJson.put("remarks", "")
                    masterJSON.put(subCat(), masterJSON.getJSONObject(subCat()).put(cameraQuestionId, answerJson))
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            }
        } else if (requestCode == REQUEST) {
            when (resultCode) {
                Activity.RESULT_OK ->                     // All required changes were successfully made
                    finish()
                Activity.RESULT_CANCELED -> {
                }
                else -> {
                }
            }
        }
        if (mediaFile != null) {
            mediaFile!!.delete()
        }
        if (requestCode == FILE_UPLOAD_REQUEST_CODE && resultCode == RESULT_OK) {
            if (data == null) return

            val newUris = mutableListOf<Uri>()

            if (data.clipData != null) {
                for (i in 0 until data.clipData!!.itemCount) {
                    newUris.add(data.clipData!!.getItemAt(i).uri)
                }
            } else if (data.data != null) {
                newUris.add(data.data!!)
            }

            val validUris = mutableListOf<Uri>()
            for (uri in newUris) {
                val name = getFileName(uri)
                val ext = name.substringAfterLast('.', "").lowercase()
                val sizeMB = getFileSizeMB(uri)

                if (allowedTypes.isNotEmpty() && !allowedTypes.contains(ext)) {
                    Toast.makeText(this, "Invalid type: $name", Toast.LENGTH_SHORT).show()
                    continue
                }
                if (sizeMB > maxSizeMB) {
                    Toast.makeText(this, "Too large: $name", Toast.LENGTH_SHORT).show()
                    continue
                }
                validUris.add(uri)
            }

            if (validUris.size > maxFiles) {
                Toast.makeText(this, "Max $maxFiles files allowed", Toast.LENGTH_SHORT).show()
                return
            }

            selectedFiles.clear()
            selectedFiles.addAll(validUris)

            val names = selectedFiles.joinToString("\n") { getFileName(it) }
            findViewById<TextView>(R.id.uploaded_files_text).text = names

            // upload to server
            uploadFilesToServer(selectedFiles, assignid.toString(), currentQuestionId.toString(), sectionKey.toString(), currentUploadedFilesText)
        }
    }

    private fun uploadFilesToServer(files: List<Uri>, assignId: String, questionId: String, sectionKey: String, uploadedFilesText: TextView?) {
        val retrofit = Retrofit.Builder()
            .baseUrl("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/")
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        val service = retrofit.create(ApiService::class.java)

        val parts = files.map { uri ->
            val inputStream = contentResolver.openInputStream(uri)!!
            val fileName = getFileName(uri)
            val requestBody = inputStream.readBytes().toRequestBody("multipart/form-data".toMediaTypeOrNull())
            MultipartBody.Part.createFormData("files[]", fileName, requestBody)
        }

        val assignPart = MultipartBody.Part.createFormData("assignid", assignId)
        val questionPart = MultipartBody.Part.createFormData("questionid", questionId)

        val allParts = mutableListOf<MultipartBody.Part>()
        allParts.add(assignPart)
        allParts.add(questionPart)
        allParts.addAll(parts)

        service.uploadFiles(allParts).enqueue(object : Callback<List<UploadResponse>> {
            override fun onResponse(call: Call<List<UploadResponse>>, response: Response<List<UploadResponse>>) {
                if (response.isSuccessful) {
                    val uploaded = response.body() ?: emptyList()
                    val array = JSONArray()
                    uploaded.forEach {
                        if (it.status == "success") {
                            val obj = JSONObject()
                            obj.put("file", it.file)
                            array.put(obj)
                        }
                    }
                    val answerJson = JSONObject().apply {
                        put("answered", array.length() > 0)
                        put("answer", array)
                        put("issue", "no")
                        put("remarks", "")
                    }

                    val sectionJson = masterJSON.optJSONObject(sectionKey) ?: JSONObject().also {
                        masterJSON.put(sectionKey, it)
                    }
                    sectionJson.put(questionId, answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)

                    uploadedFilesText?.text = files.joinToString("\n") { getFileName(it) }
                } else {
                    Toast.makeText(this@QuestionActivity, "Upload failed: ${response.code()} ${response.message()}", Toast.LENGTH_SHORT).show()
                }
            }

            override fun onFailure(call: Call<List<UploadResponse>>, t: Throwable) {
                Toast.makeText(this@QuestionActivity, "Upload error: ${t.message}", Toast.LENGTH_SHORT).show()
            }
        })
    }

    private fun uploadSignatureToServer(
        bitmap: Bitmap,
        assignId: String,
        questionId: String,
        sectionKey: String,
        uploadedFilesText: TextView?,
        utility: String
    ) {
        val retrofit = Retrofit.Builder()
            .baseUrl("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/") // XAMPP local server
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        val service = retrofit.create(ApiService::class.java)

        // Convert bitmap -> bytes -> RequestBody
        val baos = ByteArrayOutputStream()
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos)
        val imageBytes = baos.toByteArray()
        val fileName = "signature_${questionId}_${assignId}_${System.currentTimeMillis()}.png"
        val requestBody = imageBytes.toRequestBody("multipart/form-data".toMediaTypeOrNull())
        val filePart = MultipartBody.Part.createFormData("signature", fileName, requestBody)

        // Extra form fields
        val assignPart = MultipartBody.Part.createFormData("assignid", assignId)
        val questionPart = MultipartBody.Part.createFormData("questionid", questionId)

        val allParts = mutableListOf<MultipartBody.Part>().apply {
            add(assignPart)
            add(questionPart)
            add(filePart)
        }

        service.uploadSignature(allParts).enqueue(object : Callback<List<UploadResponse>> {
            override fun onResponse(
                call: Call<List<UploadResponse>>,
                response: Response<List<UploadResponse>>
            ) {
                if (response.isSuccessful) {
                    val uploaded = response.body() ?: emptyList()
                    val array = JSONArray()

                    uploaded.forEach {
                        if (it.status == "success") {
                            val obj = JSONObject()
                            obj.put("file", it.file) // server file path
                            array.put(obj)
                        }
                    }

                    val answerJson = JSONObject().apply {
                        put("answered", array.length() > 0)
                        put("utility", utility)
                        put("answer", array) // JSON array of file paths
                        put("issue", "no")
                        put("remarks", "")
                    }

                    val sectionJson = masterJSON.optJSONObject(sectionKey) ?: JSONObject().also {
                        masterJSON.put(sectionKey, it)
                    }
                    sectionJson.put(questionId, answerJson)
                    FormAnswerManager.saveAnswer(sectionKey.toString(), sectionID.toString(), questionId, answerJson)

                    val shortFileName = fileName.substringAfterLast("_0_")

                    uploadedFilesText?.text = shortFileName
                } else {
                    Toast.makeText(
                        this@QuestionActivity,
                        "Upload failed: ${response.code()}",
                        Toast.LENGTH_SHORT
                    ).show()
                }
            }

            override fun onFailure(call: Call<List<UploadResponse>>, t: Throwable) {
                Toast.makeText(
                    this@QuestionActivity,
                    "Upload error: ${t.message}",
                    Toast.LENGTH_SHORT
                ).show()
            }
        })
    }

    private fun captureImage() {

        fun getoutputMediaFileUri(): File {
            val mediaFile: File = Utility.getSignFile(this)
            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return mediaFile
        }

        fun getoutputMediaFileUriException(): Uri? {
            val mediaFile: File = Utility.getSignFile(this)

            picturefilename = mediaFile.name
            try {
                mediaFile.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            imagefilepath = mediaFile
            return Uri.fromFile(mediaFile)
        }

        try {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            val fileUri = FileProvider.getUriForFile(this, BuildConfig.APPLICATION_ID + ".provider", getoutputMediaFileUri())
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
            startActivityForResult(intent, CAPTURE_NUMBER)
        } catch (e: Exception) {

            try {
                val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                val fileUri = getoutputMediaFileUriException()
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri)
                startActivityForResult(intent, CAPTURE_NUMBER)
            } catch (e1: Exception) { //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
                e.printStackTrace()
            }

        }

    }

    private var picturefilename = "no data available"
    private var imagefilepath: File? = null

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        val inflater = menuInflater
        inflater.inflate(R.menu.menu_form, menu)
        return true
    }

    private fun initCallbacks() {
        findViewById<View>(R.id.btn_submit).setOnClickListener {
            try {
                if (isValid()) {
                    insertTempAnswers()
                } else {
                    Toast.makeText(applicationContext, "Answer All Questions", Toast.LENGTH_SHORT).show()
                }
            } catch (e: JSONException) {
                Toast.makeText(applicationContext, "Error!,${e.printStackTrace()}", Toast.LENGTH_SHORT).show()
                e.printStackTrace()
            }
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            R.id.done -> try {
                if (isValid()) {
                    insertTempAnswers()
                } else {
                    Toast.makeText(applicationContext, "Answer All Questions", Toast.LENGTH_SHORT).show()
                }
            } catch (e: JSONException) {
                Toast.makeText(applicationContext, "Error!", Toast.LENGTH_SHORT).show()
                e.printStackTrace()
            }
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    private fun goToPreview() {
        val intent = Intent(applicationContext, PreviewActivity::class.java)
        intent.putExtra("id", id)
        intent.putExtra("date", date)
        intent.putExtra("cat", cat)
        intent.putExtra("assignid", assignid)
        startActivityForResult(intent, REQUEST)
    }

    @Throws(JSONException::class)
    private fun subCat(): String {
        return subcats.getJSONObject(tabLayout!!.selectedTabPosition).getString(QuestionTable.SUBCAT)
    }

    @Throws(JSONException::class)
    private fun isValid(): Boolean{
//        Log.e("testvalid","here")
//        val serviceDatabase = ServiceDatabase.getInstance(this)
//        for (i in 0 until subcats!!.length()) {
//            val subcatId = subcats!!.getJSONObject(i).getString(QuestionTable.SUBCAT)
//                Log.d("subcat Id", subcatId)

        val serviceDatabase = ServiceDatabase.getInstance(this)

        val masterjsonObj = FormAnswerManager.getFormJson()
//        Log.e("FormAnswer","$masterjsonObj")

        if (sectionKey != "General"){
            var i = 0
            for (sectionName in sectionList) {
//                Log.d("sectionList","$sectionName, $sectionList, $sectionKey")
//                val sectionName = tabLayout!!.getTabAt(i)!!.text.toString()
                val sectionObj = masterjsonObj.optJSONObject(sectionName) ?: JSONObject().also { masterjsonObj.put(sectionName, it) }
//                Log.e("sectionObj", "$sectionObj")
//                Log.e("valid section", "$sectionName, ${sectionObj.optString("sectionId", null)}")
                val sectionId = if (sectionName == "General") null else sectionObj.optString("sectionId", null)
                if (sectionId == null) {
                    tabLayout!!.getTabAt(i)!!.select()
                    return false
                }
                val jsonArray = serviceDatabase.getQuestions(id, date, cat, assignid, sectionId)
//                Log.e("testvalid1","$jsonArray,$id,$date,$cat,$assignid,$sectionId")
                for (j in 0 until jsonArray.length()) {
                    val answerJSON = masterjsonObj.getJSONObject(sectionName)
                    val questionId = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.QUESTION_ID)
//                    Log.e("here", "$answerJSON")
//                    Log.d("question_id","$questionId")
                    if (!answerJSON.has(questionId)) {
                        tabLayout!!.getTabAt(i)!!.select()
                        return false
                    }
                    if (!answerJSON.getBoolean("filled")
                        || ((!answerJSON.getJSONObject(questionId).getBoolean("answered")
                                || answerJSON.getJSONObject(questionId).getString("answer").isEmpty())
                                && jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.QUESTION_REQUIREMENT) == "mandatory")) {
                        tabLayout!!.getTabAt(i)!!.select()
                        return false
                    }
                }
                i++
            }
            i = 0
        } else {
            for (i in 0 until tabLayout!!.tabCount) {
                val sectionName = tabLayout!!.getTabAt(i)!!.text.toString()
                val sectionObj = masterJSON.optJSONObject(sectionName) ?: continue

                val sectionId = if (sectionName == "General") null else sectionObj.optString("sectionId", null)
                val jsonArray = serviceDatabase.getQuestions(id, date, cat, assignid, sectionId)
                Log.e("testvali2","$jsonArray,$id,$date,$cat,$assignid,$sectionKey")
                for (j in 0 until jsonArray.length()) {
                    val answerJSON = masterJSON.getJSONObject(sectionKey)?: JSONObject().also { masterJSON.put(sectionKey, it) }
                    val questionId = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.QUESTION_ID)
                    Log.e("here","$answerJSON")
                    if (!answerJSON.has(questionId)) {
                        tabLayout!!.getTabAt(i)!!.select()
                        return false
                    }
                    if (!answerJSON.getBoolean("filled")
                        || ((!answerJSON.getJSONObject(questionId).getBoolean("answered")
                                || answerJSON.getJSONObject(questionId).getString("answer").isEmpty())
                                && jsonArray.getJSONObject(j).getString("question_requirement") == "mandatory")) {
                        tabLayout!!.getTabAt(i)!!.select()
                        return false
                    }
                }
            }
        }
        return true
    }

    @Throws(JSONException::class)
    private fun insertTempAnswers() {
        val database = ServiceDatabase.getInstance(this)
        val masterjsonObj = FormAnswerManager.getFormJson()
        if(sectionKey != "General") {
            for(sectionName in sectionList) {
                val jsonArray = database.getQuestions(id, date, cat, assignid, masterjsonObj.optJSONObject(sectionName).getString("sectionId"))
                for (j in 0 until jsonArray.length()) {
                    try {
                        val answerJSON = masterjsonObj.optJSONObject(sectionName) ?: JSONObject().also { masterjsonObj.put(sectionName, it) }
                        val questionJSON = jsonArray.getJSONObject(j)
                        val questionId = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.QUESTION_ID)
                        val questionType = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.ANSWER_TYPE)
                        val jsonObject = JSONObject()

                        if (questionType == "address") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("value"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, i)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "first last name") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("value"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, i)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "single choice grid" || questionType == "multiple choice grid") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("col"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, responseObj.getString("row"))
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "ranking") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("option_id"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, responseObj.getString("rank"))
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "file upload" || questionType == "signature") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("file"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "multiple choice image" || questionType == "multiple choice") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, addrArray.getString(i))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "division titledescription" || questionType == "division image" || questionType == "division video") {
//                            Log.d("division","division")
                        } else {
                            jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                FlexibleFormQuestionsTable.FORM_ID))
                            jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                FlexibleFormQuestionsTable.QUESTION_ID))
                            jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, answerJSON.getJSONObject(questionId).getString("answer"))
                            jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                            jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                            jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null )
                            jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                            jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                            jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                            Log.d("insertTemp","$jsonObject")
                            database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
        } else {
            for (i in 0 until subcats!!.length()) {
//            val subcatId = subcats!!.getJSONObject(i).getString(QuestionTable.SUBCAT)
//            Log.d("subcat Id", subcatId)
                val jsonArray = database.getQuestions(id, date, cat, assignid, sectionID)
                for (j in 0 until jsonArray.length()) {
                    try {
                        val answerJSON = masterJSON.optJSONObject(sectionKey) ?: JSONObject().also { masterJSON.put(sectionKey, it) }
                        val questionJSON = jsonArray.getJSONObject(j)
                        val questionId = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.QUESTION_ID)
                        val questionType = jsonArray.getJSONObject(j).getString(FlexibleFormQuestionsTable.ANSWER_TYPE)
                        val jsonObject = JSONObject()

                        if (questionType == "address") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("value"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, i)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "first last name") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("value"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, i)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "single choice grid" || questionType == "multiple choice grid") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("col"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, responseObj.getString("row"))
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "ranking") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("option_id"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, responseObj.getString("rank"))
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "file upload" || questionType == "signature") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                val responseObj = addrArray.getJSONObject(i)
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, responseObj.getString("file"))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "multiple choice image" || questionType == "multiple choice") {
                            val addrArray = answerJSON.getJSONObject(questionId).getJSONArray("answer")
                            for (i in 0 until addrArray.length()) {
                                jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.FORM_ID))
                                jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                    FlexibleFormQuestionsTable.QUESTION_ID))
                                jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, addrArray.getString(i))
                                jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                                jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                                jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null)
                                jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                                jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                                jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                                Log.d("insertTemp","$jsonObject")
                                database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                            }
                        } else if (questionType == "division titledescription" || questionType == "division image" || questionType == "division video") {
                            Log.d("division","division")
                        } else {
                            jsonObject.put(FlexibleFormResponsesTable.FORM_ID, questionJSON.getString(
                                FlexibleFormQuestionsTable.FORM_ID))
                            jsonObject.put(FlexibleFormResponsesTable.QUESTION_ID, questionJSON.getString(
                                FlexibleFormQuestionsTable.QUESTION_ID))
                            jsonObject.put(FlexibleFormResponsesTable.OPTION_TEXT, answerJSON.getJSONObject(questionId).getString("answer"))
                            jsonObject.put(FlexibleFormResponsesTable.ASSIGNMENT_ID, assignid)
                            jsonObject.put(FlexibleFormResponsesTable.CATEGORY, cat)
                            jsonObject.put(FlexibleFormResponsesTable.ROW_INDEX, null )
                            jsonObject.put(FlexibleFormResponsesTable.ISSUE, answerJSON.getJSONObject(questionId).getString("issue"))
                            jsonObject.put(FlexibleFormResponsesTable.DELETE_STATUS, 0)
//                    jsonObject.put(AnswerTable.REMARKS, " ")
//                    if( answerJSON.getJSONObject(questionId).getString("remarks")==null)
//                    {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            ""
//                        )
//                    }
//                    else {
//                        jsonObject.put(
//                            AnswerTable.REMARKS,
//                            answerJSON.getJSONObject(questionId).getString("remarks")
//                        )
//                    }
                            jsonObject.put(FlexibleFormResponsesTable.PREVIEW, "1")
//                            Log.d("insertTemp","$jsonObject")
                            database.insertIntoTable(jsonObject, FlexibleFormResponsesTable.TABLENAME)
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
        }

        goToPreview()
    }

    override fun onBackPressed() {
        val builder = AlertDialog.Builder(this)
        builder.setPositiveButton("LEAVE") { dialog, id -> // User clicked OK button
            FormAnswerManager.formAnswers.clear()
            setResult(Activity.RESULT_OK)
            finish()
        }
        builder.setNegativeButton("STAY") { dialog, id ->
            // User clicked OK button
        }
        builder.setMessage("Back button pressed!")
        val dialog = builder.create()
        dialog.show()
    }

    companion object {
        private const val CAPTURE_NUMBER = 2
        private const val REQUEST = 1
        private const val FILE_UPLOAD_REQUEST_CODE = 3
    }

}