package com.b2lmobitech.fieldcloudplus.service.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.service.adapter.ReceivedSpareAdapter;

import org.json.JSONArray;
import org.json.JSONException;

public class ReceivedSpareActivity extends AppCompatActivity {

    RecyclerView recyclerView;
    TextView errorText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_receivedspare);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);

        getSupportActionBar().setTitle("Received Spares");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);

        try {
            setAdapter(new JSONArray(getIntent().getStringExtra("json")));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setAdapter(JSONArray jsonArray){
        ReceivedSpareAdapter adapter=new ReceivedSpareAdapter(this,jsonArray);
        recyclerView.setAdapter(adapter);
        if(jsonArray.length()==0){
            errorText.setText("No Received Spares");
            errorText.setVisibility(View.VISIBLE);
        }else{
            errorText.setVisibility(View.GONE);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
