package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.gesture.GestureOverlayView;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;

import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import androidx.core.widget.NestedScrollView;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;

import androidx.appcompat.widget.SwitchCompat;

import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.MaterialSpinner;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.LocationSettingsStatusCodes;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReportActivity extends AppCompatActivity {

    MaterialSpinner statusSpinner, hourSpinner;
    SwitchCompat workingBillable, spareBillable;
    RelativeLayout serviceChargeLayout, spareLayout, spareAmountLayout, spareBillableLayout, retrivedLayout;
    ImageView statusCamera, statusImage, billCamera, billImage;
    TextView spareAmount, serviceCharge, totalCharge;
    EditText thingsDone;
    GestureOverlayView gestureOverlayView;
    Button clearGesture;
    NestedScrollView nestedScrollView;
    EditText signatureName;


    String ticket, facility;
    private final int REQUEST_CODE = 3, REQUEST_STATUS_IMAGE = 1, REQUEST_BILL_IMAGE = 2, REQUEST_CHECK_SETTINGS = 4;

    JSONObject jsonObject = new JSONObject();
    JSONArray jsonArray = new JSONArray();
    int spareCharge = 0;
    Uri imageUri;
    File mediaFile = null;
    ArrayList<String> sparesList = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_report);

        ticket = getIntent().getStringExtra("ticket");
        facility = getIntent().getStringExtra("facility");

        getSupportActionBar().setTitle("Work Report");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        try {
            jsonObject.put("bill", "");
            jsonObject.put("status", "");
            jsonObject.put("sparescharge", 0);
            jsonObject.put("servicecharge", 0);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        getWidgets();
        getSpares();
    }

    private void getWidgets() {
        statusSpinner = findViewById(R.id.statusSpinner);
        hourSpinner = findViewById(R.id.hourSpinner);
        workingBillable = findViewById(R.id.workingBillable);
        serviceChargeLayout = findViewById(R.id.serviceChargeLayout);
        statusCamera = findViewById(R.id.statusCamera);
        statusImage = findViewById(R.id.statusImage);
        billCamera = findViewById(R.id.billCamera);
        billImage = findViewById(R.id.billImage);
        spareLayout = findViewById(R.id.spareLayout);
        spareBillable = findViewById(R.id.spareBillable);
        spareAmountLayout = findViewById(R.id.spareAmountLayout);
        retrivedLayout = findViewById(R.id.retrivedLayout);
        spareBillableLayout = findViewById(R.id.spareBillableLayout);
        spareAmount = findViewById(R.id.spareAmount);
        thingsDone = findViewById(R.id.thingsDone);
        gestureOverlayView = findViewById(R.id.gestureOverlayView);
        clearGesture = findViewById(R.id.clearGesture);
        nestedScrollView = findViewById(R.id.nestedScrollView);
        signatureName = findViewById(R.id.signatureName);
        serviceCharge = findViewById(R.id.serviceCharge);
        totalCharge = findViewById(R.id.totalCharge);
        workingBillable.setChecked(true);
        spareBillable.setChecked(true);
        setListeners();
    }

    private void setListeners() {
        workingBillable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                try {
                    setServiceCharge();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

        hourSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                try {
                    setServiceCharge();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        spareLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(getApplicationContext(), SelectSpareActivity.class);
                intent.putExtra("json", jsonArray.toString());
                intent.putStringArrayListExtra("spares", sparesList);
                startActivityForResult(intent, REQUEST_CODE);
            }
        });

        retrivedLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(getApplicationContext(), ReceivedSpareActivity.class);
                intent.putExtra("json", jsonArray.toString());
                startActivity(intent);
            }
        });
        spareBillable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                try {
                    setSpares();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

        statusCamera.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openCamera(REQUEST_STATUS_IMAGE);
            }
        });
        billCamera.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openCamera(REQUEST_BILL_IMAGE);
            }
        });
        clearGesture.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                gestureOverlayView.clear(false);
            }
        });
        gestureOverlayView.setDrawingCacheEnabled(true);
        gestureOverlayView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                nestedScrollView.requestDisallowInterceptTouchEvent(true);//very important
                return false;
            }
        });

    }

    private void setSpares() throws JSONException {
        if (jsonArray.length() != 0) {
            spareAmountLayout.setVisibility(spareBillable.isChecked() ? View.VISIBLE : View.GONE);
            if (spareBillable.isChecked()) {
                spareAmountLayout.setVisibility(View.VISIBLE);
                spareAmount.setText(String.valueOf(spareCharge));
                jsonObject.put("sparescharge", spareCharge);
            } else {
                spareAmountLayout.setVisibility(View.GONE);
                jsonObject.put("sparescharge", 0);
            }
            spareBillableLayout.setVisibility(View.VISIBLE);
        } else {
            jsonObject.put("sparescharge", 0);
            spareAmountLayout.setVisibility(View.GONE);
            spareBillableLayout.setVisibility(View.GONE);
        }
        setTotalCharge();
    }

    private void setServiceCharge() throws JSONException {
        if (workingBillable.isChecked() && hourSpinner.getSelectedItemPosition() != 0) {
            int total = hourSpinner.getSelectedItemPosition() * 100;
            jsonObject.put("servicecharge", total);
            serviceChargeLayout.setVisibility(View.VISIBLE);
            serviceCharge.setText(String.valueOf(total));
        } else {
            jsonObject.put("servicecharge", 0);
            serviceChargeLayout.setVisibility(View.GONE);
        }
        setTotalCharge();
    }

    private void setTotalCharge() throws JSONException {
        totalCharge.setText(String.format(Locale.getDefault(), "%d",
                jsonObject.getInt("sparescharge") + jsonObject.getInt("servicecharge")));
    }

    protected void openCamera(int code) {
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        imageUri = getOutputMediaFileUri();
        intent.putExtra(MediaStore.EXTRA_OUTPUT, imageUri);
        startActivityForResult(intent, code);
    }

    public Uri getOutputMediaFileUri() {

        //return FileProvider.getUriForFile(this,com.Rover.BuildConfig.APPLICATION_ID + ".provider",getOutputMediaFile(type));
        //Uri.fromFile(mediaFile);
        mediaFile = Utility.getCapturedImageFile();

        Uri uri = null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            uri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider",
                    mediaFile);
        } else {
            uri = Uri.fromFile(mediaFile);
        }
        return uri;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);


        if (requestCode == REQUEST_CODE && resultCode == RESULT_OK) {
            try {
                JSONObject jsonObject = new JSONObject(data.getStringExtra("json"));
                this.jsonObject.put("spares", jsonObject.getJSONArray("list"));
                this.jsonObject.put("sparescharge", jsonObject.getInt("total"));
                jsonArray = jsonObject.getJSONArray("list");
                spareCharge = jsonObject.getInt("total");
                setSpares();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ((requestCode == REQUEST_BILL_IMAGE || requestCode == REQUEST_STATUS_IMAGE) && resultCode == RESULT_OK) {
            try {
                if (imageUri != null) {
                    Bitmap cambmp = BitmapFactory.decodeStream(this.getContentResolver().openInputStream(imageUri), null, null);
                    cambmp = Utility.processImage(cambmp);
                    if (requestCode == REQUEST_BILL_IMAGE) {
                        billImage.setImageBitmap(cambmp);
                        jsonObject.put("bill", Utility.bitmap2string(cambmp));
                    } else {
                        statusImage.setImageBitmap(cambmp);
                        jsonObject.put("status", Utility.bitmap2string(cambmp));
                    }
                }
            } catch (Exception e) {
                Toast.makeText(getApplicationContext(), "please try again", Toast.LENGTH_SHORT).show();
            }

        } else if (requestCode == REQUEST_CHECK_SETTINGS) {
            switch (resultCode) {
                case Activity.RESULT_OK:
                    // All required changes were successfully made
                    getLcoation();
                    break;
                case Activity.RESULT_CANCELED:
                    RequestProgress.getInstance(this).hideProgressBar();
                    // The user was asked to change settings, but chose not to
                    break;
                default:
                    break;
            }
        }


    }

    private boolean isValid() {
        if (statusSpinner.getSelectedItemPosition() == 0) {
            alert("Select Ticket Status");
            return false;
        }
        if (hourSpinner.getSelectedItemPosition() == 0) {
            alert("Select Working Hours");
            return false;
        }
        if (thingsDone.getText().toString().isEmpty()) {
            alert("Fill Things Done");
            return false;
        }
        if (gestureOverlayView.getGesture() == null) {
            alert("Get Signature");
            return false;
        }

        if (signatureName.getText().toString().isEmpty()) {
            alert("Enter Singaturer Name");
            return false;
        }
        return true;
    }

    private void collectData() throws JSONException {
        Preference preference = Preference.getInstance(this);
        jsonObject.put("email", preference.getEmailId());
        jsonObject.put("company", preference.getCompanyName());
        jsonObject.put("sign", Utility.bitmap2string(gestureOverlayView.getDrawingCache()));
        jsonObject.put("signaturer", signatureName.getText().toString());
        jsonObject.put("workstatus", statusSpinner.getSelectedItem().toString());
        jsonObject.put("hours", hourSpinner.getSelectedItemPosition());
        jsonObject.put("things", thingsDone.getText().toString());
        jsonObject.put("ticket", ticket);
        jsonObject.put("facility", facility);
        insertReport();
    }

    private void alert(String str) {
        Toast.makeText(getApplicationContext(), str, Toast.LENGTH_SHORT).show();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.done:
                if (isValid()) {
                    connectLocation();
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void getLcoation() {

        if (ActivityCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        }

        RequestProgress requestProgress = RequestProgress.getInstance(this);
        requestProgress.showProgressBar();



        LocationServices.getFusedLocationProviderClient(this).getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener(new OnCompleteListener() {
            @Override
            public void onComplete(@NonNull Task task) {
                android.location.Location location = (Location) task.getResult();

                if (location != null) {
                    try {
                        getAddress(location);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    Toast.makeText(getApplicationContext(), "Unable to find lcoation", Toast.LENGTH_SHORT).show();
                }
            }
        });

    }

    private void connectLocation() {

        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY);
        locationRequest.setInterval(100);
        locationRequest.setFastestInterval(100 / 2);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);
        Task<LocationSettingsResponse> task =
                LocationServices.getSettingsClient(this).checkLocationSettings(builder.build());
        task.addOnCompleteListener(new OnCompleteListener<LocationSettingsResponse>() {
            @Override
            public void onComplete(Task<LocationSettingsResponse> task) {
                try {
                    LocationSettingsResponse response = task.getResult(ApiException.class);
                    // All location settings are satisfied. The client can initialize location
                    getLcoation();
                } catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case LocationSettingsStatusCodes.RESOLUTION_REQUIRED:
                            try {
                                ResolvableApiException resolvable = (ResolvableApiException) exception;
                                resolvable.startResolutionForResult(
                                        ReportActivity.this,
                                        REQUEST_CHECK_SETTINGS);
                            } catch (IntentSender.SendIntentException e) {
                                // Ignore the error.
                            } catch (ClassCastException e) {
                                // Ignore, should be an impossible error.
                            }
                            break;
                    }
                }
            }
        });
    }

    private void getAddress(Location location) throws JSONException {
        Geocoder mGeocoder = new Geocoder(this, Locale.getDefault());

        jsonObject.put("lat", location.getLatitude());
        jsonObject.put("lon", location.getLongitude());

        List<Address> addresses = null;
        try {
            addresses = mGeocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
        } catch (IOException e) {
            e.printStackTrace();
        }

        if (addresses != null && addresses.size() > 0) {
            jsonObject.put("location", addresses.get(0).getAddressLine(0));
        }
        collectData();
    }

    private void insertReport() {
        Map<String, String> params = new HashMap<>();
        params.put("JSON", jsonObject.toString());

        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.INSERT_WORKREPORT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    insertReport(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getSpares() {
        Map<String, String> params = new HashMap<>();
        Preference preference = Preference.getInstance(this);
        params.put("cname", preference.getCompanyName());
        MyRequestQueue.getInstance(this).addToQueue(SERVICEURL.GET_SPARES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getSpares(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getSpares(JSONObject jsonObject) throws JSONException {
        sparesList = new ArrayList<>();
        JSONArray jsonArray = jsonObject.getJSONArray("spares");
        sparesList = JSONUtils.toArrayListString(jsonArray);
    }

    private void insertReport(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getInt("s") == 1) {
            Toast.makeText(getApplicationContext(), "Report Submited", Toast.LENGTH_SHORT).show();
            setResult(Activity.RESULT_OK);
            finish();
        } else {
            Toast.makeText(getApplicationContext(), "Unable to submit the report", Toast.LENGTH_SHORT).show();
        }
    }

}
